/*
************************************************************************
*
*   ExRadius.c - radius setting commands
*
*   Copyright (c) 1995
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdattr/SCCS/s.ExRadius.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_attr.h>

#include <string.h>

#include <arg.h>
#include <data_hand.h>
#include <prim_hand.h>
#include <attr_struc.h>
#include <attr_mng.h>
#include <graph_draw.h>

typedef struct {
  ExprP radExprP;
  float rad;
  BOOL changeShading;
} RadDescr;

static float CurrRad = 0.2;

static void
evalRad(void *entP, RadDescr *radP)
{
  ExprRes exprRes;

  ExprEval(entP, radP->radExprP, &exprRes);
  if (exprRes.resType == ER_INT)
    radP->rad = (float) exprRes.u.intVal;
  else
    radP->rad = exprRes.u.floatVal;
}

static AttrP
changeRad(AttrP attrP, RadDescr *radP)
{
  struct AttrS attr;

  if (radP->rad < 0.0)
    radP->rad = 0.0;

  CurrRad = radP->rad;

  AttrCopy(&attr, attrP);
  AttrReturn(attrP);
  if (radP->changeShading) {
    if (radP->rad == 0.0)
      attr.shadeModel = -1;
    else if (attr.radius == 0.0)
      attr.shadeModel = SHADE_DEFAULT;
  }
  attr.radius = radP->rad;
  return AttrGet(&attr);
}

static void
peakRad(DhPeakP peakP, void *clientData)
{
  evalRad(peakP, clientData);
  DhPeakSetAttr(peakP, changeRad(DhPeakGetAttr(peakP), clientData));
}

static void
primRad(PrimObjP primP, void *clientData)
{
  evalRad(primP, clientData);
  PrimSetAttr(primP, changeRad(PrimGetAttr(primP), clientData));
}

#define ARG_NUM 1

ErrCode
ExRadius(char *cmd)
{
  DataEntityType entType;
  ArgDescr arg[ARG_NUM];
  ErrCode errCode;
  RadDescr radDescr;
  PropRefP refP;

  if (strcmp(cmd, "RadiusPeak") == 0)
    entType = DE_PEAK;
  else
    entType = DE_PRIM;

  arg[0].type = AT_DOUBLE;

  ArgInit(arg, ARG_NUM);

  arg[0].prompt = "Radius";
  arg[0].entType = entType;
  arg[0].v.doubleVal = CurrRad;

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  radDescr.radExprP = arg[0].v.exprP;
  radDescr.changeShading = FALSE;

  refP = PropGetRef(PROP_SELECTED, FALSE);

  switch (entType) {
    case DE_PEAK:
      DhApplyPeak(refP, peakRad, &radDescr);
      break;
    case DE_PRIM:
      radDescr.changeShading = TRUE;
      PrimApply(PT_ALL, refP, primRad, &radDescr);
      break;
  }

  ArgCleanup(arg, ARG_NUM);

  GraphSpecChanged(PROP_SELECTED);
  GraphRedrawNeeded();

  return EC_OK;
}
