/*
************************************************************************
*
*   ExLine.c - line style commands
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdattr/SCCS/s.ExLine.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_attr.h>

#include <string.h>

#include <arg.h>
#include <data_hand.h>
#include <prim_hand.h>
#include <attr_struc.h>
#include <attr_mng.h>
#include <graph_draw.h>

static int LineStyle = 0;
static float LineWidth = 0.0;

typedef struct {
  SgLineStyle style;
  ExprP widthExprP;
  float width;
} LineDescr;

static void
evalWidth(void *entP, LineDescr *lineP)
{
  ExprRes exprRes;

  ExprEval(entP, lineP->widthExprP, &exprRes);
  if (exprRes.resType == ER_INT)
    lineP->width = (float) exprRes.u.intVal;
  else
    lineP->width = exprRes.u.floatVal;
}

static AttrP
changeLine(AttrP attrP, LineDescr *lineP)
{
  struct AttrS attr;
  
  if (lineP->width < 0.0)
    lineP->width = 0.0;

  LineWidth = lineP->width;

  AttrCopy(&attr, attrP);
  AttrReturn(attrP);
  attr.lineStyle = lineP->style;
  attr.lineWidth = lineP->width;
  return AttrGet(&attr);
}

static void
setSpecLine(DhSpecP specP, void *clientData)
{
  evalWidth(specP, clientData);
  DhSpecSetAttr(specP, changeLine(DhSpecGetAttr(specP), clientData));
}

static void
setPeakLine(DhPeakP peakP, void *clientData)
{
  evalWidth(peakP, clientData);
  DhPeakSetAttr(peakP, changeLine(DhPeakGetAttr(peakP), clientData));
}

static void
setPrimLine(PrimObjP primP, void *clientData)
{
  evalWidth(primP, clientData);
  PrimSetAttr(primP, changeLine(PrimGetAttr(primP), clientData));
}

#define ARG_NUM 2

ErrCode
ExLine(char *cmd)
{
  DataEntityType entType;
  ArgDescr arg[ARG_NUM];
  EnumEntryDescr enumEntry[2];
  ErrCode errCode;
  LineDescr lineDescr;
  PropRefP refP;

  if (strcmp(cmd, "LineSpec") == 0)
    entType = DE_SPEC;
  else if (strcmp(cmd, "LinePeak") == 0)
    entType = DE_PEAK;
  else
    entType = DE_PRIM;

  arg[0].type = AT_ENUM;
  arg[1].type = AT_DOUBLE;

  ArgInit(arg, ARG_NUM);

  enumEntry[0].str = "solid";
  enumEntry[0].onOff = FALSE;
  enumEntry[1].str = "dashed";
  enumEntry[1].onOff = FALSE;

  enumEntry[LineStyle].onOff = TRUE;

  arg[0].prompt = "Line Style";
  arg[0].u.enumD.entryP = enumEntry;
  arg[0].u.enumD.n = 2;
  arg[0].v.intVal = LineStyle;

  arg[1].prompt = "Line Width";
  arg[1].entType = entType;
  arg[1].v.doubleVal = LineWidth;

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  LineStyle = arg[0].v.intVal;

  if (LineStyle == 0)
    lineDescr.style = SG_LINE_SOLID;
  else
    lineDescr.style = SG_LINE_DASHED;

  if (entType == DE_NONE)
    lineDescr.width = arg[1].v.doubleVal;
  else
    lineDescr.widthExprP = arg[1].v.exprP;

  refP = PropGetRef(PROP_SELECTED, FALSE);

  switch (entType) {
    case DE_SPEC:
      DhApplySpec(refP, setSpecLine, &lineDescr);
      break;
    case DE_PEAK:
      DhApplyPeak(refP, setPeakLine, &lineDescr);
      break;
    case DE_PRIM:
      PrimApply(PT_ALL, refP, setPrimLine, &lineDescr);
      break;
  }

  ArgCleanup(arg, ARG_NUM);

  GraphSpecChanged(PROP_SELECTED);
  GraphRedrawNeeded();

  return EC_OK;
}
