/*
************************************************************************
*
*   ExLength.c - length setting commands
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdattr/SCCS/s.ExLength.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_attr.h>

#include <string.h>

#include <arg.h>
#include <data_hand.h>
#include <prim_hand.h>
#include <attr_struc.h>
#include <attr_mng.h>
#include <graph_draw.h>

typedef struct {
  ExprP lengthExprP;
  float length;
} LengthDescr;

static float CurrLength = 0.0;

static void
evalLength(void *entP, LengthDescr *lengthP)
{
  ExprRes exprRes;

  ExprEval(entP, lengthP->lengthExprP, &exprRes);
  if (exprRes.resType == ER_INT)
    lengthP->length = (float) exprRes.u.intVal;
  else
    lengthP->length = exprRes.u.floatVal;
}

static AttrP
changeLength(AttrP attrP, LengthDescr *lengthP)
{
  struct AttrS attr;

  if (lengthP->length < 0.0)
    lengthP->length = 0.0;

  CurrLength = lengthP->length;

  AttrCopy(&attr, attrP);
  AttrReturn(attrP);
  attr.length = lengthP->length;
  return AttrGet(&attr);
}

static void
peakLength(DhPeakP peakP, void *clientData)
{
  evalLength(peakP, clientData);
  DhPeakSetAttr(peakP, changeLength(DhPeakGetAttr(peakP), clientData));
}

#define ARG_NUM 1

ErrCode
ExLength(char *cmd)
{
  DataEntityType entType;
  ArgDescr arg[ARG_NUM];
  ErrCode errCode;
  LengthDescr lengthDescr;
  PropRefP refP;

  entType = DE_PEAK;

  arg[0].type = AT_DOUBLE;

  ArgInit(arg, ARG_NUM);

  arg[0].prompt = "Length";
  arg[0].entType = entType;
  arg[0].v.doubleVal = CurrLength;

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  lengthDescr.lengthExprP = arg[0].v.exprP;

  refP = PropGetRef(PROP_SELECTED, FALSE);

  DhApplyPeak(refP, peakLength, &lengthDescr);

  ArgCleanup(arg, ARG_NUM);

  GraphSpecChanged(PROP_SELECTED);
  GraphRedrawNeeded();

  return EC_OK;
}
