/*
************************************************************************
*
*   ExColor.c - color setting commands
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdattr/SCCS/s.ExColor.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_attr.h>

#include <string.h>

#include <arg.h>
#include <data_hand.h>
#include <prim_hand.h>
#include <attr_struc.h>
#include <attr_mng.h>
#include <graph_draw.h>

typedef struct {
  ExprP rExprP, gExprP, bExprP;
  float r, g, b;
} ColorDescr;

static float
normCol(float f)
{
  if (f < 0.0)
    return 0.0;
  if (f > 1.0)
    return 1.0;
  return f;
}

static void
evalColor(void *entP, ColorDescr *colorP)
{
  ExprRes exprRes;

  ExprEval(entP, colorP->rExprP, &exprRes);
  if (exprRes.resType == ER_INT)
    colorP->r = normCol((float) exprRes.u.intVal);
  else
    colorP->r = normCol(exprRes.u.floatVal);

  ExprEval(entP, colorP->gExprP, &exprRes);
  if (exprRes.resType == ER_INT)
    colorP->g = normCol((float) exprRes.u.intVal);
  else
    colorP->g = normCol(exprRes.u.floatVal);

  ExprEval(entP, colorP->bExprP, &exprRes);
  if (exprRes.resType == ER_INT)
    colorP->b = normCol((float) exprRes.u.intVal);
  else
    colorP->b = normCol(exprRes.u.floatVal);
}

static AttrP
changeColor(AttrP attrP, ColorDescr *colorP)
{
  struct AttrS attr;

  AttrCopy(&attr, attrP);
  AttrReturn(attrP);
  attr.colR = colorP->r;
  attr.colG = colorP->g;
  attr.colB = colorP->b;
  return AttrGet(&attr);
}

static void
colorSpec(DhSpecP specP, void *clientData)
{
  evalColor(specP, clientData);
  DhSpecSetAttr(specP, changeColor(DhSpecGetAttr(specP), clientData));
}

static void
colorPeak(DhPeakP peakP, void *clientData)
{
  evalColor(peakP, clientData);
  DhPeakSetAttr(peakP, changeColor(DhPeakGetAttr(peakP), clientData));
}

static void
colorPrim(PrimObjP primP, void *clientData)
{
  evalColor(primP, clientData);
  PrimSetAttr(primP, changeColor(PrimGetAttr(primP), clientData));
}

ErrCode
ExColor(char *cmd)
{
  DataEntityType entType;
  ArgDescr arg[3];
  ErrCode errCode;
  ColorDescr colDescr;
  PropRefP refP;
  int i;

  if (strcmp(cmd, "ColorSpec") == 0)
    entType = DE_SPEC;
  else if (strcmp(cmd, "ColorPeak") == 0)
    entType = DE_PEAK;
  else
    entType = DE_PRIM;

  arg[0].type = AT_DOUBLE;
  arg[1].type = AT_DOUBLE;
  arg[2].type = AT_DOUBLE;

  ArgInit(arg, 3);

  arg[0].prompt = "Red";
  arg[1].prompt = "Green";
  arg[2].prompt = "Blue";

  for (i = 0; i < 3; i++) {
    arg[i].entType = entType;
    arg[i].v.doubleVal = 0.0;
  }

  errCode = ArgGet(arg, 3);
  if (errCode != EC_OK) {
    ArgCleanup(arg, 3);
    return errCode;
  }

  colDescr.rExprP = arg[0].v.exprP;
  colDescr.gExprP = arg[1].v.exprP;
  colDescr.bExprP = arg[2].v.exprP;

  refP = PropGetRef(PROP_SELECTED, FALSE);

  switch (entType) {
    case DE_SPEC:
      DhApplySpec(refP, colorSpec, &colDescr);
      break;
    case DE_PEAK:
      DhApplyPeak(refP, colorPeak, &colDescr);
      break;
    case DE_PRIM:
      PrimApply(PT_ALL, refP, colorPrim, &colDescr);
      break;
  }

  ArgCleanup(arg, 3);

  GraphSpecChanged(PROP_SELECTED);
  GraphRedrawNeeded();

  return EC_OK;
}
