/*
************************************************************************
*
*   ExAttr.c - Attr* commands
*
*   Copyright (c) 1994-96
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdattr/SCCS/s.ExAttr.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_attr.h>

#include <stdio.h>
#include <string.h>

#include <dstr.h>
#include <pu.h>
#include <data_ent.h>
#include <data_hand.h>
#include <prim_hand.h>
#include <attr_struc.h>
#include <attr_mng.h>

typedef struct {
  int entNo;
  AttrP attrP;
} AttrDescr;

static void
getAttr(AttrP attrP, AttrDescr *descrP)
{
  if (descrP->entNo == 0)
    descrP->attrP = attrP;
  else if (descrP->attrP != attrP)
    descrP->attrP = NULL;

  descrP->entNo++;
}

static void
getAttrSpec(DhSpecP specP, void *clientData)
{
  getAttr(DhSpecGetAttr(specP), clientData);
}

static void
getAttrPeak(DhPeakP peakP, void *clientData)
{
  getAttr(DhPeakGetAttr(peakP), clientData);
}

static void
getAttrPrim(PrimObjP primP, void *clientData)
{
  getAttr(PrimGetAttr(primP), clientData);
}

ErrCode
ExAttr(char *cmd)
{
  AttrDescr descr;
  PropRefP refP;
  DataEntityType entType;
  AttrP attrP;
  PuTextWindow textW;
  char *name, buf[100], *str;
  DSTR macro;

  descr.entNo = 0;
  descr.attrP = NULL;

  refP = PropGetRef(PROP_SELECTED, FALSE);

  if (strcmp(cmd, "AttrSpec") == 0) {
    DhApplySpec(refP, getAttrSpec, &descr);
    entType = DE_SPEC;
  } else if (strcmp(cmd, "AttrPeak") == 0) {
    DhApplyPeak(refP, getAttrPeak, &descr);
    entType = DE_PEAK;
  } else {
    PrimApply(PT_ALL, refP, getAttrPrim, &descr);
    entType = DE_PRIM;
  }

  if (descr.entNo == 0) {
    CipSetError("no item selected");
    return EC_ERROR;
  }

  attrP = descr.attrP;
  if (attrP == NULL) {
    CipSetError("not all selected items have same attributes");
    return EC_ERROR;
  }

  textW = PuCreateTextWindow(cmd);
  macro = DStrNew();
  name = cmd + 4;

  (void) sprintf(buf, "Values of attr %d:\n\n", AttrGetIndex(attrP));
  PuWriteStr(textW, buf);

  (void) sprintf(buf, "Color:           %5.3f %5.3f %5.3f\n",
      attrP->colR, attrP->colG, attrP->colB);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Color%s %5.3f %5.3f %5.3f\n",
      name, attrP->colR, attrP->colG, attrP->colB);
  DStrAppStr(macro, buf);

  (void) sprintf(buf, "Ambient Coeff.:  %5.3f\n", attrP->ambCoeff);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Diffuse Coeff.:  %5.3f\n", attrP->diffCoeff);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Specular Coeff.: %5.3f\n", attrP->specCoeff);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Shininess:       %.1f\n", attrP->shininess);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Reflection:      %5.3f\n", attrP->reflect);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Opacity:         %5.3f\n", attrP->alpha);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Refraction:      %5.3f\n", attrP->refract);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Material%s %5.3f %5.3f %5.3f %.1f %5.3f %5.3f %5.3f\n",
      name, attrP->ambCoeff, attrP->diffCoeff, attrP->specCoeff,
      attrP->shininess, attrP->reflect, attrP->alpha, attrP->refract);
  DStrAppStr(macro, buf);

  (void) sprintf(buf, "Texture Name:    %s\n", attrP->texture);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Texture Scale:   %.2f\n", attrP->textureScale);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Bumpiness:       %5.3f\n", attrP->bumpDepth);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Bump Scale:      %.2f\n", attrP->bumpScale);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Texture%s '%s' %.2f %5.3f %.2f\n",
      name, attrP->texture, attrP->textureScale,
      attrP->bumpDepth, attrP->bumpScale);
  DStrAppStr(macro, buf);

  if (entType == DE_SPEC) {
    if (attrP->specStyle == SS_INVISIBLE)
      str = "invisible";
    else if (attrP->specStyle == SS_GRID)
      str = "grid";
    else if (attrP->specStyle == SS_SURFACE)
      str = "surface";
    else
      str = "contour";
    (void) sprintf(buf, "Style:           %s\n", str);
    PuWriteStr(textW, buf);
    (void) sprintf(buf, "StyleSpec %s\n", str);
    DStrAppStr(macro, buf);
  } else if (entType == DE_PEAK) {
    if (attrP->peakStyle == PS_INVISIBLE)
      str = "invisible";
    else if (attrP->peakStyle == PS_CIRCLE)
      str = "circle";
    else
      str = "cross";
    (void) sprintf(buf, "Style:           %s\n", str);
    PuWriteStr(textW, buf);
    (void) sprintf(buf, "StylePeak %s\n", str);
    DStrAppStr(macro, buf);

    (void) sprintf(buf, "Label:           %s\n", attrP->labelFormat);
    PuWriteStr(textW, buf);
    (void) sprintf(buf, "LabelPeak '%s'\n", attrP->labelFormat);
    DStrAppStr(macro, buf);
  }

  (void) sprintf(buf, "Radius:          %.3f\n", attrP->radius);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Radius%s %.3f\n", name, attrP->radius);
  DStrAppStr(macro, buf);

  if (attrP->lineStyle == SG_LINE_SOLID)
    str = "solid";
  else
    str = "dashed";
  (void) sprintf(buf, "Line Style:      %s\n", str);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Line Width:      %.1f\n", attrP->lineWidth);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Line%s %s %.1f\n", name, str, attrP->lineWidth);
  DStrAppStr(macro, buf);

  if (attrP->shadeModel == -1)
    str = "none";
  else if (attrP->shadeModel == SG_SHADE_FLAT)
    str = "flat";
  else if (attrP->shadeModel == SG_SHADE_GOURAUD)
    str = "gouraud";
  else if (attrP->shadeModel == SG_SHADE_PHONG)
    str = "phong";
  else if (attrP->shadeModel == SG_SHADE_DOTS)
    str = "dots";
  else
    str = "lines";
  (void) sprintf(buf, "Shading:         %s\n", str);
  PuWriteStr(textW, buf);
  (void) sprintf(buf, "Shade%s %s\n", name, str);
  DStrAppStr(macro, buf);

  if (entType == DE_PRIM) {
    (void) sprintf(buf, "Font Size:       %5.3f\n", attrP->fontSize);
    PuWriteStr(textW, buf);
    (void) sprintf(buf, "SizeText %5.3f\n", attrP->fontSize);
    DStrAppStr(macro, buf);
  }

  PuWriteStr(textW, "\nMacro:\n\n");
  PuWriteStr(textW, DStrToStr(macro));

  DStrFree(macro);

  return EC_OK;
}
