/*
************************************************************************
*
*   SelHistory.c - put interactive selection into history
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cip/SCCS/s.SelHistory.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include "sel_history.h"

#include <stdio.h>

#include <dstr.h>
#include <data_hand.h>
#include <data_sel.h>
#include <prim_hand.h>
#include <prim_sel.h>
#include <history.h>

static void
selHistory(DataEntityType entType, void *entP, SelKind kind)
{
  char *cmd;
  DSTR arg = DStrNew();
  char numBuf[20];

  if (kind == SK_ADD)
    DStrAssignStr(arg, "selected | ");
  else
    DStrAssignStr(arg, "selected & ! (");

  switch(entType) {
    case DE_SPEC:
      cmd = "SelectSpec";
      DStrAppChar(arg, ' ');
      DStrAppStr(arg, "num = ");
      (void) sprintf(numBuf, "%d", DhSpecGetNumber(entP));
      DStrAppStr(arg, numBuf);
      break;
    case DE_PEAK:
      cmd = "SelectPeak";
      DStrAppChar(arg, ' ');
      DStrAppStr(arg, "num = ");
      (void) sprintf(numBuf, "%d", DhPeakGetNumber(entP));
      DStrAppStr(arg, numBuf);
      break;
    case DE_PRIM:
      cmd = "SelectPrim";
      DStrAppStr(arg, "num = ");
      (void) sprintf(numBuf, "%d", PrimGetNumber(entP));
      DStrAppStr(arg, numBuf);
      break;
  }

  if (kind == SK_REMOVE)
    DStrAppStr(arg, ")");

  HistoryArgStr(DStrToStr(arg));
  HistoryEndCmd(cmd, TRUE);

  DStrFree(arg);
}

static void
primSelHistory(PrimObjP primP, SelKind kind)
{
  selHistory(DE_PRIM, primP, kind);
}


void
SelHistoryInit(void)
{
  SelAddCB(selHistory);
  PrimSelAddCB(primSelHistory);
}
