/*
************************************************************************
*
*   VRMLUtil.c - VRML utility functions
*
*   Copyright (c) 1996
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/07/21
*   Pathname of SCCS file     : /sgiext/molmol/sg/src/vrml/SCCS/s.VRMLUtil.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include "vrml_util.h"

#include <sg_get.h>
#include <sg_plot.h>

static float Fact;

void
VRMLInit2D(void)
{
  Fact = SgGetOrthoHeight();
}

void
VRMLMap2D(float xOut[3], float xIn[2])
{
  xOut[0] = xIn[0] * Fact;
  xOut[1] = xIn[1] * Fact;
  xOut[2] = 0.0;
}

void
VRMLPlotVect(float x[3])
{
  SgPlotOutputFloat(x[0]);
  SgPlotOutputStr(" ");
  SgPlotOutputFloat(x[1]);
  SgPlotOutputStr(" ");
  SgPlotOutputFloat(x[2]);
}
