/*
************************************************************************
*
*   VRMLPoly.c - VRML polygon drawing
*
*   Copyright (c) 1996
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/07/23
*   Pathname of SCCS file     : /sgiext/molmol/sg/src/vrml/SCCS/s.VRMLPoly.c
*   SCCS identification       : 1.2
*
************************************************************************
*/

#include "vrml_poly.h"

#include <stdio.h>

#include <sg.h>
#include <sg_map.h>
#include <sg_map.h>
#include <sg_plot.h>
#include "vrml_util.h"
#include "vrml_color.h"
#include "vrml_light.h"

static void
plotPoint2D(float x[2])
{
  float xm[3];

  VRMLMap2D(xm, x);
  VRMLPlotVect(xm);
}

static void
plotPoint(float xm[3], float x[3])
{
  SgMapModelPoint(xm, x);
  VRMLPlotVect(xm);
}

static void
plotVect(float v[3])
{
  float vm[3];

  SgMapModelVect(vm, v);
  VRMLPlotVect(vm);
}

void
SgVRMLDrawPolygon2D(float x[][2], int n)
{
  float xm[3];
  int i;

  SgPlotOutputStr("Separator {\n");
  VRMLPlotColor();

  SgPlotOutputStr("Coordinate3 {\n");
  SgPlotOutputStr("point [\n");

  for (i = 0; i < n; i++) {
    VRMLMap2D(xm, x[i]);
    VRMLPlotVect(xm);
    SgPlotOutputStr(",\n");
  }

  SgPlotOutputStr("]\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("Normal {vector 0 0 1}\n");
  SgPlotOutputStr("NormalBinding {value OVERALL}\n");

  SgPlotOutputStr("IndexedFaceSet {\n");
  SgPlotOutputStr("coordIndex [");
  for (i = 0; i < n; i++) {
    SgPlotOutputInt(i);
    SgPlotOutputStr(", ");
  }
  SgPlotOutputStr("]\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("}\n");
}

void
SgVRMLDrawPolygon(float x[][3], int n, float nv[3])
{
  float xm[3], nvm[3];
  int i;

  VRMLUpdateLight();
  SgPlotOutputStr("Separator {\n");
  VRMLPlotColor();

  SgPlotOutputStr("Coordinate3 {\n");
  SgPlotOutputStr("point [\n");

  for (i = 0; i < n; i++) {
    SgMapModelPoint(xm, x[i]);
    VRMLPlotVect(xm);
    SgPlotOutputStr(",\n");
  }

  SgPlotOutputStr("]\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("Normal {vector ");
  SgMapModelVect(nvm, nv);
  VRMLPlotVect(nvm);
  SgPlotOutputStr("}\n");
  SgPlotOutputStr("NormalBinding {value OVERALL}\n");

  SgPlotOutputStr("IndexedFaceSet {\n");
  SgPlotOutputStr("coordIndex [");
  for (i = 0; i < n; i++) {
    SgPlotOutputInt(i);
    SgPlotOutputStr(", ");
  }
  SgPlotOutputStr("]\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("}\n");
}

static void
plotIndices(int n)
{
  int i;

  for (i = 0; i < n - 2; i += 2) {
    SgPlotOutputInt(i);
    SgPlotOutputStr(", ");
    SgPlotOutputInt(i + 1);
    SgPlotOutputStr(", ");
    SgPlotOutputInt(i + 2);
    SgPlotOutputStr(", -1,\n");

    if (i + 3 == n)
      break;

    SgPlotOutputInt(i + 2);
    SgPlotOutputStr(", ");
    SgPlotOutputInt(i + 1);
    SgPlotOutputStr(", ");
    SgPlotOutputInt(i + 3);
    SgPlotOutputStr(", -1,\n");
  }
}

void
SgVRMLDrawTriMesh(float x[][3], float nv[][3], int n)
{
  float xm[3], nvm[3];
  int i;

  VRMLUpdateLight();
  SgPlotOutputStr("Separator {\n");
  VRMLPlotColor();

  SgPlotOutputStr("Coordinate3 {\n");
  SgPlotOutputStr("point [\n");

  for (i = 0; i < n; i++) {
    SgMapModelPoint(xm, x[i]);
    VRMLPlotVect(xm);
    SgPlotOutputStr(",\n");
  }

  SgPlotOutputStr("]\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("Normal {\n");
  SgPlotOutputStr("vector [");

  for (i = 0; i < n; i++) {
    SgMapModelVect(nvm, nv[i]);
    VRMLPlotVect(nvm);
    SgPlotOutputStr(",\n");
  }

  SgPlotOutputStr("]\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("IndexedFaceSet {\n");

  SgPlotOutputStr("coordIndex [");
  plotIndices(n);
  SgPlotOutputStr("]\n");

  SgPlotOutputStr("normalIndex [");
  plotIndices(n);
  SgPlotOutputStr("]\n");

  SgPlotOutputStr("}\n");

  SgPlotOutputStr("}\n");
}

void
SgVRMLDrawStrip(float x1[][3], float x2[][3],
    float nv1[][3], float nv2[][3], int n)
{
  float xm[3], nvm[3];
  int i;

  if (nv2 == NULL)
    nv2 = nv1;

  VRMLUpdateLight();
  SgPlotOutputStr("Separator {\n");
  VRMLPlotColor();

  SgPlotOutputStr("Coordinate3 {\n");
  SgPlotOutputStr("point [\n");

  for (i = 0; i < n; i++) {
    SgMapModelPoint(xm, x1[i]);
    VRMLPlotVect(xm);
    SgPlotOutputStr(", ");
    SgMapModelPoint(xm, x2[i]);
    VRMLPlotVect(xm);
    SgPlotOutputStr(",\n");
  }

  SgPlotOutputStr("]\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("Normal {\n");
  SgPlotOutputStr("vector [");

  for (i = 0; i < n; i++) {
    SgMapModelVect(nvm, nv1[i]);
    VRMLPlotVect(nvm);
    SgPlotOutputStr(", ");
    SgMapModelVect(nvm, nv2[i]);
    VRMLPlotVect(nvm);
    SgPlotOutputStr(",\n");
  }

  SgPlotOutputStr("]\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("IndexedFaceSet {\n");

  SgPlotOutputStr("coordIndex [");
  plotIndices(2 * n);
  SgPlotOutputStr("]\n");

  SgPlotOutputStr("normalIndex [");
  plotIndices(2 * n);
  SgPlotOutputStr("]\n");

  SgPlotOutputStr("}\n");

  SgPlotOutputStr("}\n");
}
