/*
************************************************************************
*
*   VRMLMarker.c - VRML marker drawing
*
*   Copyright (c) 1996
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/07/21
*   Pathname of SCCS file     : /sgiext/molmol/sg/src/vrml/SCCS/s.VRMLMarker.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include "vrml_marker.h"

#include <sg_map.h>
#include <sg_plot.h>
#include "vrml_util.h"
#include "vrml_color.h"

void
SgVRMLDrawMarkers(float x[][3], int n)
{
  float xm[3];
  int i;

  SgPlotOutputStr("Separator {\n");
  VRMLPlotColor();

  SgPlotOutputStr("Coordinate3 {\n");
  SgPlotOutputStr("point [\n");

  for (i = 0; i < n; i++) {
    if (i > 0)
      SgPlotOutputStr(",\n");
    SgMapModelPoint(xm, x[i]);
    VRMLPlotVect(xm);
  }

  SgPlotOutputStr("]\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("}\n");
}
