/*
************************************************************************
*
*   VRMLLight.c - VRML light source handling
*
*   Copyright (c) 1996
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/07/23
*   Pathname of SCCS file     : /sgiext/molmol/sg/src/vrml/SCCS/s.VRMLLight.c
*   SCCS identification       : 1.2
*
************************************************************************
*/

#include "vrml_light.h"

#include <sg_plot.h>
#include "vrml_util.h"

static BOOL LightChanged = FALSE;
static SgLightState LightState, LightKind = SG_LIGHT_OFF;
static float LightPos[3], LightDir[3];

void
SgVRMLSetLight(SgLightState state)
{
  LightState = state;

  if (state == SG_LIGHT_OFF || state == LightKind)
    return;

  LightKind = state;
  LightChanged = TRUE;
}

void
SgVRMLSetLightPosition(float x[3])
{
  int i;

  for (i = 0; i < 3; i++) {
    LightPos[i] = x[i];
    LightDir[i] = - x[i];
  }

  LightChanged = TRUE;
}

void
VRMLUpdateLight(void)
{
  if (LightKind == SG_LIGHT_OFF || ! LightChanged)
    return;

  if (LightKind == SG_LIGHT_POINT) {
    SgPlotOutputStr("PointLight {");
    SgPlotOutputStr("location ");
    VRMLPlotVect(LightPos);
    SgPlotOutputStr("}\n");
  } else {
    SgPlotOutputStr("DirectionalLight {");
    SgPlotOutputStr("direction ");
    VRMLPlotVect(LightDir);
    SgPlotOutputStr("\n");
    SgPlotOutputStr("}\n");
  }

  LightChanged = FALSE;
}
