/*
************************************************************************
*
*   VRMLInit.c - init VRML device
*
*   Copyright (c) 1996
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/07/21
*   Pathname of SCCS file     : /sgiext/molmol/sg/src/vrml/SCCS/s.VRMLInit.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include "vrml_init.h"

#include <sg_plot.h>
#include <sg_get.h>
#include "vrml_util.h"

SgRes
SgVRMLInit(int *argcP, char *argv[])
{
  SgPlotOutputStr("#VRML V1.0 ascii\n\n");
  SgPlotOutputStr("Separator {\n");

  VRMLInit2D();

  return SG_RES_OK;
}

SgRes
SgVRMLCleanup(void)
{
  SgPlotOutputStr("ShapeHints {\n");
  SgPlotOutputStr("vertexOrdering COUNTERCLOCKWISE\n");
  if (SgGetFeature(SG_FEATURE_BACKFACE))
    SgPlotOutputStr("shapeType SOLID\n");
  SgPlotOutputStr("faceType CONVEX\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("}\n");

  return SG_RES_OK;
}
