/*
************************************************************************
*
*   prim_hand.h - data handler for primitives
*
*   Copyright (c) 1994-96
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/include/SCCS/s.prim_hand.h
*   SCCS identification       : 1.1
*
************************************************************************
*/

#ifndef _PRIM_HAND_H_
#define _PRIM_HAND_H_

#include <bool.h>
#include <g_file.h>
#include <prop_def.h>
#include <data_hand.h>
#include <attr_type.h>

typedef struct PrimObjS *PrimObjP;

typedef enum {
  PT_ALL,
  PT_TEXT,
  PT_DRAWOBJ
} PrimType;

typedef enum {
  PDT_LINE,
  PDT_RECT,
  PDT_CIRCLE
} PrimDrawobjType;

typedef enum {
  PDS_INVISIBLE,
  PDS_LINE,
  PDS_CYLINDER,
  PDS_NEON
} PrimDrawobjStyle;

typedef void (*PrimApplyFunc) (PrimObjP, void *);
typedef void (*PrimPropCB) (PrimObjP, PropRefP, BOOL, void *);

extern void PrimDestroyAll(void);
extern PrimObjP PrimNew(PrimType, DhSpecP);
extern void PrimDestroy(PrimObjP);

extern void PrimApply(PrimType, PropRefP, PrimApplyFunc, void *);
extern void PrimSpecApply(PrimType, PropRefP, DhSpecP, PrimApplyFunc, void *);

extern PrimObjP PrimFindNumber(int);

extern void PrimAddPropCB(PrimType, PropRefP, PrimPropCB, void *);

extern void PrimSetProp(PropRefP, PrimObjP, BOOL);
extern BOOL PrimGetProp(PropRefP, PrimObjP);
extern unsigned *PrimGetPropTab(PrimObjP);

extern void PrimSetAttr(PrimObjP, AttrP);

extern void PrimSetPos(PrimObjP, Vec3);
extern void PrimSetVec(PrimObjP, Vec3);
extern void PrimSetText(PrimObjP, char *);
extern void PrimSetDrawobjType(PrimObjP, PrimDrawobjType);
extern void PrimSetDrawobjStyle(PrimObjP, PrimDrawobjStyle);
extern void PrimSetPoint(PrimObjP, int, Vec3, Vec3);

extern int PrimGetNumber(PrimObjP);
extern PrimType PrimGetType(PrimObjP);
extern DhSpecP PrimGetSpec(PrimObjP);
extern AttrP PrimGetAttr(PrimObjP);

extern void PrimGetPos(PrimObjP, Vec3);
extern void PrimGetVec(PrimObjP, Vec3);
extern char *PrimGetText(PrimObjP);
extern PrimDrawobjType PrimGetDrawobjType(PrimObjP);
extern PrimDrawobjStyle PrimGetDrawobjStyle(PrimObjP);
extern void PrimGetPoint(PrimObjP, int, Vec3, Vec3);
extern int PrimGetPointNo(PrimObjP);

#endif  /* _PRIM_HAND_H_ */
