/*
************************************************************************
*
*   data_hand.h - data handler
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/include/SCCS/s.data_hand.h
*   SCCS identification       : 1.1
*
************************************************************************
*/

#ifndef _DATA_HAND_H_
#define _DATA_HAND_H_

#include <bool.h>
#include <dstr.h>
#include <mat_vec.h>
#include <contour_line.h>
#include <iso_surface.h>
#include <app/base_types.h>
#include <app/spec_noise.h>
#include <app/reg.h>
#include <app/peak.h>
#include <g_file.h>
#include <prop_def.h>
#include <attr_type.h>

typedef struct DhSpecS *DhSpecP;
typedef struct DhPeakS *DhPeakP;

typedef void (*DhSpecApplyFunc) (DhSpecP, void *);
typedef void (*DhPeakApplyFunc) (DhPeakP, void *);

typedef void (*DhSpecInvalidCB) (DhSpecP, void *);

typedef enum {
  ST_BRUKER,
  ST_EASY,
  ST_NOISE,
  ST_REGION
} SpecType;

/* create and destroy structures */

extern void DhDestroyAll(void);

extern DhSpecP DhSpecNew(DSTR, SpecType);
extern DhSpecP DhSpecNewNoise(DhSpecP);
extern DhSpecP DhRegNew(DhSpecP, AppRegionP);
extern void DhSpecDestroy(DhSpecP);

extern DhPeakP DhPeakNew(DhSpecP, AppPeakP);
extern void DhPeakDestroy(DhPeakP);

/* callbacks for change notification */

extern void DhAddSpecInvalidCB(DhSpecInvalidCB, void *);
extern void DhRemoveSpecInvalidCB(DhSpecInvalidCB, void *);

/* query data structure */

extern int DhGetSpecNo(void);

extern void DhApplySpec(PropRefP, DhSpecApplyFunc, void *);
extern DhSpecP DhSpecFindName(DSTR);
extern DhSpecP DhSpecFindNumber(int);
extern DhSpecP DhRegGetSpec(DhSpecP);
extern DhSpecP DhPeakGetReg(DhPeakP);
extern DhSpecP DhPeakGetSpec(DhPeakP);

extern void DhApplyPeak(PropRefP, DhPeakApplyFunc, void *);
extern void DhSpecApplyPeak(PropRefP, DhSpecP, DhPeakApplyFunc, void *);
extern DhPeakP DhPeakFind(DhSpecP, int);

/* access to underlying structures of app library */

extern AppSpectrumP DhSpecGetApp(DhSpecP);
extern AppNoiseP DhSpecGetNoise(DhSpecP);
extern AppRegionP DhRegGetApp(DhSpecP);
extern AppPeakP DhPeakGetApp(DhPeakP);

/* access data, general */

extern SpecType DhSpecGetType(DhSpecP);
extern int DhSpecGetDim(DhSpecP);
extern void DhSpecGetSizes(DhSpecP, int []);
extern void DhSpecSetRegion(DhSpecP, int [][2]);
extern void DhSpecGetRegion(DhSpecP, int [][2]);
extern void DhSpecSetResol(DhSpecP, int []);
extern void DhSpecSetScale(DhSpecP, float);
extern float *DhSpecGetVal(DhSpecP, int []);

/* access data, 2D */

extern Vec3 *DhSpecGetPoints(DhSpecP);
extern Vec3 *DhSpecGetNorm(DhSpecP);
extern void DhSpecGetCont(DhSpecP, ContourLine **, int *);

/* access data, 3D */

extern void DhSpecSetLevel(DhSpecP, float);
extern void DhSpecGetSurf(DhSpecP, IsoSurface **, int *);

/* access data, 2D/3D */

extern void DhPeakGetPoint(DhPeakP, Vec3);

/* properties */

extern void DhClearPropStand(void);
extern void DhSpecSetPropStand(DhSpecP);

extern void DhSpecSetProp(PropRefP, DhSpecP, BOOL);
extern void DhPeakSetProp(PropRefP, DhPeakP, BOOL);

extern BOOL DhSpecGetProp(PropRefP, DhSpecP);
extern BOOL DhPeakGetProp(PropRefP, DhPeakP);

extern unsigned *DhSpecGetPropTab(DhSpecP);
extern unsigned *DhPeakGetPropTab(DhPeakP);

/* set attributes */

extern void DhSpecSetName(DhSpecP, DSTR);
extern void DhSpecSetRotMat(DhSpecP, Mat4);
extern void DhSpecSetRotPoint(DhSpecP, Vec3);
extern void DhSpecSetTransVect(DhSpecP, Vec3);
extern void DhSpecSetAttr(DhSpecP, AttrP);
extern void DhSpecSetSpecAttr(DhSpecP, SpecAttrP);

extern void DhPeakSetAttr(DhPeakP, AttrP);

/* get attributes */

extern DSTR DhSpecGetName(DhSpecP);
extern int DhSpecGetNumber(DhSpecP);
extern void DhSpecGetRotMat(DhSpecP, Mat4);
extern void DhSpecGetRotPoint(DhSpecP, Vec3);
extern void DhSpecGetTransVect(DhSpecP, Vec3);
extern AttrP DhSpecGetAttr(DhSpecP);
extern SpecAttrP DhSpecGetSpecAttr(DhSpecP);

extern int DhPeakGetNumber(DhPeakP);
extern AttrP DhPeakGetAttr(DhPeakP);

/* calculations */

extern void DhTransfVec(Vec3, DhSpecP);

#endif  /* _DATA_HAND_H_ */
