/*
************************************************************************
*
*   attr_struc.h - attribute structure
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/include/SCCS/s.attr_struc.h
*   SCCS identification       : 1.1
*
************************************************************************
*/

#ifndef _ATTR_STRUC_H_
#define _ATTR_STRUC_H_

#include <attr_type.h>

#include <bool.h>
#include <sg_types.h>

#define LABEL_FORMAT_SIZE 16
#define SHADE_DEFAULT SG_SHADE_GOURAUD

typedef enum {
  SS_INVISIBLE,
  SS_GRID,
  SS_SURFACE,
  SS_CONTOUR
} SpecStyle;

typedef enum {
  PS_INVISIBLE,
  PS_CIRCLE,
  PS_CROSS
} PeakStyle;

struct AttrS {
  float colR, colG, colB;
  float secColR, secColG, secColB;
  float ambCoeff;
  float diffCoeff;
  float specCoeff;
  float shininess;
  float reflect;
  float alpha;
  float refract;
  char texture[SG_TEXTURE_NAME_SIZE];
  float textureScale;
  float bumpDepth;
  float bumpScale;
  SpecStyle specStyle;
  PeakStyle peakStyle;
  char labelFormat[LABEL_FORMAT_SIZE];
  float radius;
  float angle;
  float length;
  float lineWidth;
  SgLineStyle lineStyle;
  short shadeModel;  /* -1 or one of SgShadeModel values */
  float fontSize;
};

struct SpecAttrS {
  BOOL objDefined;
  SgObjId objId;
};

#endif  /* _ATTR_STRUC_H_ */
