/*
************************************************************************
*
*   help2html.c - convert help pages to HTML format
*
*   Copyright (c) 1995
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 95/10/13
*   Pathname of SCCS file     : /sgiext/molmol/bin/SCCS/s.help2html.c
*   SCCS identification       : 1.3
*
************************************************************************
*/

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <bool.h>

#define LINE_LEN 500

static void
writeHead(FILE *fp, char *title)
{
  (void) fprintf(fp, "<HEAD>\n");
  (void) fprintf(fp, "<TITLE>%s</TITLE>\n", title);
  (void) fprintf(fp, "<LINK REV=\"made\" "
      "HREF=\"mailto:kor@mol.biol.ethz.ch\">\n");
  (void) fprintf(fp, "</HEAD>\n");
  (void) fprintf(fp, "<BODY>\n");
  (void) fprintf(fp, "<H1>%s</H1>\n", title);
}

static void
writeTail(FILE *fp)
{
  (void) fprintf(fp, "<HR>\n");
  (void) fprintf(fp, "<ADDRESS>\n");
  (void) fprintf(fp, "Reto Koradi, "
      "<A HREF=mailto:kor@mol.biol.ethz.ch>kor@mol.biol.ethz.ch</A>\n");
  (void) fprintf(fp, "</ADDRESS>\n");
  (void) fprintf(fp, "</BODY>\n");
}

int
main(int argc, char *argv[])
{
  int fileI;
  FILE *indexF, *inF, *outF;
  char outName[100];
  BOOL descrFound, inExample, inParag, inPre;
  char line[LINE_LEN], outLine[LINE_LEN], linkStr[LINE_LEN], *wordP;
  int res, inInd, outInd, wordLen, i;

  if (argc < 2) {
    (void) fprintf(stderr, "usage: %s filenames\n", argv[0]);
    return 1;
  }

  res = mkdir("html", 0777);
  if (mkdir("html", 0777) < 0 && errno != EEXIST) {
    (void) fprintf(stderr, "could not create subdir html\n");
    return 1;
  }

  indexF = fopen("html/index.html", "w");
  if (indexF == NULL) {
    (void) fprintf(stderr, "could not open html/index.html\n");
    return 1;
  }
  writeHead(indexF, "Command List");

  for (fileI = 1; fileI < argc; fileI++) {
    inF = fopen(argv[fileI], "r");
    if (inF == NULL) {
      (void) fprintf(stderr, "could not open %s\n", argv[fileI]);
      return 1;
    }

    (void) sprintf(outName, "html/%s.html", argv[fileI]);
    outF = fopen(outName, "w");
    if (outF == NULL) {
      (void) fprintf(stderr, "could not open %s\n", outName);
      return 1;
    }

    (void) fprintf(indexF, "<A HREF=\"%s.html\"><KBD>%s</KBD></A><BR>\n",
	argv[fileI], argv[fileI]);
    writeHead(outF, argv[fileI]);
    descrFound = FALSE;
    inExample = FALSE;
    inParag = FALSE;
    inPre = FALSE;

    while (fgets(line, sizeof(line), inF) != NULL) {
      line[strlen(line) - 1] = '\0';  /* remove trailing \n */

      if (strncmp(line, "DESCRIPTION", 11) == 0)
	descrFound = TRUE;

      inInd = 0;
      while (line[inInd] != '\0') {
	if (line[inInd] != ' ' && line[inInd] != '\t')
	  break;
	inInd++;
      }

      if (line[inInd] == '\0') {
	if (inParag) {
	  (void) fprintf(outF, "<P>\n");
	  inParag = FALSE;
	} else if (inPre) {
	  (void) fprintf(outF, "</PRE>\n");
	  inPre = FALSE;
	}
	continue;
      }
      
      if (line[0] != ' ' && line[0] != '\t') {
	(void) fprintf(outF, "<STRONG>%s</STRONG><P>\n", line);
	inExample = (strncmp(line, "EXAMPLE", 7) == 0);
	continue;
      }

      if (! descrFound || inExample ||
	  strncmp(line, "      ", 6) == 0 || line[0] == '\t') {
	if (inParag) {
	  (void) fprintf(outF, "<P>\n");
	  inParag = FALSE;
	}

	if (! inPre) {
	  (void) fprintf(outF, "<PRE>\n");
	  inPre = TRUE;
	}

	if (line[0] == '\t') {
	  outInd = 1;
	  (void) fprintf(outF, "   ");
	} else {
	  outInd = 5;
	}

	while (line[outInd] == '\t') {
	  (void) fprintf(outF, "        ");
	  outInd++;
	}

	(void) fprintf(outF, "%s\n", line + outInd);
	continue;
      }

      if (inPre) {
	(void) fprintf(outF, "</PRE>\n");
	inPre = FALSE;
      }

      wordP = outLine;
      inInd = 5;
      outInd = 0;

      while (line[inInd] != '\0') {
	outLine[outInd++] = line[inInd++];

	if (line[inInd] == ' ' || line[inInd] == '\0' ||
	    line[inInd] == ',' || line[inInd] == '.' ||
	    line[inInd] == ')') {
	  outLine[outInd] = '\0';
	  wordLen = strlen(wordP);

	  for (i = 1; i < argc; i++) {
	    if (i == fileI)
	      continue;

	    if (strcmp(argv[i], wordP) == 0 ||
		outLine[outInd - 1] == '*' && wordLen > 1 &&
		strncmp(argv[i], wordP, wordLen - 1) == 0) {
	      (void) sprintf(linkStr,
	          "<A HREF=\"%s.html\"><KBD>%s</KBD></A>", argv[i], wordP);
	      (void) strcpy(wordP, linkStr);
	      outInd = strlen(outLine);
	    }
	  }

	  wordP = outLine + outInd + 1;
	} else if (line[inInd - 1] == '(') {
	  wordP = outLine + outInd;
	}
      }

      (void) fprintf(outF, "%s\n", outLine);

      inParag = TRUE;
    }

    writeTail(outF);

    (void) fclose(inF);
    (void) fclose(outF);
  }

  writeTail(indexF);
  (void) fclose(indexF);

  return 0;
}
