#include <stdio.h>
#include <stdlib.h>

#include <app/spec_access.h>
#include <app/spec_noise.h>
#include <specio/bruker.h>

int
main(int argc, char *argv[])
{
  AppSpectrumP specP;
  AppDataRange rangeA[2];
  AppNoiseP noiseP;
  int dim, sizeA[2], coord[2];

  specP = SpecIOBrukerOpen("/u/data/shit/nmr/shit/1/shit/1/2rr");
  if (specP == NULL) {
    (void) fprintf(stderr, "could not open spectrum\n");
    return 1;
  }

  (void) printf("\ncalculate noise\n");
  AppGetSpectrumInfo(specP, &dim, sizeA);
  rangeA[0][0] = 0;
  rangeA[0][1] = sizeA[0] - 1;
  rangeA[1][0] = 0;
  rangeA[1][1] = sizeA[1] - 1;
  noiseP = AppNoisePrepare(specP, rangeA);

  coord[0] = -1;
  for (coord[1] = 0; coord[1] < sizeA[1]; coord[1]++)
    (void) printf("row %4d: %9.3f\n",
	coord[1], AppNoiseGetRow(noiseP, coord));

  coord[1] = -1;
  for (coord[0] = 0; coord[0] < sizeA[0]; coord[0]++)
    (void) printf("col %4d: %9.3f\n",
	coord[0], AppNoiseGetRow(noiseP, coord));

  AppNoiseDestroy(noiseP);

  SpecIOBrukerClose(specP);

  return 0;
}
