/*
************************************************************************
*
*  block_tab.h - header for BlockTab.c
*
*  Copyright (c) 1988 - 1996
*
*  Spectrospin AG, 8117 Faellanden Switzerland
*  Bruker Instruments Inc., Billerica Mass. 01821 USA
*  Bruker Analytische Messtechnik GmbH, D-76189 Karlsruhe
*  Bruker Franzen Analytik GmbH, D-28359 Bremen
*
*  All Rights Reserved
*
*  Date of last modification : 96/09/13
*  Pathname of SCCS file     : /sgiext/autopsy/app/src/ndio/SCCS/s.block_tab.h
*  SCCS identification       : 1.1
*
*  Modifications :
*  <NAME>   <DATE>   <COMMENTS>
*
************************************************************************
*/

#ifndef _BLOCK_TAB_H_
#define _BLOCK_TAB_H_

#include <bool.h>
#include <ndio/ndio_types.h>

typedef NdioDataPtr BlockPtr;
typedef struct blockTabRec *BLOCKTABHANDLE;

extern void BlockSetMemLimit(int memLimit);

extern void BlockInit(void);

extern BLOCKTABHANDLE BlockOpen(char *fileName,
    NdioFileType type, int headerSize, int fileSize, int blockSize,
    NdioFileMode mode, BOOL byteSwap);

extern BlockPtr BlockGet(BLOCKTABHANDLE blockHandle,
    int idx, NdioFileMode mode);

extern void BlockPut(BLOCKTABHANDLE blockHandle,
    int idx, NdioFileMode mode);

extern void BlockClose(BLOCKTABHANDLE blockHandle);

extern void BlockCleanup(void);

#endif  /* _BLOCK_TAB_H_ */
