/*
************************************************************************
*
*   NdioError.c - functions for setting Ndio error reporting function
*
*   Copyright (c) 1992-96
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH - 8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/src/ndio/SCCS/s.NdioError.c
*   SCCS identification       : 1.1
*
*   Modifications :
*   <NAME>  <DATE>  <COMMENTS>
*   kor     920319  created
*
************************************************************************
*/

#include <ndio/ndio_error.h>

#include <stdio.h>
#include <stdarg.h>
#include <errno.h>

#ifdef __linux
/*PG extern int errno;*/
#else
extern char *sys_errlist[];
/*extern int errno;*/
extern int sys_nerr;
#endif

/**********************************************************************/
static void
ndioDefaultError(
    char *msg,
    ...)
/*----------------------------------------------------------------------
Default for NdioError.
----------------------------------------------------------------------*/
{
  va_list args;

  va_start(args, msg);
  (void) fprintf(stderr, "ERROR: ");
  (void) vfprintf(stderr, msg, args);
  va_end(args);
  (void) fprintf(stderr, "\n");
}

NdioErrorFuncType NdioError = ndioDefaultError;

/**********************************************************************/
void
NdioErrorSetFunc(NdioErrorFuncType errorF)
/*----------------------------------------------------------------------
Set the error reporting function used by Ndio.
----------------------------------------------------------------------*/
{
  NdioError = errorF;
}

/**********************************************************************/
char *
NdioErrorGetSys(void)
/*----------------------------------------------------------------------
Gets the error string after a system call gave an error return.
----------------------------------------------------------------------*/
{
  if (errno < 0 || errno >= sys_nerr)
    return "unknown error";

  return sys_errlist[errno];
}
