/*
************************************************************************
*
*   reg_struc.h - type definition for region structure
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/21
*   Pathname of SCCS file     : /sgiext/autopsy/app/src/app/SCCS/s.reg_struc.h
*   SCCS identification       : 1.3
*
************************************************************************
*/

#include <linlist.h>
#include <app/reg.h>

typedef struct RegCopyS *RegCopyP;

struct AppRegionS {
  struct AppRegionDataS d;  /* must be first member, type cast! */
  AppSpectrumP specP;
  int boxSize;
  AppNoiseP noiseP;
  float segLevel, minLevel;
  LINLIST maxL;  /* list of struct AppMaxS */
  RegCopyP copyP;
};

extern void RegionSortMax(AppRegionP regP);
/* Sort maximum list by amplitude. */

extern float *RegionGetNoise(AppRegionP regP);
/* Return array with noise value for each data point. Should be
   freed when not needed anymore. */

extern void RegionStrucFree(AppRegionP regP);
/* Free contents of structure, but not structure itself. */
