/*
************************************************************************
*
*   SpecAccess.c - spectrum access
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/src/app/SCCS/s.SpecAccess.c
*   SCCS identification       : 1.2
*
************************************************************************
*/

#include <app/spec_access.h>

#include <stdlib.h>
#include <string.h>

#include "spec.h"

AppSpectrumP
AppOpenSpectrum(int dim, int sizeA[], float offsA[], float swA[],
    AppDataType type, AppSpectrumReadF readF, void *clientData)
{
  AppSpectrumP specP;
  int i;

  specP = malloc(sizeof(*specP));

  specP->dim = dim;
  for (i = 0; i < dim; i++) {
    specP->sizeA[i] = sizeA[i];
    specP->offsA[i] = offsA[i];
    specP->swA[i] = swA[i];
  }
  specP->type = type;
  specP->sign = 1;
  specP->readF = readF;
  specP->clientData = clientData;

  return specP;
}

void
AppSetSpectrumSign(AppSpectrumP specP, int sign)
{
  specP->sign = sign;
}

void
AppGetSpectrumInfo(AppSpectrumP specP, int *dimP, int sizeA[])
{
  int i;

  *dimP = specP->dim;

  for (i = 0; i < specP->dim; i++)
    sizeA[i] = specP->sizeA[i];
}

void
AppConvertSpectrumUnit(AppSpectrumP specP,
    float inCoord[], char *inUnit, float outCoord[], char *outUnit)
{
  int i;

  if (strcmp(inUnit, outUnit) == 0) {
    for (i = 0; i < specP->dim; i++)
      outCoord[i] = inCoord[i];
  } else if (strcmp(inUnit, "point") == 0) {
    for (i = 0; i < specP->dim; i++)
      outCoord[i] = specP->offsA[i] -
	  inCoord[i] * specP->swA[i] / specP->sizeA[i];
  } else {
    for (i = 0; i < specP->dim; i++)
      outCoord[i] = (specP->offsA[i] - inCoord[i]) *
	  specP->sizeA[i] / specP->swA[i];
  }
}

void
AppReadSpectrum(AppSpectrumP specP, AppDataRange rangeA[], AppDataP dataA)
{
  float *fP;
  int *iP;
  int totSize, i;

  specP->readF(specP->clientData, rangeA, dataA);

  if (specP->sign == 1)
    return;

  totSize = 1;
  for (i = 0; i < specP->dim; i++)
    totSize *= rangeA[i][1] - rangeA[i][0] + 1;

  if (specP->type == ADT_FLT32) {
    fP = dataA;
    for (i = 0; i < totSize; i++)
      fP[i] = - fP[i];
  } else {
    iP = dataA;
    for (i = 0; i < totSize; i++)
      iP[i] = - iP[i];
  }
}

void
AppCloseSpectrum(AppSpectrumP specP)
{
  free(specP);
}
