/*
************************************************************************
*
*   Conv.c - conversion of vectors to float
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/src/app/SCCS/s.Conv.c
*   SCCS identification       : 1.2
*
************************************************************************
*/

#include "conv.h"

#include <stdlib.h>

/* The vector returned by one of these functions is only valid
   until the next call to one of the functions! */

static int CurrSize = 0;
static float *CurrA;

float *
ConvGetFloat(AppDataP dataA, int size, AppDataType type)
{
  int *intA;  /* PORT: must be 32-bit type! */
  int i;

  if (type == ADT_FLT32)
    return dataA;

  if (size > CurrSize) {
    if (CurrSize == 0)
      CurrA = malloc(size * sizeof(*CurrA));
    else
      CurrA = realloc(CurrA, size * sizeof(*CurrA));
    
    CurrSize = size;
  }

  intA = dataA;

  for (i = 0; i < size; i++)
    CurrA[i] = (float) intA[i];

  return CurrA;
}

float *
ConvGetRegionFloat(AppRegionDataP regDataP)
{
  int size, i;

  size = 1;
  for (i = 0; i < regDataP->dimensionNo; i++)
    size *= regDataP->rangeA[i][1] - regDataP->rangeA[i][0] + 1;
  
  return ConvGetFloat(regDataP->dataA, size, regDataP->dataType);
}
