/*
************************************************************************
*
*   bruker.h - I/O of spectra in BRUKER format
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/specio/SCCS/s.bruker.h
*   SCCS identification       : 1.2
*
************************************************************************
*/

#include <app/spec_access.h>

extern AppSpectrumP SpecIOBrukerOpen(char *fileName);
/* Open spectrum in BRUKER format. The file name given must be the
   name of a file with processed data, the necessary parameters
   are read from the parameter files in the same directory. */

extern void SpecIOBrukerGetCompressed(AppSpectrumP specP,
    AppDataRange rangeA[], int resolA[], AppDataP dataA);
/* Read the specified part of the spectrum, and fill the data into
   dataA, the type will be float. The region is compressed to
   the resolutions given in resolA.
*/

extern void SpecIOBrukerClose(AppSpectrumP specP);
/* Close a file opened with SpecIOBrukerOpen(). */
