/*
************************************************************************
*
*   ndio_types.h - data types for N dimensional data i/o module 
*
*   Copyright (c) 1991-96
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification	: 96/09/13
*   Pathname of SCCS file	: /sgiext/autopsy/app/include/ndio/SCCS/s.ndio_types.h
*   SCCS identification		: 1.1
*
*   Modifications :
*   <NAME>  <DATE>  <COMMENTS>
*
************************************************************************
*/

#ifndef _NDIO_TYPES_H_
#define _NDIO_TYPES_H_

#include <ndio/mach_types.h>

typedef FLOAT32  NdioData;	/* all data is returned as 32 bit float */
typedef NdioData *NdioDataPtr;

#define DATA_SIZE sizeof(NdioData) 

typedef enum {
  NdioINT,
  NdioFLOAT,
  NdioEASY8,
  NdioEASY16
} NdioFileType;

typedef enum {
  NdioREAD,
  NdioWRITE,
  NdioREAD_WRITE
} NdioFileMode;

#endif  /* _NDIO_TYPES_H_ */
