/*
************************************************************************
*
*   ndio_header.h - definitions for headers of Ndio files
*
*   Copyright (c) 1992-96
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH - 8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/ndio/SCCS/s.ndio_header.h
*   SCCS identification       : 1.1
*
*   Modifications :
*   <NAME>  <DATE>  <COMMENTS>
*   kor     920313  created
************************************************************************
*/

#ifndef _NDIO_HEADER_H_
#define _NDIO_HEADER_H_

#define NDIO_MAGIC 0x7d30fc95

/*--------------- these parameters are always available --------------*/

#define NDIO_PAR_BYTE_SWAP 1
/* (INT32) 1 if byte swapping is necessary on this machine,
   0 otherwise */

#define NDIO_PAR_HEADER_SIZE 2
/* size of the header in bytes (INT32) */

#define NDIO_PAR_DIM  3
/* number of dimensions (INT32) */

#define NDIO_PAR_SIZE 4
/* size in one direction (INT32), array[dim] */

#define NDIO_PAR_TOTAL_SIZE 5
/* total size (INT32) */

#define NDIO_PAR_SMX_SIZE 6
/* submatrix size in one direction (INT32), array[dim] */

#define NDIO_PAR_TOTAL_SMX_SIZE 7
/* total size of a submatrix (INT32) */

/*-------------------- these paramers are optional -------------------*/

#define NDIO_PAR_TYPE 101
/* type (INT32), one of NDIO_TYPE_* */

#define NDIO_TYPE_INT32
#define NDIO_TYPE_FLOAT32

#define NDIO_PAR_IMIN 102
/* minimum (INT32) */

#define NDIO_PAR_IMAX 103
/* maximum (INT32) */

#define NDIO_PAR_FMIN 104
/* minimum (FLOAT32) */

#define NDIO_PAR_FMAX 105
/* maximum (FLOAT32) */

#endif  /* _NDIO_HEADER_H_ */
