/*
************************************************************************
*
*   spec_noise.h - local noise determination
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/21
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/app/SCCS/s.spec_noise.h
*   SCCS identification       : 1.3
*
************************************************************************
*/

#ifndef SPEC_NOISE_H
#define SPEC_NOISE_H

#include <app/base_types.h>

typedef struct AppNoiseS *AppNoiseP;

extern AppNoiseP AppNoisePrepare(AppSpectrumP specP, AppDataRange rangeA[]);
/* Prepare for calculation of local noise values in the given
   region. An opaque pointer is returned, it is passed to all
   functions that need noise levels. */

extern float AppNoiseGetMagnitude(AppNoiseP noiseP, int coord[]);
/* Returns the noise magnitude at the given coordinates. */

extern float AppNoiseGetMagnitudeFloat(AppNoiseP noiseP, float posA[]);
/* Returns the noise magnitude at the given position as maximum
   of all neighbouring data points. */

extern float AppNoiseGetRow(AppNoiseP noiseP, int coord[]);
/* Returns the noise magnitude for the given row. The row is
   selected by the coordinates, where -1 must be passed for exactly
   one of them, the row will extend in this direction. */

extern void AppNoiseDestroy(AppNoiseP noiseP);
/* Free storage allocated in AppNoisePrepare(). */

#endif
