/*
************************************************************************
*
*   reg_symm.h - calculate symmetry of spectrum region
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/21
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/app/SCCS/s.reg_symm.h
*   SCCS identification       : 1.3
*
************************************************************************
*/

#ifndef REG_SYMM_H
#define REG_SYMM_H

#include <app/base_types.h>
#include <app/reg_data.h>

extern void AppBestSymmetry(AppRegionDataP regDataP, int maxPosA[],
    float maxSplitA[], float splitDiff, float noiseMagn, float posA[]);
/* Calculate the symmetry center of the region (position that gives the
   best symmetry). maxPosA must be given as the position of the local
   maximum where the search should start.
   maxSplitA defines the maximum splitting of peaks in each
   dimension (in data points). splitDiff gives the relative difference
   of amplitudes allowed for split peaks. NULL can be given for
   maxSplitA if no check for too large splitting is desired.
   An estimation for the noise at the peak position must be passed
   as noiseMagn, noiseMagnitudeMax from the region descriptor can
   be used if no better value is know. */

extern void AppCalcSymmetry(AppRegionDataP regDataP,
    float posA[], float errA[]);
/* Calculate errors in the symmetry for each direction for the given
   position of the symmetry center. */

extern void AppSymmetrize(AppRegionDataP regDataP,
    float posA[], BOOL dirSelA[]);
/* Symmetrize region relative to the given symmetry center, in the
   directions where the entry in dirSelA is TRUE. */

#endif
