/*
************************************************************************
*
*   reg_data.h - type definiton of spectrum region data
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/app/SCCS/s.reg_data.h
*   SCCS identification       : 1.2
*
************************************************************************
*/

#ifndef REG_DATA_H
#define REG_DATA_H

#include <app/base_types.h>

typedef struct AppRegionDataS {
  int dimensionNo;
  AppDataRange rangeA[APP_MAX_DIM];
  AppDataRange subRangeA[APP_MAX_DIM];
  AppDataType dataType;
  AppDataP dataA;
  BOOL *validA;
  float baseLevel;
  float maxAmplitude;
  float noiseMagnitudeMax;
} *AppRegionDataP;

extern BOOL AppRegionIsInside(AppRegionDataP regDataP, int coord[]);
/* Return TRUE if the given coordinates are inside the region,
   FALSE otherwise. */

#endif
