/*
************************************************************************
*
*   reg.h - type definiton of spectrum region
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/21
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/app/SCCS/s.reg.h
*   SCCS identification       : 1.3
*
************************************************************************
*/

#ifndef REG_H
#define REG_H

#include <app/reg_data.h>
#include <app/spec_noise.h>

#define APP_PUSH_DATA     0x01
#define APP_PUSH_VALID    0x02
#define APP_PUSH_MAX_LIST 0x04

/* AppRegionP can be casted to AppRegionDataP, it's kind of a subclass
   with some additonal information (like a list of maxima) that can't
   be accessed directly from outside. */
typedef struct AppRegionS *AppRegionP;

typedef struct AppMaxS {
  int coordinates[APP_MAX_DIM];
  float amplitude;
  float noiseMagnitude;
} *AppMaxP;

typedef void (* AppMaxApplyF) (AppMaxP maxP, void *clientData);

extern AppRegionP AppRegionNew(AppRegionDataP regDataP);
/* Create a new region with the given data. The function allocates
   memory for the structure and all fields and copies them. */

extern void AppRegionPushState(AppRegionP regP, int mask);
/* Save the current state of the region, so that it can be modified
   and later recoverd with AppRegionPopState. The saved fields are
   given by a mask, which must be a bitwise or of the APP_PUSH_*
   values defined above. */

extern void AppRegionPopState(AppRegionP regP);
/* Recover state previous to most recent call of AppRegionPushState. */

extern void AppRegionDestroy(AppRegionP regP);
/* Free all memory associated with the given region. */

extern void AppMaxApply(AppRegionP regP,
    AppMaxApplyF applyF, void *clientData);
/* Call applyF for all local maxima of the region. */

extern void AppMaxUpdate(AppRegionP regP);
/* Update maxAmplitude and list with local maxima after dataA was changed. */

#endif
