/*
************************************************************************
*
*   elim.h - eliminate peaks in region
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/app/SCCS/s.elim.h
*   SCCS identification       : 1.2
*
************************************************************************
*/

#ifndef ELIM_H
#define ELIM_H

#include <app/base_types.h>
#include <app/reg.h>

extern void AppElimAll(AppRegionP regP,
    float minLevel, int minSizeA[],
    float maxSplitA[], float splitDiff,
    float maxErrFact);
/* Try to find a well enough separated peak in the given region.
   Only local maxima that are at least a factor of minLevel
   above the noise level are considered. The minimal number of data
   points used to describe a peak in each direction is given
   in minSizeA.
   maxSplitA defines the maximum splitting of peaks in each
   dimension (in data points). splitDiff gives the relative
   difference of amplitudes allowed for split peaks.
   maxErrFact is the maximum allowed symmetry error of a peak
   relative to its amplitude. If the error is larger than this
   value, it is considered to be consisting of multiple peaks.
   Typical values are between 0.1 and 0.5.
   Found peaks will be added to the peak list of the spectrum
   and subtracted from the region. */

#endif
