Copyright (c) 2002-07 Peter Guntert. All rights reserved.
c     ==================================================================
C     COCO:      Compare covalent geometries
C
      PROGRAM COCO
C
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INCLUDE 'global.incl'
C
      CHARACTER*(*) VERS,DEFLIB
      PARAMETER (VERS='2.1',DEFLIB='/usr/local/soft/lib/amber94.lib',
     *           NTYP=5,MAXSTR=50,MAXA1=MAXA+1)
C
      DIMENSION CUT(NTYP),RX(MAXA),RY(MAXA),RZ(MAXA),A(3,MAXA),
     *          B(3,MAXA),NVIO(NTYP,MAXSTR+4),RMSVIO(NTYP,MAXSTR+4),
     *          VIOMAX(NTYP,MAXSTR+4),TABMAX(MAXVIO),
     *          KEY1(MAXVIO),KEY2(MAXVIO),INDX(MAXVIO),
     *          AA(3),BB(3),CC(3),DD(3) 
      LOGICAL REDIR,FREE(MAXD)
      CHARACTER FILNAM*80,LINE*80,VIOTAB(MAXVIO)*(MAXSTR+4),
     *          TYP(NTYP)*6,STR(MAXSTR)*4
C
      DATA TYP/'Bond','Angle','Fixed','RMSD','Dihed'/
C
      OPEN (9,STATUS='SCRATCH')
      WRITE (*,*)
      WRITE (*,*) 'COCO: COmpare COvalent geometries (version ',VERS,')'
      WRITE (*,*)
      WRITE (*,*) 'Copyright (c) 2002-07 Peter Guntert. '//
     *            'All rights reserved.'
      WRITE (*,*)
C     ----------------------------------------------- OUTPUT RESULT FILE
      CALL READFN ('Output result file','res','coco.res',
     *             FILNAM)
      OPEN (3,FILE=FILNAM)
      WRITE (3,'(''Result file of the program COCO  (version '',
     *      A,'')'')') VERS
      WRITE (3,'(''_______________________________''///)')
C     ----------------------------------------------------- READ LIBRARY
      CALL READFN ('Input library file','lib',DEFLIB,FILNAM)
      OPEN (1,FILE=FILNAM,STATUS='OLD')
      CALL GETLIB (1)
      CLOSE (1)
      WRITE (3,'(''Library                        : '',A)')
     *      FILNAM(1:LENSTR(FILNAM))
C     ---------------------------------------------------- READ SEQUENCE
      CALL READFN ('Input sequence file','seq',' ',FILNAM)
      OPEN (1,FILE=FILNAM,STATUS='OLD')
      CALL GETSEQ (1,9)
      CLOSE (1)
      WRITE (3,'(''Sequence                       : '',A)')
     *      FILNAM(1:LENSTR(FILNAM))
      DO 20 I=1,ND
        J=IDORD(I)
        FREE(I)=ABS(DDEF(I)).GT.1.0E8
        IF (FREE(I)) THEN
          DVAL(J)=PI
        ELSE
          DVAL(J)=DDEF(I)
        END IF
   20   CONTINUE
      CALL TREE (FREE)
C     ---------------------------------------- LIST STRUCTURE PARAMETERS
      WRITE (LINE(1:19),'(I8,'' rotatable)'')') NDFREE
      DO 21 I=1,8
   21   IF (LINE(I:I).GT.' ') GO TO 22
   22 WRITE (3,'(''Number of residues             :'',I10/
     *           ''Number of atoms                :'',I10/
     *           ''Number of dihedral angles      :'',I10,'' ('',A)')
     *      NR,NA,ND,LINE(I:19)
C     --------------------------------------- SET VIOLATION LIST CUTOFFS
      CALL READR (9,'Cutoffs: bond lengths/angles, fixed dist., RMSDs'//
     *           ', dihedrals','0.01 5.0 2*0.05 5.0',CUT,NTYP)
      WRITE (3,'(''Cutoff for bond lengths        :'',F10.4,'' A''/
     *           ''Cutoff for bond angles         :'',F10.4,'' deg''/
     *           ''Cutoff for fixed distances     :'',F10.4,'' A''/
     *           ''Cutoff for rigid unit RMSDs    :'',F10.4,'' A''/
     *           ''Cutoff for fixed dih. angles   :'',F10.4,'' deg'')')
     *      (CUT(J),J=1,NTYP)
C     ---------------------------------------------- REFERENCE STRUCTURE
      CALL READFN ('Input reference structure file','cor','none',FILNAM)
      IF (FILNAM.EQ.' ') THEN
        CALL GENER
        FILNAM='generated internally'
      ELSE
        OPEN (1,FILE=FILNAM,STATUS='OLD')
        CALL GETCOR (1)
        CLOSE (1)
      END IF
      DO 30 I=1,NA
        RX(I)=CX(I)
        RY(I)=CY(I)
   30   RZ(I)=CZ(I)
      WRITE (3,'(''Reference structure            : '',A)')
     *      FILNAM(1:LENSTR(FILNAM))
C     ----------------------------------------- INPUT CONFORMATION FILES
      MVIO=0
      NSTR=0
      REDIR=.FALSE.
   35 IF (REDIR) THEN
        READ (2,'(A)',END=800) FILNAM
      ELSE
        CALL READFN ('Input structure file','cor','none',FILNAM)
        I=INDEX(FILNAM,'<')
        REDIR=I.GT.0
        IF (REDIR) THEN
          OPEN (2,FILE=FILNAM(I+1:80),STATUS='OLD')
          WRITE (3,'(''List with structure file names : '',A)')
     *          FILNAM(I+1:LENSTR(FILNAM))
          GO TO 35 
        END IF
      END IF
      IF (FILNAM.EQ.' ') GO TO 800
      NSTR=NSTR+1
      OPEN (1,FILE=FILNAM,STATUS='OLD')
      CALL GETCOR (1)
      CLOSE (1)
      WRITE (*,'(''Structure'',I4,'': '',A)')
     *      NSTR,FILNAM(1:LENSTR(FILNAM))
      WRITE (3,'(///''Structure'',I4,''                  : '',A)')
     *      NSTR,FILNAM(1:LENSTR(FILNAM))
C     --------------------------- FIND ATOMS THAT ARE IN BOTH STRUCTURES
      NABOTH=0
      DO 40 I=1,NA
        IF (RX(I).GE.1.0E10) CX(I)=RX(I)
   40   IF (CX(I).LT.1.0E10) NABOTH=NABOTH+1
      WRITE (3,'(''Number of matching atoms       :'',I10)') NABOTH
C     ----------------------------------------------- CHECK BOND LENGTHS
      WRITE (3,'(//''Bond length deviations:''/
     *       27X,''reference    value    viol.'')')
      ITYP=1
      N=0
      NN=0
      SUM=0.0
      RMS=0.0
      VMAX=0.0
      DO 220 I=1,NA-1
        IF (CX(I).LT.1.0E10) THEN
          DO 210 K=1,NBOND(I)
            J=IBOND(K,I)
            IF (CX(J).LT.1.0E10 .AND. J.GT.I) THEN
              N=N+1
              R=SQRT((RX(I)-RX(J))**2+(RY(I)-RY(J))**2+(RZ(I)-RZ(J))**2)
              C=SQRT((CX(I)-CX(J))**2+(CY(I)-CY(J))**2+(CZ(I)-CZ(J))**2)
              V=ABS(R-C)
              SUM=SUM+V
              RMS=RMS+V**2
              VMAX=MAX(V,VMAX)
              IF (V.GE.CUT(ITYP)) THEN
                NN=NN+1
                WRITE (3,'(A5,A3,I3,'' - '',A5,A3,I3,2X,3F9.4)') 
     *                ANAM(I),RNAM(IAR(I)),IR(IAR(I)),
     *                ANAM(J),RNAM(IAR(J)),IR(IAR(J)),R,C,R-C
                CALL ADDVIO (NSTR,ITYP*MAXA1+I,J,V,KEY1,KEY2,VIOTAB,
     *                       TABMAX,MVIO)  
              END IF
            END IF
  210       CONTINUE
        END IF  
  220   CONTINUE
      WRITE (3,'(/''Number of bond lengths         :'',I10/
     *            ''Number of deviations > cutoff  :'',I10/
     *            ''Average deviation              :'',F10.4,'' A''/
     *            ''RMS deviation                  :'',F10.4,'' A''/
     *            ''Maximal deviation              :'',F10.4,'' A''/
     *            ''Sum of deviations              :'',F10.4,'' A'')')
     *      N,NN,SUM/MAX(N,1),SQRT(RMS/MAX(N,1)),VMAX,SUM
      NVIO(ITYP,NSTR)=NN
      RMSVIO(ITYP,NSTR)=SQRT(RMS/MAX(N,1))
      VIOMAX(ITYP,NSTR)=VMAX
C     ------------------------------------------------ CHECK BOND ANGLES
      WRITE (3,'(//''Bond angle deviations:''/
     *       42X,''reference    value    viol.'')')
      ITYP=2
      N=0
      NN=0
      SUM=0.0
      RMS=0.0
      VMAX=0.0
      DO 320 I=1,NA
        IF (CX(I).LT.1.0E10) THEN
          DO 310 K=1,NBOND(I)
            J=IBOND(K,I)
            IF (CX(J).LT.1.0E10) THEN
              DO 300 L=K+1,NBOND(I)
                M=IBOND(L,I)
                IF (CX(M).LT.1.0E10) THEN
                  N=N+1
                  EX=RX(J)-RX(I)
                  EY=RY(J)-RY(I)
                  EZ=RZ(J)-RZ(I)
                  FX=RX(M)-RX(I)
                  FY=RY(M)-RY(I)
                  FZ=RZ(M)-RZ(I)
                  R=RAD*ACOS((EX*FX+EY*FY+EZ*FZ)/
     *              SQRT((EX**2+EY**2+EZ**2)*(FX**2+FY**2+FZ**2)))
                  EX=CX(J)-CX(I)
                  EY=CY(J)-CY(I)
                  EZ=CZ(J)-CZ(I)
                  FX=CX(M)-CX(I)
                  FY=CY(M)-CY(I)
                  FZ=CZ(M)-CZ(I)
                  C=RAD*ACOS((EX*FX+EY*FY+EZ*FZ)/
     *              SQRT((EX**2+EY**2+EZ**2)*(FX**2+FY**2+FZ**2)))
                  V=ABS(R-C)
                  SUM=SUM+V
                  RMS=RMS+V**2
                  VMAX=MAX(V,VMAX)
                  IF (V.GE.CUT(ITYP)) THEN
                    NN=NN+1
                    WRITE (3,'(A5,A3,I3,'' - '',A5,A3,I3,'' - '',
     *                A5,A3,I3,3X,3F9.3)') 
     *                ANAM(J),RNAM(IAR(J)),IR(IAR(J)),
     *                ANAM(I),RNAM(IAR(I)),IR(IAR(I)),
     *                ANAM(M),RNAM(IAR(M)),IR(IAR(M)),R,C,R-C
                    CALL ADDVIO (NSTR,ITYP*MAXA1+I,J*MAXA1+M,V,
     *                           KEY1,KEY2,VIOTAB,TABMAX,MVIO)  
                  END IF
                END IF
  300           CONTINUE
            END IF
  310       CONTINUE
        END IF  
  320   CONTINUE          
      WRITE (3,'(/''Number of bond angles          :'',I10/
     *            ''Number of deviations > cutoff  :'',I10/
     *            ''Average deviation              :'',F10.4,'' deg''/
     *            ''RMS deviation                  :'',F10.4,'' deg''/
     *            ''Maximal deviation              :'',F10.4,'' deg''/
     *            ''Sum of deviations              :'',F10.4,'' deg'')')
     *      N,NN,SUM/MAX(N,1),SQRT(RMS/MAX(N,1)),VMAX,SUM
      NVIO(ITYP,NSTR)=NN
      RMSVIO(ITYP,NSTR)=SQRT(RMS/MAX(N,1))
      VIOMAX(ITYP,NSTR)=VMAX
C     -------------------------------------------- CHECK FIXED DISTANCES
      WRITE (3,'(//''Fixed distance deviations:''/
     *       27X,''reference    value    viol.'')')
      ITYP=3
      N=0
      NN=0
      SUM=0.0
      RMS=0.0
      VMAX=0.0
      IRANGE=0
      DO 420 I=1,NA-1
        IF (CX(I).LT.1.0E10) THEN
          K1=IAUNIT(I)
          DO 410 J=I+1,NA
            K2=IAUNIT(J)
            IF (CX(J).LT.1.0E10 .AND. (K1.EQ.K2 .OR. 
     *          I.EQ.IDA(2,K2) .OR. I.EQ.IDA(3,K2) .OR.
     *          J.EQ.IDA(2,K1) .OR. J.EQ.IDA(3,K1))) THEN
              N=N+1
              IRANGE=MAX(IRANGE,ABS(IAR(I)-IAR(J)))
              R=SQRT((RX(I)-RX(J))**2+(RY(I)-RY(J))**2+(RZ(I)-RZ(J))**2)
              C=SQRT((CX(I)-CX(J))**2+(CY(I)-CY(J))**2+(CZ(I)-CZ(J))**2)
              V=ABS(R-C)
              SUM=SUM+V
              RMS=RMS+V**2
              VMAX=MAX(V,VMAX)
              IF (V.GE.CUT(ITYP)) THEN
                NN=NN+1
                WRITE (3,'(A5,A3,I3,'' - '',A5,A3,I3,2X,3F9.4)') 
     *                ANAM(I),RNAM(IAR(I)),IR(IAR(I)),
     *                ANAM(J),RNAM(IAR(J)),IR(IAR(J)),R,C,R-C
                CALL ADDVIO (NSTR,ITYP*MAXA1+I,J,V,KEY1,KEY2,VIOTAB,
     *                       TABMAX,MVIO)  
              END IF
            END IF
  410       CONTINUE
        END IF  
  420   CONTINUE
      WRITE (3,'(/''Number of fixed distances      :'',I10/
     *            ''Number of deviations > cutoff  :'',I10/
     *            ''Average deviation              :'',F10.4,'' A''/
     *            ''RMS deviation                  :'',F10.4,'' A''/
     *            ''Maximal deviation              :'',F10.4,'' A''/
     *            ''Sum of deviations              :'',F10.4,'' A'')')
     *      N,NN,SUM/MAX(N,1),SQRT(RMS/MAX(N,1)),VMAX,SUM
      NVIO(ITYP,NSTR)=NN
      RMSVIO(ITYP,NSTR)=SQRT(RMS/MAX(N,1))
      VIOMAX(ITYP,NSTR)=VMAX
C     ------------------------------------------- CHECK RIGID UNIT RMSDS
      WRITE (3,'(//''Rigid unit RMSDs:''/17X,''RMSD'')')
      ITYP=4
      N=0
      NN=0
      SUM=0.0
      RMS=0.0
      VMAX=0.0
      DO 520 I=1,NDFREE
        M=0
        DO 510 J=1,NA 
          IF ((J.EQ.IDA(2,I) .OR. J.EQ.IDA(3,I) .OR. IAUNIT(J).EQ.I)
     *        .AND. CX(J).LT.1.0E10) THEN
            M=M+1
            A(1,M)=RX(J)
            A(2,M)=RY(J)
            A(3,M)=RZ(J)
            B(1,M)=CX(J)
            B(2,M)=CY(J)
            B(3,M)=CZ(J)
          END IF
  510     CONTINUE
        IF (M.GT.1) THEN
          N=N+1
          V=RMSD(A,B,M)
          SUM=SUM+V
          RMS=RMS+V**2
          VMAX=MAX(V,VMAX)
          IF (V.GE.CUT(ITYP)) THEN
            NN=NN+1
            WRITE (3,'(A5,1X,A3,I3,F11.4)') 
     *            DNAM(I),RNAM(IDR(I)),IR(IDR(I)),V
            CALL ADDVIO (NSTR,ITYP*MAXA1+I,0,V,KEY1,KEY2,VIOTAB,
     *                   TABMAX,MVIO)  
          END IF
        END IF
  520   CONTINUE
      WRITE (3,'(/''Number of rigid unit RMSDs     :'',I10/
     *            ''Number of deviations > cutoff  :'',I10/
     *            ''Average deviation              :'',F10.4,'' A''/
     *            ''RMS deviation                  :'',F10.4,'' A''/
     *            ''Maximal deviation              :'',F10.4,'' A''/
     *            ''Sum of deviations              :'',F10.4,'' A'')')
     *      N,NN,SUM/MAX(N,1),SQRT(RMS/MAX(N,1)),VMAX,SUM
      NVIO(ITYP,NSTR)=NN
      RMSVIO(ITYP,NSTR)=SQRT(RMS/MAX(N,1))
      VIOMAX(ITYP,NSTR)=VMAX
C     -------------------------------------- CHECK FIXED DIHEDRAL ANGLES
      WRITE (3,'(//''Fixed dihedral angle deviations:''/
     *       55X,''reference    value    viol.'')')
      ITYP=5
      N=0
      NN=0
      SUM=0.0
      RMS=0.0
      VMAX=0.0
C      write (*,*) 'irange=',irange
      DO 640 I2=1,NA-1
        IF (CX(I2).LT.1.0E10) THEN
          K2=IAUNIT(I2)
          NE=IFIRA(MIN(NR,IAR(I2)+IRANGE)+1)-1
          NB=IFIRA(MAX(1,IAR(I2)-IRANGE))
          DO 630 I3=I2+1,NE
            K3=IAUNIT(I3)
            IF (CX(I3).LT.1.0E10 .AND. (K3.EQ.K2 .OR. 
     *          I3.EQ.IDA(2,K2) .OR. I3.EQ.IDA(3,K2) .OR.
     *          I2.EQ.IDA(2,K3) .OR. I2.EQ.IDA(3,K3))) THEN
              NE=MIN(NE,IFIRA(MIN(NR,IAR(I3)+IRANGE)+1)-1)
              NB=MAX(NB,IFIRA(MAX(1,IAR(I3)-IRANGE)))
              V=-1.0
              DO 620 I1=NB,NE
                K1=IAUNIT(I1)
                IF (CX(I1).LT.1.0E10 .AND. I1.NE.I2 .AND. I1.NE.I3 .AND.
     *              (K1.EQ.K2 .OR. 
     *               I1.EQ.IDA(2,K2) .OR. I1.EQ.IDA(3,K2) .OR.
     *               I2.EQ.IDA(2,K1) .OR. I2.EQ.IDA(3,K1)) .AND.
     *              (K1.EQ.K3 .OR. 
     *               I1.EQ.IDA(2,K3) .OR. I1.EQ.IDA(3,K3) .OR.
     *               I3.EQ.IDA(2,K1) .OR. I3.EQ.IDA(3,K1))) THEN
                  NE=MIN(NE,IFIRA(MIN(NR,IAR(I1)+IRANGE)+1)-1)
                  DO 610 I4=I1+1,NE
                    K4=IAUNIT(I4)
                    IF (CX(I4).LT.1.0E10 .AND. I4.NE.I2 .AND. I4.NE.I3 
     *                  .AND. (K4.EQ.K1 .OR. 
     *                  I4.EQ.IDA(2,K1) .OR. I4.EQ.IDA(3,K1) .OR.
     *                  I1.EQ.IDA(2,K4) .OR. I1.EQ.IDA(3,K4)) .AND.
     *                  (K4.EQ.K2 .OR. 
     *                  I4.EQ.IDA(2,K2) .OR. I4.EQ.IDA(3,K2) .OR.
     *                  I2.EQ.IDA(2,K4) .OR. I2.EQ.IDA(3,K4)) .AND.
     *                  (K4.EQ.K3 .OR. 
     *                  I4.EQ.IDA(2,K3) .OR. I4.EQ.IDA(3,K3) .OR.
     *                  I3.EQ.IDA(2,K4) .OR. I3.EQ.IDA(3,K4))) THEN
                      AA(1)=RX(I1)
                      AA(2)=RY(I1)
                      AA(3)=RZ(I1)
                      BB(1)=RX(I2)
                      BB(2)=RY(I2)
                      BB(3)=RZ(I2)
                      CC(1)=RX(I3)
                      CC(2)=RY(I3)
                      CC(3)=RZ(I3)
                      DD(1)=RX(I4)
                      DD(2)=RY(I4)
                      DD(3)=RZ(I4)
                      RA=RAD*TOR(AA,BB,CC,DD)
                      AA(1)=CX(I1)
                      AA(2)=CY(I1)
                      AA(3)=CZ(I1)
                      BB(1)=CX(I2)
                      BB(2)=CY(I2)
                      BB(3)=CZ(I2)
                      CC(1)=CX(I3)
                      CC(2)=CY(I3)
                      CC(3)=CZ(I3)
                      DD(1)=CX(I4)
                      DD(2)=CY(I4)
                      DD(3)=CZ(I4)
                      CA=RAD*TOR(AA,BB,CC,DD)
                      IF (RA.LT.1.0E10 .AND. CA.LT.1.0E10) THEN
                        T=RA-CA
                        VA=MIN(ABS(T),ABS(T+360.0),ABS(T-360.0),
     *                         ABS(T+720.0),ABS(T-720.0))
                        IF (VA.GT.V) THEN
                          V=VA
                          R=RA
                          C=CA
                          J1=I1
                          J4=I4
                        END IF
                      END IF
                    END IF
  610               CONTINUE
                END IF
  620           CONTINUE
              IF (V.GE.0.0) THEN
                N=N+1
                SUM=SUM+V
                RMS=RMS+V**2
                VMAX=MAX(V,VMAX)
                IF (V.GE.CUT(ITYP)) THEN
                  NN=NN+1
                  WRITE (3,'(A5,A3,I3,'' - '',A5,A3,I3,'' - '',
     *                       A5,A3,I3,'' - '',A5,A3,I3,2X,3F9.3)') 
     *                       ANAM(J1),RNAM(IAR(J1)),IR(IAR(J1)),
     *                       ANAM(I2),RNAM(IAR(I2)),IR(IAR(I2)),
     *                       ANAM(I3),RNAM(IAR(I3)),IR(IAR(I3)),
     *                       ANAM(J4),RNAM(IAR(J4)),IR(IAR(J4)),R,C,V
                  CALL ADDVIO (NSTR,ITYP*MAXA1+I2,I3,V,KEY1,KEY2,
     *                         VIOTAB,TABMAX,MVIO)  
                END IF
              END IF
            END IF
  630       CONTINUE
        END IF  
  640   CONTINUE
      WRITE (3,'(/''Number of fixed dihedral angles:'',I10/
     *            ''Number of deviations > cutoff  :'',I10/
     *            ''Average deviation              :'',F10.4,'' deg''/
     *            ''RMS deviation                  :'',F10.4,'' deg''/
     *            ''Maximal deviation              :'',F10.4,'' deg''/
     *            ''Sum of deviations              :'',F10.4,'' deg'')')
     *      N,NN,SUM/MAX(N,1),SQRT(RMS/MAX(N,1)),VMAX,SUM
      NVIO(ITYP,NSTR)=NN
      RMSVIO(ITYP,NSTR)=SQRT(RMS/MAX(N,1))
      VIOMAX(ITYP,NSTR)=VMAX
C     ------------------------------------------- OVERVIEW OF DEVIATIONS
      GO TO 35
  800 IF (REDIR) CLOSE (2)
      IF (MVIO.GT.MAXVIO) CALL ERRMSG ('COCO: Too many deviations.')
      IF (MVIO.GT.1) CALL I2SORT (KEY1,KEY2,INDX,MVIO,0)
      WRITE (3,'(///''Overview of deviations:''//49X,''max'',
     *      I2,I4,20I5)') 1,(I,I=5,NSTR,5)
      DO 810 II=1,MVIO
        ITYP=KEY1(II)/MAXA1
        I=MOD(KEY1(II),MAXA1)
        L=INDX(II)
        IF (ITYP.EQ.1 .OR. ITYP.EQ.3 .OR. ITYP.EQ.5) THEN
          J=KEY2(II)
          WRITE (3,'(A6,A5,A3,I3,'' - '',A5,A3,I3,F21.4,1X,A)') 
     *          TYP(ITYP),ANAM(I),RNAM(IAR(I)),IR(IAR(I)),
     *                    ANAM(J),RNAM(IAR(J)),IR(IAR(J)),
     *          TABMAX(L),VIOTAB(L)(1:LENSTR(VIOTAB(L)))
        ELSE IF (ITYP.EQ.2) THEN
          J=KEY2(II)/MAXA1
          M=MOD(KEY2(II),MAXA1) 
          WRITE (3,'(A6,A5,A3,I3,2('' - '',A5,A3,I3),F7.3,1X,A)') 
     *          TYP(ITYP),ANAM(J),RNAM(IAR(J)),IR(IAR(J)),
     *                    ANAM(I),RNAM(IAR(I)),IR(IAR(I)),
     *                    ANAM(M),RNAM(IAR(M)),IR(IAR(M)),
     *          TABMAX(L),VIOTAB(L)(1:LENSTR(VIOTAB(L)))
        ELSE 
          WRITE (3,'(A6,A5,A3,I3,F35.4,1X,A)') 
     *          TYP(ITYP),DNAM(I),RNAM(IDR(I)),IR(IDR(I)),
     *          TABMAX(L),VIOTAB(L)(1:LENSTR(VIOTAB(L)))
        END IF
  810   CONTINUE
C     ----------------------------------------- STATISTICS OF DEVIATIONS
      DO 930 J=1,NTYP
        DO 910 I=NSTR+1,NSTR+4
          NVIO(J,I)=0
          RMSVIO(J,I)=0.0
  910     VIOMAX(J,I)=0.0
        NVIO(J,NSTR+3)=1000000
        RMSVIO(J,NSTR+3)=1.0E10
        VIOMAX(J,NSTR+3)=1.0E10
        STR(NSTR+1)='Mean'
        STR(NSTR+2)='+/-'
        STR(NSTR+3)='Min'
        STR(NSTR+4)='Max'
        DO 920 I=1,NSTR
          WRITE (STR(I),'(I4)') I
          NVIO(J,NSTR+1)=NVIO(J,NSTR+1)+NVIO(J,I)
          NVIO(J,NSTR+2)=NVIO(J,NSTR+2)+NVIO(J,I)**2
          NVIO(J,NSTR+3)=MIN(NVIO(J,NSTR+3),NVIO(J,I))
          NVIO(J,NSTR+4)=MAX(NVIO(J,NSTR+4),NVIO(J,I))
          RMSVIO(J,NSTR+1)=RMSVIO(J,NSTR+1)+RMSVIO(J,I)
          RMSVIO(J,NSTR+2)=RMSVIO(J,NSTR+2)+RMSVIO(J,I)**2
          RMSVIO(J,NSTR+3)=MIN(RMSVIO(J,NSTR+3),RMSVIO(J,I))
          RMSVIO(J,NSTR+4)=MAX(RMSVIO(J,NSTR+4),RMSVIO(J,I))
          VIOMAX(J,NSTR+1)=VIOMAX(J,NSTR+1)+VIOMAX(J,I)
          VIOMAX(J,NSTR+2)=VIOMAX(J,NSTR+2)+VIOMAX(J,I)**2
          VIOMAX(J,NSTR+3)=MIN(VIOMAX(J,NSTR+3),VIOMAX(J,I))
  920     VIOMAX(J,NSTR+4)=MAX(VIOMAX(J,NSTR+4),VIOMAX(J,I))
        NVIO(J,NSTR+1)=NVIO(J,NSTR+1)/NSTR
        NVIO(J,NSTR+2)=
     *    NINT(SQRT(REAL(NVIO(J,NSTR+2))/NSTR-NVIO(J,NSTR+1)**2))
        RMSVIO(J,NSTR+1)=RMSVIO(J,NSTR+1)/NSTR
        RMSVIO(J,NSTR+2)=SQRT(RMSVIO(J,NSTR+2)/NSTR-RMSVIO(J,NSTR+1)**2)
        VIOMAX(J,NSTR+1)=VIOMAX(J,NSTR+1)/NSTR
  930   VIOMAX(J,NSTR+2)=SQRT(VIOMAX(J,NSTR+2)/NSTR-VIOMAX(J,NSTR+1)**2)
C #       bond lengths        bond angles    fixed distances rigid unit RMSDs
C      #    rms    max    #    rms    max    #    rms    max    #   rms   max
C99 9999 9.9999 9.9999 9999 99.999 99.999 9999 9.9999 9.9999 9999 9.999 9.999
      WRITE (3,'(///''Statistics of deviations:''//
     *  ''   #      bond lengths        bond angles    fixed '',
     *  ''distances   rigid unit RMSDs    fixed dihedrals''/
     *  ''       #    rms    max    #    rms    max'',
     *  ''    #    rms    max    #    rms    max    #    rms    max'')')
      WRITE (3,'(A4,I4,2F7.4,I5,2F7.3,I5,2F7.4,I5,2F7.4,I5,2F7.3)')
     *  (STR(I),(NVIO(J,I),RMSVIO(J,I),VIOMAX(J,I),J=1,NTYP),I=1,NSTR+4)
      CLOSE (3)
      STOP
      END
C     ==================================================================
      SUBROUTINE ADDVIO (NSTR,K1,K2,V,KEY1,KEY2,VIOTAB,TABMAX,N)
C
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION KEY1(N+1),KEY2(N+1),TABMAX(N+1)
      CHARACTER VIOTAB(N+1)*(*)
C
      DO 10 I=1,N
   10   IF (K1.EQ.KEY1(I) .AND. K2.EQ.KEY2(I)) GO TO 20
      N=I
      KEY1(I)=K1
      KEY2(I)=K2
      VIOTAB(I)=' '
      TABMAX(I)=0.0
   20 VIOTAB(I)(NSTR:NSTR)='*'
      TABMAX(I)=MAX(TABMAX(I),V)
      RETURN
      END
C     ------------------------------------------------------------------
C     BUILD:    Build a structure of given sequence.
C
C               This routine sets up all structural data except
C               the binary tree of dihedral angles and the
C               cartesian coordinates of the atoms. The data
C               required by this routine are the residue sequence
C               and the library data. The flags for special con-
C               tacts (ICNTCT) and disulphide-bridges (ISS) are
C               initialized such that they indicate neither special
C               contacts nor disulphide-bridges.
C               The complete build-up of the structure consists
C               of the following steps:
C                (1) read library and residue sequence
C                (2) CALL BUILD
C                (3) set logical array FREE of free dihedral angles
C                (4) CALL TREE (FREE)
C                (5) set array DVAL of dihedral angle values
C                (6) CALL GENER
C               Steps (1) and (2) are executed only once for a
C               given structure; steps (3) and (4) are executed
C               each time when free dihedral angles are fixed or
C               vice versa; if the conformation (the values of
C               the dihedral angles) is changed, steps (5) and (6)
C               are repeated. If the binary tree of dihedral angles
C               is not needed, steps (3) and (4) may be omitted.
C
C               Peter G"untert, 24-10-1988
C     ------------------------------------------------------------------
      SUBROUTINE BUILD
C
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INCLUDE 'global.incl'
C
      DIMENSION A1(3),A2(3),A3(3),A4(3)
C     ------------------------------------------- SET UP NUMBER OF ATOMS
      NA=0
      DO 130 I=1,NR
        IFIRA(I)=NA+1
        DO 110 J=1,NAA
  110     IF (RNAM(I).EQ.AANAM(J) .AND. AATYP(J).EQ.'RESID') GO TO 120
        CALL ERRMSG ('BUILD: Illegal residue type '//RNAM(I))
  120   IRLIB(I)=J
  130   NA=NA+LASAT(J)-IFIRAT(J)+1
      IFIRA(NR+1)=NA+1
      IF (NA.GT.MAXA) CALL ERRMSG ('BUILD: Too many atoms')
C     ----------------------------------------------------- OFFSET TABLE
      J=IRLIB(1)
      IOFFST=IFIRA(1)-IFIRAT(J)
      DO 140 L=1,NAT(J)
  140   JOFFST(L,1)=MAX(0,L+IOFFST)
      DO 170 I=2,NR
        JOLD=J
        IOLD=IOFFST
        J=IRLIB(I)
        IOFFST=IFIRA(I)-IFIRAT(J)
        DO 160 K=1,3
          DO 150 L=NAT(JOLD),4,-1
  150       IF (ATNAM(L,JOLD).EQ.ATNAM(K,J)) GO TO 160
          CALL ERRMSG ('BUILD: Overlap atom '//ATNAM(K,J)//
     *                 ' not found for residue '//AANAM(JOLD))
  160     JOFFST(K,I)=L+IOLD
        DO 170 L=4,NAT(J)
  170     JOFFST(L,I)=L+IOFFST
C     --------------------------------------- ANGLE AND ATOM DEFINITIONS
      ND=0
      IDA(2,-1)=-1
      IDA(3,-1)=0
      LDA(-1)=NA+1
      IDA(2,0)=0
      IDA(3,0)=1
      LDA(0)=NA+1
      MDIHAT=1
      NDIHAT=0
      DO 270 I=1,NR
        J=IRLIB(I)
        II=IFIRAT(J)
        IFIRD(I)=ND+1
        DO 220 L=1,NDIH(J)
          I1=IDIHAT(1,L,J)
          I2=IDIHAT(2,L,J)
          I3=IDIHAT(3,L,J)
          I4=IDIHAT(4,L,J)
          IF ((I.NE.1  .OR. I2.GE.II) .AND.
     *        (I.NE.NR .OR. I3.LT.LASAT(J))) THEN
            IF (I.EQ.1 .AND. I1.LT.II) MDIHAT=I1
            IF (I.EQ.NR .AND. I4.GT.LASAT(J)) NDIHAT=I4
            ND=ND+1
            IF (ND.GT.MAXD)
     *        CALL ERRMSG ('BUILD: Too many dihedral angles')
            IDR(ND)=I
            IF (ABS(DIHVAL(L,J)).GT.TWOPI) THEN
              A1(1)=COX(I1,J)
              A1(2)=COY(I1,J)
              A1(3)=COZ(I1,J)
              A2(1)=COX(I2,J)
              A2(2)=COY(I2,J)
              A2(3)=COZ(I2,J)
              A3(1)=COX(I3,J)
              A3(2)=COY(I3,J)
              A3(3)=COZ(I3,J)
              A4(1)=COX(I4,J)
              A4(2)=COY(I4,J)
              A4(3)=COZ(I4,J)
              DIHVAL(L,J)=TOR(A1,A2,A3,A4)
            END IF
            DVAL0(ND)=DIHVAL(L,J)
            DINVBL(ND)=1.0/SQRT((COX(I2,J)-COX(I3,J))**2+
     *                          (COY(I2,J)-COY(I3,J))**2+
     *                          (COZ(I2,J)-COZ(I3,J))**2)
            DO 210 K=1,4
  210         IDA(K,ND)=MIN(JOFFST(IDIHAT(K,L,J),I),NA+1)
            LDA(ND)=LDIHAT(L,J)
            IF (LDA(ND).GT.0) THEN
              LDA(ND)=MIN(JOFFST(LDA(ND),I),NA+1)
            ELSE
              LDA(ND)=NA+1
            END IF
            DNAM(ND)=DIHNAM(L,J)
          END IF
  220     CONTINUE
        DO 260 L=IFIRAT(J),LASAT(J)
          MA=JOFFST(L,I)
          IAR(MA)=I
          NBOND(MA)=0
          DO 240 K=1,4
            KK=ICON(K,L,J)
            IF (KK.GT.0) KK=JOFFST(KK,I)
            IF (KK.GE.1 .AND. KK.LE.NA) THEN
              NBOND(MA)=NBOND(MA)+1
              IBOND(NBOND(MA),MA)=KK
            END IF
  240       CONTINUE
          DO 250 K=NBOND(MA)+1,4
  250       IBOND(K,MA)=0
          IAP(MA)=IPARTR(L,J)
          IF (IAP(MA).GT.0) IAP(MA)=JOFFST(IAP(MA),I)
          ANAM(MA)=ATNAM(L,J)
  260     IATYP(MA)=IATTYP(L,J)
  270   CONTINUE
      IFIRD(NR+1)=ND+1
      DO 280 I=0,ND
  280   IDORD(I)=I
C      write (*,'(1X,A5,I4,5A5)') (rnam(idr(i)),ir(iar(i)),
C     *(anam(ida(j,i)),j=1,4),anam(lda(i)),i=2,nd)
C     --------------------------------------- HYDROGEN BONDS, CORE RADII
      DO 300 I=1,NA
        J=I+100000
        ICNTCT(I)=J
        ISBOND(I)=J
        IHBOND(I)=J
        K=IATYP(I)
        IF (IATHB(K).NE.0) IHBOND(I)=IATHB(K)
  300   ARAD(I)=ATRAD(K)
C     ------------------------------------------- SPECIAL COVALENT LINKS
      DO 350 I=1,NLINK
        DO 350 K=1,2
          DO 320 J=IFIRA(IRLINK(K,I)),IFIRA(IRLINK(K,I)+1)-1
  320       IF (ALINK(K,I).EQ.ANAM(J)) GO TO 330
          CALL ERRMSG ('BUILD: Illegal atom '//ALINK(K,I)
     *         (1:LENSTR(ALINK(K,I)))//' in special covalent link')
  330     ISBOND(J)=I
          ICNTCT(J)=I
          DO 340 L=1,NBOND(J)
  340       ICNTCT(IBOND(L,J))=-I
  350     CONTINUE
      RETURN
      END
C     ------------------------------------------------------------------
C     ERRMSG:   Display error messages and stop.
C
C               Peter G"untert, 20-1-1988
C     ------------------------------------------------------------------
      SUBROUTINE ERRMSG (TEXT)
C
      CHARACTER*(*) TEXT
C
      WRITE (3,*) 'Error in ',TEXT(1:LENSTR(TEXT)),'.'
      WRITE (*,*) 'Error in ',TEXT(1:LENSTR(TEXT)),'.'
      STOP
      END
C     ------------------------------------------------------------------
C     GENCOR:   Generate cartesian coordinates of the atoms.
C
C               Vectorized version for the CRAY CFT77 compiler.
C               Peter G"untert, 24-10-1988
C     ------------------------------------------------------------------
      SUBROUTINE GENCOR
C
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INCLUDE 'global.incl'
C
      DIMENSION R1(MAXDIH),R2(MAXDIH),R3(MAXDIH),
     *          R4(MAXDIH),R5(MAXDIH),R6(MAXDIH),
     *          R7(MAXDIH),R8(MAXDIH),R9(MAXDIH)
C     --------------------- CALCULATE SINE AND COSINE OF DIHEDRAL ANGLES
      DO 10 I=1,NDFREE
        U=DVAL(I)-DVAL0(I)
        SIND(I)=SIN(U)
   10   COSD(I)=COS(U)
C     ------------------------------------------- LOOP OVER ALL RESIDUES
      DO 160 I=1,NR
        IF (I.EQ.1) THEN
          J=IRLIB(I)
          IOFFST=IFIRA(I)-IFIRAT(J)
          CX(0)=COX(MDIHAT,J)
          CY(0)=COY(MDIHAT,J)
          CZ(0)=COZ(MDIHAT,J)
          DO 40 L=IFIRAT(J),NAT(J)
            K=L+IOFFST
            CX(K)=COX(L,J)
            CY(K)=COY(L,J)
   40       CZ(K)=COZ(L,J)
        ELSE
C         ------------------------------------------------------ DOCKING
          JOLD=J
          IOLD=IOFFST
          J=IRLIB(I)
          IOFFST=IFIRA(I)-IFIRAT(J)
          K=JOFFST(1,I)
          C1=CX(K)
          C2=CY(K)
          C3=CZ(K)
          K=JOFFST(2,I)
          R31=CX(K)-C1
          R32=CY(K)-C2
          R33=CZ(K)-C3
          K=JOFFST(3,I)
          R11=CX(K)-C1
          R12=CY(K)-C2
          R13=CZ(K)-C3
          U=1.0/SQRT(R11**2+R12**2+R13**2)
          R11=R11*U
          R12=R12*U
          R13=R13*U
          R21=R12*R33-R13*R32
          R22=R13*R31-R11*R33
          R23=R11*R32-R12*R31
          U=1.0/SQRT(R21**2+R22**2+R23**2)
          R21=R21*U
          R22=R22*U
          R23=R23*U
          R31=R12*R23-R13*R22
          R32=R13*R21-R11*R23
          R33=R11*R22-R12*R21
          DO 120 L=1,NAT(J)
            K=JOFFST(L,I)
            E1=COX(L,J)
            E2=COY(L,J)
            E3=COZ(L,J)
            CX(K)=C1+R11*E1+R21*E2+R31*E3
            CY(K)=C2+R12*E1+R22*E2+R32*E3
  120       CZ(K)=C3+R13*E1+R23*E2+R33*E3
        END IF
C       ----------------------------------------- ROTATE DIHEDRAL ANGLES
        N=0
        DO 130 L=IFIRD(I),IFIRD(I+1)-1
          N=N+1
          LL=IDORD(L)
          I2=IDA(2,LL)
          I3=IDA(3,LL)
          SL=SIND(LL)
          CL=COSD(LL)
          OMCL=1.0-CL
          E1=CX(I3)-CX(I2)
          E2=CY(I3)-CY(I2)
          E3=CZ(I3)-CZ(I2)
          U=1.0/SQRT(E1**2+E2**2+E3**2)
          E1=E1*U
          E2=E2*U
          E3=E3*U
          EQ1=E1**2
          EQ2=E2**2
          EQ3=E3**2
          SE1=E1*SL
          SE2=E2*SL
          SE3=E3*SL
          C2=OMCL*E1*E2
          C3=OMCL*E1*E3
          C6=OMCL*E2*E3
          R1(N)=EQ1+CL*(EQ2+EQ3)
          R2(N)=C2-SE3
          R3(N)=C3+SE2
          R4(N)=C2+SE3
          R5(N)=EQ2+CL*(EQ1+EQ3)
          R6(N)=C6-SE1
          R7(N)=C3-SE2
          R8(N)=C6+SE1
  130     R9(N)=EQ3+CL*(EQ1+EQ2)
        DO 160 L=IFIRD(I+1)-1,IFIRD(I),-1
          LL=IDORD(L)
          I3=IDA(3,LL)
          C1=CX(I3)
          C2=CY(I3)
          C3=CZ(I3)
          DO 150 K=I3+1,MIN(LDA(LL),NAT(J)+IOFFST)
            E1=CX(K)-C1
            E2=CY(K)-C2
            E3=CZ(K)-C3
            CX(K)=C1+R1(N)*E1+R2(N)*E2+R3(N)*E3
            CY(K)=C2+R4(N)*E1+R5(N)*E2+R6(N)*E3
  150       CZ(K)=C3+R7(N)*E1+R8(N)*E2+R9(N)*E3
  160     N=N-1
      IF (NDIHAT.GT.LASAT(J)+1) THEN
        CX(NA+1)=CX(NDIHAT+IOFFST)
        CY(NA+1)=CY(NDIHAT+IOFFST)
        CZ(NA+1)=CZ(NDIHAT+IOFFST)
      END IF
      RETURN
      END
C     ------------------------------------------------------------------
C     GENER:    Generate cartesian coordinates of the atoms.
C
C               Vectorized version for the CRAY CFT77 compiler.
C               Peter G"untert, 24-10-1988
C               Modified version, Peter G"untert, 21-01-1991
C     ------------------------------------------------------------------
      SUBROUTINE GENER  

C
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INCLUDE 'global.incl'
C
      DIMENSION R1(4,-1:MAXD),R2(4,-1:MAXD),R3(4,-1:MAXD)
C
      DATA ((R1(K,I),R2(K,I),R3(K,I),K=1,4),I=-1,0)
     *     /1.0,3*0.0,1.0,3*0.0,1.0,3*0.0,1.0,3*0.0,1.0,3*0.0,1.0,3*0.0/
C     --------------------- CALCULATE SINE AND COSINE OF DIHEDRAL ANGLES
      DO 10 I=1,NDFREE
        U=DVAL(I)
        S=SIN(U)
        C=COS(U)
        R1(1,I)= R0(1,I)
        R2(1,I)= R0(2,I)
        R3(1,I)= R0(3,I)
        R1(2,I)= R0(4,I)*C+R0(7,I)*S
        R2(2,I)= R0(5,I)*C+R0(8,I)*S
        R3(2,I)= R0(6,I)*C+R0(9,I)*S
        R1(3,I)=-R0(4,I)*S+R0(7,I)*C
        R2(3,I)=-R0(5,I)*S+R0(8,I)*C
        R3(3,I)=-R0(6,I)*S+R0(9,I)*C
        R1(4,I)= R0(10,I)
        R2(4,I)= R0(11,I)
   10   R3(4,I)= R0(12,I)
C     --------------------------------------------------- BUILD BACKBONE
      N=4+NDFREE/(2*MAXD)
      DO 30 II=1,NDGEN(1)
        I=IDGEN(II)
        J=IPREV(I)
        R11=R1(1,J)
        R12=R2(1,J)
        R13=R3(1,J)
        R21=R1(2,J)
        R22=R2(2,J)
        R23=R3(2,J)
        R31=R1(3,J)
        R32=R2(3,J)
        R33=R3(3,J)
CDIR$   SHORTLOOP
        DO 20 K=1,N
          E1=R1(K,I) 
          E2=R2(K,I) 
          E3=R3(K,I) 
          R1(K,I)=E1*R11+E2*R21+E3*R31
          R2(K,I)=E1*R12+E2*R22+E3*R32
   20     R3(K,I)=E1*R13+E2*R23+E3*R33
        R1(4,I)=R1(4,I)+R1(4,J)
        R2(4,I)=R2(4,I)+R2(4,J)
   30   R3(4,I)=R3(4,I)+R3(4,J)
C     ------------------------------------------------ BUILD SIDE CHAINS
      DO 40 IGEN=2,NGEN
CDIR$   IVDEP
C$DIR   NO_RECURRENCE
        DO 40 II=NDGEN(IGEN-1)+1,NDGEN(IGEN)
          I=IDGEN(II)
          J=IPREV(I)
          P11=R1(1,J)
          P12=R2(1,J)
          P13=R3(1,J)
          P21=R1(2,J)
          P22=R2(2,J)
          P23=R3(2,J)
          P31=R1(3,J)
          P32=R2(3,J)
          P33=R3(3,J)
          E1=R1(1,I)
          E2=R2(1,I)
          E3=R3(1,I)
          R1(1,I)=E1*P11+E2*P21+E3*P31
          R2(1,I)=E1*P12+E2*P22+E3*P32
          R3(1,I)=E1*P13+E2*P23+E3*P33
          E1=R1(2,I)
          E2=R2(2,I)
          E3=R3(2,I)
          R1(2,I)=E1*P11+E2*P21+E3*P31
          R2(2,I)=E1*P12+E2*P22+E3*P32
          R3(2,I)=E1*P13+E2*P23+E3*P33
          E1=R1(3,I)
          E2=R2(3,I)
          E3=R3(3,I)
          R1(3,I)=E1*P11+E2*P21+E3*P31
          R2(3,I)=E1*P12+E2*P22+E3*P32
          R3(3,I)=E1*P13+E2*P23+E3*P33
          E1=R1(4,I)
          E2=R2(4,I)
          E3=R3(4,I)
          R1(4,I)=E1*P11+E2*P21+E3*P31+R1(4,J)
          R2(4,I)=E1*P12+E2*P22+E3*P32+R2(4,J)
   40     R3(4,I)=E1*P13+E2*P23+E3*P33+R3(4,J)
C     ------------------------------------------------- ATOM COORDINATES
      DO 50 K=1,NA				        
        I=IAUNIT(K)				        
        E1=CX0(K)				        
        E2=CY0(K)				        
        E3=CZ0(K)				        
        CX(K)=R1(1,I)*E1+R1(2,I)*E2+R1(3,I)*E3+R1(4,I)  
        CY(K)=R2(1,I)*E1+R2(2,I)*E2+R2(3,I)*E3+R2(4,I)  
   50   CZ(K)=R3(1,I)*E1+R3(2,I)*E2+R3(3,I)*E3+R3(4,I)   
      RETURN
      END

C     ------------------------------------------------------------------
C     GETCOR:   Read DG coordinate file from unit IUNIT.
C
C               Peter G"untert, 18-10-1989
C     ------------------------------------------------------------------
      SUBROUTINE GETCOR (IUNIT)
C
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INCLUDE 'global.incl'
C
      CHARACTER*5 RN,AN
      DO 70 I=1,NA
   70   CX(I)=1.0E20
C     ------------------------------------------------- READ COORDINATES
      READ (IUNIT,'(//)')
  110 CONTINUE
  115   READ (IUNIT,'(6X,A5,I6,6X,3F11.4)',END=200) AN,IRE,C1,C2,C3
        IF (AN.EQ.' ') GO TO 115
        DO 120 I=1,NR
  120     IF (IRE.EQ.IR(I)) GO TO 130
        WRITE (RN,'(I5)') IRE
        CALL ERRMSG ('GETCOR: Illegal residue number'//RN(2:5))
  130   DO 140 J=IFIRA(I),IFIRA(I+1)-1
  140     IF (AN.EQ.ANAM(J)) GO TO 150
        WRITE (RN,'(I5)') IRE
        CALL ERRMSG ('GETCOR: Illegal atom name '//AN//' for '//RNAM(I)
     *               //RN(2:5))
  150   CX(J)=C1
        CY(J)=C2
        CZ(J)=C3
      GO TO 110
  200 RETURN
      END
C     ------------------------------------------------------------------
C     GETLIB:   Read amino acid library from unit IUNIT.
C
C               Peter G"untert, 20-10-1988
C     ------------------------------------------------------------------
      SUBROUTINE GETLIB (IUNIT)
C
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INCLUDE 'global.incl'
C
      CHARACTER LINE*35,AT*5
C
      NAA=0
      NATTYP=0
   10 CONTINUE
        READ (IUNIT,'(A)',END=40) LINE
        IF (LINE(1:9).EQ.'ATOMTYPES') THEN
          READ (LINE,'(10X,I5)') NATTYP
          IF (NATTYP.GT.MAXTYP)
     *      CALL ERRMSG ('GETLIB: Too many atom types')
          DO 15 I=1,NATTYP
            READ (IUNIT,'(5X,A5,F10.2,2I5)')
     *           ATTYP(I),ATRAD(I),IATHB(I),J
   15       HEAVY(I)=J.NE.0
        ELSE IF (LINE(1:7).EQ.'RESIDUE') THEN
          NAA=NAA+1
          IF (NAA.GT.MAXAA)
     *       CALL ERRMSG ('GETLIB: Too many residue types')
          READ (LINE,'(A5,5X,A5,4I5)') AATYP(NAA),AANAM(NAA),
     *         NDIH(NAA),NAT(NAA),IFIRAT(NAA),LASAT(NAA)
          IF (NDIH(NAA).GT.MAXDIH)
     *       CALL ERRMSG ('GETLIB: Too many dihedral angles for '//
     *                    'residue type '//AANAM(NAA))
          IF (NAT(NAA).GT.MAXAT)
     *       CALL ERRMSG ('GETLIB: Too many atoms for residue type '//
     *                    AANAM(NAA))
          DO 20 I=1,NDIH(NAA)
            DIHVAL(I,NAA)=1000.0
            READ (IUNIT,'(5X,A5,22X,5I5)')
     *           DIHNAM(I,NAA),(IDIHAT(J,I,NAA),J=1,4),LDIHAT(I,NAA)
   20       CONTINUE
          DO 30 I=1,NAT(NAA)
            READ (IUNIT,'(5X,2A5,17X,3F10.4,5I5)')
     *           ATNAM(I,NAA),AT,COX(I,NAA),COY(I,NAA),COZ(I,NAA),
     *           (ICON(J,I,NAA),J=1,4),IPARTR(I,NAA)
            DO 25 J=1,NATTYP
   25         IF (AT.EQ.ATTYP(J)) GO TO 30
            CALL ERRMSG ('GETLIB: Illegal atom type '//AT)
   30       IATTYP(I,NAA)=J
        END IF
      GO TO 10
C     ---------------------------- PUT RESIDUE INTO STANDARD ORIENTATION
   40 DO 120 J=1,NAA
        C1=COX(1,J)
        C2=COY(1,J)
        C3=COZ(1,J)
        DO 110 I=1,NAT(J)
          COX(I,J)=COX(I,J)-C1
          COY(I,J)=COY(I,J)-C2
  110     COZ(I,J)=COZ(I,J)-C3
        R11=COX(3,J)
        R12=COY(3,J)
        R13=COZ(3,J)
        R31=COX(2,J)
        R32=COY(2,J)
        R33=COZ(2,J)
        U=1.0/SQRT(R11**2+R12**2+R13**2)
        R11=R11*U
        R12=R12*U
        R13=R13*U
        R21=R12*R33-R13*R32
        R22=R13*R31-R11*R33
        R23=R11*R32-R12*R31
        U=1.0/SQRT(R21**2+R22**2+R23**2)
        R21=R21*U
        R22=R22*U
        R23=R23*U
        R31=R12*R23-R13*R22
        R32=R13*R21-R11*R23
        R33=R11*R22-R12*R21
        DO 120 I=1,NAT(J)
          C1=COX(I,J)
          C2=COY(I,J)
          C3=COZ(I,J)
          COX(I,J)=R11*C1+R12*C2+R13*C3
          COY(I,J)=R21*C1+R22*C2+R23*C3
  120     COZ(I,J)=R31*C1+R32*C2+R33*C3
      RETURN
      END
C     ------------------------------------------------------------------
C     GETSEQ:   Read protein sequence from unit IUNIT.
C
C               Peter G"untert, 21-10-1988
C     ------------------------------------------------------------------
      SUBROUTINE GETSEQ (IUNIT,ISCRAT)
C
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INCLUDE 'global.incl'
C
      DIMENSION INDX(MAXRMS)
      CHARACTER*81 LINE*81,EL*80,S*5
C
      NR=0
      NLINK=0
      M=0
      LINE(81:81)=' '
      REWIND (ISCRAT)
      WRITE (ISCRAT,*) '''{'' ',1
      WRITE (ISCRAT,*) '''OMEGA'' ',180.0
   10 CONTINUE
        READ (IUNIT,'(A)',END=50) LINE(1:80)
        I=INDEX(LINE,'#')
        IF (I.GT.0) LINE(I:80)=' '
        K=0
        EL=' '
        DO 40 J=1,81
          IF (LINE(J:J).LE.' ' .OR.
     *        LINE(J:J).EQ.'{' .OR. LINE(J:J).EQ.'}') THEN
            IF (K.GT.0) THEN
              IF ((EL(1:1).GE.'0' .AND. EL(1:1).LE.'9') .OR. 
     *            EL(1:1).EQ.'-' .OR. EL(1:1).EQ.'+') THEN
                IF (M.EQ.0) THEN
                  READ (EL,'(BN,I6)') IR(NR)
                ELSE IF (M.EQ.3) THEN
                  READ (EL,'(BN,I6)') IRLINK(1,NLINK)
                ELSE IF (M.EQ.1) THEN
                  READ (EL,'(BN,I6)') IRLINK(2,NLINK)
                ELSE
                  CALL ERRMSG
     *                 ('GETSEQ: Illegal covalent link specification')
                END IF
              ELSE IF (EL.EQ.'link') THEN
                NLINK=NLINK+1
                M=5
              ELSE IF (M.EQ.0) THEN
                L=INDEX(EL,'=')
                IF (L.EQ.0) THEN
                  NR=NR+1
                  IF (NR.GT.MAXR)
     *              CALL ERRMSG ('GETSEQ: Too many residues')
                  IF (EL(1:1).EQ.'c') THEN
                    RNAM(NR)=EL(2:6)
                    WRITE (ISCRAT,*) '''{'' ',NR
                    WRITE (ISCRAT,*) '''OMEGA'' 0.0'
                    WRITE (ISCRAT,*) '''}'' ',NR
                  ELSE
                    RNAM(NR)=EL(1:5)
                  END IF
                  IF (NR.EQ.1) THEN
                    IR(NR)=1
                  ELSE
                    IR(NR)=IR(NR-1)+1
                  END IF
                ELSE IF (EL(L+1:L+4).EQ.'free') THEN
                  WRITE (ISCRAT,*) '''',EL(1:L-1),''' ',1.0E10
                ELSE IF (EL(L+1:L+5).EQ.'fixed') THEN
                  WRITE (ISCRAT,*) '''',EL(1:L-1),''' ',-1.0E10
                ELSE
                  WRITE (ISCRAT,*) '''',EL(1:L-1),''' ',
     *                             EL(L+1:LENSTR(EL))
                END IF
              ELSE IF (M.EQ.4) THEN
                ALINK(1,NLINK)=EL(1:5)
              ELSE IF (M.EQ.2) THEN
                ALINK(2,NLINK)=EL(1:5)
              ELSE
                CALL ERRMSG
     *               ('GETSEQ: Syntax error in sequence file')
              END IF
              K=0
              EL=' '
              M=MAX(0,M-1)
            END IF
            IF (LINE(J:J).EQ.'{') THEN
              WRITE (ISCRAT,*) '''{'' ',NR+1
            ELSE IF (LINE(J:J).EQ.'}') THEN
              WRITE (ISCRAT,*) '''}'' ',NR
            END IF
          ELSE
            K=K+1
            EL(K:K)=LINE(J:J)
          END IF
   40     CONTINUE
      GO TO 10
   50 WRITE (ISCRAT,*) '''}'' ',NR
      WRITE (ISCRAT,*) '''END'' 0'
C     ------------------------------------------- SPECIAL COVALENT LINKS
      DO 70 I=1,NLINK
        DO 70 J=1,2
          DO 60 K=1,NR
   60       IF (IR(K).EQ.IRLINK(J,I)) GO TO 70
          CALL ERRMSG ('GETSEQ: Illegal residue number for special '//
     *                 'covalent link')
   70     IRLINK(J,I)=K
C      write (*,'(A5,I3,5X,A5,I3)')
C     *      ((alink(j,i),irlink(j,i),j=1,2),i=1,nlink)
      REWIND (ISCRAT)
C   98 READ (ISCRAT,'(A)',END=99) LINE
C      WRITE (*,'(A50)') LINE
C      GO TO 98
C   99 CONTINUE
C     -------------------------------------------------- BUILD STRUCTURE
      CALL BUILD
C     ---------------------------- EVALUATE FREE/FIXED ANGLE INFORMATION
      N=0
      REWIND (ISCRAT)
  110 READ (ISCRAT,*) S,V
      IF (S.NE.'END') THEN
        IF (S.EQ.'{') THEN
          N=N+1
          INDX(N)=NINT(V)
          IF (N.GT.MAXRMS) CALL ERRMSG ('GETSEQ: Stack overflow')
          IF (N.EQ.1) THEN
            DO 120 I=1,ND
  120         DTAB(I,N)=1.0E10
          ELSE
            DO 130 I=1,ND
  130         DTAB(I,N)=DTAB(I,N-1)
          END IF
        ELSE IF (S.NE.'}') THEN
          IF (ABS(V).LT.1.0E8) V=V/RAD
          DO 140 I=1,ND
  140       IF (S.EQ.DNAM(I)) DTAB(I,N)=V
        ELSE IF (N.GT.1) THEN
          DO 150 I=IFIRD(INDX(N)),IFIRD(NINT(V)+1)-1
  150       DTAB(I,N-1)=DTAB(I,N)
          N=N-1
        END IF
      GO TO 110
      END IF
      DO 160 I=1,ND
C        write (*,*) idr(i),dnam(i),dtab(i,n)
  160   DDEF(I)=DTAB(I,1)
      RETURN
      END
C     ------------------------------------------------------------------
      SUBROUTINE I2SORT (KEY1,KEY2,INDX,N,MODE)
C
      PARAMETER (NSTACK=30)
      DIMENSION KEY1(N),KEY2(N),INDX(N),ISL(NSTACK),ISR(NSTACK)
C
      IF (MODE.EQ.0) THEN
        DO 10 I=1,N
   10     INDX(I)=I
      END IF
      JS=1
      ISL(1)=1
      ISR(1)=N
   50 CONTINUE
        JL=ISL(JS)
        JR=ISR(JS)
        JS=JS-1
   52   CONTINUE
          I=JL
          J=JR
          IX1=KEY1((JL+JR)/2)
          IX2=KEY2((JL+JR)/2)
   53     CONTINUE
   54       IF (KEY1(I).LT.IX1 .OR. 
     *          (KEY1(I).EQ.IX1 .AND. KEY2(I).LT.IX2)) THEN
              I=I+1
            GO TO 54
            END IF
   55       IF (KEY1(J).GT.IX1 .OR.
     *          (KEY1(J).EQ.IX1 .AND. KEY2(J).GT.IX2)) THEN
              J=J-1
            GO TO 55
            END IF
            IF (I.GT.J) GO TO 58
            K=KEY1(I)
            KEY1(I)=KEY1(J)
            KEY1(J)=K
            K=KEY2(I)
            KEY2(I)=KEY2(J)
            KEY2(J)=K
            K=INDX(I)
            INDX(I)=INDX(J)
            INDX(J)=K
            I=I+1
            J=J-1
          IF (I.LE.J) GO TO 53
   58     IF (J-JL.LT.JR-I) THEN
            IF (I.LT.JR) THEN
              JS=JS+1
              ISL(JS)=I
              ISR(JS)=JR
            END IF
            JR=J
          ELSE
            IF (JL.LT.J) THEN
              JS=JS+1
              ISL(JS)=JL
              ISR(JS)=J
            END IF
            JL=I
          END IF
        IF (JL.LT.JR) GO TO 52
      IF (JS.GT.0) GO TO 50
      RETURN
      END
C     ------------------------------------------------------------------
      SUBROUTINE ISORT (KEY,INDX,N,MODE)
C
      PARAMETER (NSTACK=30)
      DIMENSION KEY(N),INDX(N),ISL(NSTACK),ISR(NSTACK)
C
      IF (MODE.EQ.0) THEN
        DO 10 I=1,N
   10     INDX(I)=I
      END IF
      JS=1
      ISL(1)=1
      ISR(1)=N
   50 CONTINUE
        JL=ISL(JS)
        JR=ISR(JS)
        JS=JS-1
   52   CONTINUE
          I=JL
          J=JR
          IX=KEY((JL+JR)/2)
   53     CONTINUE
   54       IF (KEY(I).LT.IX) THEN
              I=I+1
            GO TO 54
            END IF
   55       IF (KEY(J).GT.IX) THEN
              J=J-1
            GO TO 55
            END IF
            IF (I.GT.J) GO TO 58
            K=KEY(I)
            KEY(I)=KEY(J)
            KEY(J)=K
            K=INDX(I)
            INDX(I)=INDX(J)
            INDX(J)=K
            I=I+1
            J=J-1
          IF (I.LE.J) GO TO 53
   58     IF (J-JL.LT.JR-I) THEN
            IF (I.LT.JR) THEN
              JS=JS+1
              ISL(JS)=I
              ISR(JS)=JR
            END IF
            JR=J
          ELSE
            IF (JL.LT.J) THEN
              JS=JS+1
              ISL(JS)=JL
              ISR(JS)=J
            END IF
            JL=I
          END IF
        IF (JL.LT.JR) GO TO 52
      IF (JS.GT.0) GO TO 50
      RETURN
      END
C     ------------------------------------------------------------------
C     LENSTR:   Return index of last non-blank character of the
C               string S, or zero if S is a blank string.
C
C               Written in standard FORTRAN-77.
C               Peter G"untert, 28-11-1988
C     ------------------------------------------------------------------
      FUNCTION LENSTR(S)
C
      CHARACTER*(*) S
C
      DO 10 L=LEN(S),1,-1
   10   IF (S(L:L).GT.' ') GO TO 20
   20 LENSTR=L
      RETURN
      END
C     ==================================================================
      SUBROUTINE READFN (TEXT,DEFEXT,DEFNAM,FILNAM)
C
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      CHARACTER*(*) TEXT,FILNAM,DEFNAM,DEFEXT
C
      IF (DEFNAM.EQ.' ') THEN
        WRITE (*,*) TEXT,' (',DEFEXT,'):'
      ELSE
        WRITE (*,*) TEXT,' (',DEFEXT,', default: ',DEFNAM,'):'
      END IF
      READ (*,'(A)') FILNAM
      I=INDEX(FILNAM,'#')
      IF (I.GT.0) FILNAM(I:LEN(FILNAM))=' '
      IF (FILNAM.EQ.' ') THEN
        IF (DEFNAM.EQ.' ' .OR. DEFNAM.EQ.'none') RETURN
        FILNAM=DEFNAM
      END IF
      L=LENSTR(FILNAM)
      DO 10 I=1,L
   10   IF (FILNAM(I:I).GT.' ') GO TO 20
   20 DO 25 J=I,L
   25   FILNAM(J-I+1:J-I+1)=FILNAM(J:J)
      L=L-I+1
      IF (FILNAM(L:L).EQ.'|') THEN
        FILNAM(L:L)=' '
        RETURN
      END IF
      IF (FILNAM.EQ.'*') RETURN
      DO 30 I=L,1,-1
   30   IF (FILNAM(I:I).EQ.'.') GO TO 40
   40 DO 50 J=L,1,-1
   50   IF (INDEX(':]/',FILNAM(J:J)).GT.0) GO TO 60
   60 IF (I.LE.J) FILNAM(L+1:LEN(FILNAM))='.'//DEFEXT
      RETURN
      END
C     ==================================================================
C     READI:    Read integer numbers from standard input in free format.
C
C               On input ISCRAT is the unit number of a scratch file,
C               TEXT is a prompt that will be written to standard
C               output follwed by an indication of the default
C               values as given in DEFLT, and N is the number of
C               integer numbers to be read from standard input. Then
C               one line is read from standard input which must
C               either cointain the N integer numbers or be empty.
C               If it is empty the numbers are read from DEFLT.
C               On output the first N elements of the array I will
C               contain the integer numbers read.
C
C               Written in standard FORTRAN-77.
C               Peter G"untert, 1-6-1989
C     ------------------------------------------------------------------
      SUBROUTINE READI (ISCRAT,TEXT,DEFLT,I,N)
C
      DIMENSION I(N)
      CHARACTER*(*) TEXT,DEFLT
      CHARACTER*78 DEFLIN,LINE
C
      J=1
      DEFLIN=DEFLT(1:1)
      DO 10 K=2,LENSTR(DEFLT)
        IF (DEFLT(K-1:K).NE.'  ' .AND. DEFLT(K-1:K).NE.'. ') THEN
          J=J+1
          DEFLIN(J:J)=DEFLT(K:K)
        END IF
   10   CONTINUE
      IF (DEFLIN(1:1).EQ.' ') DEFLIN=DEFLIN(2:J)
      WRITE (*,*) TEXT,' (default: ',DEFLIN(1:LENSTR(DEFLIN)),'):'
      READ (*,'(A)') LINE
      J=INDEX(LINE,'#')
      IF (J.GT.0) LINE(J:J)='/'
   20 K=INDEX(DEFLIN,'..')
      IF (K.GT.0) THEN
        DEFLIN(K:K+1)=' '
        GO TO 20
      END IF
   30 K=INDEX(LINE,'..')
      IF (K.GT.0) THEN
        LINE(K:K+1)=' '
        GO TO 30
      END IF
      REWIND (ISCRAT)
      WRITE (ISCRAT,'(A,''/''/A,''/'')') DEFLIN,LINE
      REWIND (ISCRAT)
      READ (ISCRAT,*) (I(J),J=1,N)
      READ (ISCRAT,*) (I(J),J=1,N)
      RETURN
      END
C     ==================================================================
C     READR:    Read real numbers from standard input in free format.
C
C               On input ISCRAT is the unit number of a scratch file,
C               TEXT is a prompt that will be written to standard
C               output follwed by an indication of the default
C               values as given in DEFLT, and N is the number of
C               real numbers to be read from standard input. Then
C               one line is read from standard input which must
C               either cointain the N real numbers or be empty.
C               If it is empty the numbers are read from DEFLT.
C               On output the first N elements of the array F will
C               contain the real numbers read.
C
C               Written in standard FORTRAN-77.
C               Peter G"untert, 1-6-1989
C     ------------------------------------------------------------------
      SUBROUTINE READR (ISCRAT,TEXT,DEFLT,F,N)
C
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DIMENSION F(N)
      CHARACTER*(*) TEXT,DEFLT
      CHARACTER*78 LINE
C
      WRITE (*,*) TEXT,' (default: ',DEFLT,'):'
      READ (*,'(A)') LINE
      J=INDEX(LINE,'#')
      IF (J.GT.0) LINE(J:J)='/'
      REWIND (ISCRAT)
      WRITE (ISCRAT,'(A,''/''/A,''/'')') DEFLT,LINE
      REWIND (ISCRAT)
      READ (ISCRAT,*) (F(J),J=1,N)
      READ (ISCRAT,*) (F(J),J=1,N)
      RETURN
      END
C     ------------------------------------------------------------------
C     RMSD:     Least squares best fit of two sets of n points
C               in 3-dimensional Euclidean space.
C
C               Vectorized version for the CRAY CFT77 compiler.
C               Peter G"untert, 23-11-1988
C     ------------------------------------------------------------------
      FUNCTION RMSD (A,B,N)
C
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      PARAMETER (ONE=1.0)
      DIMENSION A(3,N),B(3,N),T(3),R(3,3),E(3),S(3),U(3,3),V(3,3)
C
      RMSD=0.0
      IF (N.LE.3) RETURN
      W=1.0/N
      DO 20 I=1,3
        T(I)=0.0
        S(I)=0.0
        DO 10 K=1,N
          T(I)=T(I)+A(I,K)
   10     S(I)=S(I)+B(I,K)
        T(I)=T(I)*W
   20   S(I)=S(I)*W
      DO 40 J=1,3
        DO 30 I=1,3
   30     U(I,J)=0.0
        DO 35 K=1,N
          SUM=B(J,K)-S(J)
          U(1,J)=U(1,J)+(A(1,K)-T(1))*SUM
          U(2,J)=U(2,J)+(A(2,K)-T(2))*SUM
   35     U(3,J)=U(3,J)+(A(3,K)-T(3))*SUM
        DO 40 I=1,3
   40     U(I,J)=U(I,J)*W
      DETU=U(1,1)*U(2,2)*U(3,3)+U(1,2)*U(2,3)*U(3,1)+
     *     U(1,3)*U(2,1)*U(3,2)-U(1,3)*U(2,2)*U(3,1)-
     *     U(1,1)*U(2,3)*U(3,2)-U(1,2)*U(2,1)*U(3,3)
      CALL SVDCMP (U,3,3,3,3,E,V)
      SUM=MIN(E(1),E(2),E(3))
      DO 45 I=1,3
        IF (E(I).EQ.SUM) E(I)=DETU
   45   E(I)=SIGN(ONE,E(I))
      DO 50 I=1,3
        DO 50 J=1,3
          R(I,J)=
     *        E(1)*V(I,1)*U(J,1)+E(2)*V(I,2)*U(J,2)+E(3)*V(I,3)*U(J,3)
   50     CONTINUE
      DO 80 K=1,N
        E(1)=A(1,K)-T(1)
        E(2)=A(2,K)-T(2)
        E(3)=A(3,K)-T(3)
        RMSD=RMSD+
     *       (R(1,1)*E(1)+R(1,2)*E(2)+R(1,3)*E(3)-B(1,K)+S(1))**2+
     *       (R(2,1)*E(1)+R(2,2)*E(2)+R(2,3)*E(3)-B(2,K)+S(2))**2+
     *       (R(3,1)*E(1)+R(3,2)*E(2)+R(3,3)*E(3)-B(3,K)+S(3))**2
   80   CONTINUE
      RMSD=SQRT(RMSD*W)
      RETURN
      END
C     ------------------------------------------------------------------
C     SVDCMP:   Singular value decomposition.
C
C               Lit.: W. H. Press et. al., Numerical Recipes,
C                     Cambridge University Press (1986), p. 60.
C     ------------------------------------------------------------------
      SUBROUTINE SVDCMP (A,M,N,MP,NP,W,V)
C
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      PARAMETER (NMAX=100)
      DIMENSION A(MP,NP),W(NP),V(NP,NP),RV1(NMAX)
C
      G=0.0
      SCALE=0.0
      ANORM=0.0
      DO 25 I=1,N
        L=I+1
        RV1(I)=SCALE*G
        G=0.0
        S=0.0
        SCALE=0.0
        IF (I.LE.M) THEN
          DO 11 K=I,M
            SCALE=SCALE+ABS(A(K,I))
   11       CONTINUE
          IF (SCALE.NE.0.0) THEN
            DO 12 K=I,M
              A(K,I)=A(K,I)/SCALE
              S=S+A(K,I)*A(K,I)
   12         CONTINUE
            F=A(I,I)
            G=-SIGN(SQRT(S),F)
            H=F*G-S
            A(I,I)=F-G
            IF (I.NE.N) THEN
              DO 15 J=L,N
                S=0.0
                DO 13 K=I,M
                  S=S+A(K,I)*A(K,J)
   13             CONTINUE
                F=S/H
                DO 14 K=I,M
                  A(K,J)=A(K,J)+F*A(K,I)
   14             CONTINUE
   15           CONTINUE
            ENDIF
            DO 16 K=I,M
              A(K,I)=SCALE*A(K,I)
   16         CONTINUE
          ENDIF
        ENDIF
        W(I)=SCALE*G
        G=0.0
        S=0.0
        SCALE=0.0
        IF ((I.LE.M) .AND. (I.NE.N)) THEN
          DO 17 K=L,N
            SCALE=SCALE+ABS(A(I,K))
   17       CONTINUE
          IF (SCALE.NE.0.0) THEN
            DO 18 K=L,N
              A(I,K)=A(I,K)/SCALE
              S=S+A(I,K)*A(I,K)
   18         CONTINUE
            F=A(I,L)
            G=-SIGN(SQRT(S),F)
            H=F*G-S
            A(I,L)=F-G
            DO 19 K=L,N
              RV1(K)=A(I,K)/H
   19         CONTINUE
            IF (I.NE.M) THEN
              DO 23 J=L,M
                S=0.0
                DO 21 K=L,N
                  S=S+A(J,K)*A(I,K)
   21             CONTINUE
                DO 22 K=L,N
                  A(J,K)=A(J,K)+S*RV1(K)
   22             CONTINUE
   23           CONTINUE
            ENDIF
            DO 24 K=L,N
              A(I,K)=SCALE*A(I,K)
   24         CONTINUE
          ENDIF
        ENDIF
        ANORM=MAX(ANORM,(ABS(W(I))+ABS(RV1(I))))
   25   CONTINUE
      DO 32 I=N,1,-1
        IF (I.LT.N) THEN
          IF (G.NE.0.0) THEN
            DO 26 J=L,N
              V(J,I)=(A(I,J)/A(I,L))/G
   26         CONTINUE
            DO 29 J=L,N
              S=0.0
              DO 27 K=L,N
                S=S+A(I,K)*V(K,J)
   27           CONTINUE
              DO 28 K=L,N
                V(K,J)=V(K,J)+S*V(K,I)
   28           CONTINUE
   29         CONTINUE
          ENDIF
          DO 31 J=L,N
            V(I,J)=0.0
            V(J,I)=0.0
   31       CONTINUE
        ENDIF
        V(I,I)=1.0
        G=RV1(I)
        L=I
   32   CONTINUE
      DO 39 I=N,1,-1
        L=I+1
        G=W(I)
        IF (I.LT.N) THEN
          DO 33 J=L,N
            A(I,J)=0.0
   33       CONTINUE
        ENDIF
        IF (G.NE.0.0) THEN
          G=1.0/G
          IF (I.NE.N) THEN
            DO 36 J=L,N
              S=0.0
              DO 34 K=L,M
                S=S+A(K,I)*A(K,J)
   34           CONTINUE
              F=(S/A(I,I))*G
              DO 35 K=I,M
                A(K,J)=A(K,J)+F*A(K,I)
   35           CONTINUE
   36         CONTINUE
          ENDIF
          DO 37 J=I,M
            A(J,I)=A(J,I)*G
   37       CONTINUE
        ELSE
          DO 38 J=I,M
            A(J,I)=0.0
   38       CONTINUE
        ENDIF
        A(I,I)=A(I,I)+1.0
   39   CONTINUE
      DO 49 K=N,1,-1
        DO 48 ITS=1,30
          DO 41 L=K,1,-1
            NM=L-1
            IF ((ABS(RV1(L))+ANORM).EQ.ANORM) GO TO 2
            IF ((ABS(W(NM))+ANORM).EQ.ANORM) GO TO 1
   41       CONTINUE
    1     C=0.0
          S=1.0
          DO 43 I=L,K
            F=S*RV1(I)
            IF ((ABS(F)+ANORM).NE.ANORM) THEN
              G=W(I)
              H=SQRT(F*F+G*G)
              W(I)=H
              H=1.0/H
              C=(G*H)
              S=-(F*H)
              DO 42 J=1,M
                Y=A(J,NM)
                Z=A(J,I)
                A(J,NM)=(Y*C)+(Z*S)
                A(J,I)=-(Y*S)+(Z*C)
   42           CONTINUE
            ENDIF
   43       CONTINUE
    2     Z=W(K)
          IF (L.EQ.K) THEN
            IF (Z.LT.0.0) THEN
              W(K)=-Z
              DO 44 J=1,N
                V(J,K)=-V(J,K)
   44           CONTINUE
            ENDIF
            GO TO 3
          ENDIF
          IF (ITS.EQ.30)
     *      CALL ERRMSG ('SVDCMP: No convergence in 30 iterations')
          X=W(L)
          NM=K-1
          Y=W(NM)
          G=RV1(NM)
          H=RV1(K)
          F=((Y-Z)*(Y+Z)+(G-H)*(G+H))/(2.0*H*Y)
CPG avoid overflow
CPG          G=SQRT(F*F+1.0)
          G=F*SQRT(1.0+(1.0/F)**2)
          F=((X-Z)*(X+Z)+H*((Y/(F+SIGN(G,F)))-H))/X
          C=1.0
          S=1.0
          DO 47 J=L,NM
            I=J+1
            G=RV1(I)
            Y=W(I)
            H=S*G
            G=C*G
            Z=SQRT(F*F+H*H)
            RV1(J)=Z
            C=F/Z
            S=H/Z
            F=(X*C)+(G*S)
            G=-(X*S)+(G*C)
            H=Y*S
            Y=Y*C
            DO 45 JJ=1,N
              X=V(JJ,J)
              Z=V(JJ,I)
              V(JJ,J)=(X*C)+(Z*S)
              V(JJ,I)=-(X*S)+(Z*C)
   45         CONTINUE
            Z=SQRT(F*F+H*H)
            W(J)=Z
            IF (Z.NE.0.0) THEN
              Z=1.0/Z
              C=F*Z
              S=H*Z
            ENDIF
            F=(C*G)+(S*Y)
            X=-(S*G)+(C*Y)
            DO 46 JJ=1,M
              Y=A(JJ,J)
              Z=A(JJ,I)
              A(JJ,J)=(Y*C)+(Z*S)
              A(JJ,I)=-(Y*S)+(Z*C)
   46         CONTINUE
   47       CONTINUE
          RV1(L)=0.0
          RV1(K)=F
          W(K)=X
   48     CONTINUE
    3   CONTINUE
   49   CONTINUE
      RETURN
      END
C     ------------------------------------------------------------------
C     TOR:      Calculate the torsion angle (in radians) defined
C               by the four points A,B,C,D.
C
C               Written in standard FORTRAN-77.
C               Peter G"untert, 28-11-1988
C     ------------------------------------------------------------------
      FUNCTION TOR(A,B,C,D)
C
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DIMENSION A(3),B(3),C(3),D(3),BA(3),CB(3),DC(3),E1(3),E2(3)
C
      DO 10 K=1,3
        BA(K)=B(K)-A(K)
        CB(K)=C(K)-B(K)
   10   DC(K)=D(K)-C(K)
      E1(1)=1.0/SQRT(BA(1)**2+BA(2)**2+BA(3)**2)
      E1(2)=1.0/SQRT(CB(1)**2+CB(2)**2+CB(3)**2)
      E1(3)=1.0/SQRT(DC(1)**2+DC(2)**2+DC(3)**2)
      DO 20 K=1,3
        BA(K)=BA(K)*E1(1)
        CB(K)=CB(K)*E1(2)
   20   DC(K)=DC(K)*E1(3)
      E1(1)=BA(2)*CB(3)-BA(3)*CB(2)
      E1(2)=BA(3)*CB(1)-BA(1)*CB(3)
      E1(3)=BA(1)*CB(2)-BA(2)*CB(1)
      E2(1)=CB(2)*DC(3)-CB(3)*DC(2)
      E2(2)=CB(3)*DC(1)-CB(1)*DC(3)
      E2(3)=CB(1)*DC(2)-CB(2)*DC(1)
      T=SQRT((E1(1)**2+E1(2)**2+E1(3)**2)*(E2(1)**2+E2(2)**2+E2(3)**2))
      IF (T.LT.0.2) THEN
C        write (*,*) 'Warning: small t = ',t,' in TOR.'
        TOR=1.0E10
      ELSE
        CO=(E1(1)*E2(1)+E1(2)*E2(2)+E1(3)*E2(3))/T
        IF (CO.GT.1.0) CO=1.0
        IF (CO.LT.-1.0) CO=-1.0
        TOR=SIGN(ACOS(CO),(E1(2)*E2(3)-E1(3)*E2(2))*CB(1)+
     *                    (E1(3)*E2(1)-E1(1)*E2(3))*CB(2)+
     *                    (E1(1)*E2(2)-E1(2)*E2(1))*CB(3))
      END IF
      RETURN
      END
C     ------------------------------------------------------------------
C     TREE:     Reorder the dihedral angle data and build the
C               binary tree structure of free dihedral angles.
C
C               On input, FREE is a logical array indicating the
C               free dihedral angles with respect to the original(!)
C               order of dihedral angles.
C               The dihedral angle data are ordered such that the
C               array elements with indices 1,...,NDFREE (<=ND)
C               contain the data of the free dihedral angles and
C               those with indices NDFREE+1,...,ND the data of the
C               fixed dihedral angles. To go through the dihedral
C               angle data in the original order use indirect
C               indexing: IDORD(1),...,IDORD(ND).
C               TREE can be called only after the set-up of the
C               basic structural data with BUILD. It can be called
C               several times without repeating the call of BUILD.
C
C               Peter G"untert, 20-10-1988
C               Modified version, Peter G"untert, 21-01-1991
C     ------------------------------------------------------------------
      SUBROUTINE TREE (FREE)
C
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INCLUDE 'global.incl'
C
      PARAMETER (MAXR2=MAXR*MAXR,MAXA1=MAXA+1,MAXD1=MAXD+1,
     *           MAXDA=MAXD1*MAXA1)
      DIMENSION DV(MAXD),DV0(MAXD),DI(MAXD),
     *          ID(4,MAXD),LD(MAXD),IRR(MAXD),KEY(MAXA),T(12)
      LOGICAL FREE(MAXD)
      CHARACTER*5 DN(MAXD)
C     ------------------------------------------ ORDER FREE/FIXED ANGLES
      L=0
      DO 20 I=1,ND
        IF (FREE(I)) THEN
          L=L+1
          J=IDORD(I)
          IDORD(I)=L
          DN(L)=DNAM(J)
          DV(L)=DVAL(J)
          DV0(L)=DVAL0(J)
          DI(L)=DINVBL(J)
          DO 10 K=1,4
   10       ID(K,L)=IDA(K,J)
          LD(L)=LDA(J)
          IRR(L)=IDR(J)
        END IF
   20   CONTINUE
      NDFREE=L
      DO 40 I=1,ND
        IF (.NOT.FREE(I)) THEN
          L=L+1
          J=IDORD(I)
          IDORD(I)=L
          DN(L)=DNAM(J)
          DV(L)=DVAL(J)
          DV0(L)=DVAL0(J)
          DI(L)=DINVBL(J)
          DO 30 K=1,4
   30       ID(K,L)=IDA(K,J)
          LD(L)=LDA(J)
          IRR(L)=IDR(J)
        END IF
   40   CONTINUE
      DO 60 I=1,ND
        DNAM(I)=DN(I)
        DVAL(I)=DV(I)
        DVAL0(I)=DV0(I)
        DINVBL(I)=DI(I)
        DO 50 K=1,4
   50     IDA(K,I)=ID(K,I)
        LDA(I)=LD(I)
   60   IDR(I)=IRR(I)
C     ---------------------------------- SINE AND COSINE OF FIXED ANGLES
      SIND(-1)=0.0
      COSD(-1)=1.0
      SIND(0)=0.0
      COSD(0)=1.0
      DO 70 I=NDFREE+1,ND
        U=DVAL(I)-DVAL0(I)
        SIND(I)=SIN(U)
   70   COSD(I)=COS(U)
C     -------------------------------------------- BINARY TREE STRUCTURE
      DO 120 I=0,NA
  120   IAUNIT(I)=-1
      IPREV(-1)=-2
      DO 130 I=0,NDFREE
        IPREV(I)=IAUNIT(IDA(3,I))
        DO 130 K=IDA(3,I)+1,LDA(I)
  130     IAUNIT(K)=I
C     ----- DATA FOR THE RECOGNITION OF SHORT RANGE SEQUENTIAL DISTANCES
      DO 240 I=1,NA
        J=IAUNIT(I)
        IF (LDA(J).GT.NA) THEN
          IARB(I)=IAR(I)
        ELSE
          IARB(I)=IAR(I)*MAXR2
        END IF
  240   CONTINUE
C     ----------------- DATA FOR THE GENERATION OF CARTESIAN COORDINATES
      DO 280 I=1,NDFREE
        IF (LDA(I).GT.NA) THEN
          KEY(I)=I
        ELSE
          J=IPREV(I)
          IF (J.GT.0) KEY(I)=KEY(J)+MAXDA
        END IF
  280   CONTINUE
      CALL ISORT (KEY,IDGEN,NDFREE,0)
      NDGEN(1)=0
      DO 290 I=1,NDFREE
        NGEN=KEY(I)/MAXDA+1
  290   NDGEN(NGEN)=I
C      write(90,*) 'ngen=',ngen
C      n=1
C      do j=1,ngen
C        write(90,'(I4,1X,A5,I3)') 
C     *  (j,dnam(idgen(i)),ir(idr(idgen(i))),i=n,ndgen(j))
C        n=i
C      end do
C
      DO 450 I=1,NDFREE
        DV(I)=DVAL(I)
  450   DVAL(I)=0.0
      CALL GENCOR
      DO 460 I=1,NA
        IF (IAUNIT(I).LE.0) THEN
          CX0(I)=CX(I)
          CY0(I)=CY(I)
          CZ0(I)=CZ(I)
        END IF
  460   CONTINUE
      DO 470 J=1,NDFREE
        DVAL(J)=DV(J)
        I1=IDA(1,J)
        I2=IDA(2,J)
        I3=IDA(3,J)
        C1=CX(I2)
        C2=CY(I2)
        C3=CZ(I2)
        R11=CX(I3)-C1
        R12=CY(I3)-C2
        R13=CZ(I3)-C3
        R31=CX(I1)-C1
        R32=CY(I1)-C2
        R33=CZ(I1)-C3
        U=1.0/SQRT(R11**2+R12**2+R13**2)
        R11=R11*U
        R12=R12*U
        R13=R13*U
        R21=R12*R33-R13*R32
        R22=R13*R31-R11*R33
        R23=R11*R32-R12*R31
        U=1.0/SQRT(R21**2+R22**2+R23**2)
        R21=R21*U
        R22=R22*U
        R23=R23*U
        R31=R12*R23-R13*R22
        R32=R13*R21-R11*R23
        R33=R11*R22-R12*R21
        R0(1,J)=R11
        R0(2,J)=R12
        R0(3,J)=R13
        R0(4,J)=R21
        R0(5,J)=R22
        R0(6,J)=R23
        R0(7,J)=R31
        R0(8,J)=R32
        R0(9,J)=R33
        R0(10,J)=C1
        R0(11,J)=C2
        R0(12,J)=C3
        DO 470 I=1,NA
          IF (IAUNIT(I).EQ.J) THEN
            E1=CX(I)-C1
            E2=CY(I)-C2
            E3=CZ(I)-C3
            CX0(I)=R11*E1+R12*E2+R13*E3
            CY0(I)=R21*E1+R22*E2+R23*E3
            CZ0(I)=R31*E1+R32*E2+R33*E3
          END IF
  470     CONTINUE
C      write (91,*) 'TREE: r0 from structure'
C      write (91,'(I4,1X,2A5,I3,F7.2,2X,3F6.2/18X,F7.2,2X,3F6.2/18X,
C     *F7.2,2X,3F6.2)') 
C     *(i,dnam(i),rnam(idr(i)),ir(idr(i)),r0(10,i),r0(11,i),r0(12,i),
C     *r0(1,i),r0(2,i),r0(3,i),r0(4,i),r0(5,i),r0(6,i),r0(7,i),r0(8,i),
C     *r0(9,i),i=1,ndfree) 
C
      DO 480 K=2,12
  480   R0(K,0)=0.0 
      R0(1,0)=1.0
      R0(5,0)=1.0
      R0(9,0)=1.0
      DO 520 I=NDFREE,1,-1
        J=IPREV(I)
        DO 500 K=1,9
  500     T(K)=R0(K,I)
        DO 510 K=10,12
  510     T(K)=R0(K,I)-R0(K,J)
        R0(1,I)=T(1)*R0(1,J)+T(2)*R0(2,J)+T(3)*R0(3,J)
        R0(2,I)=T(1)*R0(4,J)+T(2)*R0(5,J)+T(3)*R0(6,J)
        R0(3,I)=T(1)*R0(7,J)+T(2)*R0(8,J)+T(3)*R0(9,J)
        R0(4,I)=T(4)*R0(1,J)+T(5)*R0(2,J)+T(6)*R0(3,J)
        R0(5,I)=T(4)*R0(4,J)+T(5)*R0(5,J)+T(6)*R0(6,J)
        R0(6,I)=T(4)*R0(7,J)+T(5)*R0(8,J)+T(6)*R0(9,J)
        R0(7,I)=T(7)*R0(1,J)+T(8)*R0(2,J)+T(9)*R0(3,J)
        R0(8,I)=T(7)*R0(4,J)+T(8)*R0(5,J)+T(9)*R0(6,J)
        R0(9,I)=T(7)*R0(7,J)+T(8)*R0(8,J)+T(9)*R0(9,J)
        R0(10,I)=T(10)*R0(1,J)+T(11)*R0(2,J)+T(12)*R0(3,J)
        R0(11,I)=T(10)*R0(4,J)+T(11)*R0(5,J)+T(12)*R0(6,J)
  520   R0(12,I)=T(10)*R0(7,J)+T(11)*R0(8,J)+T(12)*R0(9,J)
      RETURN
      END
C     ==================================================================
C     YESNO:    Get yes/no answer from standard input.
C
C               On input, TEXT is a character string that is written
C               to standard output, followed by an indication of the
C               default answer. This default has to be specified in
C               the character string DEFLT: if the first character of
C               this string equals 'y' or 'Y' the default value for
C               the logical variable ANSWER will be .TRUE. otherwise
C               it will be .FALSE.. On output, ANSWER will have this
C               default value if a blank line is read from standard
C               input. If a non-blank line is read from standard in-
C               put the value of ANSWER on output is determined by
C               the first non-blank character on this line: 'y' or
C               'Y' yield .TRUE., and 'n' or 'N' yield .FALSE., re-
C               spectively; otherwise the default (according to DEFLT)
C               is used.
C
C               Written in standard FORTRAN-77.
C               Peter G"untert, 25-4-1989
C     ------------------------------------------------------------------
      SUBROUTINE YESNO (TEXT,DEFLT,ANSWER)
C
      CHARACTER*(*) TEXT,DEFLT
      LOGICAL ANSWER(*)
      CHARACTER*80 LINE
C
      N=LEN(DEFLT)
      DO 10 J=1,N
   10   ANSWER(J)=DEFLT(J:J).EQ.'Y' .OR. DEFLT(J:J).EQ.'y'
      WRITE (*,*) TEXT,' (default: ',DEFLT,')?'
      READ (*,'(A)') LINE
      J=0
      DO 20 I=1,80
        IF (LINE(I:I).GT.' ') THEN
          J=J+1
          IF (ANSWER(J)) THEN
            ANSWER(J)=.NOT.(LINE(I:I).EQ.'N' .OR. LINE(I:I).EQ.'n')
          ELSE
            ANSWER(J)=LINE(I:I).EQ.'Y' .OR. LINE(I:I).EQ.'y'
          END IF
          IF (J.GE.N) RETURN
        END IF
   20   CONTINUE
      RETURN
      END
C
