/*
 * Decompiled with CFR 0.152.
 */
package visualization.gui;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.imageio.ImageIO;
import model.components.basic.Particle;
import settings.Settings;

public class UtilsUI {
    public static final UtilsUI instance = new UtilsUI();
    public static Color RED = new Color(227, 1, 30);
    public static Color GREEN = new Color(54, 159, 51);
    public static Color GRAY = new Color(80, 80, 80);
    public static final int VALID_ONLY_INTEGERS = 0;
    public static final int VALID_ONLY_NUMEBRS = 1;

    public static UtilsUI getInstance() {
        return instance;
    }

    public static Color quantitativeColors(double temperatureIn) {
        int temperatureScale = (int)(255.0 * temperatureIn / Settings.temperatureMaxColoring);
        return temperatureScale <= 255 ? new Color(temperatureScale, 20, 255 - temperatureScale) : new Color(255, 50, 0);
    }

    public static Color getTemperatureColor(double temperatureIn) {
        return UtilsUI.quantitativeColors(temperatureIn);
    }

    public static Color getTemperatureColor(Particle p) {
        return UtilsUI.quantitativeColors(p.getSpeed() * p.getSpeed() * p.getMAtomic() * 2.0 / 3.0 / 1.380649E-23);
    }

    public static Color setAlpha(Color colorIn, int alphaIn) {
        return new Color(colorIn.getRed(), colorIn.getGreen(), colorIn.getBlue(), alphaIn);
    }

    public static Color setGreen(Color colorIn, int greenIn) {
        return new Color(colorIn.getRed(), greenIn, colorIn.getBlue(), colorIn.getAlpha());
    }

    public ImageView prepareIcon(String path) {
        try {
            Image openIcon = new Image(this.getClass().getResource(path).toURI().toString());
            ImageView openView = new ImageView(openIcon);
            openView.setFitWidth(20.0);
            openView.setFitHeight(20.0);
            return openView;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public BufferedImage prepareImage(String path, int width, int height) {
        try {
            BufferedImage before = ImageIO.read(this.getClass().getResourceAsStream(path));
            int w = before.getWidth();
            int h = before.getHeight();
            BufferedImage after = new BufferedImage(width, height, 2);
            AffineTransform at = new AffineTransform();
            at.scale((float)width / (float)w, (float)height / (float)h);
            AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
            return scaleOp.filter(before, after);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void attachNumericalValidator(final TextField obj, final double recommendedMin, final double recommendedMax, final int numberCategory, final boolean onlyPositives, final boolean allowZero) {
        final Pattern pattern_int = Pattern.compile("[\\deE]*");
        final Pattern pattern_num = Pattern.compile("[\\d\\-\\.eE]*");
        ChangeListener<String> listener = new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String oldValue, String newValue) {
                if (!pattern_int.matcher(newValue).matches() && numberCategory == 0 || !pattern_num.matcher(newValue).matches() && numberCategory == 1) {
                    obj.setText(oldValue);
                    return;
                }
                try {
                    double val = Double.parseDouble(obj.getText());
                    if (val < recommendedMin || val > recommendedMax) {
                        obj.setStyle("-fx-background-color: lightgoldenrodyellow");
                    } else if (val >= recommendedMin && val <= recommendedMax) {
                        obj.setStyle("-fx-background-color: lightgreen");
                    }
                    if (val < 0.0 && onlyPositives) {
                        obj.setText(oldValue);
                    }
                    if (val == 0.0 && !allowZero) {
                        obj.setText(oldValue);
                    }
                }
                catch (Exception e) {
                    obj.setStyle("-fx-background-color: lightcoral");
                }
            }
        };
        listener.changed(null, (Object)obj.getText(), (Object)obj.getText());
        obj.textProperty().addListener((ChangeListener)listener);
    }
}

