/*
 * Decompiled with CFR 0.152.
 */
package tests;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageCompressionOnTheFly {
    public static byte[] compressImage(BufferedImage bi) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, "jpg", bos);
        return bos.toByteArray();
    }

    public static BufferedImage decompressImage(byte[] data) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        return ImageIO.read(bis);
    }

    public static void main(String[] args) throws IOException {
        long time = System.currentTimeMillis();
        byte[] jpegData = null;
        for (int n = 0; n < 100; ++n) {
            BufferedImage bi = new BufferedImage(1920, 1080, 5);
            jpegData = ImageCompressionOnTheFly.compressImage(bi);
        }
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        int sum = 0;
        for (int n = 0; n < 100; ++n) {
            BufferedImage bi = ImageCompressionOnTheFly.decompressImage(jpegData);
            sum += bi.getWidth();
        }
        System.out.println(System.currentTimeMillis() - time);
    }
}

