/*
 * Decompiled with CFR 0.152.
 */
package multimedia;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javax.imageio.ImageIO;
import multimedia.aviwriter.AviWriter;
import settings.Settings;
import visualization.snapshots.ExperimentSnapshotCollector;

public class VTLMovie {
    private ExperimentSnapshotCollector collector;

    public VTLMovie(ExperimentSnapshotCollector collector) {
        this.collector = collector;
    }

    public void renderMovie(File file) {
        String tmpDirectoryPath = Settings.hiddenDefaultDirectory.getPath() + File.separator + "tmp" + File.separator;
        Object outputFilePath = file.getAbsolutePath();
        if (!((String)outputFilePath).endsWith(".avi")) {
            outputFilePath = (String)outputFilePath + ".avi";
        }
        try {
            File fTmp = new File(tmpDirectoryPath);
            fTmp.mkdir();
            for (int frame = 0; frame < this.collector.lenImages(); ++frame) {
                try {
                    WritableImage wi = this.collector.getImage(frame);
                    BufferedImage awtImage = new BufferedImage((int)wi.getWidth(), (int)wi.getHeight(), 1);
                    BufferedImage renderedImage = SwingFXUtils.fromFXImage((Image)wi, (BufferedImage)awtImage);
                    ImageIO.write((RenderedImage)renderedImage, "jpg", new File(tmpDirectoryPath + String.format("%05d", frame) + "_frame.jpg"));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            File outFile = new File((String)outputFilePath);
            try {
                AviWriter aviWriter = new AviWriter(outFile, 2, true);
                for (int i = 1; i < this.collector.lenImages(); ++i) {
                    BufferedImage bi = ImageIO.read(new File(tmpDirectoryPath + String.format("%05d_frame.jpg", i)));
                    aviWriter.writeFrame(bi);
                }
                aviWriter.setFramesPerSecond(20, 1);
                aviWriter.setSamplesPerSecond(1);
                aviWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

