/*
 * Decompiled with CFR 0.152.
 */
package model.components.containers;

import java.awt.Graphics2D;
import java.util.HashMap;
import model.components.basic.WallDynamic;
import model.components.basic.WallDynamicBottom;
import model.components.basic.WallDynamicPlane;
import model.components.basic.WallDynamicSide;
import model.components.core.VTLComponent;
import model.physics.properties.DynamicObject;
import settings.Settings;

public class BoxDynamic
extends VTLComponent
implements DynamicObject {
    public WallDynamic[] walls = new WallDynamic[6];
    public double m;
    public double[] v = new double[]{0.0, 0.0, 0.0};
    public double[] pos = new double[6];

    public BoxDynamic(double x1In, double y1In, double x2In, double y2In, double mIn) {
        this.pos[0] = x1In;
        this.pos[1] = y1In;
        this.pos[2] = Settings.zFront;
        this.pos[3] = x2In;
        this.pos[4] = y2In;
        this.pos[5] = Settings.zBack;
        this.walls[0] = new WallDynamicSide(this.pos[0], this.pos[1], this.pos[4], mIn);
        this.walls[1] = new WallDynamicBottom(this.pos[0], this.pos[3], this.pos[4], mIn);
        this.walls[2] = new WallDynamicPlane(this.pos[0], this.pos[3], this.pos[1], this.pos[4], this.pos[2], mIn);
        this.walls[3] = new WallDynamicSide(this.pos[3], this.pos[1], this.pos[4], mIn);
        this.walls[4] = new WallDynamicBottom(this.pos[0], this.pos[3], this.pos[1], mIn);
        this.walls[5] = new WallDynamicPlane(this.pos[0], this.pos[3], this.pos[1], this.pos[4], this.pos[5], mIn);
        this.m = mIn;
    }

    @Override
    public void draw(Graphics2D context) {
        for (int i = 0; i < 6; ++i) {
            this.walls[i].draw(context);
        }
    }

    @Override
    public void update(double dt) {
        this.pos[0] = this.pos[0] + this.v[0] * dt * Settings.pixelsInAMeter;
        this.pos[1] = this.pos[1] + this.v[1] * dt * Settings.pixelsInAMeter;
        this.pos[2] = this.pos[2] + this.v[2] * dt * Settings.pixelsInAMeter;
        this.pos[3] = this.pos[3] + this.v[0] * dt * Settings.pixelsInAMeter;
        this.pos[4] = this.pos[4] + this.v[1] * dt * Settings.pixelsInAMeter;
        this.pos[5] = this.pos[5] + this.v[2] * dt * Settings.pixelsInAMeter;
        for (int i = 0; i < 6; ++i) {
            this.walls[i].update(dt);
        }
    }

    @Override
    public double[] getPosition() {
        return this.pos;
    }

    @Override
    public double getM() {
        return this.m;
    }

    @Override
    public double[] getV() {
        return this.v;
    }

    @Override
    public HashMap<String, Double> getState() {
        final double[] pos = this.getPosition();
        return new HashMap<String, Double>(){
            {
                this.put("X", pos[0]);
                this.put("Y", pos[1]);
                this.put("Z", pos[2]);
                this.put("WIDTH", pos[3] - pos[0]);
                this.put("HEIGHT", pos[4] - pos[1]);
                this.put("HEIGHT", pos[5] - pos[2]);
            }
        };
    }

    @Override
    public void setV(double[] vIn) {
        for (int i = 0; i < 6; ++i) {
            this.walls[i].setV(vIn);
        }
        this.v = vIn;
    }

    public void setPosY(double y1In, double y2In) {
        this.pos[1] = y1In;
        this.pos[4] = y2In;
        this.walls[0].getPosition()[1] = y1In;
        this.walls[0].getPosition()[4] = y2In;
        this.walls[1].getPosition()[1] = y2In;
        this.walls[1].getPosition()[4] = y2In;
        this.walls[2].getPosition()[1] = y1In;
        this.walls[2].getPosition()[4] = y2In;
        this.walls[3].getPosition()[1] = y1In;
        this.walls[3].getPosition()[4] = y2In;
        this.walls[4].getPosition()[1] = y1In;
        this.walls[4].getPosition()[4] = y1In;
        this.walls[5].getPosition()[1] = y1In;
        this.walls[5].getPosition()[4] = y2In;
    }

    @Override
    public String toXML() {
        throw new UnsupportedOperationException();
    }

    @Override
    public VTLComponent fromXML(String XMLString) {
        throw new UnsupportedOperationException();
    }
}

