/*
 * Decompiled with CFR 0.152.
 */
package model.components.basic;

import java.awt.Color;
import java.awt.Graphics2D;
import model.components.basic.WallStaticSide;
import model.physics.properties.TemperatureObject;
import settings.Settings;
import visualization.gui.UtilsUI;

public class WallStaticSideHeater
extends WallStaticSide
implements TemperatureObject {
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_RIGHT = 1;
    public double temperature;
    public static double tempMax = Settings.temperatureMaxColoring;
    protected int alignment = 0;

    public WallStaticSideHeater(double xIn, double y1In, double y2In, double temperature, int alignment) {
        super(xIn, y1In, y2In);
        this.temperature = temperature;
        this.alignment = alignment;
    }

    @Override
    public void draw(Graphics2D context) {
        context.setColor(new Color(51, 51, 51));
        int thickness = (int)Math.max(2.0, 0.05 * Settings.pixelsInAMeter);
        if (this.alignment == 0) {
            context.fillRoundRect((int)this.pos[0], (int)Math.min(this.pos[1], this.pos[4]), thickness, (int)(Math.abs(this.pos[1] - this.pos[4]) + (double)thickness), 10, 10);
        }
        if (this.alignment == 1) {
            context.fillRoundRect((int)this.pos[0] - thickness, (int)Math.min(this.pos[1], this.pos[4]), thickness, (int)(Math.abs(this.pos[1] - this.pos[4]) + (double)thickness), 10, 10);
        }
        if (Settings.allowHeating) {
            context.setColor(UtilsUI.getTemperatureColor(this.temperature));
            if (this.alignment == 0) {
                context.fillRoundRect((int)this.pos[0], (int)Math.min(this.pos[1], this.pos[4]), thickness / 3, (int)(Math.abs(this.pos[1] - this.pos[4]) + (double)(thickness / 3)), thickness / 6, thickness / 6);
            }
            if (this.alignment == 1) {
                context.fillRoundRect((int)this.pos[0] - thickness / 3, (int)Math.min(this.pos[1], this.pos[4]), thickness / 3, (int)(Math.abs(this.pos[1] - this.pos[4]) + (double)(thickness / 3)), thickness / 6, thickness / 6);
            }
        }
    }

    @Override
    public double getT() {
        return this.temperature;
    }

    @Override
    public void setT(double t) {
        this.temperature = t;
    }
}

