/* Copyright (c) 1989-2011 Peter Guntert. All rights reserved. */

#ifndef P2C_H
#define P2C_H


#include <stdio.h>

#ifndef NO_TIME
# include <time.h>
#endif


/* If the following heuristic fails, compile -DBSD=0 for non-BSD systems,
   or -DBSD=1 for BSD systems. */

#ifdef M_XENIX
# define BSD 0
#endif

#ifdef FILE       /* a #define in BSD, a typedef in SYSV (hp-ux, at least) */
# ifndef BSD	  /*  (a convenient, but horrible kludge!) */
#  define BSD 1
# endif
#endif

#ifdef BSD
# if !BSD
#  undef BSD
# endif
#endif


#ifdef __STDC__
# include <stddef.h>
# include <stdlib.h>
# define HAS_STDLIB
# define __CAT__(a,b)a##b
#else
# ifndef BSD
/*#  include <memory.h>*/
# endif
# include <sys/types.h>
# define __ID__(a)a
# define __CAT__(a,b)__ID__(a)b
#endif


#ifdef BSD
# include <strings.h>
# define memcpy(a,b,n) (bcopy(b,a,n),a)
# define memcmp(a,b,n) bcmp(a,b,n)
# define strchr(s,c) index(s,c)
# define strrchr(s,c) rindex(s,c)
#else
# include <string.h>
#endif

#include <ctype.h>
#include <math.h>
#include <setjmp.h>
#include <assert.h>


typedef struct __p2c_jmp_buf {
    struct __p2c_jmp_buf *next;
    jmp_buf jbuf;
} __p2c_jmp_buf;


/* Warning: The following will not work if setjmp is used simultaneously.
   This also violates the ANSI restriction about using vars after longjmp,
   but a typical implementation of longjmp will get it right anyway. */

#ifndef FAKE_TRY
# define TRY(x)         do { __p2c_jmp_buf __try_jb;  \
			     __try_jb.next = __top_jb;  \
			     if (!setjmp((__top_jb = &__try_jb)->jbuf)) {
# define RECOVER(x)	__top_jb = __try_jb.next; } else {
# define RECOVER2(x,L)  __top_jb = __try_jb.next; } else {  \
			     if (0) { L: __top_jb = __try_jb.next; }
# define ENDTRY(x)      } } while (0) 
#else
# define TRY(x)         if (1) {
# define RECOVER(x)     } else do {
# define RECOVER2(x,L)  } else do { L: ;
# define ENDTRY(x)      } while (0)
#endif



#ifdef M_XENIX  /* avoid compiler bug */
# define SHORT_MAX  (32767)
# define SHORT_MIN  (-32768)
#endif


/* The following definitions work only on twos-complement machines */
#ifndef SHORT_MAX
# define SHORT_MAX  (((unsigned short) -1) >> 1)
# define SHORT_MIN  (~SHORT_MAX)
#endif

#ifndef INT_MAX
# define INT_MAX    (((unsigned int) -1) >> 1)
# define INT_MIN    (~INT_MAX)
#endif

#ifndef LONG_MAX
# define LONG_MAX   (((unsigned long) -1) >> 1)
# define LONG_MIN   (~LONG_MAX)
#endif

#ifndef SEEK_SET
# define SEEK_SET   0
# define SEEK_CUR   1
# define SEEK_END   2
#endif

#ifndef EXIT_SUCCESS
# define EXIT_SUCCESS  0
# define EXIT_FAILURE  1
#endif


#define SETBITS  32


#ifdef __STDC__
# define Signed     signed
# define Void       void      /* Void f() = procedure */
# ifndef Const
#  define Const     const
# endif
# ifndef Volatile
# define Volatile  volatile
# endif
# define PP(x)      x         /* function prototype */
# define PV()       (void)    /* null function prototype */
typedef void *Anyptr;
#else
# define Signed
# define Void       void
# ifndef Const
#  define Const
# endif
# ifndef Volatile
#  define Volatile
# endif
# define PP(x)      ()
# define PV()       ()
typedef char *Anyptr;
#endif

#ifdef __GNUC__
# define Inline     inline
#else
# define Inline
#endif

#define Register    register  /* Register variables */
#define Char        char      /* Characters (not bytes) */

#ifndef Static
# define Static     static    /* Private global funcs and vars */
#endif

#ifndef Local
# define Local      static    /* Nested functions */
#endif

typedef Signed   char schar;
typedef unsigned char boolean;

#ifndef true
# define true    1
# define false   0
#endif


typedef struct {
    Anyptr proc, link;
} _PROCEDURE;

#ifndef _FNSIZE
# define _FNSIZE  120
#endif


extern Void    PASCAL_MAIN  PP( (int, Char **) );
extern Char    **P_argv;
extern int     P_argc;
extern short   P_escapecode;
extern int     P_ioresult;
extern __p2c_jmp_buf *__top_jb;


#ifdef P2C_H_PROTO   /* if you have Ansi C but non-prototyped header files */
extern Char    *strcat      PP( (Char *, Const Char *) );
extern Char    *strchr      PP( (Const Char *, int) );
extern int      strcmp      PP( (Const Char *, Const Char *) );
extern Char    *strcpy      PP( (Char *, Const Char *) );
extern size_t   strlen      PP( (Const Char *) );
extern Char    *strncat     PP( (Char *, Const Char *, size_t) );
extern int      strncmp     PP( (Const Char *, Const Char *, size_t) );
extern Char    *strncpy     PP( (Char *, Const Char *, size_t) );
extern Char    *strrchr     PP( (Const Char *, int) );

extern Anyptr   memchr      PP( (Const Anyptr, int, size_t) );
extern Anyptr   memmove     PP( (Anyptr, Const Anyptr, size_t) );
extern Anyptr   memset      PP( (Anyptr, int, size_t) );
#ifndef memcpy
extern Anyptr   memcpy      PP( (Anyptr, Const Anyptr, size_t) );
extern int      memcmp      PP( (Const Anyptr, Const Anyptr, size_t) );
#endif

extern int      atoi        PP( (Const Char *) );
extern double   atof        PP( (Const Char *) );
extern long     atol        PP( (Const Char *) );
extern double   strtod      PP( (Const Char *, Char **) );
extern long     strtol      PP( (Const Char *, Char **, int) );
#endif /*P2C_H_PROTO*/

extern int      _OutMem     PV();
extern int      _CaseCheck  PV();
extern int      _NilCheck   PV();
extern int	_Escape     PP( (int) );
extern int	_EscIO      PP( (int) );

extern long     Ipow        PP( (long, long) );
extern Char    *strsub      PP( (Char *, Char *, int, int) );
extern Char    *strltrim    PP( (Char *) );
extern Char    *strrtrim    PP( (Char *) );
extern Char    *strrpt      PP( (Char *, Char *, int) );
extern Char    *strpad      PP( (Char *, Char *, int, int) );
extern int      strpos2     PP( (Char *, Char *, int) );
extern long     memavail    PV();
extern int      P_peek      PP( (FILE *) );
extern int      P_eof       PP( (FILE *) );
extern int      P_eoln      PP( (FILE *) );
extern Void     P_readpaoc  PP( (FILE *, Char *, int) );
extern Void     P_readlnpaoc PP( (FILE *, Char *, int) );
extern long     P_maxpos    PP( (FILE *) );
extern Char    *P_trimname  PP( (Char *, int) );
extern long    *P_setunion  PP( (long *, long *, long *) );
extern long    *P_setint    PP( (long *, long *, long *) );
extern long    *P_setdiff   PP( (long *, long *, long *) );
extern long    *P_setxor    PP( (long *, long *, long *) );
extern int      P_inset     PP( (unsigned, long *) );
extern int      P_setequal  PP( (long *, long *) );
extern int      P_subset    PP( (long *, long *) );
extern long    *P_addset    PP( (long *, unsigned) );
extern long    *P_addsetr   PP( (long *, unsigned, unsigned) );
extern long    *P_remset    PP( (long *, unsigned) );
extern long    *P_setcpy    PP( (long *, long *) );
extern long    *P_expset    PP( (long *, long) );
extern long     P_packset   PP( (long *) );
extern int      P_getcmdline PP( (int l, int h, Char *line) );
extern Void     TimeStamp   PP( (int *Day, int *Month, int *Year,
				 int *Hour, int *Min, int *Sec) );
extern Void	P_sun_argv  PP( (char *, int, int) );


/* I/O error handling */
#define _CHKIO(cond,ior,val,def)  ((cond) ? P_ioresult=0,(val)  \
					  : P_ioresult=(ior),(def))
#define _SETIO(cond,ior)          (P_ioresult = (cond) ? 0 : (ior))

/* Following defines are suitable for the HP Pascal operating system */
#define FileNotFound     10
#define FileNotOpen      13
#define FileWriteError   38
#define BadInputFormat   14
#define EndOfFile        30

/* Creating temporary files */
#if (defined(BSD) || defined(NO_TMPFILE)) && !defined(HAVE_TMPFILE)
# define tmpfile()  (fopen(tmpnam(NULL), "w+"))
#endif

/* File buffers */
#define FILEBUF(f,sc,type) sc int __CAT__(f,_BFLAGS);   \
			   sc type __CAT__(f,_BUFFER)

#define RESETBUF(f,type)   (__CAT__(f,_BFLAGS) = 1)
#define SETUPBUF(f,type)   (__CAT__(f,_BFLAGS) = 0)

#define GETFBUF(f,type)    (*((__CAT__(f,_BFLAGS) == 1 &&   \
			       ((__CAT__(f,_BFLAGS) = 2),   \
				fread(&__CAT__(f,_BUFFER),  \
				      sizeof(type),1,(f)))),\
			      &__CAT__(f,_BUFFER)))
#define AGETFBUF(f,type)   ((__CAT__(f,_BFLAGS) == 1 &&   \
			     ((__CAT__(f,_BFLAGS) = 2),   \
			      fread(&__CAT__(f,_BUFFER),  \
				    sizeof(type),1,(f)))),\
			    __CAT__(f,_BUFFER))

#define PUTFBUF(f,type,v)  (GETFBUF(f,type) = (v))
#define CPUTFBUF(f,v)      (PUTFBUF(f,char,v))
#define APUTFBUF(f,type,v) (memcpy(GETFBUF(f,type), (v),  \
				   sizeof(__CAT__(f,_BUFFER))))

#define GET(f,type)        (__CAT__(f,_BFLAGS) == 1 ?   \
			    fread(&__CAT__(f,_BUFFER),sizeof(type),1,(f)) :  \
			    (__CAT__(f,_BFLAGS) = 1))

#define PUT(f,type)        (fwrite(&__CAT__(f,_BUFFER),sizeof(type),1,(f)),  \
			    (__CAT__(f,_BFLAGS) = 0))
#define CPUT(f)            (PUT(f,char))

#define BUFEOF(f)	   (__CAT__(f,_BFLAGS) != 2 && P_eof(f))
#define BUFFPOS(f)	   (ftell(f) - (__CAT__(f,_BFLAGS) == 2))

/* Memory allocation */
#ifdef __GCC__
# define Malloc(n)  (malloc(n) ?: (Anyptr)_OutMem())
#else
extern Anyptr __MallocTemp__;
# define Malloc(n)  ((__MallocTemp__ = malloc(n)) ? __MallocTemp__ : (Anyptr)_OutMem())
#endif
#define FreeR(p)    (free((Anyptr)(p)))    /* used if arg is an rvalue */
#define Free(p)     (free((Anyptr)(p)), (p)=NULL)

/* sign extension */
#define SEXT(x,n)   ((x) | -(((x) & (1L<<((n)-1))) << 1))

/* packed arrays */   /* BEWARE: these are untested! */
#define P_getbits_UB(a,i,n,L)   ((int)((a)[(i)>>(L)-(n)] >>   \
				       (((~(i))&((1<<(L)-(n))-1)) << (n)) &  \
				       (1<<(1<<(n)))-1))

#define P_getbits_SB(a,i,n,L)   ((int)((a)[(i)>>(L)-(n)] <<   \
				       (16 - ((((~(i))&((1<<(L)-(n))-1))+1) <<\
					      (n)) >> (16-(1<<(n))))))

#define P_putbits_UB(a,i,x,n,L) ((a)[(i)>>(L)-(n)] |=   \
				 (x) << (((~(i))&((1<<(L)-(n))-1)) << (n)))

#define P_putbits_SB(a,i,x,n,L) ((a)[(i)>>(L)-(n)] |=   \
				 ((x) & (1<<(1<<(n)))-1) <<   \
				 (((~(i))&((1<<(L)-(n))-1)) << (n)))

#define P_clrbits_B(a,i,n,L)    ((a)[(i)>>(L)-(n)] &=   \
				 ~( ((1<<(1<<(n)))-1) <<   \
				   (((~(i))&((1<<(L)-(n))-1)) << (n))) )

/* small packed arrays */
#define P_getbits_US(v,i,n)     ((int)((v) >> ((i)<<(n)) & (1<<(1<<(n)))-1))
#define P_getbits_SS(v,i,n)     ((int)((long)(v) << (SETBITS - (((i)+1) << (n))) >> (SETBITS-(1<<(n)))))
#define P_putbits_US(v,i,x,n)   ((v) |= (x) << ((i) << (n)))
#define P_putbits_SS(v,i,x,n)   ((v) |= ((x) & (1<<(1<<(n)))-1) << ((i)<<(n)))
#define P_clrbits_S(v,i,n)      ((v) &= ~( ((1<<(1<<(n)))-1) << ((i)<<(n)) ))

#define P_max(a,b)   ((a) > (b) ? (a) : (b))
#define P_min(a,b)   ((a) < (b) ? (a) : (b))


/* Fix toupper/tolower on Suns and other stupid BSD systems */
#ifdef toupper
# undef toupper
# undef tolower
# define toupper(c)   my_toupper(c)
# define tolower(c)   my_tolower(c)
#endif

#ifndef _toupper
# if 'A' == 65 && 'a' == 97
#  define _toupper(c)  ((c)-'a'+'A')
#  define _tolower(c)  ((c)-'A'+'a')
# else
#  define _toupper(c)  toupper(c)
#  define _tolower(c)  tolower(c)
# endif
#endif


#endif    /* P2C_H */



/* End. */


/* From input file "cofima.pas" */




/* COordinate FIle MAnipulation          */
/* called from cofima.com                */
/* Peter Guentert, 21-3-1988             */


/* ========================= String functions ============================== */
/*PG*/
Static int strpos3(st, os, l)
Char *st,*os;
long l;
{
  return strpos2(os,st,1); 
}  


Static Char LowCase(ch)
Char ch;
{
  if (isupper(ch))
    return (ch + 32);
  else
    return ch;
}


Static Char UpCase(ch)
Char ch;
{
  if (islower(ch))
    return (ch - 32);
  else
    return ch;
}


Static Char *LowStr(Result, sl, st_)
Char *Result;
long sl;
Char *st_;
{
  Char st[201];
  long i, FORLIM;

  strcpy(st, st_);
  FORLIM = strlen(st);
  for (i = 0; i < FORLIM; i++)
    st[i] = LowCase(st[i]);
  return strcpy(Result, st);
}


Static Char *UpStr(Result, sl, st_)
Char *Result;
long sl;
Char *st_;
{
  Char st[201];
  long i, FORLIM;

  strcpy(st, st_);
  FORLIM = strlen(st);
  for (i = 0; i < FORLIM; i++)
    st[i] = UpCase(st[i]);
  return strcpy(Result, st);
}


Static Char *IntStr(Result, n, w)
Char *Result;
long n, w;
{
  Char st[201];

  sprintf(st, "%*ld", (int)w, n);
  return strcpy(Result, st);
}


Static Char *CopyStr(Result, sl, st, s, l)
Char *Result;
long sl;
Char *st;
long s, l;
{
  /*PGs = P_imax(s, 1);*/ if (s<1) s=1;
  if (l == 0 || s > (long)strlen(st))
    return strcpy(Result, "");
  else {
    if (l>(long)strlen(st)-s+1) l=strlen(st)-s+1;
    sprintf(Result, "%.*s", (int)l, st + s - 1);
/*PG sprintf(Result, "%.*s", (int)P_imin(l, strlen(st) - s + 1), st + s - 1);*/
/*PGdebugprintf("CopyStr: st=%s, s=%d, l=%d, Result=%s\n",st,s,l,Result);*/
    return Result;
  }
}


Static Char *Header(Result, sl, st, l)
Char *Result;
long sl;
Char *st;
long l;
{
  return (CopyStr(Result, sl, st, 1L, l));
}


Static Char *Trailer(Result, sl, st, s)
Char *Result;
long sl;
Char *st;
long s;
{
  return (CopyStr(Result, sl, st, s, (long)strlen(st)));
}


Static Char *NoHeader(Result, sl, st)
Char *Result;
long sl;
Char *st;
{
  long l, i;

  l = strlen(st);
  if (l > 0) {
    i = 1;
    while (i < l && st[i - 1] <= ' ')
      i++;
    if (i < l || st[l - 1] > ' ') {
      sprintf(Result, "%.*s", (int)(l - i + 1), st + i - 1);
      return Result;
    } else
      return strcpy(Result, "");
  } else
    return strcpy(Result, "");
}


Static Char *NoTrailer(Result, sl, st)
Char *Result;
long sl;
Char *st;
{
  long i;

  i = strlen(st);
  if (i > 1) {
    while (i > 1 && st[i - 1] <= ' ')
      i--;
  }
  if (i == 1) {
    if (st[0] <= ' ')
      i = 0;
  }
  sprintf(Result, "%.*s", (int)i, st);
  return Result;
}


Static Char *CoreStr(Result, sl, st)
Char *Result;
long sl;
Char *st;
{
  Char STR2[201];

  return (NoHeader(Result, 200L, NoTrailer(STR2, sl, st)));
}


Static Char *Adjust(Result, sl, st, len)
Char *Result;
long sl;
Char *st;
long len;
{
  long l, i;
  Char str[201];

  l = strlen(st);
  if (len < l) {
    sprintf(Result, "%.*s", (int)len, st);
    return Result;
  } else {
    strcpy(str, st);
    for (i = l + 1; i <= len; i++)
      strcat(str, " ");
    return strcpy(Result, str);
  }
}


Static Char *Append_defext(Result, sl, spec, dl, defext)
Char *Result;
long sl;
Char *spec;
long dl;
Char *defext;
{
  long i,j;
  Char STR1[201], STR3[201];

  /*PGi = P_imax(strpos3("]", spec, 1), strpos3(":", spec, 1));*/
  i = strpos3("]", spec, 1); 
  for (j = strlen(spec); j >= 0; j--) if (spec[j] == '/') break;
  j++; if (j>i) i=j;
  j=strpos3(":", spec, 1); if (j>i) i=j;
  i = strpos3(".", Trailer(STR1, sl, spec, i + 1), 1);
  if (i == 0) {
    i = strpos3(";", spec, 1);
    if (i == 0) {
      sprintf(Result, "%s.%s", spec, defext);
      return Result;
    } else {
      sprintf(Result, "%s.%s%s",
	      Header(STR1, sl, spec, i - 1), defext,
	      Trailer(STR3, sl, spec, i));
      return Result;
    }
  } else
    return strcpy(Result, spec);
}


Static Char *Extract_filename(Result, sl, spec_) /*PG Unix specific! */
Char *Result;
long sl;
Char *spec_;
{
  Char spec[201];
  long i,j;
  Char STR1[201];

  strcpy(spec, spec_);
  i = strpos3(";", spec, 1);
  if (i > 0)
    strcpy(spec, Header(STR1, sl, spec, i - 1));
  /*PGi = P_imax(strpos3("]", spec, 1), strpos3(":", spec, 1));
  i = strpos3("]", spec, 1); j=strpos3(":", spec, 1); if (j>i) i=j;*/
  do {
    i=strpos3("/",spec,1); if (i>0) strcpy(spec,Trailer(STR1,sl,spec,i+1)); }
  while (i>0);
  return (Trailer(Result, sl, spec, i + 1));
}


Static Char *Extract_path(Result, sl, spec)  /*PG Unix specific! */
Char *Result;
long sl;
Char *spec;
{
  long i,j;
  Char STR[201];

  /*PGi = P_imax(strpos3("]", spec, 1), strpos3(":", spec, 1));
  i = strpos3("]", spec, 1); j=strpos3(":", spec, 1); if (j>i) i=j;*/
  strcpy(STR,spec);
  j=0;
  do {i=strpos3("/",STR,1); if (i>0) { j=i; STR[i-1]='x'; }} while (i>0);
/*PGdebug printf("Extract_path: spec=%s, STR=%s, j=%d\n",spec,STR,j);*/
  if (j == 0)
    return strcpy(Result, "");
  else {
    sprintf(Result, "%.*s", (int)j, spec);
    return Result;
  }
}


Static Char *Element(Result, sl, st_, n, sepl, sep, exact)
Char *Result;
long sl;
Char *st_;
long n, sepl;
Char *sep;
boolean exact;
{
  Char st[201];
  long i;
  Char STR1[201];
  Char STR2[256];
  Char STR3[201];

  strcpy(st, st_);
  if (!exact) {
    do {
      i = strpos3(sep, st, 1);
      if (i == 1)
	strcpy(st, Trailer(STR1, sl, st, sepl + 1));
    } while (i == 1);
    do {
      sprintf(STR2, "%s%s", sep, sep);
      i = strpos3(STR2, st, 1);
      if (i > 0) {
	sprintf(STR2, "%s%s",
		Header(STR1, sl, st, i - 1), Trailer(STR3, sl, st, i + sepl));
	strcpy(st, STR2);
      }
    } while (i != 0);
  }
  while (n > 1) {
    n--;
    i = strpos3(sep, st, 1);
    if (i == 0) {
      *st = '\0';
      n = 0;
    } else
      strcpy(st, Trailer(STR1, sl, st, strpos3(sep, st, 1) + sepl));
  }
  i = strpos3(sep, st, 1);
  if (i == 0)
    return strcpy(Result, st);
  else
    return (Header(Result, sl, st, i - 1));
}


Static boolean Match(ol, obj_, sl, st_)
long ol;
Char *obj_;
long sl;
Char *st_;
{
  boolean Result;
  Char obj[201];
  Char st[201];
  boolean fix;
  long i;
  Char STR1[201];
  Char STR2[256];

  strcpy(obj, obj_);
  strcpy(st, st_);
/*PGdebugprintf("Match: obj=%s, st=%s, ol=%d, sl=%d\n",obj,st,ol,sl);*/
  fix = true;
  while (*obj != '\0') {
/*PGdebugprintf("Match: obj=%s, st=%s\n",obj,st);*/
    switch (obj[0]) {

    case '%':
      if (*st == '\0')
	goto _L1;
      strcpy(st, Trailer(STR1, sl, st, 2L));
      break;

    case '*':
      fix = false;
      break;

    default:
      sprintf(STR2, "%c", obj[0]);
      i = strpos3(STR2, st, 1);
/*PGdebugprintf("strpos3: STR2=%s, st=%s, i=%d\n",STR2,st,i);*/
      if (i == 0 || fix && i > 1)
	goto _L1;
      fix = true;
      strcpy(st, Trailer(STR1, sl, st, i + 1));
      break;
    }
    strcpy(obj, Trailer(STR1, ol, obj, 2L));
  }
  Result = (*st == '\0' || !fix);
  goto _L2;
_L1:
  Result = false;
_L2:
  return Result;
}


Static Char *NoTabs(Result, sl, st)
Char *Result;
long sl;
Char *st;
{
  long n, m, l, b, i;
  Char Line[201];

  n = 0;
  m = 1;
  l = strlen(st);
  *Line = '\0';
  while (m <= l) {
    if (st[m - 1] != '\t') {
      sprintf(Line + strlen(Line), "%c", st[m - 1]);
      n++;
      m++;
      continue;
    }
    b = 8 - (n & 7);
    n += b;
    m++;
    for (i = 1; i <= b; i++)
      strcat(Line, " ");
  }
  return strcpy(Result, Line);
}


/*FUNCTION GetDate: Linetype;
                     VAR ds: PACKED ARRAY [1..11] OF Char;
                     BEGIN Date (ds); GetDate:=ds END;*/

/* ================= Mathematical and vector functions ===================== */

#define pi              3.141592654
#define rad             57.29577951


typedef float Vector[3];


Static long sgn(x)
float x;
{
  return ((x >= 0.0) - (x < 0.0));
}


Static float per(w, l, u)
float w, l, u;
{
  float d;

  d = u - l;
  while (w >= u)
    w -= d;
  while (w < l)
    w += d;
  return w;
}


Static float arccos_(x)
float x;
{
  if (x > 1.0)
    x = 1.0;
  else if (x < -1.0)
    x = -1.0;
  if (fabs(x) >= 0.5) {
    if (x > 0.0)
      return atan(sqrt(1.0 - x * x) / x);
    else
      return (pi + atan(sqrt(1.0 - x * x) / x));
  } else
    return (0.5 * pi - atan(x / sqrt(1.0 - x * x)));
}


Static float *vec(Result, x, y, z)
float *Result;
float x, y, z;
{
  Vector f;

  f[0] = x;
  f[1] = y;
  f[2] = z;
  return (float *)memcpy(Result, f, sizeof(Vector));
}


Static float *vspher(Result, r, theta, phi)
float *Result;
float r, theta, phi;
{
  Vector f;

  f[0] = r * sin(theta);
  f[1] = f[0];
  f[0] *= cos(phi);
  f[1] *= sin(phi);
  f[2] = r * cos(theta);
  return (float *)memcpy(Result, f, sizeof(Vector));
}


Static float *mult(Result, s, a_)
float *Result;
float s;
float *a_;
{
  Vector a;

  memcpy(a, a_, sizeof(Vector));
  a[0] = s * a[0];
  a[1] = s * a[1];
  a[2] = s * a[2];
  return (float *)memcpy(Result, a, sizeof(Vector));
}


Static float *sum(Result, a_, b)
float *Result, *a_, *b;
{
  Vector a;

  memcpy(a, a_, sizeof(Vector));
  a[0] += b[0];
  a[1] += b[1];
  a[2] += b[2];
  return (float *)memcpy(Result, a, sizeof(Vector));
}


Static float *diff(Result, a_, b)
float *Result, *a_, *b;
{
  Vector a;

  memcpy(a, a_, sizeof(Vector));
  a[0] -= b[0];
  a[1] -= b[1];
  a[2] -= b[2];
  return (float *)memcpy(Result, a, sizeof(Vector));
}


Static float len(a)
float *a;
{
  double TEMP, TEMP1, TEMP2;

  TEMP = a[0];
  TEMP1 = a[1];
  TEMP2 = a[2];
  return sqrt(TEMP * TEMP + TEMP1 * TEMP1 + TEMP2 * TEMP2);
}


Static float lensqr(a)
float *a;
{
  double TEMP, TEMP1, TEMP2;

  TEMP = a[0];
  TEMP1 = a[1];
  TEMP2 = a[2];
  return (TEMP * TEMP + TEMP1 * TEMP1 + TEMP2 * TEMP2);
}


Static float dist(a, b)
float *a, *b;
{
  double TEMP, TEMP1, TEMP2;

  TEMP = a[0] - b[0];
  TEMP1 = a[1] - b[1];
  TEMP2 = a[2] - b[2];
  return sqrt(TEMP * TEMP + TEMP1 * TEMP1 + TEMP2 * TEMP2);
}


Static float dot(a, b)
float *a, *b;
{
  return (a[0] * b[0] + a[1] * b[1] + a[2] * b[2]);
}


Static float *cross(Result, a, b)
float *Result, *a, *b;
{
  Vector f;

  f[0] = a[1] * b[2] - a[2] * b[1];
  f[1] = a[2] * b[0] - a[0] * b[2];
  f[2] = a[0] * b[1] - a[1] * b[0];
  return (float *)memcpy(Result, f, sizeof(Vector));
}


Static float *unit(Result, a)
float *Result, *a;
{
  return (mult(Result, 1.0 / len(a), a));
}


Static float *normal(Result, a, b)
float *Result, *a, *b;
{
  Vector TEMP1;

  return (unit(Result, cross(TEMP1, a, b)));
}


Static float *rotvec(Result, a, e, w)
float *Result, *a, *e;
float w;
{
  float cosw;
  Vector TEMP1, TEMP2, TEMP3, TEMP4, TEMP5;

  cosw = cos(w);
  return (sum(Result, mult(TEMP1, dot(e, a) * (1.0 - cosw), e),
	      sum(TEMP2, mult(TEMP3, cosw, a),
		  mult(TEMP4, sin(w), cross(TEMP5, e, a)))));
}


Static float angl(a, b)
float *a, *b;
{
  double TEMP, TEMP1, TEMP2, TEMP3, TEMP4, TEMP5;

  TEMP = a[0];
  TEMP1 = a[1];
  TEMP2 = a[2];
  TEMP3 = b[0];
  TEMP4 = b[1];
  TEMP5 = b[2];
  return (arccos_((a[0] * b[0] + a[1] * b[1] + a[2] * b[2]) /
		  sqrt((TEMP * TEMP + TEMP1 * TEMP1 + TEMP2 * TEMP2) *
		       (TEMP3 * TEMP3 + TEMP4 * TEMP4 + TEMP5 * TEMP5))));
/* p2c: cofima.pas, line 153: Note:
 * Line breaker spent 1.0+0.22 seconds, 1857 tries on line 598 [251] */
}


Static float tor(a, b, c, d)
float *a, *b, *c, *d;
{
  double cb[3], n1[3], n2[3];
  float co;
  double TEMP, TEMP1, TEMP2, TEMP3, TEMP4, TEMP5;

  /* this code leads to numerical instabilities if single precision is used:
                       BEGIN cb:=diff(c,b); n1:=cross(diff(b,a),cb); n2:=cross(cb,diff(d,c));
                       tor:=angl(n1,n2)*sgn(triple(n1,n2,cb)) END;
  */
  cb[0] = c[0] - b[0];
  cb[1] = c[1] - b[1];
  cb[2] = c[2] - b[2];
  n1[0] = (b[1] - a[1]) * cb[2] + (a[2] - b[2]) * cb[1];
  n1[1] = (b[2] - a[2]) * cb[0] + (a[0] - b[0]) * cb[2];
  n1[2] = (b[0] - a[0]) * cb[1] + (a[1] - b[1]) * cb[0];
  n2[0] = cb[1] * (d[2] - c[2]) + cb[2] * (c[1] - d[1]);
  n2[1] = cb[2] * (d[0] - c[0]) + cb[0] * (c[2] - d[2]);
  n2[2] = cb[0] * (d[1] - c[1]) + cb[1] * (c[0] - d[0]);
  TEMP = n1[0];
  TEMP1 = n1[1];
  TEMP2 = n1[2];
  TEMP3 = n2[0];
  TEMP4 = n2[1];
  TEMP5 = n2[2];
  co = (float)((n1[0] * n2[0] + n1[1] * n2[1] + n1[2] * n2[2]) /
	       sqrt((TEMP * TEMP + TEMP1 * TEMP1 + TEMP2 * TEMP2) *
		    (TEMP3 * TEMP3 + TEMP4 * TEMP4 + TEMP5 * TEMP5)));
  return (arccos_(co) * sgn((float)((n1[1] * n2[2] - n1[2] * n2[1]) * cb[0] +
			      (n1[2] * n2[0] - n1[0] * n2[2]) * cb[1] +
			      (n1[0] * n2[1] - n1[1] * n2[0]) * cb[2])));
/* p2c: cofima.pas, line 173: Note:
 * Line breaker spent 5.9+0.21 seconds, 5000 tries on line 635 [251] */
}


Static float *attach_atom(Result, a, b, c, phi0, l, tau, phi)
float *Result, *a, *b, *c;
float phi0, l, tau, phi;
{
  Vector e, TEMP, TEMP1, TEMP2, TEMP3, TEMP4, TEMP5, TEMP6, TEMP7;

  unit(e, diff(TEMP1, c, b));
  return (sum(Result, c, rotvec(TEMP,
		sum(TEMP2, mult(TEMP3, -l * cos(tau), e), mult(TEMP4,
		      l * sin(tau),
		      normal(TEMP5, cross(TEMP6, e, diff(TEMP7, a, b)), e))),
		e, phi - phi0)));
/* p2c: cofima.pas, line 177: Note:
 * Line breaker spent 1.5+0.60 seconds, 5000 tries on line 652 [251] */
}


/* ======================= Input and output routines ======================= */

Static Void Open_input_file(f, sl, spec, dl, defext, err)
FILE **f;
long sl;
Char *spec;
long dl;
Char *defext;
boolean *err;
{
  Char STR1[201];

  if (*f != NULL)
    *f = freopen(Append_defext(STR1, sl, spec, dl, defext), "r", *f);
  else
    *f = fopen(Append_defext(STR1, sl, spec, dl, defext), "r");
  /*PGif (*f == NULL)
    _EscIO(FileNotFound);
  *err = false;*/
  if (*f == NULL) *err = true; else *err = false;
}


Static Void Open_output_file(f, sl, spec, dl, defext, err)
FILE **f;
long sl;
Char *spec;
long dl;
Char *defext;
boolean *err;
{
  Char STR1[201];

  if (*f != NULL)
    *f = freopen(Append_defext(STR1, sl, spec, dl, defext), "w", *f);
  else
    *f = fopen(Append_defext(STR1, sl, spec, dl, defext), "w");
  /*PGif (*f == NULL)
    _EscIO(FileNotFound);
  *err = false;*/
  if (*f == NULL) *err = true; else *err = false;
}


Static Void Skip(f, cl, commentchar)
FILE **f;
long cl;
Char *commentchar;
{
  Char ch;
  Char STR1[256];

  while (P_peek(*f) <= ' ' && !(P_eoln(*f) || P_eof(*f))) {
    ch = getc(*f);
    if (ch == '\n')
      ch = ' ';
  }
  sprintf(STR1, "%c", P_peek(*f));
/* p2c: cofima.pas, line 191:
 * Note: File parameter f needs its associated buffers [318] */
  if (strpos3(STR1, commentchar, 1) <= 0)
    return;
/* p2c: cofima.pas, line 192:
 * Note: File parameter f needs its associated buffers [318] */
  while (!(P_eoln(*f) || P_eof(*f))) {
    ch = getc(*f);
    if (ch == '\n')
      ch = ' ';
  }
}


Static Void SkipLn(f, cl, commentchar)
FILE **f;
long cl;
Char *commentchar;
{
  Char STR1[256];
  int iret;

  do {
    Skip(f, cl, commentchar);
    if (P_eoln(*f) && !P_eof(*f)) {
      do {
	iret=fscanf(*f, "%*[^\n]");
	getc(*f);
/* p2c: cofima.pas, line 196:
 * Note: File parameter f needs its associated buffers [318] */
      } while (!(strpos3((sprintf(STR1, "%c", P_peek(*f)), STR1), commentchar,
			 1) == 0 || P_eof(*f)));
    }
/* p2c: cofima.pas, line 197:
 * Note: File parameter f needs its associated buffers [318] */
  } while (!(P_peek(*f) > ' ' || P_eof(*f)));
}


Static Void ReadStr(f, sl, st)
FILE **f;
long sl;
Char *st;
{
  Char ch;
  long i;
  boolean e;

  *st = '\0';
  e = P_eof(*f);
  if (!e)
    e = P_eoln(*f);
  while (P_peek(*f) <= ' ' && !e) {
    ch = getc(*f);
    if (ch == '\n')
      ch = ' ';
    e = P_eof(*f);
    if (!e)
      e = P_eoln(*f);
  }
/* p2c: cofima.pas, line 201:
 * Note: File parameter f needs its associated buffers [318] */
  if (P_eof(*f))
    return;
  if (P_eoln(*f))
    return;
  ch = getc(*f);
  if (ch == '\n')
    ch = ' ';
  sprintf(st, "%c", ch);
  i = 1;
  e = P_eof(*f);
  if (!e)
    e = P_eoln(*f);
  while (P_peek(*f) > ' ' && !e) {
    ch = getc(*f);
    if (ch == '\n')
      ch = ' ';
    if (i < sl) {
      sprintf(st + strlen(st), "%c", ch);
      i++;
    }
    e = P_eof(*f);
    if (!e)
      e = P_eoln(*f);
  }
/* p2c: cofima.pas, line 204:
 * Note: File parameter f needs its associated buffers [318] */
}


/* stat values:   0...o.k., n(>0)...error reading line n, -1...file cannot be opened,       */
/*                -2...too many items, -3...format is not implemented or illegal            */
/* erract values: 0...continue, 1...show error message and continue, 2...halt,              */
/*                3...show error message and halt                                           */

typedef enum {
  DG, PDB, AMBER, DIAMOND, DISMAN, HABAS, CONFOR, DISGEO, ELLIPS, CAST
} Formattype;

typedef struct CORdata {
  long atnum, resnum;
  Char atnam[6], resnam[6];
  Vector x;
} CORdata;

typedef struct CORCONdata {
  long atnum, resnum;
  Char atnam[6], resnam[6];
  Vector x;
  long con[4];
  float occupancy, bfactor;
} CORCONdata;

typedef struct DCOdata {
  long resnum1, resnum2;
  Char atnam1[6], resnam1[6], atnam2[6], resnam2[6];
  float lim;
  Char comment[81];
} DCOdata;

typedef struct ACOdata {
  long resnum;
  Char resnam[6], angnam[6];
  float lol, upl;
} ACOdata;


Static Void pg_error_handler(sl, section, stat, erract, ml, message)
long sl;
Char *section;
long stat, erract, ml;
Char *message;
{
  if (!strcmp(section, "StructIO")) {
    if ((unsigned long)erract < 32 && ((1L << erract) & 0xa) != 0 &&
	*message == '\0') {
      switch (stat) {

      case -1:
	printf("%s-error: file cannot be opened\n", section);
	break;

      case -2:
	printf("%s-error: too many items\n", section);
	break;

      case -3:
	printf("%s-error: format is not implemented or illegal\n", section);
	break;

      default:
	printf("%s-error: error reading line %ld\n", section, stat);
	break;
      }
    }
    if ((unsigned long)erract < 32 && ((1L << erract) & 0xa) != 0 &&
	*message != '\0') {
      switch (stat) {

      case -1:
	printf("%s-error: file %s cannot be opened\n", section, message);
	break;

      case -2:
	printf("%s-error: too many items (maximum=%s)\n", section, message);
	break;

      case -3:
	printf("%s-error: format is not implemented or illegal\n", section);
	break;

      default:
	printf("%s-error: error reading line %ld in file %s\n",
	       section, stat, message);
	break;
      }
    }
  } else if (!strcmp(section, "Connect")) {
    if ((unsigned long)erract < 32 && ((1L << erract) & 0xa) != 0) {
      switch (stat) {

      case -1:
	printf("%s-error: error in bond radii list\n", section);
	break;

      case -2:
	printf("%s-error: incomplete bond radii list\n", section);
	break;

      default:
	printf("%s-error: atoms with more than 4 connectivities\n", section);
	break;
      }
    }
  }
  if ((unsigned long)erract < 32 && ((1L << erract) & 0xc) != 0)
    _Escape(0);
}


Static Void readaco(fl, acofile_, dl, defext_, format, n, m, constr, naco,
		    stat, erract)
long fl;
Char *acofile_;
long dl;
Char *defext_;
Formattype format;
long n, m;
ACOdata *constr;
long *naco, *stat, erract;
{
  Char acofile[201];
  Char defext[201];
  FILE *f;
  boolean err;
  long i, l, angnum;
  ACOdata *WITH;

  strcpy(acofile, acofile_);
  strcpy(defext, defext_);
  f = NULL;
  *stat = 0;
  if (((1L << ((long)format)) & ((1L << ((long)DISMAN)) |
	 (1L << ((long)HABAS)) | (1L << ((long)ELLIPS)))) == 0) {
    *stat = -3;
    goto _L99;
  }
  Open_input_file(&f, fl, acofile, dl, defext, &err);
  if (err) {
    *stat = -1;
    goto _L99;
  }
  switch (format) {

  case ELLIPS:
    i = n;
    l = 0;
    SkipLn(&f, 1, "#");
    while (!P_eof(f)) {
      WITH = &constr[i - n];
      l++;
      err=(fscanf(f, "%ld", &WITH->resnum)!=1); 
      if (err) {
	*stat = l;
	goto _L99;
      }
/* p2c: cofima.pas, line 257:
 * Internal error in strmax_func: got a pointer instead of a string [171] */
      ReadStr(&f, 5L, WITH->resnam);
/* p2c: cofima.pas, line 257:
 * Internal error in strmax_func: got a pointer instead of a string [171] */
      ReadStr(&f, 5L, WITH->angnam);
      err=(fscanf(f, "%f%f", &WITH->lol, &WITH->upl)!=2);
      if (err) {
	*stat = l;
	goto _L99;
      }
      i++;
      SkipLn(&f, 1, "#");
      if (!P_eof(f) && i > m) {
	*stat = -2;
	goto _L99;
      }
    }
    *naco = i - n;
    break;

  case DISMAN:
  case HABAS:
    i = n;
    l = 0;
    SkipLn(&f, 1, "#");
    while (!P_eof(f)) {
      WITH = &constr[i - n];
      l++;
      err=(fscanf(f, "%ld%ld%f%f", &WITH->resnum, &angnum, &WITH->lol,
	     &WITH->upl)!=4);
      *WITH->resnam = '\0';
      if (err) {
	*stat = l;
	goto _L99;
      }
      switch (angnum) {

      case 1:
	strcpy(WITH->angnam, "PHI");
	break;

      case 2:
	strcpy(WITH->angnam, "PSI");
	break;

      case 3:
	strcpy(WITH->angnam, "OMEGA");
	break;

      default:
	sprintf(WITH->angnam, "CHI%ld", angnum - 3);
	break;
      }
      i++;
      SkipLn(&f, 1, "#");
      if (!P_eof(f) && i > m) {
	*stat = -2;
	goto _L99;
      }
    }
    *naco = i - n;
    break;
  }
_L99:
  if (f != NULL)
    fclose(f);
  f = NULL;
  if (*stat != 0)
    pg_error_handler(8L, "StructIO", *stat, erract, 0, "");
  if (f != NULL)
    fclose(f);
}


Static Void readcorcon(fl, corfile_, dl, defext_, format, title1, title2,
		       title3, n, m, atom, nat, nres, havecon, stat, erract)
long fl;
Char *corfile_;
long dl;
Char *defext_;
Formattype format;
Char *title1, *title2, *title3;
long n, m;
CORCONdata *atom;
long *nat, *nres;
boolean havecon;
long *stat, erract;
{
  Char corfile[201];
  Char defext[201];
  FILE *f;
  boolean err;
  long i, j, k, int_, l;
  float r;
  Char s[201], c;
  Char *TEMP;
  CORCONdata *WITH;
  Char STR1[201];
  Char STR2[201];
  int iret;

  strcpy(corfile, corfile_);
  strcpy(defext, defext_);
  f = NULL;
  *stat = 0;
  if ((havecon && ((1L << ((long)format)) &
		   ((1L << ((long)DG)) | (1L << ((long)DISMAN)))) == 0) ||
      ((1L << ((long)format)) &
       ((1L << ((long)DG)) | (1L << ((long)DISMAN)) | (1L << ((long)PDB)) |
	(1L << ((long)AMBER)) | (1L << ((long)DIAMOND)))) == 0) {
/* p2c: cofima.pas, line 340: Note:
 * Line breaker spent 1.0+0.20 seconds, 5000 tries on line 1067 [251] */
    *stat = -3;
    goto _L99;
  }
  Open_input_file(&f, fl, corfile, dl, defext, &err);
  if (err) {
    *stat = -1;
    goto _L99;
  }
  switch (format) {

  case DG:
  case DISMAN:
    TEMP = fgets(title1, 201, f);
    TEMP = strchr(title1, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    if (err) {
      *stat = 1;
      goto _L99;
    }
    TEMP = fgets(title2, 201, f);
    TEMP = strchr(title2, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    if (err) {
      *stat = 2;
      goto _L99;
    }
    TEMP = fgets(title3, 201, f);
    TEMP = strchr(title3, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    if (err) {
      *stat = 3;
      goto _L99;
    }
    i = n;
    *nat = 0;
    l = 3;
    SkipLn(&f, 1, "#");
    while (!P_eof(f)) {
      WITH = &atom[i - n];
      l++;
      err=(fscanf(f, "%ld", &WITH->atnum)!=1);
      if (err) {
	*stat = l;
	goto _L99;
      }
      (*nat)++;
/* p2c: cofima.pas, line 289:
 * Internal error in strmax_func: got a pointer instead of a string [171] */
      ReadStr(&f, 5L, WITH->atnam);
      err=(fscanf(f, "%ld", &WITH->resnum)!=1);
      if (err) {
	*stat = l;
	goto _L99;
      }
      if (i == n)
	*nres = 1;
      else if (WITH->resnum != atom[i - n - 1].resnum)
	(*nres)++;
/* p2c: cofima.pas, line 291:
 * Internal error in strmax_func: got a pointer instead of a string [171] */
      ReadStr(&f, 5L, WITH->resnam);
      if (havecon) {
	err=(fscanf(f, "%f%f%f%ld%ld%ld%ld%*[^\n]", WITH->x, &WITH->x[1],
	       &WITH->x[2], WITH->con, &WITH->con[1], &WITH->con[2],
	       &WITH->con[3])!=7);
	getc(f);
      } else {
	err=(fscanf(f, "%f%f%f%*[^\n]", WITH->x, &WITH->x[1], &WITH->x[2])
	     !=3);
	getc(f);
	WITH->con[0] = 0;
	WITH->con[1] = 0;
	WITH->con[2] = 0;
	WITH->con[3] = 0;
      }
      WITH->occupancy = 1.0; WITH->bfactor = 1.0;
      if (err) {
	*stat = l;
	goto _L99;
      }
      SkipLn(&f, 1, "#");
      i++;
      if (!P_eof(f) && i > m) {
	*stat = -2;
	goto _L99;
      }
    }
    break;

  case PDB:
  case AMBER:
    i = n;
    *nat = 0;
    l = 1;
    *title1 = '\0';
    *title2 = '\0';
    *title3 = '\0';
/* p2c: cofima.pas, line 299:
 * Internal error in strmax_func: got a pointer instead of a string [171] */
    ReadStr(&f, 200L, s);
    while (!P_eof(f) && strcmp(s, "ATOM")) {
      if (!strcmp(s, "HEADER")) {
	TEMP = fgets(title1, 201, f);
	TEMP = strchr(title1, '\n');
	if (TEMP != NULL)
	  *TEMP = 0;
/*	if (err) {
	  *stat = l;
	  goto _L99;
	}
	strcpy(title1, CopyStr(STR1, 200L, title1, 5L, 56L));
	strcpy(title1, CopyStr(STR1, 200L, s, 5L, 56L));
*/
	l++;
      } else if (!strcmp(s, "COMPND")) {
	TEMP = fgets(title2, 201, f);
	TEMP = strchr(title2, '\n');
	if (TEMP != NULL)
	  *TEMP = 0;
/*	if (err) {
	  *stat = l;
	  goto _L99;
	}
	strcpy(title2, CopyStr(STR1, 200L, title2, 5L, 56L));
	strcpy(title2, CopyStr(STR1, 200L, s, 5L, 56L));
*/
	l++;
      } else {
	iret=fscanf(f, "%*[^\n]");
	getc(f);
	if (err) {
	  *stat = l;
	  goto _L99;
	}
      }
      l++;
/* p2c: cofima.pas, line 310:
 * Internal error in strmax_func: got a pointer instead of a string [171] */
      ReadStr(&f, 200L, s);
    }
    SkipLn(&f, 1, "#");
    while (!P_eof(f)) if (!strcmp(s, "ATOM")) {
      WITH = &atom[i - n];
      err=(fscanf(f, "%ld", &WITH->atnum)!=1);
      if (err) {
	*stat = l;
	goto _L99;
      }
      (*nat)++;
/* p2c: cofima.pas, line 314:
 * Internal error in strmax_func: got a pointer instead of a string [171] */
      ReadStr(&f, 200L, s);
      if ((long)strlen(s) <= 4) {
	c = s[0];
	if (isdigit(c)) {
		for(j = 0; j < (long)strlen(s)-1; j++) s[j] = s[j+1];
		s[j] = c; } 
	strcpy(WITH->atnam, s);
/* p2c: cofima.pas, line 315:
 * Internal error in strmax_func: got a pointer instead of a string [171] */
	ReadStr(&f, 5L, WITH->resnam);
      } else {
	Header(WITH->atnam, 200L, s, 4L);
	Trailer(WITH->resnam, 200L, s, 5L);
      }
      k = fscanf(f, "%[^\n]", STR2);
/*      printf("(%s)\n",STR2); */
      k = sscanf(STR2, "%ld%f%f%f%[^\n]", &WITH->resnum, WITH->x, &WITH->x[1],
	         &WITH->x[2], STR1);
      if (k < 4) 
        k = sscanf(STR2, "%*s%ld%f%f%f%[^\n]", &WITH->resnum, WITH->x, &WITH->x[1],
	           &WITH->x[2], STR1);
      err=(k < 4);
      getc(f);
      if (err) {
	*stat = l;
	goto _L99;
      }
      WITH->occupancy = 1.0; WITH->bfactor = 1.0;
      if (k == 5) {
        if (sscanf(STR1, "%f%f", &WITH->occupancy, &WITH->bfactor) != 2) {
           WITH->occupancy = 1.0; WITH->bfactor = 1.0; }}
      WITH->con[0] = 0;
      WITH->con[1] = 0;
      WITH->con[2] = 0;
      WITH->con[3] = 0;
      if (i == n)
	*nres = 1;
      else if (WITH->resnum != atom[i - n - 1].resnum)
	(*nres)++;
      SkipLn(&f, 1, "#");
      l++;
/* p2c: cofima.pas, line 319:
 * Internal error in strmax_func: got a pointer instead of a string [171] */
      ReadStr(&f, 200L, s);
      i++;
      if (!P_eof(f) && i > m && !strcmp(s, "ATOM")) {
	*stat = -2;
	goto _L99;
      }
    } else { SkipLn(&f, 1, "#"); l++; ReadStr(&f, 200L, s); }
    break;

  case DIAMOND:
    err=(fscanf(f, "%f%f%f%f%f%f%*[^\n]", &r, &r, &r, &r, &r, &r)!=6);
    getc(f);
    if (err) {
      *stat = 1;
      goto _L99;
    }
    TEMP = fgets(title1, 201, f);
    TEMP = strchr(title1, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    if (err) {
      *stat = 2;
      goto _L99;
    }
    *title2 = '\0';
    TEMP = fgets(title3, 201, f);
    TEMP = strchr(title3, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    if (err) {
      *stat = 3;
      goto _L99;
    }
    i = n;
    *nat = 0;
    l = 3;
    SkipLn(&f, 1, "#");
    while (!P_eof(f)) {
      WITH = &atom[i - n];
      l++;
      err=(fscanf(f, "%f%f%f%f%ld%ld%ld%f", WITH->x, &WITH->x[1], &WITH->x[2],
	     &r, &WITH->resnum, &WITH->resnum, &WITH->atnum, &r)!=8);
      if (err) {
	*stat = l;
	goto _L99;
      }
      (*nat)++;
      if (i == n)
	*nres = 1;
      else if (WITH->resnum != atom[i - n - 1].resnum)
	(*nres)++;
/* p2c: cofima.pas, line 331:
 * Internal error in strmax_func: got a pointer instead of a string [171] */
      ReadStr(&f, 5L, WITH->resnam);
      /*PGint_ = atol(WITH->resnam);*/
      err=(sscanf(WITH->resnam,"%ld",&int_)!=1);
      if (err) {
	if (i > n)
	  strcpy(WITH->resnam, atom[i - n - 1].resnam);
	else if (err) {
	  *stat = l;
	  goto _L99;
	}
      } else {
	err=(fscanf(f, "%ld", &int_)!=1);
	if (err) {
	  *stat = l;
	  goto _L99;
	}
      }
/* p2c: cofima.pas, line 335:
 * Internal error in strmax_func: got a pointer instead of a string [171] */
      ReadStr(&f, 5L, WITH->atnam);
      iret=fscanf(f, "%*[^\n]");
      getc(f);
      if (err) {
	*stat = l;
	goto _L99;
      }
      WITH->con[0] = 0;
      WITH->con[1] = 0;
      WITH->con[2] = 0;
      WITH->con[3] = 0;
      WITH->occupancy = 1.0; WITH->bfactor = 1.0;
      SkipLn(&f, 1, "#");
      i++;
      if (!P_eof(f) && i > m) {
	*stat = -2;
	goto _L99;
      }
    }
    break;
  }
_L99:
  if (f != NULL)
    fclose(f);
  f = NULL;
  if (*stat != 0)
    pg_error_handler(8L, "StructIO", *stat, erract, 0, "");
  if (f != NULL)
    fclose(f);
}


Static Void readdco(fl, dcofile_, dl, defext_, format, n, m, constr, ndco,
		    stat, erract)
long fl;
Char *dcofile_;
long dl;
Char *defext_;
Formattype format;
long n, m;
DCOdata *constr;
long *ndco, *stat, erract;
{
  Char dcofile[201];
  Char defext[201];
  FILE *f;
  boolean err;
  long i, k, l;
  DCOdata *WITH;
  Char *TEMP;

  strcpy(dcofile, dcofile_);
  strcpy(defext, defext_);
  f = NULL;
  *stat = 0;
  if (((1L << ((long)format)) & ((1L << ((long)CAST)) | (1L << ((long)DISMAN)) |
	 (1L << ((long)HABAS)) | (1L << ((long)DISGEO)))) == 0) {
    *stat = -3;
    goto _L99;
  }
  Open_input_file(&f, fl, dcofile, dl, defext, &err);
  if (err) {
    *stat = -1;
    goto _L99;
  }
  switch (format) {

  case CAST:
  case DISMAN:
  case HABAS:
  case DISGEO:
    i = n;
    *ndco = 0;
    l = 0;
    SkipLn(&f, 1, "#");
    while (!P_eof(f)) {
      l++;
      err=(fscanf(f, "%ld", &constr[i - n].resnum1)!=1);
      if (err) {
	*stat = l;
	goto _L99;
      }
/* p2c: cofima.pas, line 352:
 * Internal error in strmax_func: got a pointer instead of a string [171] */
      ReadStr(&f, 5L, constr[i - n].resnam1);
      SkipLn(&f, 1, "#");
      k = i;
      while (!P_eof(f) && !isdigit(P_peek(f))) {
	WITH = &constr[i - n];
	l++;
	if (i > k) {
	  WITH->resnum1 = constr[k - n].resnum1;
	  strcpy(WITH->resnam1, constr[k - n].resnam1);
	}
/* p2c: cofima.pas, line 356:
 * Internal error in strmax_func: got a pointer instead of a string [171] */
	ReadStr(&f, 5L, WITH->atnam1);
	err=(fscanf(f, "%ld", &WITH->resnum2)!=1);
	if (err) {
	  *stat = l;
	  goto _L99;
	}
/* p2c: cofima.pas, line 357:
 * Internal error in strmax_func: got a pointer instead of a string [171] */
	ReadStr(&f, 5L, WITH->resnam2);
/* p2c: cofima.pas, line 357:
 * Internal error in strmax_func: got a pointer instead of a string [171] */
	ReadStr(&f, 5L, WITH->atnam2);
	err=(fscanf(f, "%f", &WITH->lim)!=1);
	TEMP = fgets(WITH->comment, 81, f);
	TEMP = strchr(WITH->comment, '\n');
	if (TEMP != NULL)
	  *TEMP = 0;
	if (err) {
	  *stat = l;
	  goto _L99;
	}
	i++;
	SkipLn(&f, 1, "#");
	if (!feof(f) && i > m) {
	  *stat = -2;
	  goto _L99;
	}
      }
    }
    *ndco = i - n;
    break;
  }
_L99:
  if (f != NULL)
    fclose(f);
  f = NULL;
  if (*stat != 0)
    pg_error_handler(8L, "StructIO", *stat, erract, 0, "");
  if (f != NULL)
    fclose(f);
}


Static Void writeaco(fl, acofile_, dl, defext_, format, n, m, constr, naco,
		     stat, erract)
long fl;
Char *acofile_;
long dl;
Char *defext_;
Formattype format;
long n, m;
ACOdata *constr;
long naco, *stat, erract;
{
  Char acofile[201];
  Char defext[201];
  FILE *f;
  boolean err;
  long i, angnum, FORLIM;
  ACOdata *WITH;
  Char STR2[201], STR3[201];

  strcpy(acofile, acofile_);
  strcpy(defext, defext_);
  f = NULL;
  *stat = 0;
  if (((1L << ((long)format)) & ((1L << ((long)DISMAN)) |
	 (1L << ((long)HABAS)) | (1L << ((long)ELLIPS)))) == 0) {
    *stat = -3;
    goto _L99;
  }
  Open_output_file(&f, fl, acofile, dl, defext, &err);
  if (err) {
    *stat = -1;
    goto _L99;
  }
  switch (format) {

  case ELLIPS:
    FORLIM = naco - n + 1;
    for (i = n; i <= FORLIM; i++) {
      WITH = &constr[i - n];
      fprintf(f, "%4ld%6s%6s%8.1f%8.1f\n",
	      WITH->resnum, Adjust(STR2, 5L, WITH->resnam, 5L),
	      Adjust(STR3, 5L, WITH->angnam, 5L), WITH->lol, WITH->upl);
    }
    break;

  case DISMAN:
    FORLIM = naco - n + 1;
    for (i = n; i <= FORLIM; i++) {
      WITH = &constr[i - n];
      fprintf(f, "# %s %ld %s\n", WITH->resnam, WITH->resnum, WITH->angnam);
      if (!strcmp(WITH->angnam, "PHI"))
	angnum = 1;
      else if (!strcmp(WITH->angnam, "PSI"))
	angnum = 2;
      else if (!strcmp(WITH->angnam, "OMEGA"))
	angnum = 3;
      else if (!strcmp(Header(STR2, 5L, WITH->angnam, 3L), "CHI")) {
	angnum = atol(Trailer(STR3, 5L, WITH->angnam, 4L));
	angnum += 3;
      } else {
	*stat = i - n + 1;
	goto _L99;
      }
      fprintf(f, "%5ld%5ld%8.1f%8.1f\n",
	      WITH->resnum, angnum, WITH->lol, WITH->upl);
    }
    break;
  }
_L99:
  if (f != NULL)
    fclose(f);
  f = NULL;
  if (*stat != 0)
    pg_error_handler(8L, "StructIO", *stat, erract, 0, "");
  if (f != NULL)
    fclose(f);
}


Static Void writecorcon(fl, corfile_, dl, defext_, format, title1_, title2_,
			title3_, n, m, atom, nat, nres, havecon, stat, erract)
long fl;
Char *corfile_;
long dl;
Char *defext_;
Formattype format;
Char *title1_, *title2_, *title3_;
long n, m;
CORCONdata *atom;
long nat, nres;
boolean havecon;
long *stat, erract;
{
  Char corfile[201];
  Char defext[201];
  Char title1[201], title2[201], title3[201];
  FILE *f;
  boolean err;
  long i;
  Char sn[201];
  long FORLIM;
  Char STR1[201], STR2[201], STR3[201], STR5[201];
  CORCONdata *WITH;

  strcpy(corfile, corfile_);
  strcpy(defext, defext_);
  strcpy(title1, title1_);
  strcpy(title2, title2_);
  strcpy(title3, title3_);
  f = NULL;
  *stat = 0;
  if ((havecon && ((1L << ((long)format)) &
		   ((1L << ((long)DG)) | (1L << ((long)DISMAN)))) == 0) ||
      ((1L << ((long)format)) &
       ((1L << ((long)DG)) | (1L << ((long)DISMAN)) | (1L << ((long)PDB)) |
	(1L << ((long)AMBER)) | (1L << ((long)DIAMOND)))) == 0) {
/* p2c: cofima.pas, line 452: Note:
 * Line breaker spent 1.1+0.18 seconds, 5000 tries on line 1567 [251] */
    *stat = -3;
    goto _L99;
  }
  Open_output_file(&f, fl, corfile, dl, defext, &err);
  if (err) {
    *stat = -1;
    goto _L99;
  }
  switch (format) {

  case DG:
  case DISMAN:
    if (nres == 0) {
      nres = 1;
      FORLIM = nat - n + 1;
      for (i = n + 1; i <= FORLIM; i++) {
	if (atom[i - n].resnum != atom[i - n - 1].resnum)
	  nres++;
      }
    }
    if (*title1 == '\0')
      fprintf(f, "%s\n",
	      Extract_filename(STR2, 200L,
		      Append_defext(STR3, fl, corfile, dl, defext)));
    else
      fprintf(f, "%s\n", title1);
    if (*title2 == '\0')
      fprintf(f, "from cofima\n");
    else
      fprintf(f, "%s\n", title2);
    if (*title3 == '\0')
      fprintf(f,
	"NUMBER OF RESIDUES:%6ld NUMBER OF ATOMS:%8ld NUMBER OF SUBUNITS:%5d\n",
	nres, nat, 1);
    else
      fprintf(f, "%s\n", title3);
    FORLIM = nat - n + 1;
    for (i = n; i <= FORLIM; i++) {
      WITH = &atom[i - n];
      if (havecon)
	fprintf(f, "%5ld %s%6ld %s%11.4f%11.4f%11.4f%6ld%6ld%6ld%6ld\n",
		WITH->atnum, Adjust(STR1, 5L, WITH->atnam, 5L), WITH->resnum,
		Adjust(STR2, 5L, WITH->resnam, 5L), WITH->x[0], WITH->x[1],
		WITH->x[2], WITH->con[0], WITH->con[1], WITH->con[2],
		WITH->con[3]);
      else
	fprintf(f, "%5ld %s%6ld %s%11.4f%11.4f%11.4f\n",
		WITH->atnum, Adjust(STR1, 5L, WITH->atnam, 5L), WITH->resnum,
		Adjust(STR2, 5L, WITH->resnam, 5L), WITH->x[0], WITH->x[1],
		WITH->x[2]);
    }
    break;

  case PDB:
    Adjust(sn, 200L, UpStr(STR2, 200L, Extract_filename(STR3, fl, corfile)),
	   4L);
    if (*title1 == '\0')
      fprintf(f, "HEADER    %s            %s\n",
	      Adjust(STR2, 200L,
		     Extract_filename(STR1, 200L,
			     Append_defext(STR5, fl, corfile, dl, defext)),
		     40L), sn);
    else if (strcmp(Header(STR2, 200L, title1, 10L), "HEADER    "))
      fprintf(f, "HEADER    %s\n",
	      Adjust(STR3, 200L, NoHeader(STR1, 200L, title1), 62L));
    else
      fprintf(f, "%s\n", Adjust(STR3, 200L, title1, 76L));
    if (*title2 != '\0') {
      if (strcmp(Header(STR2, 200L, title2, 10L), "COMPND    "))
	fprintf(f, "COMPND    %s\n",
		Adjust(STR3, 200L, NoHeader(STR1, 200L, title2), 62L));
      else
	fprintf(f, "%s\n", Adjust(STR3, 200L, title2, 76L));
    }
    FORLIM = nat - n + 1;
    for (i = n; i <= FORLIM; i++) {
      WITH = &atom[i - n];
      fprintf(f,
	      "ATOM%7ld  %s%s%4ld%12.3f%8.3f%8.3f%6.2f%6.2f\n",
	      WITH->atnum, Adjust(STR2, 5L, WITH->atnam, 4L),
	      Adjust(STR3, 5L, WITH->resnam, 5L), WITH->resnum, WITH->x[0],
	      WITH->x[1], WITH->x[2], WITH->occupancy, WITH->bfactor);
    }
    fprintf(f, "END\n");
    break;

  case AMBER:
    FORLIM = nat - n + 1;
    for (i = n; i <= FORLIM; i++) {
      WITH = &atom[i - n];
      fprintf(f, "ATOM%7ld %s%s%4ld%12.3f%8.3f%8.3f\n",
	      WITH->atnum, Adjust(STR2, 5L, WITH->atnam, 5L),
	      Adjust(STR3, 5L, WITH->resnam, 5L), WITH->resnum, WITH->x[0],
	      WITH->x[1], WITH->x[2]);
    }
    fprintf(f, "END\n");
    break;

  case DIAMOND:
    fprintf(f, "%10.2f%10.2f%10.2f%10.2f%10.2f%10.2f\n",
	    1.0, 1.0, 1.0, 90.0, 90.0, 90.0);
    if (*title1 == '\0')
      fprintf(f, "%s\n",
	      Extract_filename(STR3, 200L,
		      Append_defext(STR1, fl, corfile, dl, defext)));
    else
      fprintf(f, "%s\n", title1);
    if (*title2 == '\0')
      fprintf(f, "%10c%10c%10c%10c%5s%5s%5s%9s RESIDUE   ATOM\n",
	      'X', 'Y', 'Z', 'B', "TYPE", "IRES", "IAT", "WEIGHT");
    else
      fprintf(f, "%s\n", title2);
    FORLIM = nat - n + 1;
    for (i = n; i <= FORLIM; i++) {
      WITH = &atom[i - n];
      fprintf(f, "%10.5f%10.5f%10.5f%10.5f",
	      WITH->x[0], WITH->x[1], WITH->x[2], 25.0);
      switch (WITH->atnam[0]) {

      case 'C':
	fprintf(f, "%5d", 1);
	break;

      case 'O':
	fprintf(f, "%5d", 3);
	break;

      case 'H':
	fprintf(f, "%5d", 5);
	break;

      case 'N':
	fprintf(f, "%5d", 2);
	break;

      case 'S':
	fprintf(f, "%5d", 4);
	break;

      default:
	fprintf(f, "%5d", 0);
	break;
      }
      fprintf(f, "%5ld%5ld%9.4f %s%4ld   %s\n",
	      WITH->resnum, WITH->atnum, 1.0,
	      Adjust(STR2, 5L, WITH->resnam, 3L), WITH->resnum, WITH->atnam);
    }
    break;
  }
_L99:
  if (f != NULL)
    fclose(f);
  f = NULL;
  if (*stat != 0)
    pg_error_handler(8L, "StructIO", *stat, erract, 0, "");
  if (f != NULL)
    fclose(f);
}


Static Void writedco(fl, dcofile_, dl, defext_, format, n, m, constr, ndco,
		     stat, erract)
long fl;
Char *dcofile_;
long dl;
Char *defext_;
Formattype format;
long n, m;
DCOdata *constr;
long ndco, *stat, erract;
{
  Char dcofile[201];
  Char defext[201];
  FILE *f;
  boolean err;
  long i, FORLIM;
  DCOdata *WITH;
  Char STR1[201], STR2[201], STR3[201], STR5[201];

  strcpy(dcofile, dcofile_);
  strcpy(defext, defext_);
  f = NULL;
  *stat = 0;
  if (((1L << ((long)format)) & ((1L << ((long)CAST)) | (1L << ((long)DISMAN)) |
	 (1L << ((long)HABAS)) | (1L << ((long)DISGEO)))) == 0) {
    *stat = -3;
    goto _L99;
  }
  Open_output_file(&f, fl, dcofile, dl, defext, &err);
  if (err) {
    *stat = -1;
    goto _L99;
  }
  switch (format) {

  case CAST:
    FORLIM = ndco - n + 1;
    for (i = n; i <= FORLIM; i++) {
      WITH = &constr[i - n];
      if (i == n)
	fprintf(f, "%3ld %s\n", WITH->resnum1, WITH->resnam1);
      if (i > n) {
	if (WITH->resnum1 != constr[i - n - 1].resnum1)
	  fprintf(f, "%3ld %s\n", WITH->resnum1, WITH->resnam1);
      }
      fprintf(f, "%14s%4ld%6s%s%7.2f%s\n",
	      Adjust(STR1, 5L, WITH->atnam1, 5L), WITH->resnum2,
	      Adjust(STR3, 5L, WITH->resnam2, 5L),
	      Adjust(STR2, 5L, WITH->atnam2, 5L), WITH->lim, WITH->comment);
    }
    break;

  case DISMAN:
  case HABAS:
    FORLIM = ndco - n + 1;
    for (i = n; i <= FORLIM; i++) {
      WITH = &constr[i - n];
      if (i == n)
	fprintf(f, "%2ld %s\n", WITH->resnum1, WITH->resnam1);
      if (i > n) {
	if (WITH->resnum1 != constr[i - n - 1].resnum1)
	  fprintf(f, "%2ld %s\n", WITH->resnum1, WITH->resnam1);
      }
      fprintf(f, "%13s%5ld%6s%s%7.2f%s\n",
	      Adjust(STR1, 5L, WITH->atnam1, 5L), WITH->resnum2,
	      Adjust(STR3, 5L, WITH->resnam2, 5L),
	      Adjust(STR2, 5L, WITH->atnam2, 5L), WITH->lim, WITH->comment);
    }
    break;

  case DISGEO:
    FORLIM = ndco - n + 1;
    for (i = n; i <= FORLIM; i++) {
      WITH = &constr[i - n];
      fprintf(f, "%3ld%6s%s%4ld%6s%s%7.2f%s\n",
	      WITH->resnum1, Adjust(STR1, 5L, WITH->resnam1, 5L),
	      Adjust(STR3, 5L, WITH->atnam1, 5L), WITH->resnum2,
	      Adjust(STR2, 5L, WITH->resnam2, 5L),
	      Adjust(STR5, 5L, WITH->atnam2, 5L), WITH->lim, WITH->comment);
    }
    break;
  }
_L99:
  if (f != NULL)
    fclose(f);
  f = NULL;
  if (*stat != 0)
    pg_error_handler(8L, "StructIO", *stat, erract, 0, "");
  if (f != NULL)
    fclose(f);
}


/* ====================== Generate covalent connectivities ================= */

Static Void connect(n, m, atom, nat, bl, bondrad_, stat, erract)
long n, m;
CORCONdata *atom;
long nat, bl;
Char *bondrad_;
long *stat, erract;
{
  Char bondrad[201];
  long i, imax, j, k, l, nb, ib, nc;
  float br1, br2;
  Char el[201], errmsg[201];
  Char bat[30][6];
  float brad[30];
  boolean err;
  Char STR1[201];
  CORCONdata *WITH, *WITH1;

  strcpy(bondrad, bondrad_);
  *stat = 0;
  imax = n + nat - 1;
  nb = 0;
  do {
    nb++;
    Element(el, bl, bondrad, nb, 1, " ", false);
    if (*el == '\0')
      nb--;
    else {
      i = strpos3("=", el, 1);
      if ((unsigned long)i >= 32 || ((1L << i) & 0x7c) == 0) {
	*stat = -1;
	strcpy(errmsg, "error in bond radii list");
	goto _L99;
      }
      strcpy(bat[nb - 1], Header(STR1, 200L, el, i - 1));
      /*PGbrad[nb - 1] = atof(Trailer(STR1, 200L, el, i + 1));*/
      err=(sscanf(Trailer(STR1, 200L, el, i + 1),"%f",&brad[nb-1])!=1);
      if (err) {
	*stat = -1;
	strcpy(errmsg, "error in bond radii list");
	goto _L99;
      }
    }
  } while (*el != '\0');
  if (nb == 0) {
    *stat = -1;
    strcpy(errmsg, "error in bond radii list");
    goto _L99;
  }
  for (i = n; i <= imax; i++) {
    WITH = &atom[i - n];
    for (j = 0; j <= 3; j++)
      WITH->con[j] = 0;
  }
  for (i = n; i <= imax; i++) {
    WITH = &atom[i - n];
    ib = 1;
    while (ib <= nb && !Match(5L, bat[ib - 1], 5L, WITH->atnam))
      ib++;
    if (ib > nb) {
      *stat = -2;
      strcpy(errmsg, "incomplete bond radii list");
      goto _L99;
    }
    br1 = brad[ib - 1];
    if (WITH->con[0] == 0)
      nc = 0;
    else if (WITH->con[1] == 0)
      nc = 1;
    else if (WITH->con[2] == 0)
      nc = 2;
    else if (WITH->con[3] == 0)
      nc = 3;
    else
      nc = 4;
    if (i == n) {
      j = i;
      while (j < imax && atom[j - n].resnum == WITH->resnum)
	j++;
      k = j;
      while (k < imax && atom[k - n].resnum == atom[j - n].resnum)
	k++;
    } else if (i == j) {
      j = k;
      while (k < imax && atom[k - n].resnum == atom[j - n].resnum)
	k++;
    }
    for (l = i + 1; l <= k; l++) {
      ib = 1;
      while (ib <= nb && !Match(5L, bat[ib - 1], 5L, atom[l - n].atnam))
	ib++;
      if (ib > nb) {
	*stat = -2;
	strcpy(errmsg, "incomplete bond radii list");
	goto _L99;
      }
      br2 = brad[ib - 1];
      if (dist(WITH->x, atom[l - n].x) <= br1 + br2) {
	nc++;
	if (nc > 4) {
	  *stat = i;
	  strcpy(errmsg, "atoms with more than 4 connectivities");
	  goto _L99;
	}
	WITH->con[nc - 1] = atom[l - n].atnum;
	WITH1 = &atom[l - n];
	if (WITH1->con[0] == 0)
	  WITH1->con[0] = atom[i - n].atnum;
	else if (WITH1->con[1] == 0)
	  WITH1->con[1] = atom[i - n].atnum;
	else if (WITH1->con[2] == 0)
	  WITH1->con[2] = atom[i - n].atnum;
	else if (WITH1->con[3] == 0)
	  WITH1->con[3] = atom[i - n].atnum;
	else {
	  *stat = l;
	  strcpy(errmsg, "atoms with more than 4 connectivities");
	  goto _L99;
	}
      }
    }
  }
_L99:
  if (*stat != 0)
    pg_error_handler(7L, "Connect", *stat, erract, 200L, errmsg);
}


/* ======================= End of general routines ======================== */

/* Global declarations for COFIMA */

#define maxnat      200000   /* max. number of atoms in a structure   */
#define maxel           50   /* max. number of command line elements  */

char libdir[200];

#define macro_directory  "cofima"
    /* directory for general macros          */
Char macro_list[201];
/* list with names of all macro files in */
/* macro_directory and in the default    */
/* directory                             */
#define cofima_help_file  "help/cofima/cofima.hlp"
#define difima_help_file  "help/cofima/difima.hlp"
#define ancoma_help_file  "help/cofima/ancoma.hlp"


/* names of the help files               */


/* elements of the command line          */
typedef Char Elementlist[maxel][81];
/* list of command line elements         */

typedef struct stack {
  Char sl[201];
  long *down;
} stack;

/* stack used to expand macros           */
typedef enum {
  cfm, dfm, acm
} Modetype;   /* cfm: manipulate coordinate files      */
/* dfm: manipulate dist. constr. files   */
/* acm: manipulate angle constr. files   */
typedef enum {
  first_only, second_only, both
} Pseudomode;

/* modes to change distance constraints  */
/* from real to pseudo atoms             */


Static CORCONdata atom[maxnat];
/* list for all atoms                    */
Static DCOdata constr[maxnat];
/* list for all distance constraints     */
Static ACOdata aconstr[maxnat];
/* list for all angle constraints        */
Static boolean flag[maxnat];
/* flag[i]=true <==> atom[i] is in the   */
/*                   residue range       */
Static long inv[maxel / 32 + 2];   /* i IN inv <==> i-th command parameter  */
/*               preceded by "!" (NOT-   */
/*               operator)               */
Static FILE *f;   /* text file, used in several occasions  */
Static FILE *out;   /* output file for output redirection    */
Static long nel;   /* number of command parameters          */
Static long nst;   /* number of structures read (= 0, 1)    */
Static long nat;   /* number of atoms                       */
Static long nst_cfm, nst_dfm;   /* the same numbers specific for cofima, */
Static long nst_acm, nat_cfm;   /* difima and ancoma mode                */
Static long nat_dfm, nat_acm, natin_cfm;
    /* number of atoms read                  */
Static long natin_dfm;   /* number of distance constraints read   */
Static long natin_acm;   /* number of angle constraints read      */
Static long nres;   /* number of residues                    */
Static long stat;   /* termination status of some library    */
/* routines; stat=0 <==> no error occured*/
Static Char cmd[81];   /* command (first element of the command */
/* line)                                 */
Static Char qual[81];   /* command qualifier                     */
Static Char item[81];   /* item='angle' in ancoma, ='atom' else  */
Static Char inpfile[81];   /* name of the coordinate file read      */
Static Char inpfile_cfm[81];   /* the same names specific for cofima,   */
Static Char inpfile_dfm[81];   /* difima and ancoma mode                */
Static Char inpfile_acm[81], outfile[81];
    /* name of the output file for output    */
/* redirection                           */
Static Elementlist el;   /* list of command parameters            */
Static Char t1[201], t2[201], t3[201];
    /* title lines of coordinate file        */
Static boolean err;   /* err=true <==> error opening a file    */
Static boolean error;   /* error=true <==> error in "setflag"    */
Static boolean connected;   /* connected=true <==> connectivities    */
/*                     present           */
Static boolean rd;   /* rd=true <==> output redirection on    */
Static boolean skipcmd;   /* skipcmd=true <==> skip command        */
Static stack *sp;   /* stack pointer for command stack       */
Static stack *hi;   /* stack pointer for history stack       */
Static Formattype format;   /* file format (=DG, PDB, AMBER,...)     */
Static Formattype format_cfm;   /* format specific for cofima            */
Static Formattype format_dfm;   /* format specific for difima            */
Static Formattype format_acm;   /* format specific for ancoma            */
Static Modetype mode;   /* cofima, difima or ancoma mode         */
Static boolean first;   /* first=true <==> treat first atom of a */


/*                 distance constraint   */

/* errmsg       display error message, clear command stack
   setflag      set flag array, i.e. determine current residue range
   adjust_atnum adjust atom numbers and connectivities in coordinate files */


Static Void errmsg(msg)
Char *msg;
{
  /* show error message, clear command     */
  /* stack                                 */
  stack *p;

  if (mode == cfm)
    printf("cofima");
  else if (mode == dfm)
    printf("difima");
  else
    printf("ancoma");
  if (sp == NULL) {
    printf("-error: %s\n", msg);
    return;
  }
  printf("-error: %s, rest of macro skipped\n", msg);
  while (sp != NULL) {
    p = sp;
    sp = (stack *)sp->down;
    Free(p);
  }
}


Static Void setflag()
{
  /* set flag array, i.e. treat residue    */
  /* ranges                                */
  long i, j, k, r1, r2, n1;
  long rn[maxel / 32 + 2];
  boolean b;
  boolean flag1[maxnat], invflag[maxnat], invflag1[maxnat];
  long SET[3];
  long FORLIM;
  Char STR1[201];
  Char STR2[110];
  long SET1[maxel / 32 + 2];
  long FORLIM1;
  Char STR3[256];
  CORCONdata *WITH;
  ACOdata *WITH1;
  DCOdata *WITH2;

  P_expset(rn, 0L);
  n1 = 0;
  error = false;
  do {
    n1++;
    if (n1 > nel) {
      FORLIM = nat;
      for (j = 0; j < FORLIM; j++)
	flag[j] = true;
      goto _L9;
    }
    if (!(el[n1 - 1][0] == '+' || el[n1 - 1][0] == '-' ||
	  el[n1 - 1][0] == '.' || el[n1 - 1][0] == '@' ||
	  el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	  isalpha(el[n1 - 1][0]) || isdigit(el[n1 - 1][0]))) {
      sprintf(STR2, "illegal range definition \\%s\\", el[n1 - 1]);
      errmsg(STR2);
      error = true;
      goto _L9;
    }
  } while (!(el[n1 - 1][0] == '+' || el[n1 - 1][0] == '-' ||
	     el[n1 - 1][0] == '.' ||
	     el[n1 - 1][0] == '@' || isdigit(el[n1 - 1][0])));
  FORLIM = nel;
  for (i = n1; i <= FORLIM; i++) {
    if (el[i - 1][0] == '@')
      P_addset(rn, (int)i);
  }
  b = (*P_setdiff(SET1, rn, inv) == 0L);
  FORLIM = nat;
  for (j = 0; j < FORLIM; j++) {
    flag1[j] = b;
    invflag1[j] = false;
  }
  b = P_subset(P_addsetr(P_expset(SET, 0L), (int)n1, (int)nel),
	       P_setunion(SET1, rn, inv));
  FORLIM = nat;
  for (j = 0; j < FORLIM; j++)
    flag[j] = b;
  memcpy(invflag, invflag1, (long)maxnat);
  FORLIM = nel;
  for (i = n1 - 1; i < FORLIM; i++) {
    if (P_inset((int)(i + 1), rn)) {
      if (mode == cfm) {
	if (P_inset((int)(i + 1), inv)) {
	  FORLIM1 = nat;
	  for (j = 0; j < FORLIM1; j++)
	    invflag1[j] = (invflag1[j] ||
			   Match(200L, Trailer(STR1, 80L, el[i], 2L), 5L,
				 atom[j].resnam));
	} else {
	  FORLIM1 = nat;
	  for (j = 0; j < FORLIM1; j++)
	    flag1[j] = (flag1[j] || Match(200L, Trailer(STR1, 80L, el[i], 2L),
					  5L, atom[j].resnam));
	}
      } else if (mode == acm) {
	if (P_inset((int)(i + 1), inv)) {
	  FORLIM1 = nat;
	  for (j = 0; j < FORLIM1; j++)
	    invflag1[j] = (invflag1[j] ||
			   Match(200L, Trailer(STR1, 80L, el[i], 2L), 5L,
				 aconstr[j].resnam));
	} else {
	  FORLIM1 = nat;
	  for (j = 0; j < FORLIM1; j++)
	    flag1[j] = (flag1[j] || Match(200L, Trailer(STR1, 80L, el[i], 2L),
					  5L, aconstr[j].resnam));
	}
      } else if (first) {
	if (P_inset((int)(i + 1), inv)) {
	  FORLIM1 = nat;
	  for (j = 0; j < FORLIM1; j++)
	    invflag1[j] = (invflag1[j] ||
			   Match(200L, Trailer(STR1, 80L, el[i], 2L), 5L,
				 constr[j].resnam1));
	} else {
	  FORLIM1 = nat;
	  for (j = 0; j < FORLIM1; j++)
	    flag1[j] = (flag1[j] || Match(200L, Trailer(STR1, 80L, el[i], 2L),
					  5L, constr[j].resnam1));
	}
      } else {
	if (P_inset((int)(i + 1), inv)) {
	  FORLIM1 = nat;
	  for (j = 0; j < FORLIM1; j++)
	    invflag1[j] = (invflag1[j] ||
			   Match(200L, Trailer(STR1, 80L, el[i], 2L), 5L,
				 constr[j].resnam2));
	} else {
	  FORLIM1 = nat;
	  for (j = 0; j < FORLIM1; j++)
	    flag1[j] = (flag1[j] || Match(200L, Trailer(STR1, 80L, el[i], 2L),
					  5L, constr[j].resnam2));
	}
      }
    }
  }
  FORLIM = nel;
  for (i = n1 - 1; i < FORLIM; i++) {
    if (!P_inset((int)(i + 1), rn)) {
      if (!(el[i][0] == '+' || el[i][0] == '-' || el[i][0] == '.' ||
	    isdigit(el[i][0]))) {
	sprintf(STR2, "illegal range definition \\%s\\", el[i]);
	errmsg(STR2);
	error = true;
	goto _L9;
      }
      k = strpos3("..", el[i], 1);
      if (k == 1) {
	sprintf(STR3, "%s%s", IntStr(STR1, -LONG_MAX, 0L), el[i]);
	strcpy(el[i], STR3);
      }
      if (k == strlen(el[i]) - 1 && k > 0) {
	sprintf(STR3, "%s%s", el[i], IntStr(STR1, LONG_MAX, 0L));
	strcpy(el[i], STR3);
      }
      if (k == 0) {
	/*PGr1 = atol(el[i]);*/
	err=(sscanf(el[i],"%ld",&r1)!=1);
	if (err) {
	  sprintf(STR2, "illegal range definition \\%s\\", el[i]);
	  errmsg(STR2);
	  error = true;
	  goto _L9;
	}
	r2 = r1;
      } else {
	k = strpos3("..", el[i], 1);
	/*PGr1 = atol(Header(STR1, 80L, el[i], k - 1));*/
	err=(sscanf(Header(STR1, 80L, el[i], k - 1),"%ld",&r1)!=1);
	if (err) {
	  sprintf(STR2, "illegal range definition \\%s\\", el[i]);
	  errmsg(STR2);
	  error = true;
	  goto _L9;
	}
	/*PGr2 = atol(Trailer(STR1, 80L, el[i], k + 2));*/
	err=(sscanf(Trailer(STR1, 80L, el[i], k + 2),"%ld",&r2)!=1);
	if (err) {
	  sprintf(STR2, "illegal range definition \\%s\\", el[i]);
	  errmsg(STR2);
	  error = true;
	  goto _L9;
	}
      }
      if (mode == cfm) {
	FORLIM1 = nat;
	for (j = 0; j < FORLIM1; j++) {
	  WITH = &atom[j];
	  if (P_inset((int)(i + 1), inv))
	    invflag[j] = (invflag[j] ||
			  WITH->resnum >= r1 && WITH->resnum <= r2);
	  else
	    flag[j] = (flag[j] || WITH->resnum >= r1 && WITH->resnum <= r2);
	}
      } else if (mode == acm) {
	FORLIM1 = nat;
	for (j = 0; j < FORLIM1; j++) {
	  WITH1 = &aconstr[j];
	  if (P_inset((int)(i + 1), inv))
	    invflag[j] = (invflag[j] ||
			  WITH1->resnum >= r1 && WITH1->resnum <= r2);
	  else
	    flag[j] = (flag[j] || WITH1->resnum >= r1 && WITH1->resnum <= r2);
	}
      } else if (first) {
	FORLIM1 = nat;
	for (j = 0; j < FORLIM1; j++) {
	  WITH2 = &constr[j];
	  if (P_inset((int)(i + 1), inv))
	    invflag[j] = (invflag[j] ||
			  WITH2->resnum1 >= r1 && WITH2->resnum1 <= r2);
	  else
	    flag[j] = (flag[j] ||
		       WITH2->resnum1 >= r1 && WITH2->resnum1 <= r2);
	}
      } else {
	FORLIM1 = nat;
	for (j = 0; j < FORLIM1; j++) {
	  WITH2 = &constr[j];
	  if (P_inset((int)(i + 1), inv))
	    invflag[j] = (invflag[j] ||
			  WITH2->resnum2 >= r1 && WITH2->resnum2 <= r2);
	  else
	    flag[j] = (flag[j] ||
		       WITH2->resnum2 >= r1 && WITH2->resnum2 <= r2);
	}
      }
    }
  }
  FORLIM = nat;
  for (j = 0; j < FORLIM; j++)
    flag[j] = (flag[j] && !invflag[j] && flag1[j] && !invflag1[j]);
_L9: ;
}


Static Void adjust_atnum()
{
  /* adjust atom numbers and, if present,  */
  /* connectivities such that atom numbers */
  /* (atnum) are subsequent and start with */
  /* 1 for the first atom                  */
  /* (i.e. let atom[i].atnum:=i)           */
  long i, j, k;
  long an[maxnat];
  boolean sorted;
  long FORLIM;
  CORCONdata *WITH;

  if (connected) {
    for (i = 0; i < maxnat; i++)
      an[i] = 0;
    FORLIM = nat;
    for (i = 1; i <= FORLIM; i++) {
      j = atom[i - 1].atnum;
      if (j > 0 && j < maxnat)
	an[j - 1] = i;
    }
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      WITH = &atom[i];
      if (WITH->atnum > 0) {
	for (j = 0; j <= 3; j++) {
	  k = WITH->con[j];
	  if (k > 0 && k < maxnat)
	    WITH->con[j] = an[k - 1];
	  else
	    WITH->con[j] = 0;
	}
	do {
	  sorted = true;
	  for (j = 1; j <= 3; j++) {
	    if ((WITH->con[j - 1] > WITH->con[j] || WITH->con[j - 1] == 0) &&
		WITH->con[j] != 0) {
	      sorted = false;
	      k = WITH->con[j - 1];
	      WITH->con[j - 1] = WITH->con[j];
	      WITH->con[j] = k;
	    }
	  }
	} while (!sorted);
      } else {
	for (j = 0; j <= 3; j++)
	  WITH->con[j] = 0;
      }
    }
  }
  FORLIM = nat;
  for (i = 1; i <= FORLIM; i++)
    atom[i - 1].atnum = i;
}


/* getcmdline      get new command line from terminal or command stack
   checkqual    treat qualifiers                                    */


Static Void getcmdline(cmd, el, nel)
Char *cmd;
Char (*el)[81];
long *nel;
{
  /* get next command line, treat "!" (NOT */
  /* operator, "@first", "@last"; start    */
  /* output redirection                    */
  long i, j;
  Char st[201];
  stack *p;
  boolean interactive, found, firlas;
  Char STR1[201], fstr[201];
  Char *TEMP;
  Char STR2[201], STR3[201];
  Char STR4[256];
  Char STR5[106];
  Char STR6[256];
  long SET[3];

_L1:
  if (mode == cfm)
    printf("cofima> ");
  else if (mode == dfm)
    printf("difima> ");
  else
    printf("ancoma> ");
  interactive = (sp == NULL);
  if (sp == NULL) {
    TEMP = fgets(st, 201, stdin);
    TEMP = strchr(st, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
  } else {
    strcpy(st, sp->sl);
    p = sp;
    sp = (stack *)sp->down;
    Free(p);
    puts(st);
  }
  strcpy(st, CoreStr(STR1, 200L, NoTabs(STR3, 200L, st)));
  if (strpos3("!", st, 1) == 1) {
    strcpy(st, CoreStr(STR2, 200L, Trailer(STR1, 200L, st, 2L)));
    if (*st == '\0') {
      errmsg("nothing to search for");
      goto _L1;
    }
    p = hi;
    found = false;
    strcat(st, "*");
    while (p != NULL && !found) {
      found = Match(200L, st, 200L, p->sl);
      if (!found)
	p = (stack *)p->down;
    }
    if (!found) {
      errmsg("no match with any previous command");
      goto _L1;
    }
    strcpy(st, p->sl);
    if (mode == cfm)
      printf("cofima> %s\n", st);
    if (mode == dfm)
      printf("difima> %s\n", st);
    if (mode == acm)
      printf("ancoma> %s\n", st);
  }
  if (interactive) {
    p = hi;
    hi = (stack *)malloc(sizeof(stack));
    strcpy(hi->sl, st);
    hi->down = (long *)p;
  }

  /* -------------------------- treat @FIRST and @LAST -------------------------- */

  firlas = true;
  while (nst > 0 && firlas) {
    firlas = false;
    i = strpos3("@FIRST", st, 1);
    if (i > 0) {
      if (mode == cfm) j = atom[0].resnum;
      else {
	if (nst_cfm > 0) {
	  j = atom[0].resnum;
	  if (mode == dfm) printf("difima-warning: @FIRST is undefined in difima, ");
	  else printf("ancoma-warning: @FIRST is undefined in ancoma, ");
          printf("@FIRST=%ld (from cofima) used\n", j); } 
        else {
	  j = 1;
	  if (mode == dfm) printf("difima-warning: @FIRST is undefined in difima, ");
	  else printf("ancoma-warning: @FIRST is undefined in ancoma, ");
          printf("@FIRST=%ld used\n", j); }}
      sprintf(STR6, "%s%s%s",
	      Header(STR2, 80L, st, i - 1), IntStr(STR1, j, 0L),
	      Trailer(STR3, 80L, st, i + 6));
      strcpy(st, STR6); firlas = true; }

    i = strpos3("@first", st, 1);
    if (i > 0) {
      if (mode == cfm) {
        sprintf(fstr, "%ld", atom[0].resnum);
        for (j = 1; j < nat; j++) 
          if (atom[j].resnum != atom[j - 1].resnum &&
              atom[j].resnum != atom[j - 1].resnum + 1)
            sprintf(&fstr[strlen(fstr)], " %ld", atom[j].resnum); }
      else {
	if (nst_cfm > 0) {
          sprintf(fstr, "%ld", atom[0].resnum);
          for (j = 1; j < nat_cfm; j++)           
            if (atom[j].resnum != atom[j - 1].resnum &&
                atom[j].resnum != atom[j - 1].resnum + 1)
              sprintf(&fstr[strlen(fstr)], " %ld", atom[j].resnum); 
	  if (mode == dfm) printf("difima-warning: @first is undefined in difima, ");
	  else printf("ancoma-warning: @first is undefined in ancoma, ");
          printf("@first=%s (from cofima) used\n", fstr); } 
        else {
	  sprintf(fstr, "1");
	  if (mode == dfm) printf("difima-warning: @first is undefined in difima, ");
	  else printf("ancoma-warning: @first is undefined in ancoma, ");
          printf("@first=%s used\n", fstr); }}
      sprintf(STR6, "%s%s%s",
	      Header(STR2, 80L, st, i - 1), fstr, Trailer(STR3, 80L, st, i + 6));
      strcpy(st, STR6); firlas = true; }

    i = strpos3("@LAST", st, 1);
    if (i > 0) {
      if (mode == cfm) j = atom[nat - 1].resnum;
      else {
	if (nst_cfm > 0) {
	  j = atom[nat_cfm - 1].resnum;
	  if (mode == dfm) printf("difima-warning: @LAST is undefined in difima, ");
	  else printf("ancoma-warning: @LAST is undefined in ancoma, ");
          printf("@LAST=%ld (from cofima) used\n", j); } 
        else {
	  if (mode == dfm)
	    printf("difima-warning: @last is undefined, command skipped\n");
	  else
	    printf("ancoma-warning: @last is undefined, command skipped\n");
	  goto _L1; }}
      sprintf(STR6, "%s%s%s",
	      Header(STR2, 80L, st, i - 1), IntStr(STR1, j, 0L),
	      Trailer(STR3, 80L, st, i + 5));
      strcpy(st, STR6); firlas = true; }

    i = strpos3("@last", st, 1);
    if (i > 0) {
      if (mode == cfm) {
        fstr[0] = '\0';
        for (j = 0; j < nat - 1; j++) 
          if (atom[j].resnum != atom[j + 1].resnum &&
              atom[j].resnum != atom[j + 1].resnum - 1)
            sprintf(&fstr[strlen(fstr)], " %ld", atom[j].resnum); 
        sprintf(&fstr[strlen(fstr)], " %ld", atom[nat - 1].resnum); }
      else {
	if (nst_cfm > 0) {
          fstr[0] = '\0';
          for (j = 0; j < nat_cfm - 1; j++) 
            if (atom[j].resnum != atom[j + 1].resnum &&
                atom[j].resnum != atom[j + 1].resnum - 1)
              sprintf(&fstr[strlen(fstr)], " %ld", atom[j].resnum); 
          sprintf(&fstr[strlen(fstr)], " %ld", atom[nat_cfm - 1].resnum);
	  if (mode == dfm) printf("difima-warning: @last is undefined in difima, ");
	  else printf("ancoma-warning: @last is undefined in ancoma, ");
          printf("@last=%s (from cofima) used\n", fstr); } 
        else {
	  sprintf(fstr, "1");
	  if (mode == dfm) printf("difima-warning: @last is undefined in difima, ");
	  else printf("ancoma-warning: @last is undefined in ancoma, ");
          printf("@last=%s used\n", fstr); }}
      sprintf(STR6, "%s%s%s",
	      Header(STR2, 80L, st, i - 1), fstr, Trailer(STR3, 80L, st, i + 5));
      strcpy(st, STR6); firlas = true; }}

  /* -------------------------- extract command --------------------------------- */

  Element(cmd, 200L, st, 1L, 1, " ", false);
  i = strpos3("/", cmd, 1);
  if (i > 0) {
    Trailer(qual, 80L, cmd, i + 1);
    strcpy(cmd, Header(STR2, 80L, cmd, i - 1));
  } else
    *qual = '\0';

  /* -------------------------- extract elements -------------------------------- */

  *nel = 0;
  P_expset(inv, 0L);
  do {
    (*nel)++;
    strcpy(el[*nel - 1], Element(STR2, 200L, st, *nel + 1, 1, " ", false));
    if (*el[*nel - 1] != '\0') {
      if (el[*nel - 1][0] == '!') {
	if (strlen(el[*nel - 1]) == 1) {
	  sprintf(STR5, "incomplete parameter \\%s\\", el[*nel - 1]);
	  errmsg(STR5);
	  goto _L1;
	}
	P_addset(inv, (int)(*nel));
	strcpy(el[*nel - 1], Trailer(STR2, 80L, el[*nel - 1], 2L));
      }
      if (el[*nel - 1][0] == '#')
	*el[*nel - 1] = '\0';
    }
  } while (*el[*nel - 1] != '\0');
  (*nel)--;
  rd = false;
  if (out != NULL && out != stdout)
    fclose(out);
  out = NULL;
  if (*nel <= 0) {
    /*PGOpen_output_file(&out, 6L, "stdout", 0L, "", &err);*/
    out = stdout;
    if (out == NULL) _EscIO(FileNotFound);
    return;
  }
  if (strcmp(Header(STR2, 80L, el[*nel - 1], 1L), ">"))
  {   /* output redirection */
    /*PGOpen_output_file(&out, 6L, "stdout", 0L, "", &err);*/
    out = stdout;
    if (out == NULL) _EscIO(FileNotFound);
    return;
  }
  if (P_inset((int)(*nel), inv)) {
    errmsg("illegal use of NOT operator");
    goto _L1;
  }
  strcpy(el[*nel - 1], Trailer(STR1, 80L, el[*nel - 1], 2L));
  if (!strcmp(Header(STR1, 80L, el[*nel - 1], 1L), ">"))
  {   /* extend existing output file */
    strcpy(el[*nel - 1], Trailer(STR3, 80L, el[*nel - 1], 2L));
    if (*el[*nel - 1] == '\0')
      /*PGOpen_output_file(&out, 80L, outfile, 0L, "", &err);*/
      out = fopen(outfile, "a");
    else
      /*PGOpen_output_file(&out, 200L,
		       Append_defext(STR3, 80L, el[*nel - 1], 3L, "dat"), 0L,
		       "", &err);*/
      out = fopen(Append_defext(STR3, 80L, el[*nel - 1], 3L, "dat"), "a");
    err = (out == NULL);
    if (err) {
      errmsg("illegal output redirection");
      goto _L1;
    }
  } else {  /* write new output file */
    if (*el[*nel - 1] == '\0')
      /*PGOpen_output_file(&out, 80L, outfile, 0L, "", &err);*/
      out = fopen(outfile, "w");
    else
      /*PGOpen_output_file(&out, 200L,
		       Append_defext(STR3, 80L, el[*nel - 1], 3L, "dat"), 0L,
		       "", &err);*/
      out = fopen(Append_defext(STR3, 80L, el[*nel - 1], 3L, "dat"), "w");
    err = (out == NULL);
    if (err) {
      errmsg("illegal output redirection");
      goto _L1;
    }
  }
  if (*el[*nel - 1] != '\0')
/*PGUpStr(outfile, 200L, Append_defext(STR3, 80L, el[*nel - 1], 3L, "dat"));*/
    Append_defext(outfile, 80L, el[*nel - 1], 3L, "dat");
  (*nel)--;
  if (strcmp(outfile, "stdout"))
    rd = true;

  /* standard output */
  /* standard output */
}


enum {
  cofi, difi, anco


};

Static Void checkqual()
{
  long i, nq;
  Elementlist q;
  long qinv[maxel / 32 + 2];
  long doset, donotset;
  Char STR1[201];
  long SET[3];
  Char STR2[104];
  Char STR3[82], STR4[82], STR5[82];
  Char STR6[106];
  Char STR8[126];

  nq = 0;
  do {
    nq++;
    strcpy(q[nq - 1], Element(STR1, 80L, qual, nq, 1L, "/", false));
  } while (*q[nq - 1] != '\0');
  nq--;
  P_expset(qinv, 0L);
  for (i = 0; i < nq; i++) {
    if (q[i][0] == '!') {
      P_addset(qinv, (int)(i + 1));
      strcpy(q[i], Trailer(STR1, 80L, q[i], 2L));
      if (*q[i] == '\0') {
	sprintf(STR2, "incomplete qualifier /%s", q[i]);
	errmsg(STR2);
	goto _L1;
      }
    }
  }
  for (i = 0; i < nq; i++) {
    UpStr(STR3, 80L, q[i]); strcpy(q[i], STR3);
    sprintf(STR3, "%s*", q[i]);
    sprintf(STR4, "%s*", q[i]);
    sprintf(STR5, "%s*", q[i]);
    switch (Match(81L, STR3, 6L, "COFIMA") + Match(81L, STR4, 6L, "DIFIMA") +
	    Match(81L, STR5, 6L, "ANCOMA")) {

    case 0:
      sprintf(STR6, "unrecognized qualifier /%s", q[i]);
      errmsg(STR6);
      goto _L1;

    case 1:
      /* blank case */
      break;

    default:
      sprintf(STR8, "ambiguous qualifier /%s, supply more characters", q[i]);
      errmsg(STR8);
      goto _L1;
    }
  }
  doset = 0;
  donotset = 0;
  for (i = 1; i <= nq; i++) {
    sprintf(STR3, "%s*", q[i - 1]);
    if (Match(81L, STR3, 6L, "COFIMA")) {
      if (P_inset((int)i, qinv))
	donotset |= 1L << ((long)cofi);
      else
	doset |= 1L << ((long)cofi);
    } else {
      sprintf(STR4, "%s*", q[i - 1]);
      if (Match(81L, STR4, 6L, "DIFIMA")) {
	if (P_inset((int)i, qinv))
	  donotset |= 1L << ((long)difi);
	else
	  doset |= 1L << ((long)difi);
      } else {
	sprintf(STR5, "%s*", q[i - 1]);
	if (Match(81L, STR5, 6L, "ANCOMA")) {
	  if (P_inset((int)i, qinv))
	    donotset |= 1L << ((long)anco);
	  else
	    doset |= 1L << ((long)anco);
	}
      }
    }
  }
  if ((doset & donotset) != 0) {
    errmsg("inconsistent qualifiers");
    goto _L1;
  }
  if (nq == 0 || doset == 0)
    doset = (1L << ((long)anco + 1)) - (1L << ((long)cofi));
  if (mode == cfm) {
    if (((1L << ((long)cofi)) & donotset) != 0 ||
	((1L << ((long)cofi)) & doset) == 0) {
      printf("        ...skipped\n");
      goto _L1;
    }
  }
  if (mode == dfm) {
    if (((1L << ((long)difi)) & donotset) != 0 ||
	((1L << ((long)difi)) & doset) == 0) {
      printf("        ...skipped\n");
      goto _L1;
    }
  }
  if (mode == acm) {
    if (((1L << ((long)anco)) & donotset) != 0 ||
	((1L << ((long)anco)) & doset) == 0) {
      printf("        ...skipped\n");
      goto _L1;
    }
  }
  skipcmd = false;
  goto _L2;
_L1:
  skipcmd = true;
_L2: ;
}


#define sbr             "H*=0.4 C*=0.85 N*=0.8 O*=0.7 S*=1.3 P*=1.2 Q*=-999 LP*=-999 *=0.85"


/* connectivities   generate connectivities for all atoms based on bond radii
   disconnect       delete all connectivities in a given range
   bind             insert or delete specific connectivities
   link             generate specific connectivities                          */


Static Void connectivities()
{
  /* generate connectivities based on bond */
  /* radii                                 */
  Char s[201];
  long i, FORLIM;
  Char STR1[201];
  Char STR2[250];
  CORCONdata *WITH;

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (*inv != 0L) {
    errmsg("illegal use of NOT operator");
    goto _L9;
  }
  if (nel > 0) {
    *s = '\0';
    FORLIM = nel;
    for (i = 0; i < FORLIM; i++)
      sprintf(s + strlen(s), " %s", el[i]);
    connect(1L, (long)maxnat, atom, nat, 200L, s, &stat, 0L);
  } else
    connect(1L, (long)maxnat, atom, nat, 66L, sbr, &stat, 0L);
  connected = (stat == 0);
  switch (stat) {

  case 0:
    printf("        ...connectivities inserted");
    if (nel > 0)
      putchar('\n');
    else {
      printf(", using standard bond radii:\n");
      printf("        %s\n", sbr);
    }
    break;

  case -1:
    errmsg("illegal bond radius definition");
    goto _L9;

  case -2:
    errmsg("incomplete bond radii list");
    goto _L9;

  default:
    WITH = &atom[stat - 1];
    sprintf(STR2, "more than 4 connectivities for %s of %s %s",
	    WITH->atnam, WITH->resnam, IntStr(STR1, WITH->resnum, 0));
    errmsg(STR2);
    goto _L9;
  }
_L9: ;
}

#undef sbr


Static Void disconnect()
{
  /* delete connectivities                 */
  long i, j, k, l, l1, n1;
  boolean b;
  boolean del[maxnat];
  long SET[9], SET1[9];
  long FORLIM;
  CORCONdata *WITH, *WITH1;

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (connected) {
    if (nel == 0) {
      printf("        ...connectivities deleted\n");
      connected = false;
    } else {
      adjust_atnum();
      setflag();
      if (error)
	goto _L9;
      n1 = 1;
      while ((el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	      isalpha(el[n1 - 1][0])) && n1 < nel)
	n1++;
      if (!(el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	    isalpha(el[n1 - 1][0])))
	n1--;
      b = (*P_setdiff(SET1, P_addsetr(P_expset(SET, 0L), 1, (int)n1), inv) == 0L);
      FORLIM = nat;
      for (i = 0; i < FORLIM; i++)
	del[i] = false;
      FORLIM = nat;
      for (i = 0; i < FORLIM; i++) {
	if (flag[i]) {
	  WITH = &atom[i];
	  del[i] = b;
	  for (j = 1; j <= n1; j++) {
	    if (!P_inset((int)j, inv))
	      del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH->atnam));
	  }
	  for (j = 1; j <= n1; j++) {
	    if (P_inset((int)j, inv))
	      del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH->atnam));
	  }
	}
      }
      j = 0;
      FORLIM = nat;
      for (i = 1; i <= FORLIM; i++) {
	if (del[i - 1]) {
	  WITH = &atom[i - 1];
	  if (WITH->con[0] > 0) {
	    j++;
	    for (k = 0; k <= 3; k++) {
	      if (WITH->con[k] > 0) {
		WITH1 = &atom[WITH->con[k] - 1];
		l = 1;
		while (l <= 4 && WITH1->con[l - 1] != i)
		  l++;
		for (l1 = l; l1 <= 3; l1++)
		  WITH1->con[l1 - 1] = WITH1->con[l1];
		if (l <= 4)
		  WITH1->con[3] = 0;
		WITH->con[k] = 0;
	      }
	    }
	  }
	}
      }
      printf("        ...%ld atoms disconnected\n", j);
    }
  } else
    errmsg("there are no connectivities");
_L9: ;
}


Static Void bind(makebond)
boolean makebond;
{
  /* makebond=true:  insert connectivity   */
  /*                 into the connectivity */
  /*                 list                  */
  /* makebond=false: delete connectivity   */
  /*                 from the connectivity */
  /*                 list                  */
  long i, i1, i2, j, r1, r2;
  long SET[maxel / 32 + 2];
  Char STR1[201];
  Char STR2[116];
  Char STR3[122];
  Char STR4[256];
  long SET1[maxel / 32 + 2];
  CORCONdata *WITH;
  Char STR5[256];
  Char STR6[254];
  Char STR7[201];

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel < 4) {
    errmsg("missing parameter");
    goto _L9;
  }
  if (nel > 5) {
    errmsg("too many parameters");
    goto _L9;
  }
  if (!connected) {
    errmsg("no connectivities defined at all");
    goto _L9;
  }
  if (!(el[0][0] == '%' || el[0][0] == '*' || isalpha(el[0][0]))) {
    sprintf(STR2, "illegal atom type specification \\%s\\", el[0]);
    errmsg(STR2);
    goto _L9;
  }
  /*PGr1 = atol(el[1]);*/
  err=(sscanf(el[1],"%ld",&r1)!=1);
  if (err) {
    sprintf(STR3, "illegal residue number specification \\%s\\", el[1]);
    errmsg(STR3);
    goto _L9;
  }
  if (!(el[2][0] == '%' || el[2][0] == '*' || isalpha(el[2][0]))) {
    sprintf(STR2, "illegal atom type specification \\%s\\", el[2]);
    errmsg(STR2);
    goto _L9;
  }
  if (strpos3("%", el[0], 1) + strpos3("*", el[0], 1) +
      strpos3("%", el[2], 1) + strpos3("*", el[2], 1) > 0) {
    errmsg("illegal use of wildcards");
    goto _L9;
  }
  /*PGr2 = atol(el[3]);*/
  err=(sscanf(el[3],"%ld",&r2)!=1);
  if (err) {
    sprintf(STR3, "illegal residue number specification \\%s\\", el[3]);
    errmsg(STR3);
    goto _L9;
  }
  if (*P_setint(SET1, P_expset(SET, 0x1eL), inv) != 0L) {
    errmsg("illegal use of NOT operator");
    goto _L9;
  }
  i = 1;
  i1 = 0;
  i2 = 0;
  atom[nat].resnum = -9999;
  while (i <= nat && (i1 == 0 || i2 == 0)) {
    WITH = &atom[i - 1];
    if (WITH->resnum == r1) {
      if (!strcmp(WITH->atnam, el[0]))
	i1 = i;
    }
    if (WITH->resnum == r2) {
      if (!strcmp(WITH->atnam, el[2]))
	i2 = i;
    }
    i++;
  }
  if (i1 == 0) {
    sprintf(STR5, "atom %s not found in residue %s",
	    el[0], IntStr(STR1, r1, 0));
    errmsg(STR5);
    goto _L9;
  }
  if (i2 == 0) {
    sprintf(STR5, "atom %s not found in residue %s",
	    el[2], IntStr(STR1, r2, 0));
    errmsg(STR5);
    goto _L9;
  }
  adjust_atnum();
  if (makebond) {   /* create bond */
    WITH = &atom[i1 - 1];
    i = 1;
    while (i <= 4 && WITH->con[i - 1] > 0)
      i++;
    if (i > 4) {
      sprintf(STR6, "atom %s of %s %s has already 4 connectivities",
	      WITH->atnam, WITH->resnam, IntStr(STR1, WITH->resnum, 0));
      errmsg(STR6);
      goto _L9;
    }
    WITH->con[i - 1] = i2;
    WITH = &atom[i2 - 1];
    i = 1;
    while (i <= 4 && WITH->con[i - 1] > 0)
      i++;
    if (i > 4) {
      sprintf(STR6, "atom %s of %s %s has already 4 connectivities",
	      WITH->atnam, WITH->resnam, IntStr(STR1, WITH->resnum, 0));
      errmsg(STR6);
      goto _L9;
    }
    WITH->con[i - 1] = i1;
    printf("        ...atom %s of %s %ld bound to %s of %s %ld\n",
	   el[0], atom[i1 - 1].resnam, atom[i1 - 1].resnum, el[2],
	   atom[i2 - 1].resnam, atom[i2 - 1].resnum);
  } else {  /* break bond */
    WITH = &atom[i1 - 1];
    i = 1;
    while (i <= 4 && WITH->con[i - 1] != i2)
      i++;
    if (i > 4) {
      sprintf(STR4, "atom %s of %s %s is not bound to atom %s of %s %s",
	      WITH->atnam, WITH->resnam, IntStr(STR1, WITH->resnum, 0),
	      atom[i2 - 1].atnam, atom[i2 - 1].resnam,
	      IntStr(STR7, atom[i2 - 1].resnum, 0));
      errmsg(STR4);
      goto _L9;
    }
    for (j = i; j <= 3; j++)
      WITH->con[j - 1] = WITH->con[j];
    WITH->con[3] = 0;
    WITH = &atom[i2 - 1];
    i = 1;
    while (i <= 4 && WITH->con[i - 1] != i1)
      i++;
    if (i > 4) {
      sprintf(STR5, "atom %s of %s %s is not bound to atom %s of %s %s",
	      WITH->atnam, WITH->resnam, IntStr(STR1, WITH->resnum, 0),
	      atom[i1 - 1].atnam, atom[i1 - 1].resnam,
	      IntStr(STR7, atom[i1 - 1].resnum, 0));
      errmsg(STR5);
      goto _L9;
    }
    for (j = i; j <= 3; j++)
      WITH->con[j - 1] = WITH->con[j];
    WITH->con[3] = 0;
    printf("        ...atom %s of %s %ld unbound from %s of %s %ld\n",
	   el[0], atom[i1 - 1].resnam, atom[i1 - 1].resnum, el[2],
	   atom[i2 - 1].resnam, atom[i2 - 1].resnum);
  }
_L9: ;
}


#define sbl             2.5   /* standard bond length */


Static Void link()
{
  /* connect atoms (e.g. make ss-bridges)  */
  long i, i2, j, k, l, n1, n2, nel1;
  boolean b, sbl_used, there;
  Elementlist el1;
  float bl;
  boolean flag1[maxnat], del[maxnat];
  long FORLIM;
  long SET[9], SET1[9], SET2[9];
  long SET3[maxel / 32 + 2], SET4[maxel / 32 + 2];
  CORCONdata *WITH;
  long FORLIM1;
  Char STR1[201];
  Char STR3[254];
  CORCONdata *WITH1;

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel < 2) {
    errmsg("missing parameter");
    goto _L9;
  }
  if (!connected) {
    errmsg("no connectivities defined at all");
    goto _L9;
  }
  /*PGbl = atof(el[0]);*/
  err=(sscanf(el[0],"%f",&bl)!=1);
  sbl_used = err;
  if (sbl_used)
    bl = sbl;
  else {
    if (P_inset(1, inv)) {
      errmsg("illegal use of NOT operator");
      goto _L9;
    }
    nel--;
    FORLIM = nel;
    for (i = 1; i <= FORLIM; i++)
      strcpy(el[i - 1], el[i]);
    FORLIM = nel;
    for (i = 1; i <= FORLIM; i++) {
      if (P_inset((int)(i + 1), inv))
	P_setunion(inv, P_setdiff(SET1, inv,
				  P_addset(P_expset(SET, 0L), (int)(i + 1))),
		   P_addset(P_expset(SET2, 0L), (int)i));
    }
  }
  n1 = 1;
  while ((el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	  isalpha(el[n1 - 1][0])) && n1 < nel)
    n1++;
  if (!(el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	isalpha(el[n1 - 1][0])))
    n1--;
  if (n1 < 1) {
    errmsg("first atom type specification missing");
    goto _L9;
  }
  if (n1 > 2) {
    errmsg("more than two atom types specified");
    goto _L9;
  }
  memcpy(el1, el, sizeof(Elementlist));
  nel1 = nel;
  n2 = 2;
  while (!(el[n2 - 1][0] == '%' || el[n2 - 1][0] == '*' ||
	   isalpha(el[n2 - 1][0])) && n2 < nel)
    n2++;
  if (el[n2 - 1][0] == '%' || el[n2 - 1][0] == '*' || isalpha(el[n2 - 1][0]))
    n2--;
  nel = n2;
  nel1 -= nel;
  for (i = 0; i < nel1; i++)
    strcpy(el1[i], el[i + nel]);
  n1 = 1;
  while ((el1[n1 - 1][0] == '%' || el1[n1 - 1][0] == '*' ||
	  isalpha(el1[n1 - 1][0])) && n1 < nel1)
    n1++;
  if (!(el1[n1 - 1][0] == '%' || el1[n1 - 1][0] == '*' ||
	isalpha(el1[n1 - 1][0])))
    n1--;
  if (n1 < 1) {
    errmsg("second atom type specification missing");
    goto _L9;
  }
  if (n1 > 2) {
    errmsg("more than two atom types specified");
    goto _L9;
  }
  setflag();
  if (error)
    goto _L9;
  b = (*P_setdiff(SET4, P_expset(SET3, 0x2L), inv) == 0L);
  FORLIM = nat;
  for (i = 0; i < FORLIM; i++)
    del[i] = false;
  FORLIM = nat;
  for (i = 0; i < FORLIM; i++) {
    if (flag[i]) {
      WITH = &atom[i];
      del[i] = b;
      for (j = 1; j <= n1; j++) {
	if (!P_inset((int)j, inv))
	  del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH->atnam));
      }
      for (j = 1; j <= n1; j++) {
	if (P_inset((int)j, inv))
	  del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH->atnam));
      }
    }
  }
  FORLIM = nat;
  for (i = 0; i < FORLIM; i++)
    flag1[i] = (flag[i] && del[i]);
  memcpy(el, el1, sizeof(Elementlist));
  nel = nel1;
  setflag();
  if (error)
    goto _L9;
  b = (*P_setdiff(SET1, P_addset(P_expset(SET, 0L), (int)(n2 + 1)), inv) == 0L);
  FORLIM = nat;
  for (i = 0; i < FORLIM; i++)
    del[i] = false;
  FORLIM = nat;
  for (i = 0; i < FORLIM; i++) {
    if (flag[i]) {
      WITH = &atom[i];
      del[i] = b;
      for (j = 1; j <= n1; j++) {
	if (!P_inset((int)j, inv))
	  del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH->atnam));
      }
      for (j = 1; j <= n1; j++) {
	if (P_inset((int)j, inv))
	  del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH->atnam));
      }
    }
  }
  FORLIM = nat;
  for (i = 0; i < FORLIM; i++)
    flag[i] = (flag[i] && del[i]);
  adjust_atnum();
  j = 0;
  FORLIM = nat;
  for (i = 1; i <= FORLIM; i++) {
    if (flag1[i - 1]) {
      WITH = &atom[i - 1];
      FORLIM1 = nat;
      for (i2 = 1; i2 <= FORLIM1; i2++) {
	if (flag[i2 - 1] && i2 != i) {
	  if (dist(WITH->x, atom[i2 - 1].x) <= bl) {
	    k = 1;
	    there = false;
            for (l = 1; l <= 4 ; l++) { 
	      there = (there || WITH->con[k - 1] == atom[i2 - 1].atnum);
	      if (WITH->con[l - 1]>0) k++; 
	    }
	    if (!there) {
	      if (WITH->con[3] > 0) {
	        sprintf(STR3, "atom %s of %s %s has already 4 connectivities",
		      WITH->atnam, WITH->resnam,
		      IntStr(STR1, WITH->resnum, 0));
	        errmsg(STR3);
	        goto _L9;
	      }
	      if (atom[i2 - 1].con[3] > 0) {
	        WITH1 = &atom[i2 - 1];
	        sprintf(STR3, "atom %s of %s %s has already 4 connectivities",
		      WITH1->atnam, WITH1->resnam,
		      IntStr(STR1, WITH1->resnum, 0));
	        errmsg(STR3);
	        goto _L9;
	      }
	      j++;
	      WITH->con[k - 1] = atom[i2 - 1].atnum;
	      k = 1;
	      while (atom[i2 - 1].con[k - 1] > 0)
		k++;
	      atom[i2 - 1].con[k - 1] = WITH->atnum;
	    }
	  }
	}
      }
    }
  }
  if (sbl_used)
    printf("        ...%ld atom pairs linked, using standard bond length %0.2f\n",
	   j, sbl);
  else
    printf("        ...%ld atom pairs linked\n", j);
_L9: ;
}

#undef sbl


/* delete    delete or keep atoms or constraints */

Static Void delete__(keepat)
boolean keepat;
{
  /* delete or keep atoms or constraints   */
  long i, j, n1;
  boolean b;
  boolean del[maxnat], del2[maxnat];
  long SET[9], SET1[9];
  long FORLIM;
  CORCONdata *WITH;
  ACOdata *WITH1;
  DCOdata *WITH2;

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel < 1) {
    errmsg("missing parameter");
    goto _L9;
  }
  n1 = 1;
  while ((el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	  isalpha(el[n1 - 1][0])) && n1 < nel)
    n1++;
  if (!(el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	isalpha(el[n1 - 1][0])))
    n1--;
  b = (*P_setdiff(SET1, P_addsetr(P_expset(SET, 0L), 1, (int)n1), inv) == 0L);
  FORLIM = nat;
  for (i = 0; i < FORLIM; i++)
    del[i] = false;
  if (mode == cfm) {
    setflag();
    if (error)
      goto _L9;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (flag[i]) {
	WITH = &atom[i];
	del[i] = b;
	for (j = 1; j <= n1; j++) {
	  if (!P_inset((int)j, inv))
	    del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH->atnam));
	}
	for (j = 1; j <= n1; j++) {
	  if (P_inset((int)j, inv))
	    del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH->atnam));
	}
      }
    }
    j = 0;
    if (keepat) {
      FORLIM = nat;
      for (i = 0; i < FORLIM; i++) {
	if (del[i]) {
	  j++;
	  atom[j - 1] = atom[i];
	}
      }
      printf("        ...%ld atoms kept\n", j);
    } else {
      FORLIM = nat;
      for (i = 0; i < FORLIM; i++) {
	if (!del[i]) {
	  j++;
	  atom[j - 1] = atom[i];
	}
      }
      printf("        ...%ld atoms deleted\n", nat - j);
    }
  } else if (mode == acm) {
    setflag();
    if (error)
      goto _L9;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (flag[i]) {
	WITH1 = &aconstr[i];
	del[i] = b;
	for (j = 1; j <= n1; j++) {
	  if (!P_inset((int)j, inv))
	    del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH1->angnam));
	}
	for (j = 1; j <= n1; j++) {
	  if (P_inset((int)j, inv))
	    del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH1->angnam));
	}
      }
    }
    j = 0;
    if (keepat) {
      FORLIM = nat;
      for (i = 0; i < FORLIM; i++) {
	if (del[i]) {
	  j++;
	  aconstr[j - 1] = aconstr[i];
	}
      }
      printf("        ...%ld angle constraints kept\n", j);
    } else {
      FORLIM = nat;
      for (i = 0; i < FORLIM; i++) {
	if (!del[i]) {
	  j++;
	  aconstr[j - 1] = aconstr[i];
	}
      }
      printf("        ...%ld angle constraints deleted\n", nat - j);
    }
  } else {
    first = true;
    setflag();
    if (error)
      goto _L9;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (flag[i]) {
	WITH2 = &constr[i];
	del[i] = b;
	for (j = 1; j <= n1; j++) {
	  if (!P_inset((int)j, inv))
	    del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH2->atnam1));
	}
	for (j = 1; j <= n1; j++) {
	  if (P_inset((int)j, inv))
	    del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH2->atnam1));
	}
      }
    }
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      del2[i] = false;
    first = false;
    setflag();
    if (error)
      goto _L9;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (flag[i]) {
	WITH2 = &constr[i];
	del2[i] = b;
	for (j = 1; j <= n1; j++) {
	  if (!P_inset((int)j, inv))
	    del2[i] = (del2[i] || Match(80L, el[j - 1], 5L, WITH2->atnam2));
	}
	for (j = 1; j <= n1; j++) {
	  if (P_inset((int)j, inv))
	    del2[i] = (del2[i] && !Match(80L, el[j - 1], 5L, WITH2->atnam2));
	}
      }
    }
    j = 0;
    if (keepat) {
      FORLIM = nat;
      for (i = 0; i < FORLIM; i++) {
	if (del[i] || del2[i]) {
	  j++;
	  constr[j - 1] = constr[i];
	}
      }
      printf("        ...%ld distance constraints kept\n", j);
    } else {
      FORLIM = nat;
      for (i = 0; i < FORLIM; i++) {
	if (!(del[i] || del2[i])) {
	  j++;
	  constr[j - 1] = constr[i];
	}
      }
      printf("        ...%ld distance constraints deleted\n", nat - j);
    }
  }
  nat = j;
_L9: ;
}


/* help      read help files, display help */


Static Void help()
{
  /* display help file                     */
  Char s[201];
  long j;
  Char *TEMP;

  if (nel > 0) {
    errmsg("no parameters allowed here");
    goto _L9;
  }
  if (mode == cfm)
    sprintf(s, "%s/%s", libdir, cofima_help_file);
  else if (mode == dfm)
    sprintf(s, "%s/%s", libdir, difima_help_file);
  else
    sprintf(s, "%s/%s", libdir, ancoma_help_file);
  Open_input_file(&f, 37L, s, 0L, "", &err);
  /*PG*/ if (err) { errmsg("help file cannot be opened"); goto _L9; }  
  j = 0;
  while (!P_eof(f)) {
    j++;
/*PGdebug printf("j=%d\n",j); */
    if (!rd && j % 23 == 0) {
/* p2c: cofima.pas, line 1237:
 * Note: Using % for possibly-negative arguments [317] */
      if (j == 23)
	putc('\n', out);
      printf("        press RETURN to continue, q to stop ");
      TEMP = fgets(s, 201, stdin);
      TEMP = strchr(s, '\n');
      if (TEMP != NULL)
	*TEMP = 0;
      putchar('\n');
      if (*s != '\0') {
	j--;
	goto _L5;
      }
    }
    TEMP = fgets(s, 201, f);
    TEMP = strchr(s, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    fprintf(out, "%s\n", s);
  }
_L5:
  if (f != NULL)
    fclose(f);
  f = NULL;
  if (!rd && (unsigned long)j < 32 && ((1L << j) & 0x7ffffeL) != 0)
    putc('\n', out);
_L9: ;
}


/* insert    insert (pseudo) atom in the center of several atoms
   attach    attach atoms
   copy      copy atoms from one residue to another               */


Static Void insert_()
{
  /* insert (pseudo) atoms in the center   */
  /* of certain atoms                      */
  long i, j, k, k1, l, n1, nm, natold;
  boolean m;
  Vector xi;
  long SET[9];
  Vector TEMP;
  CORCONdata *WITH;
  long SET1[9];
  Char STR2[201];

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel < 2) {
    errmsg("missing parameter");
    goto _L9;
  }
  if ((el[0][0] == '%' || el[0][0] == '*' || isalpha(el[0][0])) &&
      (el[1][0] == '%' || el[1][0] == '*' || isalpha(el[1][0]))) {
    if (strpos3("%", el[0], 1) + strpos3("*", el[0], 1) > 0) {
      errmsg("illegal use of wildcards");
      goto _L9;
    }
    if (P_inset(1, inv)) {
      errmsg("illegal use of NOT operator");
      goto _L9;
    }
    setflag();
    if (error)
      goto _L9;
    natold = nat;
    n1 = 2;
    while ((el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	    isalpha(el[n1 - 1][0])) && n1 < nel)
      n1++;
    if (!(el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	  isalpha(el[n1 - 1][0])))
      n1--;
    j = 1;
    do {
      i = j;
      while (i < nat && atom[i - 1].resnum == atom[j - 1].resnum)
	i++;
      if (atom[i - 1].resnum != atom[j - 1].resnum)
	i--;
      if (flag[j - 1]) {
	nm = 0;
	vec(xi, 0.0, 0.0, 0.0);
	k1 = 0;
	for (k = j; k <= i; k++) {
	  WITH = &atom[k - 1];
	  m = (*P_setdiff(SET1, P_addsetr(P_expset(SET, 0L), 2, (int)n1), inv) ==
	       0L);
	  for (l = 2; l <= n1; l++) {
	    if (!P_inset((int)l, inv))
	      m = (m || Match(80L, el[l - 1], 5L, WITH->atnam));
	  }
	  for (l = 2; l <= n1; l++) {
	    if (P_inset((int)l, inv))
	      m = (m && !Match(80L, el[l - 1], 5L, WITH->atnam));
	  }
	  if (m) {
	    nm++;
	    memcpy(xi, sum(TEMP, xi, WITH->x), sizeof(Vector));
	    k1 = k;
	  }
	}
	if (nm > 0) {
	  WITH = &atom[k1];
	  nat++;
	  for (l = nat; l >= k1 + 2; l--) {
	    atom[l - 1] = atom[l - 2];
	    flag[l - 1] = flag[l - 2];
	  }
	  WITH->resnum = atom[j - 1].resnum;
	  strcpy(WITH->resnam, atom[j - 1].resnam);
	  strcpy(WITH->atnam, el[0]);
	  WITH->atnum = 0;
	  mult(WITH->x, 1.0 / nm, xi);
          WITH->occupancy = 1.0; WITH->bfactor = 1.0;
          WITH->con[0] = 0; WITH->con[1] = 0; WITH->con[2] = 0; WITH->con[3] = 0;
	} else
	  printf("cofima-warning: no matching atoms found in %s %ld\n",
		 CoreStr(STR2, 5L, atom[j - 1].resnam), atom[j - 1].resnum);
      } else
	nm = 0;
      j = i + (nm > 0) + 1;
    } while (j <= nat);
    printf("        ...%ld atoms inserted\n", nat - natold);
  } else
    errmsg("less than two atom types specified");
_L9: ;
}


#define deftau          109.4712207


Static Void attach()
{
  /* attach atoms                          */
  long i, j, k, k1, l, natold;
  float bondlen, tau, phi, phi0;
  Vector a[4];
  long atset;
  Char at4[6];
  long an[4];
  boolean con1, con4;
  long SET[maxel / 32 + 2], SET1[maxel / 32 + 2];
  long SET2[3];
  Char STR1[201];
  Char STR2[116];
  Char STR3[256];
  Char STR4[42];
  long FORLIM;
  long SET3[9];
  Char STR5[256];
  Char STR6[118];
  Char STR7[120];
  CORCONdata *WITH, *WITH1;

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel < 5) {
    errmsg("missing parameter");
    goto _L9;
  }
  if (*P_setint(SET1, P_expset(SET, 0x3eL), inv) != 0L) {
    errmsg("illegal use of NOT operator");
    goto _L9;
  }
  if ((el[0][0] == '%' || el[0][0] == '*' || el[0][0] == '~' ||
       isalpha(el[0][0])) &&
      (el[1][0] == '%' || el[1][0] == '*' || el[1][0] == '~' ||
       isalpha(el[1][0])) &&
      (el[2][0] == '%' || el[2][0] == '*' || el[2][0] == '~' ||
       isalpha(el[2][0])) &&
      (el[3][0] == '%' || el[3][0] == '*' || el[3][0] == '~' ||
       isalpha(el[3][0]))) {
/* p2c: cofima.pas, line 1441: Note:
 * Line breaker spent 0.9+0.18 seconds, 5000 tries on line 3597 [251] */
    adjust_atnum();
    if (!strcmp(el[1], "~")) {
      sprintf(STR2, "illegal atom type specification \\%s\\", el[1]);
      errmsg(STR2);
      goto _L9;
    }
    con1 = (el[1][0] == '~');
    if (con1)
      strcpy(el[1], Trailer(STR1, 80L, el[1], 2L));
    if (el[0][0] == '~') {
      sprintf(STR2, "illegal atom type specification \\%s\\", el[0]);
      errmsg(STR2);
      goto _L9;
    }
    if (el[2][0] == '~') {
      sprintf(STR2, "illegal atom type specification \\%s\\", el[2]);
      errmsg(STR2);
      goto _L9;
    }
    if (el[3][0] == '~') {
      sprintf(STR2, "illegal atom type specification \\%s\\", el[3]);
      errmsg(STR2);
      goto _L9;
    }
    if (con1 && !connected) {
      errmsg("connectivities missing");
      goto _L9;
    }
    if (el[4][0] == '%' || el[4][0] == '*' || el[4][0] == '~' ||
	isalpha(el[4][0])) {
      if (strpos3("%", el[4], 1) + strpos3("*", el[4], 1) > 0) {
	errmsg("illegal use of wildcards");
	goto _L9;
      }
      strcpy(at4, el[4]);
      if (!strcmp(at4, "~")) {
	sprintf(STR4, "illegal atom type specification \\%s\\", at4);
	errmsg(STR4);
	goto _L9;
      }
      con4 = (at4[0] == '~');
      if (con4)
	strcpy(at4, Trailer(STR1, 5L, at4, 2L));
      if (con4 && !connected) {
	errmsg("connectivities missing");
	goto _L9;
      }
      FORLIM = nel;
      for (i = 6; i <= FORLIM; i++) {
	strcpy(el[i - 2], el[i - 1]);
	if (P_inset((int)i, inv))
	  P_addset(inv, (int)(i - 1));
	else
	  P_remset(inv, (int)(i - 1));
      }
      P_remset(inv, (int)nel);
      nel--;
    } else
      *at4 = '\0';
    sprintf(STR3, "%s%s%s%s", el[0], el[1], el[2], el[3]);
    sprintf(STR5, "%s%s%s%s", el[0], el[1], el[2], el[3]);
    if (strpos3("%", STR3, 1) + strpos3("*", STR5, 1) > 0) {
      errmsg("illegal use of wildcards");
      goto _L9;
    }
    /*PGj = P_imin(4, nel - 4);*/
    j=nel-4; if (j>4) j=4;
    if (nel < 5) {
      errmsg("missing bond length specification");
      goto _L9;
    }
    if (strpos3(".", el[4], 1) <= 0 || strpos3("..", el[4], 1) != 0) {
      sprintf(STR6, "illegal bond length specification \\%s\\", el[4]);
      errmsg(STR6);
      goto _L9;
    }
    if (P_inset(5, inv)) {
      errmsg("illegal use of NOT operator");
      goto _L9;
    }
    /*PGbondlen = atof(el[4]);*/
    err=(sscanf(el[4],"%f",&bondlen)!=1);
    if (err) {
      sprintf(STR6, "illegal bond length specification \\%s\\", el[4]);
      errmsg(STR6);
      goto _L9;
    }
    if (nel >= 6) {
      if (strpos3(".", el[5], 1) > 0 && strpos3("..", el[5], 1) == 0) {
	if (P_inset(6, inv)) {
	  errmsg("illegal use of NOT operator");
	  goto _L9;
	}
	/*PGtau = atof(el[5]);*/
	err=(sscanf(el[5],"%f",&tau)!=1);
	if (err) {
	  sprintf(STR6, "illegal bond angle specification \\%s\\", el[5]);
	  errmsg(STR6);
	  goto _L9;
	}
      } else {
	j--;
	tau = deftau;
      }
    } else
      tau = deftau;
    if (nel >= 7) {
      if (strpos3(".", el[6], 1) > 0 && strpos3("..", el[6], 1) == 0) {
	if (P_inset(7, inv)) {
	  errmsg("illegal use of NOT operator");
	  goto _L9;
	}
	/*PGphi = atof(el[6]);*/
	err=(sscanf(el[6],"%f",&phi)!=1);
	if (err) {
	  sprintf(STR7, "illegal torsion angle specification \\%s\\", el[6]);
	  errmsg(STR7);
	  goto _L9;
	}
      } else {
	j--;
	phi = 0.0;
      }
    } else
      phi = 0.0;
    if (nel >= 8) {
      if (strpos3(".", el[7], 1) > 0 && strpos3("..", el[7], 1) == 0) {
	if (P_inset(8, inv)) {
	  errmsg("illegal use of NOT operator");
	  goto _L9;
	}
	/*PGphi0 = atof(el[7]);*/
	err=(sscanf(el[7],"%f",&phi0)!=1);
	if (err) {
	  sprintf(STR7, "illegal torsion angle specification \\%s\\", el[7]);
	  errmsg(STR7);
	  goto _L9;
	}
      } else {
	j--;
	phi0 = 0.0;
      }
    } else
      phi0 = 0.0;
    nel -= j;
    FORLIM = nel;
    for (i = 5; i <= FORLIM; i++) {
      strcpy(el[i - 1], el[i + j - 1]);
      if (P_inset((int)(i + j), inv))
	P_addset(inv, (int)i);
      else
	P_remset(inv, (int)i);
    }
    P_setdiff(inv, inv, P_addsetr(P_expset(SET, 0L), (int)(nel + 1), maxel));
    setflag();
    if (error)
      goto _L9;
    natold = nat;
    j = 1;
    do {
      i = j;
      while (i < nat && atom[i - 1].resnum == atom[j - 1].resnum)
	i++;
      if (atom[i - 1].resnum != atom[j - 1].resnum)
	i--;
      atset = 0;
      if (flag[j - 1]) {
	for (k = j; k <= i; k++) {
	  WITH = &atom[k - 1];
	  for (l = 3 - !con1; l <= 4; l++) {
	    if (!strcmp(el[l - 1], WITH->atnam)) {
	      atset = ((long)atset) | (1L << ((int)(l - 1)));
	      an[l - 2] = k;
	      memcpy(a[l - 2], WITH->x, sizeof(Vector));
	      if (l == 4)
		k1 = k;
	    }
	  }
	  if (!con4 && !strcmp(at4, WITH->atnam)) {
	    atset |= 0x10;
	    memcpy(a[3], WITH->x, sizeof(Vector));
	  }
	}
	if ((0x4 & atset) != 0 && con1) {
	  WITH = &atom[an[1] - 1];
	  for (l = 0; l <= 3; l++) {
	    if (WITH->con[l] > 0) {
	      WITH1 = &atom[WITH->con[l] - 1];
	      if (!strcmp(WITH1->atnam, el[1])) {
		atset |= 0x2;
		memcpy(a[0], WITH1->x, sizeof(Vector));
	      }
	    }
	  }
	}
	if (*at4 == '\0') {
	  if (atset == 0xe) {
	    WITH = &atom[k1];
	    nat++;
	    for (l = nat; l >= k1 + 2; l--) {
	      atom[l - 1] = atom[l - 2];
	      flag[l - 1] = flag[l - 2];
	    }
	    WITH->resnum = atom[j - 1].resnum;
	    strcpy(WITH->resnam, atom[j - 1].resnam);
	    strcpy(WITH->atnam, el[0]);
	    WITH->atnum = 0;
	    attach_atom(WITH->x, a[0], a[1], a[2], phi0 / rad, bondlen,
			tau / rad, phi / rad);
	    adjust_atnum();
	  } else {
	    for (l = 1; l <= 3; l++) {
	      if ((unsigned long)l >= 32 || ((1L << l) & atset) == 0) {
		if (con1 && l == 1 && (0x4 & atset) != 0)
		  printf("cofima-warning: atom %s not connected to %s of %s %ld\n",
			 el[1], el[2], atom[j - 1].resnam,
			 atom[j - 1].resnum);
		else
		  printf("cofima-warning: atom %s not found in %s %ld\n",
			 el[l], atom[j - 1].resnam, atom[j - 1].resnum);
	      }
	    }
	  }
	} else {
	  if ((0x8 & atset) != 0 && con4) {
	    WITH = &atom[an[2] - 1];
	    for (l = 0; l <= 3; l++) {
	      if (WITH->con[l] > 0) {
		WITH1 = &atom[WITH->con[l] - 1];
		if (!strcmp(WITH1->atnam, at4)) {
		  atset |= 0x10;
		  memcpy(a[3], WITH1->x, sizeof(Vector));
		}
	      }
	    }
	  }
	  if (atset == 0x1e) {
	    WITH = &atom[k1];
	    nat++;
	    for (l = nat; l >= k1 + 2; l--) {
	      atom[l - 1] = atom[l - 2];
	      flag[l - 1] = flag[l - 2];
	    }
	    WITH->resnum = atom[j - 1].resnum;
	    strcpy(WITH->resnam, atom[j - 1].resnam);
	    strcpy(WITH->atnam, el[0]);
	    WITH->atnum = 0;
	    attach_atom(WITH->x, a[0], a[1], a[2], phi0 / rad, bondlen,
			tau / rad, tor(a[0], a[1], a[2], a[3]) + phi / rad);
            WITH->occupancy = 1.0; WITH->bfactor = 1.0;
	    adjust_atnum();
	  } else {
	    for (l = 1; l <= 4; l++) {
	      if ((unsigned long)l >= 32 || ((1L << l) & atset) == 0) {
		if (con1 && l == 1 && (0x4 & atset) != 0)
		  printf("cofima-warning: atom %s not connected to %s of %s %ld\n",
			 el[1], el[2], atom[j - 1].resnam,
			 atom[j - 1].resnum);
		else if (l < 4)
		  printf("cofima-warning: atom %s not found in %s %ld\n",
			 el[l], atom[j - 1].resnam, atom[j - 1].resnum);
		else if (con4 && (0x8 & atset) != 0)
		  printf("cofima-warning: atom %s not connected to %s of %s %ld\n",
			 at4, el[3], atom[j - 1].resnam, atom[j - 1].resnum);
		else
		  printf("cofima-warning: atom %s not found in %s %ld\n",
			 at4, atom[j - 1].resnam, atom[j - 1].resnum);
	      }
	    }
	  }
	}
      }
      if (*at4 == '\0')
	j = i + (atset == 0xe) + 1;
      else
	j = i + (atset == 0x1e) + 1;
    } while (j <= nat);
    printf("        ...%ld atoms attached\n", nat - natold);
  } else
    errmsg("less than four atoms specified");
_L9: ;
}

#undef deftau


Static Void copy_()
{
  /* copy one atom to another location,    */
  /* e.g. to another residue               */
  long i, i1, i2, i3, r1, r2;
  CORCONdata at;
  long SET[maxel / 32 + 2];
  Char STR1[201];
  Char STR2[116];
  Char STR3[122];
  long SET1[maxel / 32 + 2];
  CORCONdata *WITH;
  Char STR5[256];
  Char STR6[220];

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel < 3) {
    errmsg("missing parameter");
    goto _L9;
  }
  if (nel > 5) {
    errmsg("too many parameters");
    goto _L9;
  }
  if (!(el[0][0] == '%' || el[0][0] == '*' || isalpha(el[0][0]))) {
    sprintf(STR2, "illegal atom type specification \\%s\\", el[0]);
    errmsg(STR2);
    goto _L9;
  }
  /*PGr1 = atol(el[1]);*/
  err=(sscanf(el[1],"%ld",&r1)!=1);
  if (err) {
    sprintf(STR3, "illegal residue number specification \\%s\\", el[1]);
    errmsg(STR3);
    goto _L9;
  }
  if (!(el[2][0] == '%' || el[2][0] == '*' || isalpha(el[2][0]))) {
    nel++;
    for (i = nel; i >= 4; i--)
      strcpy(el[i - 1], el[i - 2]);
    strcpy(el[2], el[0]);
  }
  if (strpos3("%", el[0], 1) + strpos3("*", el[0], 1) +
      strpos3("%", el[2], 1) + strpos3("*", el[2], 1) > 0) {
    errmsg("illegal use of wildcards");
    goto _L9;
  }
  /*PGr2 = atol(el[3]);*/
  err=(sscanf(el[3],"%ld",&r2)!=1);
  if (err) {
    sprintf(STR3, "illegal residue number specification \\%s\\", el[3]);
    errmsg(STR3);
    goto _L9;
  }
  if (*P_setint(SET1, P_expset(SET, 0x1eL), inv) != 0L) {
    errmsg("illegal use of NOT operator");
    goto _L9;
  }
  if (nel == 5) {
    if (!(el[4][0] == '%' || el[4][0] == '*' || isalpha(el[4][0]))) {
      sprintf(STR2, "illegal atom type specification \\%s\\", el[4]);
      errmsg(STR2);
      goto _L9;
    }
    if (P_inset(5, inv)) {
      errmsg("illegal use of NOT operator");
      goto _L9;
    }
  }
  i = 1;
  i1 = 0;
  i2 = 0;
  i3 = 0;
  atom[nat].resnum = -9999;
  while (i <= nat && (i1 == 0 || i2 == 0 || i3 == 0)) {
    WITH = &atom[i - 1];
    if (WITH->resnum == r1) {
      if (!strcmp(WITH->atnam, el[0]))
	i1 = i;
    }
    if (WITH->resnum == r2) {
      if (atom[i].resnum != r2)
	i2 = i + 1;
      if (nel == 5) {
	if (!strcmp(WITH->atnam, el[4]))
	  i3 = i + 1;
      }
    }
    i++;
  }
  if (i1 == 0) {
    sprintf(STR5, "atom %s not found in residue %s",
	    el[0], IntStr(STR1, r1, 0));
    errmsg(STR5);
    goto _L9;
  }
  if (i2 == 0) {
    sprintf(STR6, "residue %s not found", IntStr(STR1, r2, 0));
    errmsg(STR6);
    goto _L9;
  }
  if (i3 == 0 && nel == 5)
    printf("cofima-warning: atom %s not found in residue %ld\n", el[4], r1);
  else if (nel == 5)
    i2 = i3;
  nat++;
  at = atom[i1 - 1];
  for (i = nat; i > i2; i--)
    atom[i - 1] = atom[i - 2];
  atom[i2 - 1] = at;
  WITH = &atom[i2 - 1];
  WITH->atnum = 0;
  WITH->resnum = atom[i2 - 2].resnum;
  strcpy(WITH->resnam, atom[i2 - 2].resnam);
  strcpy(WITH->atnam, el[2]);
  printf("        ...atom %s of %s %ld copied to %s of %s %ld (inserted after %s)\n",
	 el[0], atom[i1 - 1].resnam, atom[i1 - 1].resnum, el[2],
	 atom[i2 - 1].resnam, atom[i2 - 1].resnum, atom[i2 - 2].atnam);
_L9: ;
}


/* list           list file name, residue, atom and angle types
   coordinates    list coordinates and connectivities
   constraints    list distance and angle constraints
   distances      list interatomic distances and distance constraints
   angles         list bond, dihedral and relative dihedral angles    */


Static Void list()
{
  /* list residue and atom types           */
  long i, j, k, na, nr, naty, nrty;
  boolean m;
  Char aty[maxnat][6], rty[maxnat][6];
  boolean flag1[maxnat];
  long FORLIM;
  Char STR2[116];
  Char STR3[201], STR4[201];
  CORCONdata *WITH;
  ACOdata *WITH1;
  DCOdata *WITH2;

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  FORLIM = nel;
  for (i = 0; i < FORLIM; i++) {
    if (el[i][0] == '%' || el[i][0] == '*' || isalpha(el[i][0])) {
      sprintf(STR2, "no %s type specification allowed here", item);
      errmsg(STR2);
      goto _L9;
    }
  }
  if (mode == cfm) {
    fprintf(out, "        coordinate file: %s",
	    CoreStr(STR4, 80L, inpfile));
    setflag();
    if (error)
      goto _L9;
    na = 0;
    nr = 0;
    naty = 0;
    nrty = 0;
    FORLIM = nat;
    for (i = 1; i <= FORLIM; i++) {
      if (flag[i - 1]) {
	WITH = &atom[i - 1];
	na++;
	if (i == 1)
	  nr = 1;
	else if (WITH->resnum != atom[i - 2].resnum)
	  nr++;
	m = false;
	for (j = 0; j < naty; j++)
	  m = (m || !strcmp(aty[j], WITH->atnam));
	if (!m) {
	  if (naty == 0) {
	    naty = 1;
	    strcpy(aty[0], WITH->atnam);
	  } else {
	    j = 1;
	    while (j < naty && strcmp(aty[j - 1], WITH->atnam) <= 0)
	      j++;
	    if (strcmp(aty[j - 1], WITH->atnam) <= 0)
	      j++;
	    for (k = naty; k >= j; k--)
	      strcpy(aty[k], aty[k - 1]);
	    naty++;
	    strcpy(aty[j - 1], WITH->atnam);
	  }
	}
	m = false;
	for (j = 0; j < nrty; j++)
	  m = (m || !strcmp(rty[j], WITH->resnam));
	if (!m) {
	  if (nrty == 0) {
	    nrty = 1;
	    strcpy(rty[0], WITH->resnam);
	  } else {
	    j = 1;
	    while (j < nrty && strcmp(rty[j - 1], WITH->resnam) <= 0)
	      j++;
	    if (strcmp(rty[j - 1], WITH->resnam) <= 0)
	      j++;
	    for (k = nrty; k >= j; k--)
	      strcpy(rty[k], rty[k - 1]);
	    nrty++;
	    strcpy(rty[j - 1], WITH->resnam);
	  }
	}
      }
    }
    fprintf(out, ", %ld atoms, %ld residues", na, nr);
  } else if (mode == acm) {
    fprintf(out, "        angle constraint file: %s",
	    CoreStr(STR4, 80L, inpfile));
    setflag();
    if (error)
      goto _L9;
    na = 0;
    nr = 0;
    naty = 0;
    nrty = 0;
    FORLIM = nat;
    for (i = 1; i <= FORLIM; i++) {
      if (flag[i - 1]) {
	WITH1 = &aconstr[i - 1];
	na++;
	if (i == 1)
	  nr = 1;
	else if (WITH1->resnum != aconstr[i - 2].resnum)
	  nr++;
	m = false;
	for (j = 0; j < naty; j++)
	  m = (m || !strcmp(aty[j], WITH1->angnam));
	if (!m) {
	  if (naty == 0) {
	    naty = 1;
	    strcpy(aty[0], WITH1->angnam);
	  } else {
	    j = 1;
	    while (j < naty && strcmp(aty[j - 1], WITH1->angnam) <= 0)
	      j++;
	    if (strcmp(aty[j - 1], WITH1->angnam) <= 0)
	      j++;
	    for (k = naty; k >= j; k--)
	      strcpy(aty[k], aty[k - 1]);
	    naty++;
	    strcpy(aty[j - 1], WITH1->angnam);
	  }
	}
	m = false;
	for (j = 0; j < nrty; j++)
	  m = (m || !strcmp(rty[j], WITH1->resnam));
	if (!m) {
	  if (nrty == 0) {
	    nrty = 1;
	    strcpy(rty[0], WITH1->resnam);
	  } else {
	    j = 1;
	    while (j < nrty && strcmp(rty[j - 1], WITH1->resnam) <= 0)
	      j++;
	    if (strcmp(rty[j - 1], WITH1->resnam) <= 0)
	      j++;
	    for (k = nrty; k >= j; k--)
	      strcpy(rty[k], rty[k - 1]);
	    nrty++;
	    strcpy(rty[j - 1], WITH1->resnam);
	  }
	}
      }
    }
    fprintf(out, ", %ld constraints", na);
  } else {
    fprintf(out, "        distance constraint file: %s",
	    CoreStr(STR4, 80L, inpfile));
    first = true;
    setflag();
    if (error)
      goto _L9;
    memcpy(flag1, flag, (long)maxnat);
    first = false;
    setflag();
    if (error)
      goto _L9;
    na = 0;
    naty = 0;
    nrty = 0;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (flag1[i] && flag[i]) {
	WITH2 = &constr[i];
	na++;
	m = false;
	for (j = 0; j < naty; j++)
	  m = (m || !strcmp(aty[j], WITH2->atnam1));
	if (!m) {
	  if (naty == 0) {
	    naty = 1;
	    strcpy(aty[0], WITH2->atnam1);
	  } else {
	    j = 1;
	    while (j < naty && strcmp(aty[j - 1], WITH2->atnam1) <= 0)
	      j++;
	    if (strcmp(aty[j - 1], WITH2->atnam1) <= 0)
	      j++;
	    for (k = naty; k >= j; k--)
	      strcpy(aty[k], aty[k - 1]);
	    naty++;
	    strcpy(aty[j - 1], WITH2->atnam1);
	  }
	}
	m = false;
	for (j = 0; j < naty; j++)
	  m = (m || !strcmp(aty[j], WITH2->atnam2));
	if (!m) {
	  if (naty == 0) {
	    naty = 1;
	    strcpy(aty[0], WITH2->atnam2);
	  } else {
	    j = 1;
	    while (j < naty && strcmp(aty[j - 1], WITH2->atnam2) <= 0)
	      j++;
	    if (strcmp(aty[j - 1], WITH2->atnam2) <= 0)
	      j++;
	    for (k = naty; k >= j; k--)
	      strcpy(aty[k], aty[k - 1]);
	    naty++;
	    strcpy(aty[j - 1], WITH2->atnam2);
	  }
	}
	m = false;
	for (j = 0; j < nrty; j++)
	  m = (m || !strcmp(rty[j], WITH2->resnam1));
	if (!m) {
	  if (nrty == 0) {
	    nrty = 1;
	    strcpy(rty[0], WITH2->resnam1);
	  } else {
	    j = 1;
	    while (j < nrty && strcmp(rty[j - 1], WITH2->resnam1) <= 0)
	      j++;
	    if (strcmp(rty[j - 1], WITH2->resnam1) <= 0)
	      j++;
	    for (k = nrty; k >= j; k--)
	      strcpy(rty[k], rty[k - 1]);
	    nrty++;
	    strcpy(rty[j - 1], WITH2->resnam1);
	  }
	}
	m = false;
	for (j = 0; j < nrty; j++)
	  m = (m || !strcmp(rty[j], WITH2->resnam2));
	if (!m) {
	  if (nrty == 0) {
	    nrty = 1;
	    strcpy(rty[0], WITH2->resnam2);
	  } else {
	    j = 1;
	    while (j < nrty && strcmp(rty[j - 1], WITH2->resnam2) <= 0)
	      j++;
	    if (strcmp(rty[j - 1], WITH2->resnam2) <= 0)
	      j++;
	    for (k = nrty; k >= j; k--)
	      strcpy(rty[k], rty[k - 1]);
	    nrty++;
	    strcpy(rty[j - 1], WITH2->resnam2);
	  }
	}
      }
    }
    fprintf(out, ", %ld constraints", na);
  }
  if (nel == 0)
    fprintf(out, ":\n");
  else
    fprintf(out, " in current range:\n");
  fprintf(out, "        %ld residue types:\n", nrty);
  k = 0;
  for (j = 1; j <= nrty; j++) {
    if (k == 0)
      fprintf(out, "        ");
    fputs(Adjust(STR3, 5L, rty[j - 1], 6L), out);
    if (j == nrty)
      putc('\n', out);
    else if (k == 9) {
      putc('\n', out);
      k = 0;
    } else
      k++;
  }
  if (mode == acm)
    fprintf(out, "        %ld angle types:\n", naty);
  else
    fprintf(out, "        %ld atom types:\n", naty);
  k = 0;
  for (j = 1; j <= naty; j++) {
    if (k == 0)
      fprintf(out, "        ");
    fputs(Adjust(STR3, 5L, aty[j - 1], 6L), out);
    if (j == naty)
      putc('\n', out);
    else if (aty[j - 1][0] != aty[j][0] || k == 9) {
      putc('\n', out);
      k = 0;
    } else
      k++;
  }
  if (!rd)
    putc('\n', out);
_L9: ;
}


Static Void coordinates()
{
  /* list coordinates and, if present, con-*/
  /* nectivities of certain atoms          */
  long i, j, k, n1;
  boolean b;
  boolean del[maxnat];
  Char s[201];
  long SET[9], SET1[9];
  long FORLIM;
  CORCONdata *WITH;
  Char STR2[201];
  Char *TEMP;
  Char STR3[201];
  CORCONdata *WITH1;

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel < 1) {
    strcpy(el[0], "*");
    nel = 1;
  }
  setflag();
  if (error)
    goto _L9;
  n1 = 1;
  while ((el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	  isalpha(el[n1 - 1][0])) && n1 < nel)
    n1++;
  if (!(el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	isalpha(el[n1 - 1][0])))
    n1--;
  b = (*P_setdiff(SET1, P_addsetr(P_expset(SET, 0L), 1, (int)n1), inv) == 0L);
  FORLIM = nat;
  for (i = 0; i < FORLIM; i++)
    del[i] = false;
  FORLIM = nat;
  for (i = 0; i < FORLIM; i++) {
    if (flag[i]) {
      WITH = &atom[i];
      del[i] = b;
      for (j = 1; j <= n1; j++) {
	if (!P_inset((int)j, inv))
	  del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH->atnam));
      }
      for (j = 1; j <= n1; j++) {
	if (P_inset((int)j, inv))
	  del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH->atnam));
      }
    }
  }
  j = 0;
  adjust_atnum();
  FORLIM = nat;
  for (i = 0; i < FORLIM; i++) {
    if (del[i]) {
      WITH = &atom[i];
      j++;
      if (!rd && j % 23 == 0) {
/* p2c: cofima.pas, line 1639:
 * Note: Using % for possibly-negative arguments [317] */
	if (j == 23)
	  putc('\n', out);
	printf("        press RETURN to continue, q to stop ");
	TEMP = fgets(s, 201, stdin);
	TEMP = strchr(s, '\n');
	if (TEMP != NULL)
	  *TEMP = 0;
	putchar('\n');
	if (*s != '\0') {
	  j--;
	  goto _L5;
	}
      }
      fprintf(out, "        %s%3ld%5s%9.3f%9.3f%9.3f ",
	      Adjust(STR2, 5L, WITH->resnam, 4L), WITH->resnum,
	      Adjust(STR3, 5L, WITH->atnam, 4L), WITH->x[0], WITH->x[1],
	      WITH->x[2]);
      if (connected) {
	for (k = 0; k <= 3; k++) {
	  if (WITH->con[k] > 0) {
	    WITH1 = &atom[WITH->con[k] - 1];
	    if (WITH1->resnum == atom[i].resnum)
	      fprintf(out, " %s", Adjust(STR2, 5L, WITH1->atnam, 5L));
	    else
	      fprintf(out, " %s[%ld]%*s",
		      WITH1->atnam, WITH1->resnum, WITH1->resnum < 10, "");
	  }
	}
      }
      putc('\n', out);
    }
  }
_L5:
  if (!rd && (unsigned long)j < 32 && ((1L << j) & 0x7ffffeL) != 0)
    putc('\n', out);
  if (connected)
    printf("        ...coordinates and connectivities of %ld atoms listed\n",
	   j);
  else
    printf("        ...coordinates of %ld atoms listed\n", j);
  if (rd)
    printf("           (output redirected to the file %s)\n", outfile);
_L9: ;
}


Static Void constraints()
{
  /* list distance or angle constraints    */
  long i, j, n1;
  boolean b;
  boolean del[maxnat], del1[maxnat];
  Char s[201];
  long SET[9], SET1[9];
  long FORLIM;
  ACOdata *WITH;
  Char STR1[201], STR2[201];
  Char *TEMP;
  Char STR3[201], STR4[201];
  DCOdata *WITH1;

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel < 1) {
    strcpy(el[0], "*");
    nel = 1;
  }
  n1 = 1;
  while ((el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	  isalpha(el[n1 - 1][0])) && n1 < nel)
    n1++;
  if (!(el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	isalpha(el[n1 - 1][0])))
    n1--;
  if (mode == acm) {
    setflag();
    if (error)
      goto _L9;
    b = (*P_setdiff(SET1, P_addsetr(P_expset(SET, 0L), 1, (int)n1), inv) == 0L);
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      del[i] = false;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (flag[i]) {
	WITH = &aconstr[i];
	del[i] = b;
	for (j = 1; j <= n1; j++) {
	  if (!P_inset((int)j, inv))
	    del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH->angnam));
	}
	for (j = 1; j <= n1; j++) {
	  if (P_inset((int)j, inv))
	    del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH->angnam));
	}
      }
    }
    j = 0;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (del[i]) {
	WITH = &aconstr[i];
	j++;
	if (!rd && j % 23 == 0) {
/* p2c: cofima.pas, line 1680:
 * Note: Using % for possibly-negative arguments [317] */
	  if (j == 23)
	    putc('\n', out);
	  printf("        press RETURN to continue, q to stop ");
	  TEMP = fgets(s, 201, stdin);
	  TEMP = strchr(s, '\n');
	  if (TEMP != NULL)
	    *TEMP = 0;
	  putchar('\n');
	  if (*s != '\0') {
	    j--;
	    goto _L5;
	  }
	}
	fprintf(out, "        %s%4ld%6s%8.1f...%6.1f\n",
		Adjust(STR2, 5L, WITH->resnam, 5L), WITH->resnum,
		Adjust(STR3, 5L, WITH->angnam, 5L), WITH->lol, WITH->upl);
      }
    }
  } else if (mode == dfm) {
    first = true;
    setflag();
    if (error)
      goto _L9;
    b = (*P_setdiff(SET1, P_addsetr(P_expset(SET, 0L), 1, (int)n1), inv) == 0L);
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      del[i] = false;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (flag[i]) {
	WITH1 = &constr[i];
	del[i] = b;
	for (j = 1; j <= n1; j++) {
	  if (!P_inset((int)j, inv))
	    del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH1->atnam1));
	}
	for (j = 1; j <= n1; j++) {
	  if (P_inset((int)j, inv))
	    del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH1->atnam1));
	}
      }
    }
    first = false;
    setflag();
    if (error)
      goto _L9;
    b = (*P_setdiff(SET1, P_addsetr(P_expset(SET, 0L), 1, (int)n1), inv) == 0L);
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      del1[i] = false;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (flag[i]) {
	WITH1 = &constr[i];
	del1[i] = b;
	for (j = 1; j <= n1; j++) {
	  if (!P_inset((int)j, inv))
	    del1[i] = (del1[i] || Match(80L, el[j - 1], 5L, WITH1->atnam2));
	}
	for (j = 1; j <= n1; j++) {
	  if (P_inset((int)j, inv))
	    del1[i] = (del1[i] && !Match(80L, el[j - 1], 5L, WITH1->atnam2));
	}
      }
    }
    j = 0;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (del[i] || del1[i]) {
	WITH1 = &constr[i];
	j++;
	if (!rd && j % 23 == 0) {
/* p2c: cofima.pas, line 1710:
 * Note: Using % for possibly-negative arguments [317] */
	  if (j == 23)
	    putc('\n', out);
	  printf("        press RETURN to continue, q to stop ");
	  TEMP = fgets(s, 201, stdin);
	  TEMP = strchr(s, '\n');
	  if (TEMP != NULL)
	    *TEMP = 0;
	  putchar('\n');
	  if (*s != '\0') {
	    j--;
	    goto _L5;
	  }
	}
	fprintf(out, "        %6s%3ld%5s%6s%3ld%5s%6.1f\n",
		Adjust(STR2, 5L, WITH1->resnam1, 5L), WITH1->resnum1,
		Adjust(STR3, 5L, WITH1->atnam1, 4L),
		Adjust(STR1, 5L, WITH1->resnam2, 5L), WITH1->resnum2,
		Adjust(STR4, 5L, WITH1->atnam2, 4L), WITH1->lim);
      }
    }
  }
_L5:
  if (!rd && (unsigned long)j < 32 && ((1L << j) & 0x7ffffeL) != 0)
    putc('\n', out);
  if (mode == acm)
    printf("        ...%ld angle constraints listed\n", j);
  else
    printf("        ...%ld distance constraints listed\n", j);
  if (rd)
    printf("           (output redirected to the file %s)\n", outfile);
_L9: ;
}


float ran0(idum)
long *idum;
{
	long k;
	float ans;

	*idum ^= 123459876;
	k=(*idum)/127773;
	*idum=16807*(*idum-k*127773)-2836*k;
	if (*idum < 0) *idum += 2147483647;
	ans=(*idum)/2147483647.0;
	*idum ^= 123459876;
	return ans;
}


Static Void distances(action)
int action;
{
  /* list distances between atoms          */
  long i, i2, j, k, l, n1, n2, nel0, nel1;
  boolean b;
  Char s[201];
  Elementlist el0, el1;
  boolean flag1[maxnat], del[maxnat], done[maxnat];
  long SET[maxel / 32 + 2];
  long FORLIM;
  long SET1[maxel / 32 + 2];
  long SET2[9];
  CORCONdata *WITH;
  long FORLIM1;
  long SET3[9];
  Char *TEMP;
  DCOdata *WITH1;
  float dupl = 1000000.0;
  float dlol = 0.0;
  float d;
  float offset = 0.0;
  float limit[6];
  int nlim = 0;
  int urange =  100000;
  int lrange = -100000;
  int range, nat_dfm0;
  char typ;
  char STR2[100], STR4[100];
  int nran;
  static long seed = 3771;
  float prob = 2.0;

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel < 2) {
    errmsg("missing parameter");
    goto _L9;
  }
  do {
    j = nel - 1;
    if (el[j][0] == 'd' && el[j][1] == '<') {
      i = sscanf(&el[j][2], "%f", &dupl); }
    else if (el[j][0] == 'd' && el[j][1] == '>') {
      i = sscanf(&el[j][2], "%f", &dlol); }
    else if (el[j][0] == 'r' && el[j][1] == '<') {
      i = sscanf(&el[j][2], "%d", &urange); }
    else if (el[j][0] == 'r' && el[j][1] == '>') {
      i = sscanf(&el[j][2], "%d", &lrange); }
    else if (el[j][0] == 'r' && el[j][1] == '=') {
      i = sscanf(&el[j][2], "%d", &urange); 
      lrange = urange - 1; urange++; }
    else if (el[j][0] == 'l' && el[j][1] == '=') {
      i = sscanf(&el[j][2], "%f", &offset); }
    else if (el[j][0] == 'l' && (el[j][1] == '<' || el[j][1] == '>')) {
      typ = el[j][1];
      l = strlen(&el[j][2]); nlim = 1;
      for (i = 0; i < l; i++) if (el[j][2+i] == ',') nlim++;
      switch (nlim) {
	case 1: i = sscanf(&el[j][2], "%f", &limit[0]); break;
	case 2: i = sscanf(&el[j][2], "%f,%f", &limit[0], &limit[1]); break;
	case 3: i = sscanf(&el[j][2], "%f,%f,%f", &limit[0], &limit[1], &limit[2]); break;
	case 4: i = sscanf(&el[j][2], "%f,%f,%f,%f", 
			   &limit[0], &limit[1], &limit[2], &limit[3]); break;
	case 5: i = sscanf(&el[j][2], "%f,%f,%f,%f,%f", 
			   &limit[0], &limit[1], &limit[2], &limit[3], &limit[4]); break;
	case 6: i = sscanf(&el[j][2], "%f,%f,%f,%f,%f,%f", 
			   &limit[0], &limit[1], &limit[2], &limit[3], &limit[4], &limit[5]); 
		break;
	default: i = 0; break; }
      if (i == nlim) i = 1; else i = 0; }
    else if (el[j][0] == 'p' && el[j][1] == '=') {
      l = strlen(&el[j][2]); nran = 1;
      for (i = 0; i < l; i++) if (el[j][2+i] == ',') nran++;
      switch (nran) {
	case 1: i = sscanf(&el[j][2], "%f", &prob); break;
	case 2: i = sscanf(&el[j][2], "%f,%ld", &prob, &seed); break;
	default: i = 0; break; }
      if (i == nran) i = 1; else i = 0;
      }
    else break; 
    if (i != 1) {
      sprintf(s, "illegal distance, residue number, or limit condition \"%s\"", el[j]);
      errmsg(s); goto _L9; }
    nel = j; }
  while (nel > 0);
  n1 = 1;
  while ((el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	  isalpha(el[n1 - 1][0])) && n1 < nel)
    n1++;
  if (!(el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	isalpha(el[n1 - 1][0])))
    n1--;
  if (n1 < 1) {
    errmsg("first atom type specification missing");
    goto _L9;
  }
  if (n1 > 2) {
    errmsg("more than two atom types specified");
    goto _L9;
  }
  memcpy(el1, el, sizeof(Elementlist));
  nel1 = nel;
  n2 = 2;
  while (!(el[n2 - 1][0] == '%' || el[n2 - 1][0] == '*' ||
	   isalpha(el[n2 - 1][0])) && n2 < nel)
    n2++;
  if (el[n2 - 1][0] == '%' || el[n2 - 1][0] == '*' || isalpha(el[n2 - 1][0]))
    n2--;
  if (n2 == nel) {
    errmsg("second atom type specification missing");
    goto _L9;
  }
  nel = n2;
  nel1 -= nel;
  for (i = 0; i < nel1; i++)
    strcpy(el1[i], el[i + nel]);
  n1 = 1;
  while ((el1[n1 - 1][0] == '%' || el1[n1 - 1][0] == '*' ||
	  isalpha(el1[n1 - 1][0])) && n1 < nel1)
    n1++;
  if (!(el1[n1 - 1][0] == '%' || el1[n1 - 1][0] == '*' ||
	isalpha(el1[n1 - 1][0])))
    n1--;
  if (n1 < 1) {
    errmsg("second atom type specification missing");
    goto _L9;
  }
  if (n1 > 2) {
    errmsg("more than two atom types specified");
    goto _L9;
  }
  if (mode == cfm) {
    setflag();
    if (error)
      goto _L9;
    b = (*P_setdiff(SET1, P_expset(SET, 0x2L), inv) == 0L);
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      del[i] = false;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (flag[i]) {
	WITH = &atom[i];
	del[i] = b;
	for (j = 1; j <= n1; j++) {
	  if (!P_inset((int)j, inv))
	    del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH->atnam));
	}
	for (j = 1; j <= n1; j++) {
	  if (P_inset((int)j, inv))
	    del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH->atnam));
	}
      }
    }
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      flag1[i] = (flag[i] && del[i]);
    memcpy(el, el1, sizeof(Elementlist));
    nel = nel1;
    setflag();
    if (error)
      goto _L9;
    b = (*P_setdiff(SET3, P_addset(P_expset(SET2, 0L), (int)(n2 + 1)), inv) ==
	 0L);
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      del[i] = false;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (flag[i]) {
	WITH = &atom[i];
	del[i] = b;
	for (j = 1; j <= n1; j++) {
	  if (!P_inset((int)j, inv))
	    del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH->atnam));
	}
	for (j = 1; j <= n1; j++) {
	  if (P_inset((int)j, inv))
	    del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH->atnam));
	}
      }
    }
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      flag[i] = (flag[i] && del[i]);
    j = 0; nat_dfm0 = nat_dfm;
    FORLIM = nat;
    for (i = 1; i <= FORLIM; i++) {
      if (flag1[i - 1]) {
	WITH = &atom[i - 1];
	FORLIM1 = nat;
	for (i2 = 0; i2 < FORLIM1; i2++) {
          d = dist(WITH->x, atom[i2].x); 
          range = atom[i2].resnum - WITH->resnum;
	  if (flag[i2] && i2 + 1 != i && 
              d > dlol && d < dupl && range > lrange && range < urange &&
              ran0(&seed) <= prob) {
	    j++;
            if (action == 0) {
	      if (!rd && j % 23 == 0) {
/* p2c: cofima.pas, line 1771:
 * Note: Using % for possibly-negative arguments [317] */
	        if (j == 23)
		  putc('\n', out);
	        printf("        press RETURN to continue, q to stop ");
	        TEMP = fgets(s, 201, stdin);
	        TEMP = strchr(s, '\n');
	        if (TEMP != NULL)
		  *TEMP = 0;
	        putchar('\n');
	        if (*s != '\0') {
		  j--;
		  goto _L5;
	        }
	      }
	      fprintf(out, "        distance (%s[%s %ld],%s[%s %ld]) = %8.4f\n",
		      WITH->atnam, WITH->resnam, WITH->resnum, atom[i2].atnam,
		      atom[i2].resnam, atom[i2].resnum,
		      d);
	    } else {
	      if (nat_dfm >= maxnat) {
      		sprintf(STR4, "too many distance constraints (maximum: %s)",
	                IntStr(STR2, (long)maxnat, 0L));
      		errmsg(STR4); nat_dfm = nat_dfm0;
    		goto _L9;
	      }
	      constr[nat_dfm].resnum1 = WITH->resnum;
	      constr[nat_dfm].resnum2 = atom[i2].resnum;
	      strcpy(constr[nat_dfm].atnam1, WITH->atnam);
	      strcpy(constr[nat_dfm].resnam1, WITH->resnam);
	      strcpy(constr[nat_dfm].atnam2, atom[i2].atnam);
	      strcpy(constr[nat_dfm].resnam2, atom[i2].resnam);
	      if (nlim == 0) constr[nat_dfm].lim = d + offset; 
	      else if (typ == '<') {
		for (l = 0; l < nlim; l++) if (limit[l] >= d + offset) break;
		if (l == nlim) { j--; continue; }
		constr[nat_dfm].lim = limit[l];
	      } else {
		for (l = nlim - 1; l >= 0; l--) if (limit[l] <= d + offset) break;
		if (l == -1) { j--; continue; }
		constr[nat_dfm].lim = limit[l];
	      }
	      constr[nat_dfm].comment[0] = '\0';
	      nat_dfm++; nst_dfm = 1;
	    }
	  }
	}
      }
    }
  } else {  /* list distance constraints */
    first = true;
    setflag();
    if (error)
      goto _L9;
    b = (*P_setdiff(SET1, P_expset(SET, 0x2L), inv) == 0L);
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      del[i] = false;
    memcpy(done, del, (long)maxnat);
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (flag[i]) {
	WITH1 = &constr[i];
	del[i] = b;
	for (k = 1; k <= n1; k++) {
	  if (!P_inset((int)k, inv))
	    del[i] = (del[i] || Match(80L, el[k - 1], 5L, WITH1->atnam1));
	}
	for (k = 1; k <= n1; k++) {
	  if (P_inset((int)k, inv))
	    del[i] = (del[i] && !Match(80L, el[k - 1], 5L, WITH1->atnam1));
	}
      }
    }
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      flag1[i] = (flag[i] && del[i]);
    memcpy(el0, el, sizeof(Elementlist));
    nel0 = nel;
    memcpy(el, el1, sizeof(Elementlist));
    nel = nel1;
    first = false;
    setflag();
    if (error)
      goto _L9;
    b = (*P_setdiff(SET3, P_addset(P_expset(SET2, 0L), (int)(n2 + 1)), inv) ==
	 0L);
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      del[i] = false;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (flag[i]) {
	WITH1 = &constr[i];
	del[i] = b;
	for (k = 1; k <= n1; k++) {
	  if (!P_inset((int)k, inv))
	    del[i] = (del[i] || Match(80L, el[k - 1], 5L, WITH1->atnam2));
	}
	for (k = 1; k <= n1; k++) {
	  if (P_inset((int)k, inv))
	    del[i] = (del[i] && !Match(80L, el[k - 1], 5L, WITH1->atnam2));
	}
      }
    }
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      flag[i] = (flag[i] && del[i]);
      done[i] = false;
    }
    j = 0;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      d = constr[i].lim; range = constr[i].resnum2 - constr[i].resnum1;
      if (flag1[i] && flag[i] &&
          d > dlol && d < dupl && range > lrange && range < urange &&
          ran0(&seed) <= prob) {
	done[i] = true;
	if (action == 0) {
	  WITH1 = &constr[i];
	  j++;
	  if (!rd && j % 23 == 0) {
/* p2c: cofima.pas, line 1805:
 * Note: Using % for possibly-negative arguments [317] */
	    if (j == 23) putc('\n', out);
	    printf("        press RETURN to continue, q to stop ");
	    TEMP = fgets(s, 201, stdin);
	    TEMP = strchr(s, '\n');
	    if (TEMP != NULL) *TEMP = 0;
	    putchar('\n');
	    if (*s != '\0') { j--; goto _L5; }
	  }
	  fprintf(out,
		  "        distance limit (%s[%s %ld],%s[%s %ld]) = %5.1f\n",
		  WITH1->atnam1, WITH1->resnam1, WITH1->resnum1, WITH1->atnam2,
		  WITH1->resnam2, WITH1->resnum2, WITH1->lim);
	}
      }
    }
    memcpy(el, el0, sizeof(Elementlist));
    nel = nel0;
    first = false;
    setflag();
    if (error)
      goto _L9;
    b = (*P_setdiff(SET1, P_expset(SET, 0x2L), inv) == 0L);
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      del[i] = false;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (flag[i]) {
	WITH1 = &constr[i];
	del[i] = b;
	for (k = 1; k <= n1; k++) {
	  if (!P_inset((int)k, inv))
	    del[i] = (del[i] || Match(80L, el[k - 1], 5L, WITH1->atnam2));
	}
	for (k = 1; k <= n1; k++) {
	  if (P_inset((int)k, inv))
	    del[i] = (del[i] && !Match(80L, el[k - 1], 5L, WITH1->atnam2));
	}
      }
    }
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      flag1[i] = (flag[i] && del[i]);
    memcpy(el, el1, sizeof(Elementlist));
    nel = nel1;
    first = true;
    setflag();
    if (error)
      goto _L9;
    b = (*P_setdiff(SET3, P_addset(P_expset(SET2, 0L), (int)(n2 + 1)), inv) ==
	 0L);
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      del[i] = false;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (flag[i]) {
	WITH1 = &constr[i];
	del[i] = b;
	for (k = 1; k <= n1; k++) {
	  if (!P_inset((int)k, inv))
	    del[i] = (del[i] || Match(80L, el[k - 1], 5L, WITH1->atnam1));
	}
	for (k = 1; k <= n1; k++) {
	  if (P_inset((int)k, inv))
	    del[i] = (del[i] && !Match(80L, el[k - 1], 5L, WITH1->atnam1));
	}
      }
    }
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      flag[i] = (flag[i] && del[i]);
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      d = constr[i].lim; range = constr[i].resnum2 - constr[i].resnum1;
      if (flag1[i] && flag[i] && !done[i] &&
          d > dlol && d < dupl && range > lrange && range < urange &&
          ran0(&seed) <= prob) {
	done[i] = true;
	if (action == 0) {
	  WITH1 = &constr[i];
	  j++;
	  if (!rd && j % 23 == 0) {
/* p2c: cofima.pas, line 1836:
 * Note: Using % for possibly-negative arguments [317] */
	    if (j == 23)
	      putc('\n', out);
	    printf("        press RETURN to continue, q to stop ");
	    TEMP = fgets(s, 201, stdin);
	    TEMP = strchr(s, '\n');
	    if (TEMP != NULL)
	      *TEMP = 0;
	    putchar('\n');
	    if (*s != '\0') {
	      j--;
	      goto _L5;
	    }
	  }
	  fprintf(out,
	  	"        distance limit (%s[%s %ld],%s[%s %ld]) = %5.1f\n",
	  	WITH1->atnam2, WITH1->resnam2, WITH1->resnum2, WITH1->atnam1,
	  	WITH1->resnam1, WITH1->resnum1, WITH1->lim);
	}
      }
    }
    if (action != 0) {
      j = 0;
      for (i = 0; i < nat; i++) {
	if ((action == 2 && done[i]) || (action == 1 && !done[i])) {
	  j++; constr[j - 1] = constr[i];
	}
      }
      printf("        ...%ld distance constraints deleted\n", nat - j);
      nat = j;
      goto _L9;
    }
  }
_L5:
  if (!rd && (unsigned long)j < 32 && ((1L << j) & 0x7ffffeL) != 0)
    putc('\n', out);
  if (mode == cfm && action == 0)
    printf("        ...%ld interatomic distances listed\n", j);
  else if (mode == cfm && action != 0)
    printf("        ...%ld interatomic distances extracted\n", j);
  else
    printf("        ...%ld distance constraints listed\n", j);
  if (rd)
    printf("           (output redirected to the file %s)\n", outfile);
_L9: ;
}


Static Void angles()
{
  /* list bond, absolute and relative di-  */
  /* hedral angles                         */
  /* number of atom types on command line: */
  /*   3: bond angles                      */
  /*   4: absolute dihedral angles         */
  /*   5: relative dihedral angles         */
  long i, j, k, k0, k1, l;
  boolean dih, rel, con1, con3, con4, con5;
  Char s[201];
  Vector a[5];
  Char an[5][6];
  long anu[5];
  long atset;
  long SET[maxel / 32 + 2];
  Char STR1[201];
  Char STR2[242], STR3[242];
  Char STR4[116];
  CORCONdata *WITH, *WITH1;
  Char *TEMP;
  Vector TEMP1, TEMP2;

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel < 3) {
    errmsg("missing parameter");
    goto _L9;
  }
  if ((el[0][0] == '%' || el[0][0] == '*' || el[0][0] == '~' ||
       isalpha(el[0][0])) &&
      (el[1][0] == '%' || el[1][0] == '*' || el[1][0] == '~' ||
       isalpha(el[1][0])) &&
      (el[2][0] == '%' || el[2][0] == '*' || el[2][0] == '~' ||
       isalpha(el[2][0]))) {
/* p2c: cofima.pas, line 1954: Note:
 * Line breaker spent 0.6+2.63 seconds, 897 tries on line 4957 [251] */
    sprintf(STR2, "%s%s%s", el[0], el[1], el[2]);
    sprintf(STR3, "%s%s%s", el[0], el[1], el[2]);
    if (strpos3("%", STR2, 1) + strpos3("*", STR3, 1) > 0) {
      errmsg("illegal use of wildcards");
      goto _L9;
    }
    if (P_subset(P_expset(SET, 0xeL), inv)) {
      errmsg("illegal use of NOT operator");
      goto _L9;
    }
    if (!strcmp(el[0], "~")) {
      sprintf(STR4, "illegal atom type specification \\%s\\", el[0]);
      errmsg(STR4);
      goto _L9;
    }
    if (el[1][0] == '~') {
      sprintf(STR4, "illegal atom type specification \\%s\\", el[1]);
      errmsg(STR4);
      goto _L9;
    }
    if (!strcmp(el[2], "~")) {
      sprintf(STR4, "illegal atom type specification \\%s\\", el[2]);
      errmsg(STR4);
      goto _L9;
    }
    con1 = (el[0][0] == '~');
    if (con1)
      strcpy(el[0], Trailer(STR1, 80L, el[0], 2L));
    con3 = (el[2][0] == '~');
    if (con3)
      strcpy(el[2], Trailer(STR1, 80L, el[2], 2L));
    dih = false;
    rel = false;
    con4 = false;
    con5 = false;
    if (nel >= 4) {
      if (el[3][0] == '%' || el[3][0] == '*' || el[3][0] == '~' ||
	  isalpha(el[3][0]))
	dih = true;
    }
    if (dih) {
      if (strpos3("%", el[3], 1) + strpos3("*", el[3], 1) > 0) {
	errmsg("illegal use of wildcards");
	goto _L9;
      }
      if (P_inset(4, inv)) {
	errmsg("illegal use of NOT operator");
	goto _L9;
      }
      if (!strcmp(el[3], "~")) {
	sprintf(STR4, "illegal atom type specification \\%s\\", el[3]);
	errmsg(STR4);
	goto _L9;
      }
      con4 = (el[3][0] == '~');
      if (con4)
	strcpy(el[3], Trailer(STR1, 80L, el[3], 2L));
      con4 = (con4 || con3);
      if (nel >= 5) {
	if (el[4][0] == '%' || el[4][0] == '*' || el[4][0] == '~' ||
	    isalpha(el[4][0]))
	  rel = true;
      }
      if (rel) {
	if (strpos3("%", el[4], 1) + strpos3("*", el[4], 1) > 0) {
	  errmsg("illegal use of wildcards");
	  goto _L9;
	}
	if (P_inset(5, inv)) {
	  errmsg("illegal use of NOT operator");
	  goto _L9;
	}
	if (!strcmp(el[4], "~")) {
	  sprintf(STR4, "illegal atom type specification \\%s\\", el[4]);
	  errmsg(STR4);
	  goto _L9;
	}
	con5 = (el[4][0] == '~');
	if (con5)
	  strcpy(el[4], Trailer(STR1, 80L, el[4], 2L));
	con5 = (con5 || con3);
      } else
	con5 = false;
    }
    if (!connected && (con1 || con3 || con4 || con5)) {
      errmsg("connectivities missing");
      goto _L9;
    }
    setflag();
    if (error)
      goto _L9;
    adjust_atnum();
    j = 1;
    k1 = 0;
    do {
      i = j;
      while (i < nat && atom[i - 1].resnum == atom[j - 1].resnum)
	i++;
      if (atom[i - 1].resnum != atom[j - 1].resnum)
	i--;
      atset = 0;
      if (flag[j - 1]) {
	for (k = j; k <= i; k++) {
	  WITH = &atom[k - 1];
	  for (l = 1; l <= (long)dih + (long)rel + 3; l++) {
	    if (!strcmp(el[l - 1], WITH->atnam)) {
	      if (l == 1 && !con1 || l == 2 || l == 3 && !con3 ||
		  l == 4 && !con4 || l == 5 && !con5) {
		atset = ((long)atset) | (1L << ((int)l));
		memcpy(a[l - 1], WITH->x, sizeof(Vector));
		strcpy(an[l - 1], WITH->atnam);
		anu[l - 1] = k;
		if (l == 2)
		  k0 = k;
	      }
	    }
	  }
	}
	if ((0x4 & atset) != 0 && (con1 || con3)) {
	  WITH = &atom[anu[1] - 1];
	  for (l = 0; l <= 3; l++) {
	    if (WITH->con[l] > 0) {
	      WITH1 = &atom[WITH->con[l] - 1];
	      if (con1 && !strcmp(WITH1->atnam, el[0])) {
		atset |= 0x2;
		memcpy(a[0], WITH1->x, sizeof(Vector));
		strcpy(an[0], WITH1->atnam);
	      } else if (con3 && !strcmp(WITH1->atnam, el[2])) {
		atset |= 0x8;
		memcpy(a[2], WITH1->x, sizeof(Vector));
		strcpy(an[2], WITH1->atnam);
		anu[2] = WITH1->atnum;
	      }
	    }
	  }
	}
	if (dih && (0x8 & atset) != 0 && con4) {
	  WITH = &atom[anu[2] - 1];
	  for (l = 0; l <= 3; l++) {
	    if (WITH->con[l] > 0) {
	      WITH1 = &atom[WITH->con[l] - 1];
	      if (!strcmp(WITH1->atnam, el[3])) {
		atset |= 0x10;
		memcpy(a[3], WITH1->x, sizeof(Vector));
		strcpy(an[3], WITH1->atnam);
	      }
	    }
	  }
	}
	if (rel && (0x8 & atset) != 0 && con5) {
	  WITH = &atom[anu[2] - 1];
	  for (l = 0; l <= 3; l++) {
	    if (WITH->con[l] > 0) {
	      WITH1 = &atom[WITH->con[l] - 1];
	      if (!strcmp(WITH1->atnam, el[4])) {
		atset |= 0x20;
		memcpy(a[4], WITH1->x, sizeof(Vector));
		strcpy(an[4], WITH1->atnam);
	      }
	    }
	  }
	}
	if ((0xe & (~atset)) == 0 && dih == ((0x10 & atset) != 0) &&
	    rel == ((0x20 & atset) != 0)) {
	  k1++;
	  if (!rd && k1 % 23 == 0) {
/* p2c: cofima.pas, line 1926:
 * Note: Using % for possibly-negative arguments [317] */
	    if (k1 == 23)
	      putc('\n', out);
	    printf("        press RETURN to continue, q to stop ");
	    TEMP = fgets(s, 201, stdin);
	    TEMP = strchr(s, '\n');
	    if (TEMP != NULL)
	      *TEMP = 0;
	    putchar('\n');
	    if (*s != '\0') {
	      k1--;
	      goto _L5;
	    }
	  }
	  WITH = &atom[k0 - 1];
	  if (dih && rel)
	    fprintf(out,
	      "        %s%3ld   relative dihedral angle (%s,%s,%s,%s;%s) = %10.4f\n",
	      Adjust(STR1, 5L, WITH->resnam, 6L), WITH->resnum, an[0], an[1],
	      an[2], an[3],
	      an[4], per((tor(a[0], a[1], a[2], a[3]) - tor(a[0], a[1], a[2],
			    a[4])) * rad, -180.0, 180.0));
/* p2c: cofima.pas, line 1954: Note:
 * Line breaker spent 2.6+0.17 seconds, 5000 tries on line 5148 [251] */
	  else if (dih)
	    fprintf(out,
	      "        %s%3ld   dihedral angle (%s,%s,%s,%s) = %10.4f\n",
	      Adjust(STR1, 5L, WITH->resnam, 6L), WITH->resnum, an[0], an[1],
	      an[2], an[3],
	      per(tor(a[0], a[1], a[2], a[3]) * rad, -180.0, 180.0));
	  else
	    fprintf(out, "        %s%3ld   bond angle (%s,%s,%s) = %10.4f\n",
	      Adjust(STR1, 5L, WITH->resnam, 6L), WITH->resnum, an[0], an[1],
	      an[2],
	      angl(diff(TEMP1, a[0], a[1]), diff(TEMP2, a[2], a[1])) * rad);
	}
      }
      j = i + 1;
    } while (j <= nat);
_L5:
    if (!rd && (unsigned long)k1 < 32 && ((1L << k1) & 0x7ffffeL) != 0)
      putc('\n', out);
    if (dih)
      printf("        ...%ld dihedral angles listed\n", k1);
    else
      printf("        ...%ld bond angles listed\n", k1);
    if (rd)
      printf("           (output redirected to the file %s)\n", outfile);
  } else
    errmsg("less than three atoms specified");
_L9: ;
}


/* directory   show list of macros in <macro_directory> and current directory
   type        type macros in <macro_directory> and current directory
   macro       read macro file, push contents onto the command stack          */


Static Void directory()
{
  /* list macros in <macro_directory> and  */
  /* in the default directory              */
  FILE *nam, *f;
  Char fn[201], s[201];
  boolean start, enough;
  Char STR1[201], STR2[201];
  Char *TEMP;
  Char STR3[201];
  Char STR4[202];

  f = NULL;
  nam = NULL;
  if (nel > 1) {
    errmsg("too many parameters");
    goto _L9;
  }
  if (nel == 0) {
    nel = 1;
    strcpy(el[0], "*");
  } else
    strcat(el[0], ".*");
  Open_input_file(&nam, 17L, macro_list, 0L, "", &err);
  SkipLn(&nam, 1, "#");
  fprintf(out, "        macros:\n");
  while (fgets(fn, 201, nam) != NULL) {
    TEMP = strchr(fn, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    Extract_filename(s, 200L, fn);
    if (P_inset(1, inv) == Match(80L, el[0], 200L, s))
      continue;
    sprintf(STR4, "%s ",
	    Adjust(STR2, 200L, 
		     Header(STR3, 200L, s, strpos3(".", s, 1) - 1L), 14L));
    fprintf(out, "%23s", STR4);
    start = true;
    Open_input_file(&f, 200L, fn, 3L, "cfm", &err);
    SkipLn(&f, 0L, "");
    enough = P_eof(f);
    if (!enough) {
      while (!enough) {
	TEMP = fgets(s, 201, f);
	TEMP = strchr(s, '\n');
	if (TEMP != NULL)
	  *TEMP = 0;
	strcpy(s, NoHeader(STR2, 200L, s));
	enough = (P_eof(f) || strcmp(Header(STR2, 200L, s, 1L), "#"));
	if (!enough) {
	  if (start) {
	    fprintf(out, "%s\n",
		    NoHeader(STR2, 200L, Trailer(STR1, 200L, s, 2L)));
	    start = false;
	  } else
	    fprintf(out, "%23s%s\n",
		    "", NoHeader(STR2, 200L, Trailer(STR1, 200L, s, 2L)));
	}
	SkipLn(&f, 0L, "");
      }
    }
    if (start)
      putc('\n', out);
    if (f != NULL)
      fclose(f);
    f = NULL;
  }
  if (nam != NULL)
    fclose(nam);
  nam = NULL;
  if (!rd)
    putc('\n', out);
_L9:
  if (nam != NULL)
    fclose(nam);
  if (f != NULL)
    fclose(f);
}


Static Void type_macros()
{
  /* type macros in <macro_directory> and  */
  /* in the default directory              */
  FILE *nam, *f;
  Char fn[201], s[201];
  boolean start;
  Char STR1[201], STR2[201];
  Char *TEMP;
  Char STR3[201];
  Char STR4[202];

  f = NULL;
  nam = NULL;
  if (nel > 1) {
    errmsg("too many parameters");
    goto _L9;
  }
  if (nel == 0) {
    nel = 1;
    strcpy(el[0], "*");
  } else
    strcat(el[0], ".*");
  Open_input_file(&nam, 17L, macro_list, 0L, "", &err);
  SkipLn(&nam, 1, "#");
  fprintf(out, "        macros:\n");
  while (fgets(fn, 201, nam) != NULL) {
    TEMP = strchr(fn, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    Extract_filename(s, 200L, fn);
    if (P_inset(1, inv) == Match(80L, el[0], 200L, s))
      continue;
    sprintf(STR4, "%s ",
	    Adjust(STR2, 200L, 
		     Header(STR3, 200L, s, strpos3(".", s, 1) - 1L), 14L));
    fprintf(out, "%23s", STR4);
    start = true;
    Open_input_file(&f, 200L, fn, 3L, "cfm", &err);
    SkipLn(&f, 0L, "");
    if (!P_eof(f)) {
      while (fgets(s, 201, f) != NULL) {
	TEMP = strchr(s, '\n');
	if (TEMP != NULL)
	  *TEMP = 0;
	if (start) {
	  fprintf(out, "%s\n", s);
	  start = false;
	} else
	  fprintf(out, "%23s%s\n", "", s);
	SkipLn(&f, 0L, "");
      }
    }
    if (start)
      putc('\n', out);
    if (f != NULL)
      fclose(f);
    f = NULL;
  }
  if (nam != NULL)
    fclose(nam);
  nam = NULL;
  if (!rd)
    putc('\n', out);
_L9:
  if (nam != NULL)
    fclose(nam);
  if (f != NULL)
    fclose(f);
}


Static Void macro()
{
  /* expand macro, i.e. read macro file    */
  /* put commands onto the command stack   */
  stack *p, *d, *p0;
  Char STR1[201];
  Char STR2[108];
  Char STR3[82];
  Char *TEMP;

  if (nel > 0) {
    errmsg("no parameters allowed here");
    return;
  }
  strcpy(cmd, Trailer(STR1, 80L, cmd, 2L));
  Open_input_file(&f, 80L, cmd, 3L, "cfm", &err);
  if (err && *Extract_path(STR1, 80L, cmd) == '\0') {
    sprintf(STR2, "%s/macro/cofima/%s", libdir, cmd);
/*    fprintf(stderr, "STR2=%s\n", STR2); */
    Open_input_file(&f, 107L, STR2, 3L, "cfm", &err);
  }
  if (err) {
    sprintf(cmd, "@%s", strcpy(STR3, cmd));
    errmsg("macro file not found");
    return;
  }
  SkipLn(&f, 1, "#");
  d = NULL;
  p = NULL;
  p0 = NULL;
  while (!P_eof(f)) {
    p = (stack *)malloc(sizeof(stack));
    TEMP = fgets(p->sl, 201, f);
    TEMP = strchr(p->sl, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    if (d != NULL)
      d->down = (long *)p;
    d = p;
    if (p0 == NULL)
      p0 = p;
    SkipLn(&f, 1, "#");
  }
  if (p != NULL) {
    p->down = (long *)sp;
    sp = p0;
  }
  if (f != NULL)
    fclose(f);
  f = NULL;
}


/* change_mode    change between cofima, difima, ancoma mode */


Static Void change_mode(newmode)
Modetype newmode;
{
  int iexpir=0;

  /* change between modes                  */
  printf("\n");
  if (mode == dfm) {
    nst_dfm = nst;
    nat_dfm = nat;
    strcpy(inpfile_dfm, inpfile);
    format_dfm = format;
    if (newmode == cfm) {
      mode = cfm;
      nst = nst_cfm;
      nat = nat_cfm;
      strcpy(inpfile, inpfile_cfm);
      format = format_cfm;
      printf(
	"COFIMA %s: coordinate file manipulation\n", VERSION);
    } else if (newmode == acm) {
      mode = acm;
      nst = nst_acm;
      nat = nat_acm;
      strcpy(inpfile, inpfile_acm);
      format = format_acm;
      printf(
	"ANCOMA %s: angle constraint file manipulation\n", VERSION);
    } else {
      printf(
	"DIFIMA %s: distance constraint file manipulation\n", VERSION);
    }
  } else if (mode == cfm) {
    nst_cfm = nst;
    nat_cfm = nat;
    strcpy(inpfile_cfm, inpfile);
    format_cfm = format;
    if (newmode == dfm) {
      mode = dfm;
      nst = nst_dfm;
      nat = nat_dfm;
      strcpy(inpfile, inpfile_dfm);
      format = format_dfm;
      printf(
	"DIFIMA %s: distance constraint file manipulation\n", VERSION);
    } else if (newmode == acm) {
      mode = acm;
      nst = nst_acm;
      nat = nat_acm;
      strcpy(inpfile, inpfile_acm);
      format = format_acm;
      printf(
	"ANCOMA %s: angle constraint file manipulation\n", VERSION);
    } else {
      printf(
	"COFIMA %s: coordinate file manipulation\n", VERSION);
    }
  } else if (mode == acm) {
    nst_acm = nst;
    nat_acm = nat;
    strcpy(inpfile_acm, inpfile);
    format_acm = format;
    if (newmode == cfm) {
      mode = cfm;
      nst = nst_cfm;
      nat = nat_cfm;
      strcpy(inpfile, inpfile_cfm);
      format = format_cfm;
      printf(
	"COFIMA %s: coordinate file manipulation\n", VERSION);
    } else if (newmode == cfm) {
      mode = dfm;
      nst = nst_dfm;
      nat = nat_dfm;
      strcpy(inpfile, inpfile_dfm);
      format = format_dfm;
      printf(
	"DIFIMA %s: distance constraint file manipulation\n", VERSION);
    } else {
      printf(
	"ANCOMA %s: angle constraint file manipulation\n", VERSION);
    }
  }
  if (mode == acm)
    strcpy(item, "angle");
  else
    strcpy(item, "atom");
  printf("\n%s\n\n","Copyright (c) 2002-2011 Peter Guntert");
  if (iexpir>0) {
    if ((int)time(NULL) > iexpir) { printf("Expired.\n"); exit(1); }
    printf("Warning: Version expires in %d days.\n",(iexpir-(int)time(NULL))/(24*3600));
  }
}


/* pseudo    change distance constraints from real to pseudo atoms */


Static Void pseudo(psm)
Pseudomode psm;
{
  /* change distance constraints from real */
  /* to pseudo atoms                       */
  long i, i1, j, j1, l, n1, n2, nb;
  float co;
  Char s[6];
  Elementlist cat;
  float corr[maxel];
  boolean fir, b, b1, m;
  DCOdata c;
  boolean flag1[maxnat], del[maxnat], modi[maxnat], modi1[maxnat];
  long FORLIM;
  long SET[9];
  Char STR1[201];
  Char STR2[116];
  long SET1[9];
  Char STR3[114];
  DCOdata *WITH;

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel < 2) {
    errmsg("missing parameter");
    goto _L9;
  }
  n1 = 0;
  n2 = 0;
  FORLIM = nel;
  for (i = 1; i <= FORLIM; i++) {
    if (strpos3("=", el[i - 1], 1) > 0) {
      if (n1 == 0)
	n1 = i;
      if (n2 > 0 && n2 < i - 1) {
	errmsg("corrections list is not contiguous");
	goto _L9;
      }
      n2 = i;
    }
  }
  if (n1 == 0) {
    errmsg("missing corrections");
    goto _L9;
  }
  if (n1 == 1) {
    errmsg("missing pseudo atom specification");
    goto _L9;
  }
  if (n1 == 2) {
    errmsg("missing atom specification");
    goto _L9;
  }
  for (i = 0; i <= n1 - 2; i++) {
    if (!(el[i][0] == '%' || el[i][0] == '*' || isalpha(el[i][0]))) {
      sprintf(STR2, "illegal atom type specification \\%s\\", el[i]);
      errmsg(STR2);
      goto _L9;
    }
  }
  if (strpos3("%", el[0], 1) + strpos3("*", el[0], 1) > 0) {
    errmsg("illegal use of wildcards");
    goto _L9;
  }
  if (*P_setint(SET1, P_addsetr(P_expset(SET, 0x2L), (int)n1, (int)n2), inv) !=
      0L) {
    errmsg("illegal use of NOT operator");
    goto _L9;
  }
  for (i = n1 - 1; i < n2; i++) {
    j = strpos3("=", el[i], 1);
    if (!((unsigned long)j < 32 && ((1L << j) & 0x7c) != 0 &&
	  (el[i][0] == '%' || el[i][0] == '*' || isalpha(el[i][0])))) {
      sprintf(STR3, "illegal correction definition \\%s\\", el[i]);
      errmsg(STR3);
      goto _L9;
    }
    strcpy(cat[i - n1 + 1], Header(STR1, 80L, el[i], j - 1));
    /*PGcorr[i - n1 + 1] = atof(Trailer(STR1, 80L, el[i], j + 1));*/
    err=(sscanf(Trailer(STR1, 80L, el[i], j + 1),"%f",&corr[i-n1+1])!=1);
    if (err) {
      sprintf(STR3, "illegal correction definition \\%s\\", el[i]);
      errmsg(STR3);
      goto _L9;
    }
  }
  nb = n2 - n1 + 1;
  if (strcmp(cat[nb - 1], "*")) {
    errmsg("default correction definition missing");
    goto _L9;
  }
  FORLIM = nat;
  for (i = 0; i < FORLIM; i++)
    del[i] = false;
  memcpy(modi, del, (long)maxnat);
  memcpy(modi1, del, (long)maxnat);
  if (psm != first_only) {
    first = false;
    setflag();
    if (error)
      goto _L9;
    memcpy(flag1, flag, (long)maxnat);
  } else {
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      flag1[i] = false;
  }
  if (psm != second_only) {
    first = true;
    setflag();
    if (error)
      goto _L9;
  } else {
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++)
      flag[i] = false;
  }
  b = false;
  b1 = false;
  FORLIM = nat;
  for (i = 0; i < FORLIM; i++) {
    WITH = &constr[i];
    if (flag[i]) {
      m = (*P_setdiff(SET1, P_addsetr(P_expset(SET, 0L), 2, (int)(n1 - 1)),
		      inv) == 0L);
      for (l = 2; l < n1; l++) {
	if (!P_inset((int)l, inv))
	  m = (m || Match(80L, el[l - 1], 5L, WITH->atnam1));
      }
      for (l = 2; l < n1; l++) {
	if (P_inset((int)l, inv))
	  m = (m && !Match(80L, el[l - 1], 5L, WITH->atnam1));
      }
      if (m)
	strcpy(WITH->atnam1, el[0]);
      flag[i] = m;
      b = (b || m);
    }
    if (flag1[i]) {
      m = (*P_setdiff(SET1, P_addsetr(P_expset(SET, 0L), 2, (int)(n1 - 1)),
		      inv) == 0L);
      for (l = 2; l < n1; l++) {
	if (!P_inset((int)l, inv))
	  m = (m || Match(80L, el[l - 1], 5L, WITH->atnam2));
      }
      for (l = 2; l < n1; l++) {
	if (P_inset((int)l, inv))
	  m = (m && !Match(80L, el[l - 1], 5L, WITH->atnam2));
      }
      if (m)
	strcpy(WITH->atnam2, el[0]);
      flag1[i] = m;
      b1 = (b1 || m);
    }
  }
  while (b || b1) {
    fir = true;
    b = false;
    b1 = false;
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      if (!del[i]) {
	if (flag[i]) {
	  WITH = &constr[i];
	  if (fir) {
	    c = constr[i];
	    modi[i] = true;
	    flag[i] = false;
	    if (WITH->resnum1 == WITH->resnum2) {
	      j = 1;
	      while (j <= nb && !Match(80L, cat[j - 1], 5L, WITH->atnam2))
		j++;
	      if (j > nb) {
		errmsg("incomplete corrections list");
		goto _L9;
	      }
	    } else
	      j = nb;
	    co = corr[j - 1];
	    WITH->lim += co;
	    *WITH->comment = '\0';
	    i1 = i + 1;
	    fir = false;
	  } else {
	    if (WITH->resnum1 == c.resnum1 && WITH->resnum2 == c.resnum2 &&
		!strcmp(WITH->atnam2, c.atnam2)) {
	      flag[i] = false;
	      if (WITH->lim < constr[i1 - 1].lim - co) {
		del[i1 - 1] = true;
		modi[i] = true;
		i1 = i + 1;
		WITH->lim += co;
		*WITH->comment = '\0';
	      } else
		del[i] = true;
	    } else
	      b = true;
	  }
	}
	if (flag1[i] && !del[i]) {
	  WITH = &constr[i];
	  if (fir) {
	    c = constr[i];
	    j = c.resnum1;
	    c.resnum1 = c.resnum2;
	    c.resnum2 = j;
	    strcpy(s, c.resnam1);
	    strcpy(c.resnam1, c.resnam2);
	    strcpy(c.resnam2, s);
	    strcpy(s, c.atnam1);
	    strcpy(c.atnam1, c.atnam2);
	    strcpy(c.atnam2, s);
	    modi[i] = true;
	    flag1[i] = false;
	    if (WITH->resnum1 == WITH->resnum2) {
	      j = 1;
	      while (j <= nb && !Match(80L, cat[j - 1], 5L, WITH->atnam1))
		j++;
	      if (j > nb) {
		errmsg("incomplete corrections list");
		goto _L9;
	      }
	    } else
	      j = nb;
	    co = corr[j - 1];
	    WITH->lim += co;
	    *WITH->comment = '\0';
	    i1 = i + 1;
	    fir = false;
	  } else {
	    if (WITH->resnum2 == c.resnum1 && WITH->resnum1 == c.resnum2 &&
		!strcmp(WITH->atnam1, c.atnam2)) {
	      flag1[i] = false;
	      if (WITH->lim < constr[i1 - 1].lim - co) {
		del[i1 - 1] = true;
		modi[i] = true;
		i1 = i + 1;
		strcpy(WITH->atnam2, el[0]);
		WITH->lim += co;
		*WITH->comment = '\0';
	      } else
		del[i] = true;
	    } else
	      b1 = true;
	  }
	}
      }
    }
  }
  j1 = 0;
  FORLIM = nat;
  for (i = 0; i < FORLIM; i++) {
    if (modi[i] && !del[i])
      j1++;
  }
  j = 0;
  FORLIM = nat;
  for (i = 0; i < FORLIM; i++) {
    if (!del[i]) {
      j++;
      constr[j - 1] = constr[i];
    }
  }
  printf("        ...%ld distance constraints modified, %ld deleted\n",
	 j1, nat - j);
  nat = j;
_L9: ;
}


/* readat         read coordinate, distance or angle constraint file
   writeat        write coordinate file
   writeconstr    write distance constraint file
   writeaconstr   write angle constraint file
   save           save file (with backup) using the format of the input file */


Static Void Readat()
{
  /* read files                            */
  long i, j;
  Char old_inpfile[81];
  Char r[maxnat + maxnat + 1][6];
  Char STR1[232];
  Char STR2[201];
  Char STR3[244];
  Char STR4[256];
  Char STR5[201];
  Char STR6[256];
  long FORLIM;
  CORCONdata *WITH;
  ACOdata *WITH1;
  Char STR8[240];

  if (nel > 1) {
    errmsg("too many parameters");
    goto _L9;
  }
  if (nel == 0) {
    errmsg("input file specification missing");
    goto _L9;
  }
  if (*inv != 0L) {
    errmsg("illegal use of NOT operator");
    goto _L9;
  }
  strcpy(old_inpfile, inpfile);
  if (mode == cfm) {
    Append_defext(inpfile, 80L, el[0], 3L, "cor");
    format = DIAMOND;
    readcorcon(80L, inpfile, 3, "cor", format, t1, t2, t3, 1L, (long)maxnat,
	       atom, &nat, &nres, false, &stat, 0L);
    if (stat == 0)
      connected = false;
    else if ((unsigned long)stat < 32 && ((1L << stat) & 0x1e) != 0) {
      format = DG;
      readcorcon(80L, inpfile, 3, "cor", format, t1, t2, t3, 1L, (long)maxnat,
		 atom, &nat, &nres, true, &stat, 0L);
      connected = (stat == 0);
      if (connected) {
	i = 1;
	do {
	  j = atom[i - 1].atnum;
	  i++;
	} while (i <= nat && j >= 1 && j <= maxnat);
	if (j < 1 || j > maxnat) {
	  connected = false;
	  printf(
	    "cofima-warning: atom numbers outside 1..%ld, connectivities skipped\n",
	    (long)maxnat);
	}
      } else if ((unsigned long)stat < 32 && ((1L << stat) & 0x1e) != 0) {
	readcorcon(80L, inpfile, 3, "cor", format, t1, t2, t3, 1L,
		   (long)maxnat, atom, &nat, &nres, false, &stat, 0L);
	if ((unsigned long)stat < 32 && ((1L << stat) & 0x1e) != 0) {
	  format = PDB;
	  readcorcon(80L, inpfile, 3, "cor", format, t1, t2, t3, 1L,
		     (long)maxnat, atom, &nat, &nres, false, &stat, 0L);
	  if (nat == 0) {
	    errmsg("no atom found in PDB or AMBER input file");
	    goto _L9;
	  }
	}
      }
    }
    switch (stat) {

    case 0:
      nst = 1;
      natin_cfm = nat;
      if (connected)
	printf("        ...DG input file with connectivities read, %ld atoms\n",
	       nat);
      else if (format == DG)
	printf("        ...DG input file read, %ld atoms\n", nat);
      else if (format == PDB)
	printf("        ...PDB or AMBER input file read, %ld atoms\n", nat);
      else
	printf("        ...DIAMOND input file read, %ld atoms\n", nat);
      break;

    case -1:
      errmsg("input file cannot be opened");
      strcpy(inpfile, old_inpfile);
      break;

    case -2:
      sprintf(STR3, "input file has too many atoms (maximum: %s)",
	      IntStr(STR2, (long)maxnat, 0L));
      errmsg(STR3);
      break;

    default:
      sprintf(STR1, "error in input file near line %s",
	      IntStr(STR2, stat, 0L));
      errmsg(STR1);
      break;
    }
  } else if (mode == dfm) {
    Append_defext(inpfile, 80L, el[0], 3L, "upl");
    /*PGreaddco(80L, inpfile, 1L, (long)maxnat, DISMAN, 0, 0, constr, &nat, &stat,
	    0L);*/
    readdco(80L, inpfile, 3L,"upl", DISMAN, 1L, (long)maxnat, constr, &nat, 
            &stat, 0L);
    switch (stat) {

    case 0:
      nst = 1;
      natin_dfm = nat;
      printf("        ...distance constraints input file read, %ld constraints\n",
	     nat);
      break;

    case -1:
      errmsg("input file cannot be opened");
      strcpy(inpfile, old_inpfile);
      break;

    case -2:
      sprintf(STR4,
	      "input file has too many distance constraints (maximum: %s)",
	      IntStr(STR2, (long)maxnat, 0L));
      errmsg(STR4);
      break;

    default:
      sprintf(STR1, "error in input file near line %s",
	      IntStr(STR2, stat, 0L));
      errmsg(STR1);
      break;
    }
  } else if (mode == acm) {
    Append_defext(inpfile, 80L, el[0], 3L, "aco");
    format = DISMAN;
    readaco(80L, inpfile, 3, "aco", format, 1L, (long)maxnat, aconstr, &nat,
	    &stat, 0L);
    if ((unsigned long)stat < 32 && ((1L << stat) & 0x6) != 0) {
      format = ELLIPS;
      readaco(80L, inpfile, 3, "aco", format, 1L, (long)maxnat, aconstr, &nat,
	      &stat, 0L);
    }
    switch (stat) {

    case 0:
      nst = 1;
      natin_acm = nat;
      if (format == DISMAN) {
	if (nst_cfm == 0) {
	  errmsg("can't get residue names, no coordinate file read");
	  goto _L9;
	}
	for (i = -maxnat; i <= maxnat; i++)
	  *r[i + maxnat] = '\0';
	FORLIM = nat_cfm;
	for (i = 0; i < FORLIM; i++) {
	  WITH = &atom[i];
	  /*PGif (labs(WITH->resnum) > maxnat) {*/
	  if (WITH->resnum > maxnat || WITH->resnum < (-maxnat)) {
	    sprintf(STR6, "residue numbers outside %s..%s in coordinate list",
		    IntStr(STR2, (long)(-maxnat), 0L),
		    IntStr(STR5, (long)maxnat, 0L));
	    errmsg(STR6);
	    goto _L9;
	  }
	  strcpy(r[WITH->resnum + maxnat], WITH->resnam);
	}
	FORLIM = nat;
	for (i = 0; i < FORLIM; i++) {
	  WITH1 = &aconstr[i];
	  strcpy(WITH1->resnam, r[WITH1->resnum + maxnat]);
	  if (*WITH1->resnam == '\0') {
	    sprintf(STR8, "residue %s not found in coordinate list",
		    IntStr(STR2, WITH1->resnum, 0L));
	    errmsg(STR8);
	    goto _L9;
	  }
	}
	printf(
	  "        ...DISMAN angle constraints input file read, %ld constraints\n",
	  nat);
	printf("        (residue names taken from cofima)\n");
      } else
	printf(
	  "        ...DIANA angle constraints input file read, %ld constraints\n",
	  nat);
      break;

    case -1:
      errmsg("input file cannot be opened");
      strcpy(inpfile, old_inpfile);
      break;

    case -2:
      sprintf(STR4, "input file has too many angle constraints (maximum: %s)",
	      IntStr(STR2, (long)maxnat, 0L));
      errmsg(STR4);
      break;

    default:
      sprintf(STR1, "error in input file near line %s",
	      IntStr(STR2, stat, 0L));
      errmsg(STR1);
      break;
    }
  }
_L9: ;
}


Static Void writeat(format)
Formattype format;
{
  /* write coordinate file                 */
  Char STR1[201];

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel == 0) {
    errmsg("output file specification missing");
    goto _L9;
  }
  if (nel > 1) {
    errmsg("too many parameters");
    goto _L9;
  }
  if (*inv != 0L) {
    errmsg("illegal use of NOT operator");
    goto _L9;
  }
  adjust_atnum();
  writecorcon(80L, el[0], 3, "cor", format, t1, t2, "", 1L, (long)maxnat,
	      atom, nat, 0, connected && format == DG, &stat, 0L);
  switch (stat) {

  case 0:
    if (connected && format == DG)
      printf("        ...DG output file with connectivities written, %ld atoms\n",
	     nat);
    else if (format == DG)
      printf("        ...DG output file written, %ld atoms\n", nat);
    else if (format == PDB)
      printf("        ...PDB output file written, %ld atoms\n", nat);
    else if (format == AMBER)
      printf("        ...AMBER output file written, %ld atoms\n", nat);
    else
      printf("        ...DIAMOND output file written, %ld atoms\n", nat);
    printf("        (%ld atoms were read from the file %s)\n",
	   natin_cfm, inpfile);
    break;

  case -1:
    errmsg("output file cannot be opened");
    break;
  }
_L9: ;
}


Static Void writeconstr(format)
Formattype format;
{
  /* write distance constraint file    */
  Char STR1[201];

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel == 0) {
    errmsg("output file specification missing");
    goto _L9;
  }
  if (nel > 1) {
    errmsg("too many parameters");
    goto _L9;
  }
  if (*inv != 0L) {
    errmsg("illegal use of NOT operator");
    goto _L9;
  }
  writedco(80L, el[0], 3, "upl", format, 1L, (long)maxnat, constr, nat, &stat,
	   0L);
  switch (stat) {

  case 0:
    if (format == CAST)
      printf("        ...distance constraints output file written, %ld constraints\n",
	     nat);
    else if (format == DISMAN)
      printf(
	"        ...short distance constraints output file written, %ld constraints\n",
	nat);
    else
      printf(
	"        ...long distance constraints output file written, %ld constraints\n",
	nat);
    printf("        (%ld distance constraints were read from the file %s)\n",
	   natin_dfm, inpfile);
    break;

  case -1:
    errmsg("output file cannot be opened");
    break;
  }
_L9: ;
}


Static Void writeaconstr(format)
Formattype format;
{
  /* write angle constraint file       */
  Char STR2[201];

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel == 0) {
    errmsg("output file specification missing");
    goto _L9;
  }
  if (nel > 1) {
    errmsg("too many parameters");
    goto _L9;
  }
  if (*inv != 0L) {
    errmsg("illegal use of NOT operator");
    goto _L9;
  }
  writeaco(80L, el[0], 3, "aco", format, 1L, (long)maxnat, aconstr, nat,
	   &stat, 0L);
  switch (stat) {

  case 0:
    if (format == DISMAN)
      printf(
	"        ...DISMAN angle constraints output file written, %ld constraints\n",
	nat);
    else
      printf(
	"        ...DIANA angle constraints output file written, %ld constraints\n",
	nat);
    printf("        (%ld angle constraints were read from the file %s)\n",
	   natin_acm, inpfile);
    break;

  case -1:
    errmsg("output file cannot be opened");
    break;
  }
_L9: ;
}


Static Void save()
{
  /* save coordinates in a new version of  */
  /* the input coordinate file             */
  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel > 0) {
    errmsg("no parameters allowed here");
    goto _L9;
  }
  strcpy(el[0], inpfile);
  nel = 1;
  if (mode == dfm)
    writeconstr(CAST);
  else if (mode == cfm)
    writeat(format);
  else
    writeaconstr(format);
_L9: ;
}


/* rename    rename atoms and angles
   change    rename residues         */


Static Void Rename()
{
  /* rename atoms (i.e. change atnam)      */
  long i, j, FORLIM;
  Char STR1[114];
  Char STR2[106];
  CORCONdata *WITH;
  ACOdata *WITH1;
  DCOdata *WITH2;

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel < 2) {
    errmsg("missing parameter");
    goto _L9;
  }
  if ((el[0][0] == '%' || el[0][0] == '*' || isalpha(el[0][0])) &&
      (el[1][0] == '%' || el[1][0] == '*' || isalpha(el[1][0]))) {
    if (strpos3("%", el[1], 1) + strpos3("*", el[1], 1) > 0) {
      errmsg("illegal use of wildcards");
      goto _L9;
    }
    if (P_inset(2, inv)) {
      errmsg("illegal use of NOT operator");
      goto _L9;
    }
    FORLIM = nel;
    for (i = 2; i < FORLIM; i++) {
      if (el[i][0] == '%' || el[i][0] == '*' || isalpha(el[i][0])) {
	sprintf(STR2, "too many %s types specified", item);
	errmsg(STR2);
	goto _L9;
      }
    }
    if (mode == cfm) {
      setflag();
      if (error)
	goto _L9;
      j = 0;
      FORLIM = nat;
      for (i = 0; i < FORLIM; i++) {
	if (flag[i]) {
	  WITH = &atom[i];
	  if (P_inset(1, inv) != Match(80L, el[0], 5L, WITH->atnam)) {
	    j++;
	    Header(WITH->atnam, 80L, el[1], 5L);
	  }
	}
      }
      printf("        ...%ld atoms renamed\n", j);
    } else if (mode == acm) {
      setflag();
      if (error)
	goto _L9;
      j = 0;
      FORLIM = nat;
      for (i = 0; i < FORLIM; i++) {
	if (flag[i]) {
	  WITH1 = &aconstr[i];
	  if (P_inset(1, inv) != Match(80L, el[0], 5L, WITH1->angnam)) {
	    j++;
	    Header(WITH1->angnam, 80L, el[1], 5L);
	  }
	}
      }
      printf("        ...%ld angles renamed\n", j);
    } else {
      first = true;
      setflag();
      if (error)
	goto _L9;
      j = 0;
      FORLIM = nat;
      for (i = 0; i < FORLIM; i++) {
	if (flag[i]) {
	  WITH2 = &constr[i];
	  if (P_inset(1, inv) != Match(80L, el[0], 5L, WITH2->atnam1)) {
	    j++;
	    Header(WITH2->atnam1, 80L, el[1], 5L);
	  }
	}
      }
      first = false;
      setflag();
      if (error)
	goto _L9;
      FORLIM = nat;
      for (i = 0; i < FORLIM; i++) {
	if (flag[i]) {
	  WITH2 = &constr[i];
	  if (P_inset(1, inv) != Match(80L, el[0], 5L, WITH2->atnam2)) {
	    j++;
	    Header(WITH2->atnam2, 80L, el[1], 5L);
	  }
	}
      }
      printf("        ...%ld atoms renamed\n", j);
    }
  } else {
    sprintf(STR1, "not exactly two %s types specified", item);
    errmsg(STR1);
  }
_L9: ;
}


Static Void change()
{
  /* change residue names or numbers (i.e. resnam or resnum)   */
  long i, j, k, l, n1, newnum;
  boolean b, havnam;
  boolean del[maxnat];
  long SET[9], SET1[9];
  Char STR1[201];
  long FORLIM;
  CORCONdata *WITH;
  ACOdata *WITH1;
  DCOdata *WITH2;
  char sig, newnam[80];

  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel < 2) {
    errmsg("missing parameter");
    goto _L9;
  }
  if (P_inset(nel, inv)) {
    errmsg("illegal use of NOT operator");
    goto _L9;
  }
  nel--; if (el[nel][0] == '=') el[nel][0] = ' ';
  if (strpos3("%", el[nel], 1) + strpos3("*", el[nel], 1) > 0) {
    errmsg("illegal use of wildcards"); goto _L9; }
  else if (el[nel][0] == '@') {
    strcpy(newnam, Trailer(STR1, 80L, el[nel], 2L)); havnam = true;
    if (newnam[0] == '\0') {
      errmsg("incomplete parameter"); goto _L9; }}
  else if (sscanf(el[nel], "%ld", &newnum) == 1) {
      sig = el[nel][0]; if (sig != '+' && sig != '-') sig = ' ';  
      havnam = false; }
  else {
    sprintf(STR1, "%s is neither a residue name nor residue number", el[nel]);
    errmsg(STR1); goto _L9; }

  n1 = 1;
  while ((el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
          isalpha(el[n1 - 1][0])) && n1 < nel)
    n1++;
  if (!(el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
        isalpha(el[n1 - 1][0])))
    n1--;
  b = (*P_setdiff(SET1, P_addsetr(P_expset(SET, 0L), 1, (int)n1), inv) == 0L);

  if (mode == cfm) {
    setflag(); if (error) goto _L9;
    for (i = 0; i < nat; i++) del[i] = false;
    for (i = 0; i < nat; i++) if (flag[i]) {
      WITH = &atom[i]; del[i] = b;
      for (j = 1; j <= n1; j++) if (!P_inset((int)j, inv))
        del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH->atnam));
      for (j = 1; j <= n1; j++) if (P_inset((int)j, inv))
        del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH->atnam)); }
    l = 0; adjust_atnum();
/*    fprintf(stderr, "sig=(%c)\n", sig); */
    for (i = 0; i < nat; i++) if (del[i]) {
      WITH = &atom[i]; l++; 
      if (havnam) strcpy(WITH->resnam, newnam); 
      else if (sig != ' ') WITH->resnum += newnum;
      else WITH->resnum = newnum; }
    if (havnam) printf("        ...residue name of %ld atoms changed\n", l);
    else printf("        ...residue number of %ld atoms changed\n", l); }

  else if (mode == acm) {
    setflag(); if (error) goto _L9;
    for (i = 0; i < nat; i++) del[i] = false;
    for (i = 0; i < nat; i++) if (flag[i]) {
      WITH1 = &aconstr[i]; del[i] = b;
      for (j = 1; j <= n1; j++) if (!P_inset((int)j, inv))
        del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH1->angnam));
      for (j = 1; j <= n1; j++) if (P_inset((int)j, inv))
        del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH1->angnam)); }
    l = 0;
    for (i = 0; i < nat; i++) if (del[i]) {
      WITH1 = &aconstr[i]; l++; 
      if (havnam) strcpy(WITH1->resnam, newnam); 
      else if (sig != ' ') WITH1->resnum += newnum;
      else WITH1->resnum = newnum; }
    if (havnam) 
      printf("        ...residue name of %ld angle constraints changed\n", l);
    else 
      printf("        ...residue number of %ld angle constraints changed\n", l); }

  else {
    first = true; setflag(); if (error) goto _L9;
    for (i = 0; i < nat; i++) del[i] = false;
    for (i = 0; i < nat; i++) if (flag[i]) {
      WITH2 = &constr[i]; del[i] = b;
      for (j = 1; j <= n1; j++) if (!P_inset((int)j, inv))
        del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH2->atnam1));
      for (j = 1; j <= n1; j++) if (P_inset((int)j, inv))
        del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH2->atnam1)); }
    l = 0;
    for (i = 0; i < nat; i++) if (del[i]) {
      WITH2 = &constr[i]; l++; 
      if (havnam) strcpy(WITH2->resnam1, newnam); 
      else if (sig != ' ') WITH2->resnum1 += newnum;
      else WITH2->resnum1 = newnum; }
    first = false; setflag(); if (error) goto _L9;
    for (i = 0; i < nat; i++) del[i] = false;
    for (i = 0; i < nat; i++) if (flag[i]) {
      WITH2 = &constr[i]; del[i] = b;
      for (j = 1; j <= n1; j++) if (!P_inset((int)j, inv))
        del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH2->atnam2));
      for (j = 1; j <= n1; j++) if (P_inset((int)j, inv))
        del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH2->atnam2)); }
    for (i = 0; i < nat; i++) if (del[i]) {
      WITH2 = &constr[i]; l++; 
      if (havnam) strcpy(WITH2->resnam2, newnam); 
      else if (sig != ' ') WITH2->resnum2 += newnum;
      else WITH2->resnum2 = newnum; }
    if (havnam) 
      printf("        ...residue name of %ld atoms changed\n", l);
    else 
      printf("        ...residue number of %ld atoms changed\n", l); }

_L9: ;
}


#define m               20


typedef struct _REC_stack_ {
  long l, r;
} _REC_stack_;


#define m_              20


typedef struct _REC_stack__ {
  long l, r;
} _REC_stack__;

/* Local variables for sort: */
struct LOC_sort {
  long n1, nwc;
} ;


Local boolean gt(atnam1, atnam2, LINK)
Char *atnam1, *atnam2;
struct LOC_sort *LINK;
{
  enum {
    N, number, space, A, prime, B, G, D, E, Z, H, other
  } pos[2];
  enum {
    Carb, L, M, Nitro, O, S, Q, P, Hy, exotic
  } typ[2];
  long nr[2];
  Char atnam[2][6];
  long i, j, FORLIM1;
  Char STR1[201], STR2[201];

  strcpy(atnam[0], atnam1);
  strcpy(atnam[1], atnam2);
  for (i = 0; i <= 1; i++) {
    nr[i] = 0;
    FORLIM1 = LINK->n1;
    for (j = 1; j <= FORLIM1; j++) {
      if (!strcmp(atnam[i], el[j - 1]))
	nr[i] = j;
    }
    if (nr[i] == 0)
      nr[i] = LINK->nwc;
  }
  if (nr[0] > nr[1])
    return true;
  else if (nr[0] < nr[1])
    return false;
  else {
    Adjust(atnam[0], 5L, atnam1, 5L);
    Adjust(atnam[1], 5L, atnam2, 5L);
    for (i = 0; i <= 1; i++) {
      switch (atnam[i][1]) {

      case 'G':
	pos[i] = G;
	break;

      case ' ':
	pos[i] = number;
	break;

      case 'D':
	pos[i] = D;
	break;

      case '\'':
	pos[i] = prime;
	break;

      case 'E':
	pos[i] = E;
	break;

      case 'A':
	pos[i] = A;
	break;

      case 'Z':
	pos[i] = Z;
	break;

      case 'B':
	pos[i] = B;
	break;

      case 'H':
	pos[i] = H;
	break;

      case 'N':
	pos[i] = N;
	break;

      default:
	if (isdigit(atnam[i][1]))
	  pos[i] = number;
	else
	  pos[i] = other;
	break;
      }
    }
    if ((long)pos[0] > (long)pos[1] ||
	pos[0] == other && pos[1] == other && atnam[0][1] > atnam[1][1])
      return true;
    else if ((long)pos[0] < (long)pos[1] ||
	     pos[0] == other && pos[1] == other && atnam[0][1] < atnam[1][1])
      return false;
    else if (atnam[0][2] > atnam[1][2])
      return true;
    else if (atnam[0][2] < atnam[1][2])
      return false;
    else {
      for (i = 0; i <= 1; i++) {
	switch (atnam[i][0]) {

	case 'C':
	  typ[i] = Carb;
	  break;

	case 'S':
	  typ[i] = S;
	  break;

	case 'L':
	  typ[i] = L;
	  break;

	case 'H':
	  typ[i] = Hy;
	  break;

	case 'M':
	  typ[i] = M;
	  break;

	case 'Q':
	  typ[i] = Q;
	  break;

	case 'N':
	  typ[i] = Nitro;
	  break;

	case 'P':
	  typ[i] = P;
	  break;

	case 'O':
	  typ[i] = O;
	  break;

	default:
	  typ[i] = exotic;
	  break;
	}
      }
      if ((long)typ[0] > (long)typ[1] ||
	  typ[0] == exotic && typ[1] == exotic && atnam[0][0] > atnam[1][0])
	return true;
      else if ((long)typ[0] < (long)typ[1] ||
	       (typ[0] == exotic && typ[1] == exotic &&
		atnam[0][0] < atnam[1][0]))
	return false;
      else if (strcmp(CopyStr(STR1, 5L, atnam[0], 4L, 2L),
		      CopyStr(STR2, 5L, atnam[1], 4L, 2L)) > 0)
	return true;
      else
	return false;
    }
  }
}

/* Local variables for dcosort: */
struct LOC_dcosort {
  struct LOC_sort *LINK;
} ;

Local boolean lt(atnam1, atnam2, LINK)
Char *atnam1, *atnam2;
struct LOC_dcosort *LINK;
{
  return (strcmp(atnam1, atnam2) && !gt(atnam1, atnam2, LINK->LINK));
}


Local Void dcosort(LINK)
struct LOC_sort *LINK;
{
  /* quicksort (Wirth) */
  struct LOC_dcosort V;
  long i, j, l, r, s;
  DCOdata x, w;
  _REC_stack_ stack_[m];

  V.LINK = LINK;
  s = 1;
  stack_[0].l = 1;
  stack_[0].r = nat;
  do {
    l = stack_[s - 1].l;
    r = stack_[s - 1].r;
    s--;
    do {
      i = l;
      j = r;
      x = constr[(l + r) / 2 - 1];
      do {
	while (constr[i - 1].resnum1 < x.resnum1 ||
	       (constr[i - 1].resnum1 == x.resnum1 &&
		lt(constr[i - 1].atnam1, x.atnam1, &V)) ||
	       (constr[i - 1].resnum1 == x.resnum1 &&
		!strcmp(constr[i - 1].atnam1, x.atnam1) &&
		constr[i - 1].resnum2 < x.resnum2) ||
	       (constr[i - 1].resnum1 == x.resnum1 &&
		!strcmp(constr[i - 1].atnam1, x.atnam1) &&
		constr[i - 1].resnum2 == x.resnum2 &&
		lt(constr[i - 1].atnam2, x.atnam2, &V)))
	  i++;
	while (constr[j - 1].resnum1 > x.resnum1 ||
	       (constr[j - 1].resnum1 == x.resnum1 &&
		gt(constr[j - 1].atnam1, x.atnam1, LINK)) ||
	       (constr[j - 1].resnum1 == x.resnum1 &&
		!strcmp(constr[j - 1].atnam1, x.atnam1) &&
		constr[j - 1].resnum2 > x.resnum2) ||
	       (constr[j - 1].resnum1 == x.resnum1 &&
		!strcmp(constr[j - 1].atnam1, x.atnam1) &&
		constr[j - 1].resnum2 == x.resnum2 &&
		gt(constr[j - 1].atnam2, x.atnam2, LINK)))
	  j--;
	if (i <= j) {
	  w = constr[i - 1];
	  constr[i - 1] = constr[j - 1];
	  constr[j - 1] = w;
	  i++;
	  j--;
	}
      } while (i <= j);
      if (j - l < r - i) {
	if (i < r) {
	  s++;
	  stack_[s - 1].l = i;
	  stack_[s - 1].r = r;
	}
	r = j;
      } else {
	if (l < j) {
	  s++;
	  stack_[s - 1].l = l;
	  stack_[s - 1].r = j;
	}
	l = i;
      }
    } while (l < r);
  } while (s != 0);
}

#undef m

/* Local variables for acosort: */
struct LOC_acosort {
  struct LOC_sort *LINK;
} ;

Local boolean gta(angnam1, angnam2, LINK)
Char *angnam1, *angnam2;
struct LOC_acosort *LINK;
{
  long nr[2];
  Char angnam[2][6];
  long i, j, FORLIM1;
  Char STR1[201];

  strcpy(angnam[0], angnam1);
  strcpy(angnam[1], angnam2);
  for (i = 0; i <= 1; i++) {
    nr[i] = 0;
    FORLIM1 = LINK->LINK->n1;
    for (j = 1; j <= FORLIM1; j++) {
      if (!strcmp(angnam[i], el[j - 1]))
	nr[i] = j;
    }
    if (nr[i] == 0)
      nr[i] = LINK->LINK->nwc;
  }
  if (nr[0] > nr[1])
    return true;
  else if (nr[0] < nr[1])
    return false;
  else {
    strcpy(angnam1, Adjust(STR1, 5L, angnam1, 5L));
    strcpy(angnam2, Adjust(STR1, 5L, angnam2, 5L));
    if (angnam1[0] == 'P') {
      if (angnam2[0] == 'P')
	return (strcmp(angnam1, angnam2) > 0);
      else
	return false;
    } else if (angnam2[0] == 'P')
      return true;
    else
      return (strcmp(angnam1, angnam2) > 0);
  }
}

Local boolean lta(angnam1, angnam2, LINK)
Char *angnam1, *angnam2;
struct LOC_acosort *LINK;
{
  return (strcmp(angnam1, angnam2) && !gta(angnam1, angnam2, LINK));
}


Local Void acosort(LINK)
struct LOC_sort *LINK;
{
  /* quicksort (Wirth) */
  struct LOC_acosort V;
  long i, j, l, r, s;
  ACOdata x, w;
  _REC_stack__ stack_[m_];

  V.LINK = LINK;
  s = 1;
  stack_[0].l = 1;
  stack_[0].r = nat;
  do {
    l = stack_[s - 1].l;
    r = stack_[s - 1].r;
    s--;
    do {
      i = l;
      j = r;
      x = aconstr[(l + r) / 2 - 1];
      do {
	while (aconstr[i - 1].resnum < x.resnum ||
	       (aconstr[i - 1].resnum == x.resnum &&
		lta(aconstr[i - 1].angnam, x.angnam, &V)))
	  i++;
	while (aconstr[j - 1].resnum > x.resnum ||
	       (aconstr[j - 1].resnum == x.resnum &&
		gta(aconstr[j - 1].angnam, x.angnam, &V)))
	  j--;
	if (i <= j) {
	  w = aconstr[i - 1];
	  aconstr[i - 1] = aconstr[j - 1];
	  aconstr[j - 1] = w;
	  i++;
	  j--;
	}
      } while (i <= j);
      if (j - l < r - i) {
	if (i < r) {
	  s++;
	  stack_[s - 1].l = i;
	  stack_[s - 1].r = r;
	}
	r = j;
      } else {
	if (l < j) {
	  s++;
	  stack_[s - 1].l = l;
	  stack_[s - 1].r = j;
	}
	l = i;
      }
    } while (l < r);
  } while (s != 0);
}

#undef m_


/* sort    sort atoms and constraints */


Static Void sort()
{
  /* sort atoms and constraints            */
  struct LOC_sort V;
  long i, j, k, l, i1;
  CORCONdata at;
  Char s[6];
  long SET[3];
  Char STR2[114];
  Char STR3[116];
  long SET1[3];
  long FORLIM;
  DCOdata *WITH;


  if (nst < 1) {
    errmsg("no input file read");
    goto _L9;
  }
  if (nel == 0)
    V.n1 = 0;
  else {
    V.n1 = 1;
    V.nwc = 0;
    while (V.n1 < nel && (el[V.n1 - 1][0] == '%' || el[V.n1 - 1][0] == '*' ||
			  isalpha(el[V.n1 - 1][0]))) {
      if (!strcmp(el[V.n1 - 1], "*")) {
	if (V.nwc != 0) {
	  sprintf(STR2, "only one * allowed in %s type list", item);
	  errmsg(STR2);
	  goto _L9;
	}
	V.nwc = V.n1;
      }
      V.n1++;
    }
    if (!(el[V.n1 - 1][0] == '%' || el[V.n1 - 1][0] == '*' ||
	  isalpha(el[V.n1 - 1][0])))
      V.n1--;
    else {
      if (!strcmp(el[V.n1 - 1], "*")) {
	if (V.nwc != 0) {
	  sprintf(STR2, "only one * allowed in %s type list", item);
	  errmsg(STR2);
	  goto _L9;
	}
	V.nwc = V.n1;
      }
    }
  }
  if (V.n1 > 0 && V.nwc == 0) {
    sprintf(STR3, "one * is required in the %s type list", item);
    errmsg(STR3);
    goto _L9;
  }
  if (*P_setint(SET1, inv, P_addsetr(P_expset(SET, 0L), 1, (int)V.n1)) != 0L) {
    errmsg("illegal use of NOT operator");
    goto _L9;
  }
  i = 0;
  FORLIM = V.n1;
  for (j = 0; j < FORLIM; j++) {
    if (j + 1 != V.nwc)
      i += strpos3("%", el[j], 1) + strpos3("*", el[j], 1);
  }
  if (i > 0) {
    errmsg("illegal use of wildcards");
    goto _L9;
  }
  if (mode == cfm) {
    adjust_atnum();
    setflag();
    if (error)
      goto _L9;
    j = 1;
    i1 = 0;
    do {
      i = j;
      while (i < nat && atom[i - 1].resnum == atom[j - 1].resnum)
	i++;
      if (atom[i - 1].resnum != atom[j - 1].resnum)
	i--;
      if (flag[j - 1]) {
	i1++;
	/* bubblesort (Wirth) */
	for (k = j + 1; k <= i; k++) {
	  for (l = i; l >= k; l--) {
	    if (gt(atom[l - 2].atnam, atom[l - 1].atnam, &V)) {
	      at = atom[l - 2];
	      atom[l - 2] = atom[l - 1];
	      atom[l - 1] = at;
	    }
	  }
	}
      }
      j = i + 1;
    } while (j <= nat);
    printf("        ...%ld residues sorted\n", i1);
  } else if (mode == dfm) {
    if (nel > V.n1)
      printf("difima-warning: range specification not allowed here, skipped\n");
    FORLIM = nat;
    for (i = 0; i < FORLIM; i++) {
      WITH = &constr[i];
      if (WITH->resnum1 > WITH->resnum2 || (WITH->resnum1 == WITH->resnum2 &&
	    gt(WITH->atnam1, WITH->atnam2, &V))) {
	j = WITH->resnum1;
	WITH->resnum1 = WITH->resnum2;
	WITH->resnum2 = j;
	strcpy(s, WITH->resnam1);
	strcpy(WITH->resnam1, WITH->resnam2);
	strcpy(WITH->resnam2, s);
	strcpy(s, WITH->atnam1);
	strcpy(WITH->atnam1, WITH->atnam2);
	strcpy(WITH->atnam2, s);
      }
    }
    dcosort(&V);
    printf("        ...distance constraints sorted\n");
  } else {
    if (nel > V.n1)
      printf("ancoma-warning: range specification not allowed here, skipped\n");
    acosort(&V);
    printf("        ...angle constraints sorted\n");
  }
_L9: ;
}


Static Void shiftnumbers() /* PG */
{
  /* shift residue numbers                 */
  long i, j, k, l, l1, n1, nshift, jj, rp, ns;
  boolean b, spread;
  boolean del[maxnat];
  long SET[9], SET1[9];
  long FORLIM;
  CORCONdata *WITH, *W;
  ACOdata *WITH1;
  DCOdata *WITH2;

  if (nst < 1) { errmsg("no input file read"); return; }
  if (nel < 1) { errmsg("missing parameter"); return; }
  if (sscanf(el[0],"%ld",&nshift)!=1) { 
    errmsg("Illegal residue shift");
    return;
  }
  spread = (el[0][0] == '+');
  nel--; for (i = 0; i < nel; i++) strcpy(el[i],el[i+1]);
  n1 = 1;
  while ((el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	 isalpha(el[n1 - 1][0])) && n1 < nel) n1++;
  if (!(el[n1 - 1][0] == '%' || el[n1 - 1][0] == '*' ||
	isalpha(el[n1 - 1][0]))) n1--;
  b = (*P_setdiff(SET1, P_addsetr(P_expset(SET, 0L), 1, (int)n1), inv) == 0L);

  if (mode == cfm) {

  setflag(); if (error) return;
  for (i = 0; i < nat; i++) del[i] = false;
  for (i = 0; i < nat; i++) if (flag[i]) {
	WITH = &atom[i]; del[i] = b;
	for (j = 1; j <= n1; j++) if (!P_inset((int)j, inv))
	   del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH->atnam));
	for (j = 1; j <= n1; j++) if (P_inset((int)j, inv))
	   del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH->atnam)); }
  jj = 0;
  if (spread) {
	rp = -1000000; ns = 0;
  	for (i = 0; i < nat; i++) {
	   WITH = &atom[i];
	   if (WITH->resnum < rp) ns += nshift;
	   rp = WITH->resnum;
	   if (del[i] && ns != 0) { WITH->resnum += ns; jj++; }}}
  else {
  	for (i = 0; i < nat; i++) if (del[i]) {
	   WITH = &atom[i]; WITH->resnum += nshift; jj++; }}
  printf("        ...residue number of %ld atoms shifted\n", jj);

  } else if (mode == acm) {

  setflag(); if (error) return;
  for (i = 0; i < nat; i++) del[i] = false;
  for (i = 0; i < nat; i++) if (flag[i]) {
	WITH1 = &aconstr[i]; del[i] = b;
	for (j = 1; j <= n1; j++) if (!P_inset((int)j, inv))
	   del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH1->angnam));
	for (j = 1; j <= n1; j++) if (P_inset((int)j, inv))
	   del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH1->angnam)); }
  jj = 0;
  for (i = 0; i < nat; i++) if (del[i]) {
	WITH1 = &aconstr[i]; WITH1->resnum += nshift; jj++; }
  printf("        ...residue number of %ld angle constraints shifted\n", jj);

  } else {

  first = true;
  setflag(); if (error) return;
  for (i = 0; i < nat; i++) del[i] = false;
  for (i = 0; i < nat; i++) if (flag[i]) {
	WITH2 = &constr[i]; del[i] = b;
	for (j = 1; j <= n1; j++) if (!P_inset((int)j, inv))
	   del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH2->atnam1));
	for (j = 1; j <= n1; j++) if (P_inset((int)j, inv))
	   del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH2->atnam1)); }
  jj = 0;
  for (i = 0; i < nat; i++) if (del[i]) {
	WITH2 = &constr[i]; WITH2->resnum1 += nshift; jj++; }
  first = false;
  setflag(); if (error) return;
  for (i = 0; i < nat; i++) del[i] = false;
  for (i = 0; i < nat; i++) if (flag[i]) {
	WITH2 = &constr[i]; del[i] = b;
	for (j = 1; j <= n1; j++) if (!P_inset((int)j, inv))
	   del[i] = (del[i] || Match(80L, el[j - 1], 5L, WITH2->atnam2));
	for (j = 1; j <= n1; j++) if (P_inset((int)j, inv))
	   del[i] = (del[i] && !Match(80L, el[j - 1], 5L, WITH2->atnam2)); }
  for (i = 0; i < nat; i++) if (del[i]) {
	WITH2 = &constr[i]; WITH2->resnum2 += nshift; jj++; }
  printf("        ...residue number of %ld atoms shifted\n", jj);

  }
}


/* main program */


main(argc, argv)
int argc;
Char *argv[];
{
  Char STR[201];
  char modestr[100], inpfil[200];
  int i, iret;
    
  PASCAL_MAIN(argc, argv);
/*  for (i=0; i<argc; i++) fprintf(stderr,"argv[%d] = '%s'\n", i, argv[i]); */
  for (i = strlen(argv[0]); i > 0; i--) if (argv[0][i - 1] == '/') break;
  strcpy(modestr, &argv[0][i]); modestr[6]='\0';
  if (argc > 1) strcpy(inpfil, argv[1]); else strcpy(inpfil, "");
/*  fprintf(stderr,"modestr = '%s', inpfil = '%s'\n", modestr, inpfil); */
  /*PG*/
  if (getenv("COFIMALIB")!=NULL) strcpy(libdir,(char *)getenv("COFIMALIB"));
  if (getenv("DYANALIB")!=NULL) strcpy(libdir,(char *)getenv("DYANALIB"));
  else strcpy(libdir,LIBDIR);
/*  strcat(libdir,"/cofima"); */
/*  printf("libdir=(%s)\n",libdir); */
  iret=system("echo $HOME/cofima.macro >/tmp/cofima");
  f=fopen("/tmp/cofima","r"); 
  if (f==NULL) { errmsg("cannot open /tmp/cofima\n"); exit(1); }
  iret=fscanf(f,"%s",macro_list); fclose(f); iret=system("rm /tmp/cofima");
  sprintf(STR, "ls *.cfm %s/macro/cofima/*.cfm >$HOME/cofima.macro 2>/dev/null", libdir);
  iret=system(STR); 
  /*PG*/
  out = NULL;
  f = NULL;
  nst = 0;
  sp = NULL;
  hi = NULL;
  strcpy(outfile, "stdout");
  strcpy(inpfile, "");
  mode = cfm;
  nst_dfm = 0;
  nst_acm = 0;
  strcpy(item, "atom");
/*  printf(
    "\nCOFIMA %s: coordinate file manipulation\n\n");
*/
  if (!strcmp(modestr, "difima")) change_mode(dfm);
  else if (!strcmp(modestr, "ancoma")) change_mode(acm);
  else change_mode(cfm);
  do {
    if (*inpfil == '\0') do getcmdline(cmd, el, &nel); while (*cmd == '\0');
    else if (inpfil[0] == '@') { strcpy(cmd, inpfil); nel = 0; strcpy(inpfil, ""); }
    else { strcpy(cmd, "read"); strcpy(el[0], inpfil); nel = 1; strcpy(inpfil, ""); }
/*PGdebug printf("cmd=%s, %d\n",cmd,Match(80L,cmd,4L,"HELP"));*/
    
    if (cmd[0] != '@') {
      strcat(UpStr(STR,80L,cmd), "*"); strcpy(cmd,STR); }
    i = Match(80L, cmd, 4L, "HELP") + Match(80L, cmd, 7L, "???????") +
	Match(80L, cmd, 4L, "READ") + Match(80L, cmd, 6L, "RENAME") + Match(
	  80L, cmd, 6L, "DELETE") + Match(80L, cmd, 6L, "INSERT") + Match(80L,
	  cmd, 7L, "WRITEDG") + Match(80L, cmd, 8L, "WRITEPDB") + Match(80L,
	  cmd, 4L, "LIST") + Match(80L, cmd, 9L, "DIRECTORY") + Match(80L,
	  cmd, 3L, "END") + Match(80L, cmd, 4L, "KEEP") + Match(80L, cmd, 7L,
	  "CONNECT") + Match(80L, cmd, 10L, "DISCONNECT") + Match(80L, cmd,
	  4L, "SAVE") + Match(80L, cmd, 6L, "ATTACH") + Match(80L, cmd, 11L,
	  "COORDINATES") + Match(80L, cmd, 6L, "ANGLES") + Match(80L, cmd, 9L,
	  "DISTANCES") + Match(80L, cmd, 10L, "WRITEAMBER") + Match(80L, cmd,
	  4L, "COPY") + Match(80L, cmd, 4L, "BIND") + Match(80L, cmd, 5L,
	  "BREAK") + Match(80L, cmd, 6L, "CHANGE") + Match(80L, cmd, 4L,
	  "TYPE") + Match(80L, cmd, 12L, "WRITEDIAMOND") + Match(80L, cmd, 4L,
	  "LINK") + Match(80L, cmd, 4L, "SORT") + Match(80L, cmd, 6L,
	  "COFIMA") + Match(80L, cmd, 6L, "DIFIMA") +
	Match(80L, cmd, 12L, "WRITELONGDCO") +
	Match(80L, cmd, 8L, "WRITEDCO") +
	Match(80L, cmd, 14L, "WRITEDISMANACO") +
	Match(80L, cmd, 8L, "WRITEACO") +
	Match(80L, cmd, 11L, "WRITEELLIPS") + Match(80L, cmd, 6L, "PSEUDO") +
	Match(80L, cmd, 11L, "FIRSTPSEUDO") +
	Match(80L, cmd, 12L, "SECONDPSEUDO") + Match(80L, cmd, 6L, "ANCOMA") +
	Match(80L, cmd, 11L, "CONSTRAINTS") +
	Match(80L, cmd, 5L, "SHIFT") + Match(80L, cmd, 4L, "QUIT") +
	Match(80L, cmd, 13L, "WRITESHORTDCO") +
	Match(80L, cmd, 6L, "REMOVE") + Match(80L, cmd, 6L, "RETAIN") + 
	Match(80L, cmd, 6L, "EXTRACT");
    switch (i) {
/* p2c: cofima.pas, line 2791: Note:
 * Line breaker spent 0.0+5.02 seconds, 5000 tries on line 6913 [251] */

    case 0:
      if (cmd[0] == '@')
	macro();
      else
	errmsg("unrecognized command");
      break;

    case 1:
      if (mode == cfm) {
	checkqual();
	if (skipcmd)
	  *cmd = '\0';
	else if (Match(80L, cmd, 4L, "HELP"))
	  help();
	else if (Match(80L, cmd, 7L, "???????"))
	  help();
	else if (Match(80L, cmd, 4L, "READ"))
	  Readat();
	else if (Match(80L, cmd, 6L, "RENAME"))
	  Rename();
	else if (Match(80L, cmd, 6L, "DELETE"))
	  delete__(false);
	else if (Match(80L, cmd, 4L, "KEEP"))
	  delete__(true);
	else if (Match(80L, cmd, 6L, "INSERT"))
	  insert_();
	else if (Match(80L, cmd, 6L, "ATTACH"))
	  attach();
	else if (Match(80L, cmd, 7L, "WRITEDG"))
	  writeat(DG);
	else if (Match(80L, cmd, 8L, "WRITEPDB"))
	  writeat(PDB);
	else if (Match(80L, cmd, 10L, "WRITEAMBER"))
	  writeat(AMBER);
	else if (Match(80L, cmd, 12L, "WRITEDIAMOND"))
	  writeat(DIAMOND);
	else if (Match(80L, cmd, 4L, "SAVE"))
	  save();
	else if (Match(80L, cmd, 9L, "DIRECTORY"))
	  directory();
	else if (Match(80L, cmd, 4L, "LIST"))
	  list();
	else if (Match(80L, cmd, 4L, "COPY"))
	  copy_();
	else if (Match(80L, cmd, 4L, "BIND"))
	  bind(true);
	else if (Match(80L, cmd, 5L, "BREAK"))
	  bind(false);
	else if (Match(80L, cmd, 7L, "CONNECT"))
	  connectivities();
	else if (Match(80L, cmd, 4L, "LINK"))
	  link();
	else if (Match(80L, cmd, 10L, "DISCONNECT"))
	  disconnect();
	else if (Match(80L, cmd, 11L, "COORDINATES"))
	  coordinates();
	else if (Match(80L, cmd, 6L, "ANGLES"))
	  angles();
	else if (Match(80L, cmd, 9L, "DISTANCES"))
	  distances(0);
	else if (Match(80L, cmd, 9L, "EXTRACT"))
	  distances(1);
	else if (Match(80L, cmd, 6L, "CHANGE"))
	  change();
	else if (Match(80L, cmd, 4L, "SORT"))
	  sort();
	else if (Match(80L, cmd, 5L, "SHIFT"))
	  shiftnumbers();
	else if (Match(80L, cmd, 4L, "TYPE"))
	  type_macros();
	else if (Match(80L, cmd, 6L, "DIFIMA"))
	  change_mode(dfm);
	else if (Match(80L, cmd, 6L, "ANCOMA"))
	  change_mode(acm);
	else if (!Match(80L, cmd, 3L, "END") && !Match(80L, cmd, 4L, "QUIT"))
	  printf("cofima-warning: illegal command for coordinate files, skipped\n");
      } else if (mode == dfm) {
	checkqual();
	if (skipcmd)
	  *cmd = '\0';
	else if (Match(80L, cmd, 4L, "HELP"))
	  help();
	else if (Match(80L, cmd, 7L, "???????"))
	  help();
	else if (Match(80L, cmd, 4L, "READ"))
	  Readat();
	else if (Match(80L, cmd, 6L, "RENAME"))
	  Rename();
	else if (Match(80L, cmd, 6L, "DELETE"))
	  delete__(false);
	else if (Match(80L, cmd, 4L, "KEEP"))
	  delete__(true);
	else if (Match(80L, cmd, 6L, "PSEUDO"))
	  pseudo(both);
	else if (Match(80L, cmd, 11L, "FIRSTPSEUDO"))
	  pseudo(first_only);
	else if (Match(80L, cmd, 12L, "SECONDPSEUDO"))
	  pseudo(second_only);
	else if (Match(80L, cmd, 8L, "WRITEDCO"))
	  writeconstr(CAST);
	else if (Match(80L, cmd, 13L, "WRITESHORTDCO"))
	  writeconstr(DISMAN);
	else if (Match(80L, cmd, 12L, "WRITELONGDCO"))
	  writeconstr(DISGEO);
	else if (Match(80L, cmd, 4L, "SAVE"))
	  save();
	else if (Match(80L, cmd, 9L, "DIRECTORY"))
	  directory();
	else if (Match(80L, cmd, 4L, "LIST"))
	  list();
	else if (Match(80L, cmd, 11L, "CONSTRAINTS"))
	  constraints();
	else if (Match(80L, cmd, 9L, "DISTANCES"))
	  distances(0);
	else if (Match(80L, cmd, 9L, "REMOVE"))
	  distances(1);
	else if (Match(80L, cmd, 9L, "RETAIN"))
	  distances(2);
	else if (Match(80L, cmd, 6L, "CHANGE"))
	  change();
	else if (Match(80L, cmd, 4L, "SORT"))
	  sort();
	else if (Match(80L, cmd, 5L, "SHIFT"))
	  shiftnumbers();
	else if (Match(80L, cmd, 4L, "TYPE"))
	  type_macros();
	else if (Match(80L, cmd, 6L, "COFIMA"))
	  change_mode(cfm);
	else if (Match(80L, cmd, 6L, "ANCOMA"))
	  change_mode(acm);
	else if (!Match(80L, cmd, 3L, "END") && !Match(80L, cmd, 4L, "QUIT"))
	  printf(
	    "difima-warning: illegal command for distance constraint files, skipped\n");
      } else {
	checkqual();
	if (skipcmd)
	  *cmd = '\0';
	else if (Match(80L, cmd, 4L, "HELP"))
	  help();
	else if (Match(80L, cmd, 7L, "???????"))
	  help();
	else if (Match(80L, cmd, 4L, "READ"))
	  Readat();
	else if (Match(80L, cmd, 6L, "RENAME"))
	  Rename();
	else if (Match(80L, cmd, 6L, "DELETE"))
	  delete__(false);
	else if (Match(80L, cmd, 4L, "KEEP"))
	  delete__(true);
	else if (Match(80L, cmd, 14L, "WRITEDISMANACO"))
	  writeaconstr(DISMAN);
	else if (Match(80L, cmd, 8L, "WRITEACO"))
	  writeaconstr(ELLIPS);
	else if (Match(80L, cmd, 11L, "WRITEELLIPS"))
	  writeaconstr(ELLIPS);
	else if (Match(80L, cmd, 4L, "SAVE"))
	  save();
	else if (Match(80L, cmd, 9L, "DIRECTORY"))
	  directory();
	else if (Match(80L, cmd, 4L, "LIST"))
	  list();
	else if (Match(80L, cmd, 11L, "CONSTRAINTS"))
	  constraints();
	else if (Match(80L, cmd, 6L, "CHANGE"))
	  change();
	else if (Match(80L, cmd, 4L, "SORT"))
	  sort();
	else if (Match(80L, cmd, 5L, "SHIFT"))
	  shiftnumbers();
	else if (Match(80L, cmd, 4L, "TYPE"))
	  type_macros();
	else if (Match(80L, cmd, 6L, "COFIMA"))
	  change_mode(cfm);
	else if (Match(80L, cmd, 6L, "DIFIMA"))
	  change_mode(dfm);
	else if (!Match(80L, cmd, 3L, "END") && !Match(80L, cmd, 4L, "QUIT"))
	  printf(
	    "ancoma-warning: illegal command for angle constraint files, skipped\n");
      }
      break;

    default:
      *cmd = '\0';
      errmsg("ambiguous command, supply more characters");
      break;
    }
  } while (!Match(80L, cmd, 3L, "END") && !Match(80L, cmd, 4L, "QUIT"));
  if (f != NULL)
    fclose(f);
  if (out != NULL)
    fclose(out);
  /*PG*/ iret=system("rm $HOME/cofima.macro");
  exit(0);
}



/* End. */



/* #define LACK_LABS     */   /* Define these if necessary */
/* #define LACK_MEMMOVE  */


#ifndef NO_TIME
# include <time.h>
#endif


#define Isspace(c)  isspace(c)      /* or "((c) == ' ')" if preferred */




int P_argc;
char **P_argv;

short P_escapecode;
int P_ioresult;

long EXCP_LINE;    /* Used by Pascal workstation system */

Anyptr __MallocTemp__;

__p2c_jmp_buf *__top_jb;




void PASCAL_MAIN(argc, argv)
int argc;
char **argv;
{
    P_argc = argc;
    P_argv = argv;
    __top_jb = NULL;

#ifdef LOCAL_INIT
    LOCAL_INIT();
#endif
}





/* In case your system lacks these... */

#ifdef LACK_LABS
long labs(x)
long x;
{
    return((x > 0) ? x : -x);
}
#endif


#ifdef LACK_MEMMOVE
Anyptr memmove(d, s, n)
Anyptr d, s;
register long n;
{
    if (d < s || d - s >= n) {
	memcpy(d, s, n);
	return d;
    } else if (n > 0) {
	register char *dd = d + n, *ss = s + n;
	while (--n >= 0)
	    *--dd = *--ss;
    }
    return d;
}
#endif


int my_toupper(c)
int c;
{
    if (islower(c))
	return _toupper(c);
    else
	return c;
}


int my_tolower(c)
int c;
{
    if (isupper(c))
	return _tolower(c);
    else
	return c;
}




long Ipow(a, b)
long a, b;
{
    long v;

    if (a == 0 || a == 1)
	return a;
    if (a == -1)
	return (b & 1) ? -1 : 1;
    if (b < 0)
	return 0;
    if (a == 2)
	return 1 << b;
    v = (b & 1) ? a : 1;
    while ((b >>= 1) > 0) {
	a *= a;
	if (b & 1)
	    v *= a;
    }
    return v;
}




/* Common string functions: */

/* Store in "ret" the substring of length "len" starting from "pos" (1-based).
   Store a shorter or null string if out-of-range.  Return "ret". */

char *strsub(ret, s, pos, len)
register char *ret, *s;
register int pos, len;
{
    register char *s2;

    if (--pos < 0 || len <= 0) {
        *ret = 0;
        return ret;
    }
    while (pos > 0) {
        if (!*s++) {
            *ret = 0;
            return ret;
        }
        pos--;
    }
    s2 = ret;
    while (--len >= 0) {
        if (!(*s2++ = *s++))
            return ret;
    }
    *s2 = 0;
    return ret;
}


/* Return the index of the first occurrence of "pat" as a substring of "s",
   starting at index "pos" (1-based).  Result is 1-based, 0 if not found. */

int strpos2(s, pat, pos)
char *s;
register char *pat;
register int pos;
{
    register char *cp, ch;
    register int slen;

    if (--pos < 0)
        return 0;
    slen = strlen(s) - pos;
    cp = s + pos;
    if (!(ch = *pat++))
        return 0;
    pos = strlen(pat);
    slen -= pos;
    while (--slen >= 0) {
        if (*cp++ == ch && !strncmp(cp, pat, pos))
            return cp - s;
    }
    return 0;
}


/* Case-insensitive version of strcmp. */

int strcicmp(s1, s2)
register char *s1, *s2;
{
    register unsigned char c1, c2;

    while (*s1) {
	if (*s1++ != *s2++) {
	    if (!s2[-1])
		return 1;
	    c1 = toupper(s1[-1]);
	    c2 = toupper(s2[-1]);
	    if (c1 != c2)
		return c1 - c2;
	}
    }
    if (*s2)
	return -1;
    return 0;
}




/* HP and Turbo Pascal string functions: */

/* Trim blanks at left end of string. */

char *strltrim(s)
register char *s;
{
    while (Isspace(*s++)) ;
    return s - 1;
}


/* Trim blanks at right end of string. */

char *strrtrim(s)
register char *s;
{
    register char *s2 = s;

    if (!*s)
	return s;
    while (*++s2) ;
    while (s2 > s && Isspace(*--s2))
        *s2 = 0;
    return s;
}


/* Store in "ret" "num" copies of string "s".  Return "ret". */

char *strrpt(ret, s, num)
char *ret;
register char *s;
register int num;
{
    register char *s2 = ret;
    register char *s1;

    while (--num >= 0) {
        s1 = s;
        while ((*s2++ = *s1++)) ;
        s2--;
    }
    return ret;
}


/* Store in "ret" string "s" with enough pad chars added to reach "size". */

char *strpad(ret, s, padchar, num)
char *ret;
register char *s;
register int padchar, num;
{
    register char *d = ret;

    if (s == d) {
	while (*d++) ;
    } else {
	while ((*d++ = *s++)) ;
    }
    num -= (--d - ret);
    while (--num >= 0)
	*d++ = padchar;
    *d = 0;
    return ret;
}


/* Copy the substring of length "len" from index "spos" of "s" (1-based)
   to index "dpos" of "d", lengthening "d" if necessary.  Length and
   indices must be in-range. */

void strmove(len, s, spos, d, dpos)
register char *s, *d;
register int len, spos, dpos;
{
    s += spos - 1;
    d += dpos - 1;
    while (*d && --len >= 0)
	*d++ = *s++;
    if (len > 0) {
	while (--len >= 0)
	    *d++ = *s++;
	*d = 0;
    }
}


/* Delete the substring of length "len" at index "pos" from "s".
   Delete less if out-of-range. */

void strdelete(s, pos, len)
register char *s;
register int pos, len;
{
    register int slen;

    if (--pos < 0)
        return;
    slen = strlen(s) - pos;
    if (slen <= 0)
        return;
    s += pos;
    if (slen <= len) {
        *s = 0;
        return;
    }
    while ((*s = s[len])) s++;
}


/* Insert string "src" at index "pos" of "dst". */

void strinsert(src, dst, pos)
register char *src, *dst;
register int pos;
{
    register int slen, dlen;

    if (--pos < 0)
        return;
    dlen = strlen(dst);
    dst += dlen;
    dlen -= pos;
    if (dlen <= 0) {
        strcpy(dst, src);
        return;
    }
    slen = strlen(src);
    do {
        dst[slen] = *dst;
        --dst;
    } while (--dlen >= 0);
    dst++;
    while (--slen >= 0)
        *dst++ = *src++;
}




/* File functions */

/* Peek at next character of input stream; return EOF at end-of-file. */

int P_peek(f)
FILE *f;
{
    int ch;

    ch = getc(f);
    if (ch == EOF)
	return EOF;
    ungetc(ch, f);
    return (ch == '\n') ? ' ' : ch;
}


/* Check if at end of file, using Pascal "eof" semantics.  End-of-file for
   stdin is broken; remove the special case for it to be broken in a
   different way. */

int P_eof(f)
FILE *f;
{
    register int ch;

    if (feof(f))
	return 1;
    if (f == stdin)
	return 0;    /* not safe to look-ahead on the keyboard! */
    ch = getc(f);
    if (ch == EOF)
	return 1;
    ungetc(ch, f);
    return 0;
}


/* Check if at end of line (or end of entire file). */

int P_eoln(f)
FILE *f;
{
    register int ch;

    ch = getc(f);
    if (ch == EOF)
        return 1;
    ungetc(ch, f);
    return (ch == '\n');
}


/* Read a packed array of characters from a file. */

Void P_readpaoc(f, s, len)
FILE *f;
char *s;
int len;
{
    int ch;

    for (;;) {
	if (len <= 0)
	    return;
	ch = getc(f);
	if (ch == EOF || ch == '\n')
	    break;
	*s++ = ch;
	--len;
    }
    while (--len >= 0)
	*s++ = ' ';
    if (ch != EOF)
	ungetc(ch, f);
}

Void P_readlnpaoc(f, s, len)
FILE *f;
char *s;
int len;
{
    int ch;

    for (;;) {
	ch = getc(f);
	if (ch == EOF || ch == '\n')
	    break;
	if (len > 0) {
	    *s++ = ch;
	    --len;
	}
    }
    while (--len >= 0)
	*s++ = ' ';
}


/* Compute maximum legal "seek" index in file (0-based). */

long P_maxpos(f)
FILE *f;
{
    long savepos = ftell(f);
    long val;

    if (fseek(f, 0L, SEEK_END))
        return -1;
    val = ftell(f);
    if (fseek(f, savepos, SEEK_SET))
        return -1;
    return val;
}


/* Use packed array of char for a file name. */

Char *P_trimname(fn, len)
register Char *fn;
register int len;
{
    static Char fnbuf[256];
    register Char *cp = fnbuf;
    
    while (--len >= 0 && *fn && !isspace(*fn))
	*cp++ = *fn++;
    return fnbuf;
}




/* Pascal's "memavail" doesn't make much sense in Unix with virtual memory.
   We fix memory size as 10Meg as a reasonable compromise. */

long memavail()
{
    return 10000000;            /* worry about this later! */
}

long maxavail()
{
    return memavail();
}




/* Sets are stored as an array of longs.  S[0] is the size of the set;
   S[N] is the N'th 32-bit chunk of the set.  S[0] equals the maximum
   I such that S[I] is nonzero.  S[0] is zero for an empty set.  Within
   each long, bits are packed from lsb to msb.  The first bit of the
   set is the element with ordinal value 0.  (Thus, for a "set of 5..99",
   the lowest five bits of the first long are unused and always zero.) */

/* (Sets with 32 or fewer elements are normally stored as plain longs.) */

long *P_setunion(d, s1, s2)         /* d := s1 + s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (sz1 > 0 && sz2 > 0) {
        *d++ = *s1++ | *s2++;
	sz1--, sz2--;
    }
    while (--sz1 >= 0)
	*d++ = *s1++;
    while (--sz2 >= 0)
	*d++ = *s2++;
    *dbase = d - dbase - 1;
    return dbase;
}


long *P_setint(d, s1, s2)           /* d := s1 * s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (--sz1 >= 0 && --sz2 >= 0)
        *d++ = *s1++ & *s2++;
    while (--d > dbase && !*d) ;
    *dbase = d - dbase;
    return dbase;
}


long *P_setdiff(d, s1, s2)          /* d := s1 - s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (--sz1 >= 0 && --sz2 >= 0)
        *d++ = *s1++ & ~*s2++;
    if (sz1 >= 0) {
        while (sz1-- >= 0)
            *d++ = *s1++;
    }
    while (--d > dbase && !*d) ;
    *dbase = d - dbase;
    return dbase;
}


long *P_setxor(d, s1, s2)         /* d := s1 / s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (sz1 > 0 && sz2 > 0) {
        *d++ = *s1++ ^ *s2++;
	sz1--, sz2--;
    }
    while (--sz1 >= 0)
	*d++ = *s1++;
    while (--sz2 >= 0)
	*d++ = *s2++;
    while (--d > dbase && !*d) ;
    *dbase = d - dbase;
    return dbase;
}


int P_inset(val, s)                 /* val IN s */
register unsigned val;
register long *s;
{
    register int bit;
    bit = val % SETBITS;
    val /= SETBITS;
    if (val < *s++ && ((1<<bit) & s[val]))
	return 1;
    return 0;
}


long *P_addset(s, val)              /* s := s + [val] */
register long *s;
register unsigned val;
{
    register long *sbase = s;
    register int bit, size;
    bit = val % SETBITS;
    val /= SETBITS;
    size = *s;
    if (++val > size) {
        s += size;
        while (val > size)
            *++s = 0, size++;
        *sbase = size;
    } else
        s += val;
    *s |= 1<<bit;
    return sbase;
}


long *P_addsetr(s, v1, v2)              /* s := s + [v1..v2] */
register long *s;
register unsigned v1, v2;
{
    register long *sbase = s;
    register int b1, b2, size;
    if ((int)v1 > (int)v2)
	return sbase;
    b1 = v1 % SETBITS;
    v1 /= SETBITS;
    b2 = v2 % SETBITS;
    v2 /= SETBITS;
    size = *s;
    v1++;
    if (++v2 > size) {
        while (v2 > size)
            s[++size] = 0;
        s[v2] = 0;
        *s = v2;
    }
    s += v1;
    if (v1 == v2) {
        *s |= (~((-2)<<(b2-b1))) << b1;
    } else {
        *s++ |= (-1) << b1;
        while (++v1 < v2)
            *s++ = -1;
        *s |= ~((-2) << b2);
    }
    return sbase;
}


long *P_remset(s, val)              /* s := s - [val] */
register long *s;
register unsigned val;
{
    register int bit;
    bit = val % SETBITS;
    val /= SETBITS;
    if (++val <= *s) {
	if (!(s[val] &= ~(1<<bit)))
	    while (*s && !s[*s])
		(*s)--;
    }
    return s;
}


int P_setequal(s1, s2)              /* s1 = s2 */
register long *s1, *s2;
{
    register int size = *s1++;
    if (*s2++ != size)
        return 0;
    while (--size >= 0) {
        if (*s1++ != *s2++)
            return 0;
    }
    return 1;
}


int P_subset(s1, s2)                /* s1 <= s2 */
register long *s1, *s2;
{
    register int sz1 = *s1++, sz2 = *s2++;
    if (sz1 > sz2)
        return 0;
    while (--sz1 >= 0) {
        if (*s1++ & ~*s2++)
            return 0;
    }
    return 1;
}


long *P_setcpy(d, s)                /* d := s */
register long *d, *s;
{
    register long *save_d = d;

#ifdef SETCPY_MEMCPY
    memcpy(d, s, (*s + 1) * sizeof(long));
#else
    register int i = *s + 1;
    while (--i >= 0)
        *d++ = *s++;
#endif
    return save_d;
}


/* s is a "smallset", i.e., a 32-bit or less set stored
   directly in a long. */

long *P_expset(d, s)                /* d := s */
register long *d;
register long s;
{
    if (s) {
	d[1] = s;
	*d = 1;
    } else
        *d = 0;
    return d;
}


long P_packset(s)                   /* convert s to a small-set */
register long *s;
{
    if (*s++)
        return *s;
    else
        return 0;
}





/* Oregon Software Pascal extensions, courtesy of William Bader */

int P_getcmdline(l, h, line)
int l, h;
Char *line;
{
    int i, len;
    char *s;
    
    h = h - l + 1;
    len = 0;
    for(i = 1; i < P_argc; i++) {
	s = P_argv[i];
	while (*s) {
	    if (len >= h) return len;
	    line[len++] = *s++;
	}
	if (len >= h) return len;
	line[len++] = ' ';
    }
    return len;
}

Void TimeStamp(Day, Month, Year, Hour, Min, Sec)
int *Day, *Month, *Year, *Hour, *Min, *Sec;
{
#ifndef NO_TIME
    struct tm *tm;
    time_t clock;

    time(&clock);
    tm = localtime(&clock);
    *Day = tm->tm_mday;
    *Month = tm->tm_mon + 1;		/* Jan = 0 */
    *Year = tm->tm_year;
    if (*Year < 1900)
	*Year += 1900;     /* year since 1900 */
    *Hour = tm->tm_hour;
    *Min = tm->tm_min;
    *Sec = tm->tm_sec;
#endif
}




/* SUN Berkeley Pascal extensions */

Void P_sun_argv(s, len, n)
register char *s;
register int len, n;
{
    register char *cp;

    if ((unsigned)n < P_argc)
	cp = P_argv[n];
    else
	cp = "";
    while (*cp && --len >= 0)
	*s++ = *cp++;
    while (--len >= 0)
	*s++ = ' ';
}




int _OutMem()
{
    return _Escape(-2);
}

int _CaseCheck()
{
    return _Escape(-9);
}

int _NilCheck()
{
    return _Escape(-3);
}





/* The following is suitable for the HP Pascal operating system.
   It might want to be revised when emulating another system. */

char *_ShowEscape(buf, code, ior, prefix)
char *buf, *prefix;
int code, ior;
{
    char *bufp;

    if (prefix && *prefix) {
        strcpy(buf, prefix);
	strcat(buf, ": ");
        bufp = buf + strlen(buf);
    } else {
        bufp = buf;
    }
    if (code == -10) {
        sprintf(bufp, "Pascal system I/O error %d", ior);
        switch (ior) {
            case 3:
                strcat(buf, " (illegal I/O request)");
                break;
            case 7:
                strcat(buf, " (bad file name)");
                break;
            case FileNotFound:   /*10*/
                strcat(buf, " (file not found)");
                break;
            case FileNotOpen:    /*13*/
                strcat(buf, " (file not open)");
                break;
            case BadInputFormat: /*14*/
                strcat(buf, " (bad input format)");
                break;
            case 24:
                strcat(buf, " (not open for reading)");
                break;
            case 25:
                strcat(buf, " (not open for writing)");
                break;
            case 26:
                strcat(buf, " (not open for direct access)");
                break;
            case 28:
                strcat(buf, " (string subscript out of range)");
                break;
            case EndOfFile:      /*30*/
                strcat(buf, " (end-of-file)");
                break;
            case FileWriteError: /*38*/
		strcat(buf, " (file write error)");
		break;
        }
    } else {
        sprintf(bufp, "Pascal system error %d", code);
        switch (code) {
            case -2:
                strcat(buf, " (out of memory)");
                break;
            case -3:
                strcat(buf, " (reference to NIL pointer)");
                break;
            case -4:
                strcat(buf, " (integer overflow)");
                break;
            case -5:
                strcat(buf, " (divide by zero)");
                break;
            case -6:
                strcat(buf, " (real math overflow)");
                break;
            case -8:
                strcat(buf, " (value range error)");
                break;
            case -9:
                strcat(buf, " (CASE value range error)");
                break;
            case -12:
                strcat(buf, " (bus error)");
                break;
            case -20:
                strcat(buf, " (stopped by user)");
                break;
        }
    }
    return buf;
}


int _Escape(code)
int code;
{
    char buf[100];

    P_escapecode = code;
    if (__top_jb) {
	__p2c_jmp_buf *jb = __top_jb;
	__top_jb = jb->next;
	longjmp(jb->jbuf, 1);
    }
    if (code == 0)
        exit(0);
    if (code == -1)
        exit(1);
    fprintf(stderr, "%s\n", _ShowEscape(buf, P_escapecode, P_ioresult, ""));
    exit(1);
    return code;  /*PG to avoid SGI warning: non-void function "_Escape" should return a value */
}

int _EscIO(code)
int code;
{
    P_ioresult = code;
    return _Escape(-10);
}




/* End. */



