# change from DIANA to OPAL nomenclature: proteins and DNA

delete/COFIMA Q*                     # remove pseudoatoms
delete/COFIMA @PL @NL @LL* @LP @LN   # remove pseudo-linkers

# modify end groups in DNA
attach HTMP C4' C5' O5' P  0.96 108.5 0.0 @first
delete OP1 OP2 P @first
change HTMP O5' @first @HB
change HTMP O5' @first -1
rename HTMP HB @HB
attach HE C4' C3' O3' 0.96 108.5 180.0 @last
change HE O3' @last @HE
change HE O3' @last +1

# delete protons
delete HD2 @ASP
delete HE2 @GLU

# attach missing protons
attach HN12 NE CZ NH1 HN11 1.01 119.8  180.0 @ARG
delete/COFIMA  HNZ2                          @LYS
attach HNZ2 CD CE NZ  HNZ1 1.01 109.47 120.0 @LYS
attach HNZ3 CD CE NZ  HNZ1 1.01 109.47 240.0 @LYS

# new residue names
change @ARG @ARG+
change @LYS @LYS+
change @ASP @ASP-
change @GLU @GLU-

# generate connectivities
connect
link 2.5 SG @CYSS SG @CYSS

# attach "lone pairs" to sulphur atoms, AMBER conventions
attach LP1 CA CB SG ~SG  0.679 96.7  98.0 @CYSS
attach LP2 CA CB SG ~SG  0.679 96.7 -98.0 @CYSS
attach LP1 CA CB SG  HG  0.679 96.7  98.0 @CYS
attach LP2 CA CB SG  HG  0.679 96.7 -98.0 @CYS
attach LP1 CB CG SD  CE  0.679 96.7  98.0 @MET
attach LP2 CB CG SD  CE  0.679 96.7 -98.0 @MET

# N-terminus
attach HN1 C CA N HN  1.014 109.47   0.0 @first
attach HN2 C CA N HN1 1.014 109.47 120.0 @first
attach HN3 C CA N HN1 1.014 109.47 240.0 @first
delete/COFIMA  HN         @first
rename/DIFIMA  HN HN1     @first

# C-terminus
attach OB  N CA C O   1.25  117.0  180.0 @last
rename O OA @last

# generate connectivities (terminal residues and LPs!)
connect H*=0.4 C*=0.85 N*=0.8 O*=0.7 S*=1.3 P*=1.2 Q*=-999 LP*=0.5 *=0.85
link 2.5 SG @CYSS SG @CYSS

# Lit.: DIANA   G"untert P., Braun, W. & W"uthrich, K. (1991)
#               J. Mol. Bio. 217, p. 517-530.

