/*
 * Decompiled with CFR 0.152.
 */
package visualization.snapshots;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.WritableImage;
import model.experiment.ExperimentSimplePiston;
import multimedia.Compression;
import settings.Settings;
import visualization.gui.components.MainStageController;
import visualization.gui.rendering.ExperimentRenderer;
import visualization.main.GlobalClock;
import visualization.snapshots.ExperimentSnapshot;

public class ExperimentSnapshotCollector {
    private final ArrayList<ExperimentSnapshot> snapshots = new ArrayList();
    private final ArrayList<ExperimentSnapshot> snapshotsTemporary = new ArrayList();
    private final ArrayList<ExperimentSnapshot> snapshotsEndOfStageFine = new ArrayList();
    private final ArrayList<ExperimentSnapshot> snapshotsEndOfStageAveraged = new ArrayList();
    private final ArrayList<ExperimentSnapshot> snapshotsTemporaryBuffered = new ArrayList();
    private final ArrayList<String> stageNames = new ArrayList();
    private final ArrayList<byte[]> frames = new ArrayList();
    private final ExperimentRenderer renderer;
    private double lastRecordingTime = 0.0;
    private double lastFrameTime = 0.0;
    private final int width;
    private final int height;

    public ExperimentSnapshotCollector(ExperimentSimplePiston e, int width, int height, MainStageController overlordIn) {
        this.renderer = new ExperimentRenderer(e, width, height, overlordIn);
        this.width = width;
        this.height = height;
    }

    public void collectSnapshot(ExperimentSimplePiston e) {
        this.snapshotsTemporary.add(new ExperimentSnapshot(e));
        this.snapshotsTemporaryBuffered.add(this.snapshotsTemporary.get(this.snapshotsTemporary.size() - 1));
        if (GlobalClock.t - this.lastRecordingTime >= (double)Settings.recordingsIntervalSteps) {
            this.snapshots.add(new ExperimentSnapshot(this.snapshotsTemporary));
            this.snapshotsTemporary.clear();
            this.lastRecordingTime = GlobalClock.t;
        }
        if (this.snapshotsTemporaryBuffered.size() == 2) {
            if (!this.snapshotsTemporaryBuffered.get(0).getCurrentStage().equals(this.snapshotsTemporaryBuffered.get(1).getCurrentStage())) {
                this.stageNames.add(this.snapshotsTemporaryBuffered.get(0).getCurrentStage());
                this.snapshotsEndOfStageFine.add(this.snapshotsTemporaryBuffered.get(0));
                if (this.snapshots.size() >= 1) {
                    this.snapshotsEndOfStageAveraged.add(this.snapshots.get(this.snapshots.size() - 1));
                } else {
                    this.snapshotsEndOfStageAveraged.add(this.snapshotsTemporaryBuffered.get(0));
                }
            }
            if (GlobalClock.t == (double)(Settings.numberOfTimeSteps - 1)) {
                this.stageNames.add(this.snapshotsTemporaryBuffered.get(1).getCurrentStage());
                this.snapshotsEndOfStageFine.add(this.snapshotsTemporaryBuffered.get(1));
            }
            this.snapshotsTemporaryBuffered.remove(0);
        }
        if (GlobalClock.t - this.lastFrameTime >= (double)Settings.frameIntervalSteps) {
            BufferedImage tmp = this.renderer.drawExperimentState(e.getDisplayStatistics(), this.snapshots.get(this.snapshots.size() - 1).getCurrentStage());
            try {
                this.frames.add(Compression.compressImage(tmp));
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            this.lastFrameTime = GlobalClock.t;
        }
    }

    public int lenRecording() {
        return this.snapshots.size();
    }

    public int lenImages() {
        return this.frames.size();
    }

    public int lenEndOfStageRecording() {
        return this.snapshotsEndOfStageFine.size();
    }

    public WritableImage getImage(int position) {
        try {
            if (position < this.frames.size()) {
                byte[] tmp = this.frames.get(position);
                BufferedImage output = Compression.decompressImage(tmp);
                WritableImage wi = new WritableImage(output.getWidth(), output.getHeight());
                SwingFXUtils.toFXImage((BufferedImage)output, (WritableImage)wi);
                return wi;
            }
            return new WritableImage(Settings.visualizationWidth, Settings.visualizationHeight);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new WritableImage(Settings.visualizationWidth, Settings.visualizationHeight);
        }
    }

    public ExperimentSnapshot getSnapshot(int position) {
        return this.snapshots.get(position);
    }

    public ExperimentSnapshot getSnapshotEndOfStage(int position) {
        return this.snapshotsEndOfStageFine.get(position);
    }

    public ExperimentSnapshot getSnapshotEndOfStageAveraged(int position) {
        return this.snapshotsEndOfStageAveraged.get(position);
    }

    public String getStageName(int Position) {
        return this.stageNames.get(Position);
    }
}

