/*
 * Decompiled with CFR 0.152.
 */
package visualization.main;

import java.util.Locale;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.stage.Stage;
import settings.Settings;
import visualization.gui.components.MainStageController;

public class Main
extends Application {
    public void start(Stage primaryStage) throws Exception {
        try {
            Stage stage;
            Locale currentLocale = Locale.getDefault();
            Locale.setDefault(new Locale.Builder().setLanguage("US").setRegion("US").build());
            Rectangle2D rec = null;
            for (Screen s : Screen.getScreens()) {
                Rectangle2D r = s.getVisualBounds();
                if (rec != null && !(r.getWidth() > rec.getWidth())) continue;
                rec = r;
            }
            Settings.screenArea = rec;
            MainStageController controller = new MainStageController();
            FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/src/visualization/gui/components/mainStage.fxml"));
            fxmlLoader.setController((Object)controller);
            controller.mainStage = stage = new Stage();
            stage.setTitle("Carnot software");
            stage.setScene(new Scene((Parent)fxmlLoader.load(), 1900.0, 1000.0));
            stage.setX(rec.getMinX());
            stage.setY(rec.getMinY());
            stage.setWidth(rec.getWidth());
            stage.setHeight(rec.getHeight());
            stage.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.out.println("Application started with following commandline arguments: ");
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i]);
        }
        System.out.println("Name of detected operating system: " + System.getProperty("os.name"));
        Main.launch((String[])args);
    }
}

