/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.io.File;
import javafx.geometry.Rectangle2D;

public class Settings {
    public static final int OS_WINDOWS = 0;
    public static final int OS_LINUX = 1;
    public static final int OS_MACOS = 2;
    public static final File hiddenDefaultDirectory = new File(System.getProperty("user.dir"));
    public static final File hiddenTemporaryDirectory = new File(hiddenDefaultDirectory.getAbsolutePath() + "/tmp/");
    public static final File hiddenTemporaryExperimentFile = new File(hiddenTemporaryDirectory.getAbsolutePath() + "/experimentFileTmp.txt");
    public static File hiddenCurrentDirectoryExperiment = hiddenDefaultDirectory;
    public static File hiddenCurrentDirectoryResults = hiddenDefaultDirectory;
    public static final boolean hiddenAllowParticleExchange = true;
    public static double temperatureMaxColoring = 800.0;
    public static boolean plotAllParticles = false;
    public static int delayBetweenPlottedParticles = 10;
    public static int visualizationWidth = 1600;
    public static int visualizationHeight = 900;
    public static double timeFactor = 1.0;
    public static double zoom = 1.0;
    public static Rectangle2D screenArea;
    public static double totalTime;
    public static double timePerStep;
    public static int animationFPS;
    public static double zFront;
    public static double zBack;
    public static boolean allowHeating;
    public static boolean recordHeat;
    public static boolean recordWork;
    public static double chamberWidth;
    public static double chamberHeight;
    public static double chamberDepth;
    public static boolean stopProgramExecutionOnException;
    public static int recordingsPerSecond;
    public static double pixelsInAMeter;
    public static double pixelsInAMeter2;
    public static double pixelsInAMeter3;
    public static int numberOfTimeSteps;
    public static int numberOfFrames;
    public static int frameIntervalSteps;
    public static int numberOfRecordings;
    public static int recordingsIntervalSteps;
    public static int operatingSystem;

    public static void update() {
        pixelsInAMeter = 750.0 / Math.max(chamberWidth, chamberHeight);
        pixelsInAMeter2 = pixelsInAMeter * pixelsInAMeter;
        pixelsInAMeter3 = pixelsInAMeter2 * pixelsInAMeter;
        zFront = 0.0;
        zBack = pixelsInAMeter * chamberDepth;
        numberOfTimeSteps = (int)(totalTime / timePerStep);
        numberOfFrames = (int)(totalTime * (double)animationFPS / timeFactor);
        frameIntervalSteps = numberOfTimeSteps / numberOfFrames;
        numberOfRecordings = (int)(totalTime * (double)recordingsPerSecond / timeFactor);
        recordingsIntervalSteps = numberOfTimeSteps / numberOfRecordings;
    }

    public static File getResultsDirectory() {
        return hiddenCurrentDirectoryResults != hiddenDefaultDirectory ? hiddenCurrentDirectoryResults : hiddenCurrentDirectoryExperiment;
    }

    public static File getExperimentsDirectory() {
        return hiddenCurrentDirectoryExperiment != hiddenDefaultDirectory ? hiddenCurrentDirectoryExperiment : hiddenCurrentDirectoryResults;
    }

    public static void makeTmpDir() {
        hiddenTemporaryDirectory.mkdirs();
    }

    static {
        totalTime = 1.0;
        timePerStep = 1.0E-4;
        animationFPS = 100;
        zFront = 0.0;
        zBack = 750.0;
        allowHeating = false;
        recordHeat = false;
        recordWork = false;
        chamberWidth = 1.0;
        chamberHeight = 1.0;
        chamberDepth = 1.0;
        stopProgramExecutionOnException = true;
        recordingsPerSecond = 100;
        pixelsInAMeter = 750.0 / Math.max(chamberWidth, chamberHeight);
        pixelsInAMeter2 = pixelsInAMeter * pixelsInAMeter;
        pixelsInAMeter3 = pixelsInAMeter2 * pixelsInAMeter;
        numberOfTimeSteps = (int)(totalTime / timePerStep);
        numberOfFrames = (int)(totalTime * (double)animationFPS / timeFactor);
        frameIntervalSteps = numberOfTimeSteps / numberOfFrames;
        numberOfRecordings = (int)(totalTime * (double)recordingsPerSecond / timeFactor);
        recordingsIntervalSteps = numberOfTimeSteps / numberOfRecordings;
        operatingSystem = -1;
    }
}

