/*
 * Decompiled with CFR 0.152.
 */
package visualization.gui.components;

import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.SnapshotParameters;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javax.imageio.ImageIO;
import multimedia.VTLPlotUtils;
import settings.Settings;
import visualization.gui.components.MainStageController;
import visualization.snapshots.ExperimentSnapshotCollector;

public class GraphController
implements Initializable {
    public static final int GRAPH_TIME_PROPERTY = 1;
    public static final int GRAPH_PROPERTY_PROPERTY = 2;
    public static final int GRAPH_DISTRIBUTION = 3;
    @FXML
    public ComboBox<String> comboBoxGraphName = new ComboBox();
    public ComboBox<String> comboBoxPropertyNameY = new ComboBox();
    public ComboBox<String> comboBoxPropertyNameX = new ComboBox();
    public Label labelPropertyNameX = new Label();
    public Label labelPropertyNameY = new Label();
    public LineChart<Number, Number> chart;
    public MenuItem saveMenuItem = new MenuItem();
    public BorderPane graphLayout = new BorderPane();
    @FXML
    private XYChart.Series<Number, Number> series1;
    @FXML
    private XYChart.Series<Number, Number> series2;
    ObservableList<String> propertyNames = FXCollections.observableArrayList();
    ObservableList<String> graphNames = FXCollections.observableArrayList();
    private final String[] graphTypes = new String[]{"Statistic/Time graph", "Statistic/Statistic graph", "Maxwell-Boltzmann graph"};
    private final ExperimentSnapshotCollector snapshotCollector;
    private final MainStageController overlord;

    public GraphController(ExperimentSnapshotCollector snapshotCollectorIn, MainStageController mainStageControllerIn) {
        this.snapshotCollector = snapshotCollectorIn;
        this.overlord = mainStageControllerIn;
        this.propertyNames.addAll(this.snapshotCollector.getSnapshot(0).getParameterNames());
        this.graphNames.addAll((Object[])this.graphTypes);
        this.comboBoxGraphName.getItems().addAll(this.graphNames);
    }

    public void close() {
        ((Stage)this.chart.getScene().getWindow()).close();
    }

    public void save() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Graph");
        fileChooser.setInitialDirectory(new File(System.getProperty("user.dir")));
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("PNG files (*.png)", new String[]{"*.png"});
        fileChooser.getExtensionFilters().add((Object)filter);
        File file = fileChooser.showSaveDialog(this.graphLayout.getScene().getWindow());
        WritableImage image = this.chart.snapshot(new SnapshotParameters(), null);
        if (file != null) {
            try {
                ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)image, null), "png", file);
            }
            catch (IOException e) {
                System.out.println("Error writing image");
            }
        }
    }

    public void saveCsv() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Graph");
        fileChooser.setInitialDirectory(new File(System.getProperty("user.dir")));
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
        fileChooser.getExtensionFilters().add((Object)filter);
        File file = fileChooser.showSaveDialog(this.graphLayout.getScene().getWindow());
        if (file != null) {
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                int numSeries = this.chart.getData().size();
                int[] seriesLen = new int[numSeries];
                for (int i = 0; i < numSeries; ++i) {
                    seriesLen[i] = ((XYChart.Series)this.chart.getData().get(i)).getData().size();
                }
                int maxLen = Arrays.stream(seriesLen).min().getAsInt();
                switch (this.getGraphType()) {
                    case 1: {
                        bw.write(String.format("Time,%s\n", this.comboBoxPropertyNameY.getValue()));
                        break;
                    }
                    case 2: {
                        bw.write(String.format("%s,%s\n", this.comboBoxPropertyNameX.getValue(), this.comboBoxPropertyNameY.getValue()));
                        break;
                    }
                    case 3: {
                        bw.write("Speed,pdf\n");
                    }
                }
                block12: for (int l = 0; l < maxLen; ++l) {
                    switch (this.getGraphType()) {
                        case 1: 
                        case 2: {
                            ObservableList series0 = ((XYChart.Series)this.chart.getData().get(0)).getData();
                            bw.write(String.format("%f,%f\n", (double)((Double)((Number)((XYChart.Data)series0.get(l)).getXValue())), (double)((Double)((Number)((XYChart.Data)series0.get(l)).getYValue()))));
                            continue block12;
                        }
                        case 3: {
                            ObservableList seriesD1 = ((XYChart.Series)this.chart.getData().get(0)).getData();
                            bw.write(String.format("%d-%d,%f\n", ((Number)((XYChart.Data)seriesD1.get(l)).getXValue()).intValue(), ((Number)((XYChart.Data)seriesD1.get(l)).getXValue()).intValue() + 4, ((Number)((XYChart.Data)seriesD1.get(l)).getYValue()).doubleValue()));
                        }
                    }
                }
                bw.flush();
                bw.close();
            }
            catch (IOException e) {
                System.out.println("Error writing image");
            }
        }
    }

    public int getGraphType() {
        if (((String)this.comboBoxGraphName.getValue()).equals(this.graphTypes[0])) {
            return 1;
        }
        if (((String)this.comboBoxGraphName.getValue()).equals(this.graphTypes[1])) {
            return 2;
        }
        if (((String)this.comboBoxGraphName.getValue()).equals(this.graphTypes[2])) {
            return 3;
        }
        return -1;
    }

    public void statisticSelected() {
        switch (this.getGraphType()) {
            case 1: {
                this.comboBoxPropertyNameY.getItems().addAll(this.propertyNames);
                this.comboBoxPropertyNameY.setVisible(true);
                this.comboBoxPropertyNameY.show();
                this.comboBoxPropertyNameX.getItems().clear();
                this.comboBoxPropertyNameX.setVisible(false);
                this.comboBoxPropertyNameX.hide();
                this.labelPropertyNameX.setVisible(false);
                this.labelPropertyNameY.setVisible(true);
                break;
            }
            case 2: {
                this.comboBoxPropertyNameY.getItems().addAll(this.propertyNames);
                this.comboBoxPropertyNameY.setVisible(true);
                this.comboBoxPropertyNameY.show();
                this.comboBoxPropertyNameX.getItems().addAll(this.propertyNames);
                this.comboBoxPropertyNameX.setVisible(true);
                this.comboBoxPropertyNameX.show();
                this.labelPropertyNameX.setVisible(true);
                this.labelPropertyNameY.setVisible(true);
                break;
            }
            case 3: {
                this.comboBoxPropertyNameY.getItems().clear();
                this.comboBoxPropertyNameY.setVisible(false);
                this.comboBoxPropertyNameY.hide();
                this.comboBoxPropertyNameX.getItems().clear();
                this.comboBoxPropertyNameX.setVisible(false);
                this.comboBoxPropertyNameX.hide();
                this.labelPropertyNameX.setVisible(false);
                this.labelPropertyNameY.setVisible(false);
            }
        }
    }

    private double[] getAxisRange(double min_val, double max_val) {
        double num_dec_places = Math.round(Math.log10((max_val - min_val) / 10.0));
        double margin = Math.pow(10.0, num_dec_places);
        double axis_min_round = min_val - min_val % Math.pow(10.0, num_dec_places) - margin;
        double axis_max_round = max_val + (Math.pow(10.0, num_dec_places) - max_val % Math.pow(10.0, num_dec_places)) + margin;
        return new double[]{axis_min_round, axis_max_round, margin};
    }

    @FXML
    private void plot() {
        try {
            this.chart.getStylesheets().add((Object)this.getClass().getResource("/visualization/resources/css/graph_plot.css").toURI().toURL().toExternalForm());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (((String)this.comboBoxGraphName.getValue()).equals(this.graphTypes[0])) {
            Platform.runLater(() -> {
                try {
                    this.chart.getData().clear();
                    this.series1 = new XYChart.Series();
                    this.chart.getData().add(this.series1);
                    for (int n = 0; n < this.snapshotCollector.lenRecording(); ++n) {
                        if (this.snapshotCollector.getSnapshot(n) == null) continue;
                        double val = this.snapshotCollector.getSnapshot(n).getState().get(this.comboBoxPropertyNameY.getValue());
                        this.series1.getData().add((Object)new XYChart.Data((Object)(((double)n + 1.0) / (double)Settings.recordingsPerSecond), (Object)val));
                    }
                    this.chart.getXAxis().setLabel("Time [s.]");
                    this.chart.getYAxis().setLabel((String)this.comboBoxPropertyNameY.getValue());
                    this.chart.getYAxis().setAutoRanging(false);
                    this.chart.setLegendVisible(false);
                    VTLPlotUtils.formatLineChart(this.chart, false, true);
                    this.chart.getXAxis().setAutoRanging(false);
                    double lengthAxis = (double)this.snapshotCollector.lenRecording() / (double)Settings.recordingsPerSecond;
                    ((NumberAxis)this.chart.getXAxis()).setUpperBound(lengthAxis);
                    ((NumberAxis)this.chart.getXAxis()).setTickUnit(Math.pow(10.0, Math.round(Math.log10(lengthAxis / 10.0))));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } else if (((String)this.comboBoxGraphName.getValue()).equals(this.graphTypes[1])) {
            Platform.runLater(() -> {
                this.chart.getData().clear();
                this.series1 = new XYChart.Series();
                this.chart.getData().add(this.series1);
                for (int n = 0; n < this.snapshotCollector.lenRecording(); ++n) {
                    if (this.snapshotCollector.getSnapshot(n) == null) continue;
                    double val1 = this.snapshotCollector.getSnapshot(n).getState().get(this.comboBoxPropertyNameX.getValue());
                    double val2 = this.snapshotCollector.getSnapshot(n).getState().get(this.comboBoxPropertyNameY.getValue());
                    this.series1.getData().add((Object)new XYChart.Data((Object)val1, (Object)val2));
                }
                this.chart.getXAxis().setLabel((String)this.comboBoxPropertyNameX.getValue());
                this.chart.getYAxis().setLabel((String)this.comboBoxPropertyNameY.getValue());
                this.chart.setLegendVisible(false);
                VTLPlotUtils.formatLineChart(this.chart, true, true);
            });
        } else if (((String)this.comboBoxGraphName.getValue()).equals(this.graphTypes[2])) {
            Platform.runLater(() -> {
                try {
                    this.chart.getData().clear();
                    this.series1 = new XYChart.Series();
                    this.chart.getData().add(this.series1);
                    int currentTime = this.overlord.getCurrentTime() * (Settings.numberOfRecordings / Settings.numberOfFrames);
                    if (this.snapshotCollector.getSnapshot(currentTime) != null) {
                        double[] experimentalMB = this.snapshotCollector.getSnapshot(currentTime).getDistributions().get("Experimental Maxwell Boltzmann Distribution");
                        for (int n = 0; n < experimentalMB.length; ++n) {
                            this.series1.getData().add((Object)new XYChart.Data((Object)(4.0 * (double)n), (Object)experimentalMB[n]));
                        }
                    }
                    this.series1.setName("Particle Speed Distribution");
                    this.chart.getXAxis().setLabel("particle speed [m/s]");
                    this.chart.getYAxis().setLabel("pdf");
                    this.chart.setLegendVisible(true);
                    VTLPlotUtils.formatLineChart(this.chart, true, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.chart.setAxisSortingPolicy(LineChart.SortingPolicy.NONE);
        this.comboBoxPropertyNameX.setVisible(false);
        this.comboBoxPropertyNameY.setVisible(false);
        this.labelPropertyNameX.setVisible(false);
        this.labelPropertyNameY.setVisible(false);
        this.comboBoxGraphName.getItems().addAll(this.graphNames);
        NumberAxis xAxis = new NumberAxis();
        NumberAxis yAxis = new NumberAxis();
        xAxis.setLabel("t [steps]");
        yAxis.setLabel("Value");
    }
}

