/*
 * Decompiled with CFR 0.152.
 */
package multimedia;

import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;

public class VTLPlotUtils {
    public static double[] getAxisRangeBordered(double min_val, double max_val) {
        if (Math.abs(min_val - max_val) < 1.0E-4) {
            min_val -= 1.0E-4;
            max_val += 1.0E-4;
        }
        double num_dec_places = Math.round(Math.log10((max_val - min_val) / 10.0));
        double margin = Math.pow(10.0, num_dec_places);
        double axis_min_round = min_val - min_val % Math.pow(10.0, num_dec_places) - margin;
        double axis_max_round = max_val + (Math.pow(10.0, num_dec_places) - max_val % Math.pow(10.0, num_dec_places)) + margin;
        return new double[]{axis_min_round, axis_max_round, margin};
    }

    public static void formatLineChart(LineChart<Number, Number> chart, boolean formatXAxis, boolean formatYAxis) {
        XYChart.Series series = (XYChart.Series)chart.getData().get(0);
        double xMin = 1000000.0;
        double xMax = -1000000.0;
        double yMin = 1000000.0;
        double yMax = -1000000.0;
        for (int n = 0; n < series.getData().size(); ++n) {
            XYChart.Data data = (XYChart.Data)series.getData().get(n);
            xMin = Math.min(xMin, (Double)data.getXValue());
            xMax = Math.max(xMax, (Double)data.getXValue());
            yMin = Math.min(yMin, (Double)data.getYValue());
            yMax = Math.max(yMax, (Double)data.getYValue());
        }
        if (formatXAxis) {
            double[] axisRange = VTLPlotUtils.getAxisRangeBordered(xMin, xMax);
            chart.getXAxis().setAutoRanging(false);
            ((NumberAxis)chart.getXAxis()).setLowerBound(axisRange[0]);
            ((NumberAxis)chart.getXAxis()).setUpperBound(axisRange[1]);
            ((NumberAxis)chart.getXAxis()).setTickUnit(axisRange[2]);
        }
        if (formatYAxis) {
            double[] axisRange = VTLPlotUtils.getAxisRangeBordered(yMin, yMax);
            chart.getYAxis().setAutoRanging(false);
            ((NumberAxis)chart.getYAxis()).setLowerBound(axisRange[0]);
            ((NumberAxis)chart.getYAxis()).setUpperBound(axisRange[1]);
            ((NumberAxis)chart.getYAxis()).setTickUnit(axisRange[2]);
        }
    }
}

