/*
 * Decompiled with CFR 0.152.
 */
package model.components.schedulers;

import model.components.schedulers.Scheduler;
import model.experiment.ExperimentSimplePiston;
import settings.Settings;
import visualization.gui.components.MainStageController;

public class TemperatureScheduler
extends Scheduler<ExperimentSimplePiston> {
    private final boolean allowHeating;
    private final double targetTemperature;
    private final double newRate;

    public TemperatureScheduler(String name, boolean allowHeating, double targetTemperature, double newRate, double time, MainStageController overlordIn) {
        this.type = "Temperature";
        this.name = name;
        this.allowHeating = allowHeating;
        this.targetTemperature = targetTemperature;
        this.newRate = newRate;
        this.time = time;
        this.overlord = overlordIn;
    }

    public String toString() {
        return String.format("%s/Temperature Scheduler: T = %.2f K, t=%.2f s.", this.name, this.targetTemperature, this.time);
    }

    public boolean isHeatingAllowed() {
        return this.allowHeating;
    }

    public double getTemperature() {
        return this.targetTemperature;
    }

    @Override
    public void update(double timeIn) {
        double timeForChange = timeIn / (double)Settings.numberOfTimeSteps * Settings.totalTime;
        if (!this.hasFired && timeForChange >= this.time) {
            Settings.allowHeating = this.allowHeating;
            this.overlord.getExperiment().setTempHeater(this.targetTemperature);
            this.overlord.getExperiment().heaterParameter = this.newRate;
            this.hasFired = true;
        }
    }
}

