/*
 * Decompiled with CFR 0.152.
 */
package model.components.basic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;
import model.components.core.VTLComponent;
import model.physics.properties.DynamicObject;
import settings.Settings;
import visualization.gui.UtilsUI;

public class Particle
extends VTLComponent
implements DynamicObject {
    private final double mAtomic;
    private final double mParticle;
    private final double r;
    private double[] pos;
    private double[] v;
    private double speed;

    public Particle(double mAtomicIn, double mParticleIn, double rIn, double[] posIn, double[] vIn) {
        this.mAtomic = mAtomicIn;
        this.mParticle = mParticleIn;
        this.r = rIn;
        this.pos = posIn;
        this.setV(vIn);
    }

    @Override
    public void draw(Graphics2D context) {
        Color c = UtilsUI.getTemperatureColor(this);
        context.setPaint(c);
        context.fillOval((int)(this.pos[0] - this.r), (int)(this.pos[1] - this.r), (int)(2.0 * this.r + 1.0), (int)(2.0 * this.r + 1.0));
    }

    @Override
    public void update(double dt) {
        this.pos[0] = this.pos[0] + dt * this.v[0] * Settings.pixelsInAMeter;
        this.pos[1] = this.pos[1] + dt * this.v[1] * Settings.pixelsInAMeter;
        this.pos[2] = this.pos[2] + dt * this.v[2] * Settings.pixelsInAMeter;
    }

    @Override
    public double[] getPosition() {
        return this.pos;
    }

    public double getX() {
        return this.pos[0];
    }

    public double getY() {
        return this.pos[1];
    }

    public double getZ() {
        return this.pos[2];
    }

    public double getMAtomic() {
        return this.mAtomic;
    }

    @Override
    public double getM() {
        return this.mParticle;
    }

    public double getR() {
        return this.r;
    }

    @Override
    public HashMap<String, Double> getState() {
        return null;
    }

    @Override
    public double[] getV() {
        return this.v;
    }

    public double getVX() {
        return this.v[0];
    }

    public double getVY() {
        return this.v[1];
    }

    public double getVZ() {
        return this.v[2];
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setPos(double[] newPosition) {
        this.pos = newPosition;
    }

    @Override
    public void setV(double[] v) {
        this.v = v;
        this.speed = Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    @Override
    public String toXML() {
        return null;
    }

    @Override
    public VTLComponent fromXML(String XMLString) {
        return null;
    }
}

