/*
 * Decompiled with CFR 0.152.
 */
package visualization.gui.components;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import model.components.schedulers.PistonScheduler;
import model.components.schedulers.PressureScheduler;
import model.components.schedulers.RecordingScheduler;
import model.components.schedulers.Scheduler;
import model.components.schedulers.StageScheduler;
import model.components.schedulers.TemperatureScheduler;
import model.experiment.ExperimentSimplePiston;
import settings.Settings;
import visualization.gui.UtilsUI;
import visualization.gui.components.MainStageController;
import visualization.gui.components.NewExperimentSchedulerBoxController;
import visualization.gui.popup.DefaultPopups;

public class SimplePistonSettingsWindowController
implements Initializable {
    @FXML
    public BorderPane root = new BorderPane();
    @FXML
    public Button doneButton = new Button();
    public HBox schedulerHBox = new HBox();
    @FXML
    public TextField stepSizeField = new TextField();
    public TextField animationFPSField = new TextField();
    public TextField reportsPerSecondField = new TextField();
    public TextField timeFactorField = new TextField();
    @FXML
    public TextField molesField = new TextField();
    public TextField particlesField = new TextField();
    public TextField particleMassField = new TextField();
    public TextField particleTemperatureField = new TextField();
    public TextField particleExchangeRateField = new TextField();
    @FXML
    public TextField chamberWidth = new TextField();
    public TextField chamberHeight = new TextField();
    public TextField chamberDepth = new TextField();
    public TextField pistonMassField = new TextField();
    @FXML
    public TextField externalPressureField = new TextField();
    private final String separator = ": ";
    public ArrayList<TextField> textFieldArrayList = new ArrayList();
    public ArrayList<String> textFieldNameArrayList = new ArrayList<String>(Arrays.asList("  Step size                    : ", "  Animation fps                : ", "  Reports per second           : ", "  Number of moles              : ", "  Number of particles          : ", "  Particle mass                : ", "  Initial particle temperature : ", "  Particle heat exchange rate  : ", "  Chamber width                : ", "  Chamber height               : ", "  Chamber depth                : ", "  Piston mass                  : ", "  Initial heater temperature   : ", "  Heater rate                  : ", "  External pressure            : "));
    @FXML
    MenuItem menuLoad;
    @FXML
    public Button returnButton = new Button();
    public Button runNewButton = new Button();
    public Button ignoreButton = new Button();
    MainStageController overlord;
    ArrayList<NewExperimentSchedulerBoxController> addedSchedules = new ArrayList();

    private void initializeArrayList() {
        this.textFieldArrayList.add(this.stepSizeField);
        UtilsUI.attachNumericalValidator(this.stepSizeField, 1.0E-5, 1.0E-4, 1, true, true);
        this.textFieldArrayList.add(this.animationFPSField);
        UtilsUI.attachNumericalValidator(this.animationFPSField, 20.0, 20.0, 0, true, true);
        this.textFieldArrayList.add(this.reportsPerSecondField);
        UtilsUI.attachNumericalValidator(this.reportsPerSecondField, 100.0, 10000.0, 0, true, true);
        this.textFieldArrayList.add(this.molesField);
        UtilsUI.attachNumericalValidator(this.molesField, 1.0E-6, 1000000.0, 1, true, true);
        this.textFieldArrayList.add(this.particlesField);
        UtilsUI.attachNumericalValidator(this.particlesField, 5000.0, 30000.0, 0, true, true);
        this.textFieldArrayList.add(this.particleMassField);
        UtilsUI.attachNumericalValidator(this.particleMassField, 1.0E-6, 1000000.0, 1, true, true);
        this.textFieldArrayList.add(this.particleTemperatureField);
        UtilsUI.attachNumericalValidator(this.particleTemperatureField, 1.0E-6, 1000.0, 1, true, true);
        this.textFieldArrayList.add(this.particleExchangeRateField);
        UtilsUI.attachNumericalValidator(this.particleExchangeRateField, 1.0E-6, 1000000.0, 1, true, true);
        this.textFieldArrayList.add(this.chamberWidth);
        UtilsUI.attachNumericalValidator(this.chamberWidth, 0.1, 1000000.0, 1, true, true);
        this.textFieldArrayList.add(this.chamberHeight);
        UtilsUI.attachNumericalValidator(this.chamberHeight, 0.1, 1000000.0, 1, true, true);
        this.textFieldArrayList.add(this.chamberDepth);
        UtilsUI.attachNumericalValidator(this.chamberDepth, 0.1, 1000000.0, 1, true, true);
        this.textFieldArrayList.add(this.pistonMassField);
        UtilsUI.attachNumericalValidator(this.pistonMassField, 1.0E-6, 1000000.0, 1, true, true);
        this.textFieldArrayList.add(this.externalPressureField);
        UtilsUI.attachNumericalValidator(this.externalPressureField, 3000.0, 20000.0, 1, true, true);
    }

    public SimplePistonSettingsWindowController(MainStageController mainStageControllerIn) {
        this.overlord = mainStageControllerIn;
    }

    public void buttonDone() {
        this.done();
    }

    public void buttonDoneAndSave() {
        if (this.save()) {
            this.done();
        }
    }

    public void buttonSave() {
        this.save();
    }

    public boolean save() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Experiment");
        fileChooser.setInitialDirectory(Settings.getExperimentsDirectory());
        File file = fileChooser.showSaveDialog(this.doneButton.getScene().getWindow());
        return this.saveFile(file, true);
    }

    public void done() {
        this.saveTemporary();
        if (this.addedSchedules.size() == 0) {
            DefaultPopups.showInfoPopup("The form contains no stages. Add a stage to set the experiment.");
            return;
        }
        for (int n = 0; n < this.addedSchedules.size() - 1; ++n) {
            if (!this.addedSchedules.get((int)n).schedulerNameField.getText().equals(this.addedSchedules.get((int)(n + 1)).schedulerNameField.getText())) continue;
            DefaultPopups.showInfoPopup("The form contains two consecutive stages with identical names. Please change one of the names.");
            return;
        }
        try {
            ExperimentSimplePiston experimentObj = new ExperimentSimplePiston();
            double totalTimeDummy = 0.0;
            for (NewExperimentSchedulerBoxController scheduleToAdd : this.addedSchedules) {
                totalTimeDummy += SimplePistonSettingsWindowController.readValue(scheduleToAdd.schedulerTimeField).doubleValue();
            }
            Settings.totalTime = totalTimeDummy;
            Settings.timePerStep = SimplePistonSettingsWindowController.readValue(this.stepSizeField);
            Settings.animationFPS = SimplePistonSettingsWindowController.readValue(this.animationFPSField).intValue();
            Settings.recordingsPerSecond = SimplePistonSettingsWindowController.readValue(this.reportsPerSecondField).intValue();
            experimentObj.numberMoles = SimplePistonSettingsWindowController.readValue(this.molesField);
            experimentObj.numberParticles = SimplePistonSettingsWindowController.readValue(this.particlesField).intValue();
            experimentObj.atomMassInUnits = SimplePistonSettingsWindowController.readValue(this.particleMassField);
            experimentObj.tempParticles = SimplePistonSettingsWindowController.readValue(this.particleTemperatureField);
            experimentObj.particleExchangeRate = SimplePistonSettingsWindowController.readValue(this.particleExchangeRateField);
            Settings.chamberWidth = SimplePistonSettingsWindowController.readValue(this.chamberWidth);
            Settings.chamberHeight = SimplePistonSettingsWindowController.readValue(this.chamberHeight);
            Settings.chamberDepth = SimplePistonSettingsWindowController.readValue(this.chamberDepth);
            experimentObj.pistonMass = SimplePistonSettingsWindowController.readValue(this.pistonMassField);
            experimentObj.pistonMode = 0;
            Settings.allowHeating = false;
            experimentObj.particleExchangeRate = 100.0;
            experimentObj.pressure = SimplePistonSettingsWindowController.readValue(this.externalPressureField);
            try {
                Settings.update();
            }
            catch (Exception e) {
                DefaultPopups.showInfoPopup("New experiment can not be created, because the settings are incompatible.\nThe issue is most likely located in the time-control and stages-tab of your experiment and related to a division by 0.\nIf the time interval between movie frames or between experiment reports or between physics steps is larger than the total duration of the experiment, increase the corresponding number of frames, or decrease the time-step and try again.\nOtherwise, please report the log file to the developers.");
                return;
            }
            if (Settings.animationFPS >= Settings.recordingsPerSecond) {
                DefaultPopups.showInfoPopup("New experiment can not be created, because the settings are incompatible.\nThe number of reports per second must be larger than the animation frames per second.");
                return;
            }
            double timeStartDummy = 0.0;
            double timeStopDummy = 0.0;
            for (NewExperimentSchedulerBoxController scheduleToAdd : this.addedSchedules) {
                Scheduler scheduler;
                StageScheduler schedulerStage = new StageScheduler(scheduleToAdd.schedulerNameField.getText(), timeStartDummy, timeStopDummy += SimplePistonSettingsWindowController.readValue(scheduleToAdd.schedulerTimeField).doubleValue(), this.overlord);
                experimentObj.addScheduler(schedulerStage);
                RecordingScheduler schedulerRecording = new RecordingScheduler(scheduleToAdd.reportHeatTickBox.isSelected(), scheduleToAdd.reportWorkTickBox.isSelected(), timeStartDummy, this.overlord);
                experimentObj.addScheduler(schedulerRecording);
                if (scheduleToAdd.addPistonSchedulerTickBox.isSelected()) {
                    scheduler = new PistonScheduler(scheduleToAdd.schedulerNameField.getText(), scheduleToAdd.pistonModeCombo.getSelectionModel().getSelectedIndex(), SimplePistonSettingsWindowController.readValue(scheduleToAdd.volumeField), timeStartDummy, this.overlord);
                    experimentObj.addScheduler(scheduler);
                }
                if (scheduleToAdd.addTemperatureSchedulerTickBox.isSelected()) {
                    scheduler = new TemperatureScheduler(scheduleToAdd.schedulerNameField.getText(), scheduleToAdd.heatersModeCombo.getSelectionModel().getSelectedIndex() == 1, SimplePistonSettingsWindowController.readValue(scheduleToAdd.heatersTemperatureField), SimplePistonSettingsWindowController.readValue(scheduleToAdd.heatersRateField), timeStartDummy, this.overlord);
                    experimentObj.addScheduler(scheduler);
                }
                if (scheduleToAdd.addPressureSchedulerTickBox.isSelected()) {
                    scheduler = new PressureScheduler(scheduleToAdd.schedulerNameField.getText(), SimplePistonSettingsWindowController.readValue(scheduleToAdd.pressureField), timeStartDummy, timeStopDummy, this.overlord, scheduleToAdd.pressureModeCombo.getSelectionModel().getSelectedIndex() == 0);
                    experimentObj.addScheduler(scheduler);
                }
                timeStartDummy += SimplePistonSettingsWindowController.readValue(scheduleToAdd.schedulerTimeField).doubleValue();
            }
            experimentObj.setup();
            this.overlord.setExperiment(experimentObj);
            Stage stage = (Stage)this.doneButton.getScene().getWindow();
            stage.close();
            this.overlord.startExperiment();
        }
        catch (Exception e) {
            DefaultPopups.showInfoPopup("New experiment can not be created, because the form contains at least one invalid value.\nPlease correct it and try again.");
        }
    }

    public void loadFromFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load Experiment");
        fileChooser.setInitialDirectory(Settings.getExperimentsDirectory());
        File file = fileChooser.showOpenDialog(this.doneButton.getScene().getWindow());
        if (file != null) {
            Settings.hiddenCurrentDirectoryExperiment = file.getParentFile();
            this.loadData(file);
        }
    }

    public void loadLatest() {
        this.loadData(Settings.hiddenTemporaryExperimentFile);
    }

    public void loadExample0() {
        this.loadPredefinedExperiment("equilibrium");
    }

    public void loadFromFile(String filePath) {
        this.loadData(new File(filePath));
    }

    public void loadPredefinedExperiment(String experimentName) {
        try {
            this.loadData(this.getClass().getResourceAsStream("/src/experiments/" + experimentName + ".txt"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadData(File file) {
        try {
            this.loadData(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void loadData(InputStream file) {
        if (file != null) {
            try {
                BufferedReader experimentStream = new BufferedReader(new InputStreamReader(file));
                String line = experimentStream.readLine();
                if (line.equals("#Carnot experiment file 2.0")) {
                    experimentStream.readLine();
                    experimentStream.readLine();
                    experimentStream.readLine();
                    for (TextField textField : this.textFieldArrayList) {
                        textField.setText(experimentStream.readLine().split(": ")[1]);
                    }
                    this.schedulerHBox.getChildren().clear();
                    this.addedSchedules.clear();
                    while (experimentStream.readLine() != null) {
                        experimentStream.readLine();
                        this.newStage();
                        NewExperimentSchedulerBoxController currentScheduleController = this.addedSchedules.get(this.addedSchedules.size() - 1);
                        currentScheduleController.readScheduler(experimentStream, 0);
                    }
                } else if (line.equals("#Carnot experiment file")) {
                    experimentStream.readLine();
                    experimentStream.readLine();
                    experimentStream.readLine();
                    for (int n = 0; n < 12; ++n) {
                        this.textFieldArrayList.get(n).setText(experimentStream.readLine().split(": ")[1]);
                    }
                    experimentStream.readLine();
                    experimentStream.readLine();
                    this.textFieldArrayList.get(12).setText(experimentStream.readLine().split(": ")[1]);
                    this.schedulerHBox.getChildren().clear();
                    this.addedSchedules.clear();
                    while (experimentStream.readLine() != null) {
                        experimentStream.readLine();
                        this.newStage();
                        NewExperimentSchedulerBoxController currentScheduleController = this.addedSchedules.get(this.addedSchedules.size() - 1);
                        currentScheduleController.readScheduler(experimentStream, 0);
                    }
                } else {
                    for (int n = 0; n < 12; ++n) {
                        if (n == 0) {
                            this.textFieldArrayList.get(n).setText(line);
                            continue;
                        }
                        this.textFieldArrayList.get(n).setText(experimentStream.readLine());
                    }
                    experimentStream.readLine();
                    experimentStream.readLine();
                    this.textFieldArrayList.get(12).setText(experimentStream.readLine());
                    this.schedulerHBox.getChildren().clear();
                    this.addedSchedules.clear();
                    while (experimentStream.readLine() != null) {
                        this.newStage();
                        NewExperimentSchedulerBoxController currentScheduleController = this.addedSchedules.get(this.addedSchedules.size() - 1);
                        currentScheduleController.readScheduler(experimentStream, 1);
                    }
                }
                experimentStream.close();
            }
            catch (IOException e) {
                System.out.println("Error reading file");
                e.printStackTrace();
            }
        }
    }

    public void newStage() {
        try {
            VBox newStageVBox = (VBox)FXMLLoader.load((URL)this.getClass().getResource("/visualization/gui/components/newExperimentSchedulerBox.fxml"));
            this.schedulerHBox.getChildren().add((Object)newStageVBox);
            this.addedSchedules.add((NewExperimentSchedulerBoxController)SimplePistonSettingsWindowController.getController((Node)newStageVBox));
            this.schedulerHBox.getChildren().add((Object)new Separator(Orientation.VERTICAL));
            this.addedSchedules.get((int)(this.addedSchedules.size() - 1)).deleteButton.setOnAction(e -> {
                if (e.getSource() instanceof Button) {
                    int index = this.schedulerHBox.getChildren().indexOf((Object)((Button)e.getTarget()).getParent());
                    this.schedulerHBox.getChildren().remove(index);
                    this.schedulerHBox.getChildren().remove(index);
                    this.addedSchedules.remove(index / 2);
                }
            });
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static Object getController(Node node) {
        Object controller;
        do {
            controller = node.getUserData();
            node = node.getParent();
        } while (controller == null && node != null);
        return controller;
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.menuLoad.setGraphic((Node)UtilsUI.getInstance().prepareIcon("/visualization/resources/buttons/open.png"));
        this.menuLoad.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.initializeArrayList();
    }

    public void initializeFields() {
        ArrayList<TextField> textFields = SimplePistonSettingsWindowController.getAllFields((Parent)this.root);
        for (TextField field : textFields) {
            DecimalFormat format = new DecimalFormat("#");
            TextFormatter decimalTextFormatter = new TextFormatter(change -> {
                if (change.getControlNewText().isEmpty()) {
                    return change;
                }
                ParsePosition parsePosition = new ParsePosition(0);
                Number object = format.parse(change.getControlNewText(), parsePosition);
                if (object == null || parsePosition.getIndex() < change.getControlNewText().length()) {
                    return null;
                }
                return change;
            });
            field.setTextFormatter(decimalTextFormatter);
        }
    }

    private static ArrayList<TextField> getAllFields(Parent rootIn) {
        ArrayList<TextField> fieldsOut = new ArrayList<TextField>();
        for (Node node : rootIn.getChildrenUnmodifiable()) {
            if (node instanceof TextField) {
                fieldsOut.add((TextField)node);
            }
            if (!(node instanceof Parent)) continue;
            fieldsOut.addAll(SimplePistonSettingsWindowController.getAllFields((Parent)node));
        }
        return fieldsOut;
    }

    private static Double readValue(TextField textFieldIn) {
        return Double.parseDouble(textFieldIn.getText());
    }

    private void saveTemporary() {
        File file = Settings.hiddenTemporaryExperimentFile;
        this.saveFile(file, false);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean saveFile(File file, boolean userDriven) {
        if (file != null) {
            try (FileWriter experimentFile = new FileWriter(file);){
                PrintWriter experimentWriter = new PrintWriter(experimentFile);
                try {
                    if (userDriven) {
                        Settings.hiddenCurrentDirectoryExperiment = file.getParentFile();
                    }
                    experimentWriter.println("#Carnot experiment file 2.0");
                    experimentWriter.println("#" + file.getName());
                    experimentWriter.println();
                    experimentWriter.println("#Settings");
                    for (int n = 0; n < this.textFieldArrayList.size(); ++n) {
                        experimentWriter.println(this.textFieldNameArrayList.get(n) + this.textFieldArrayList.get(n).getText());
                    }
                    for (NewExperimentSchedulerBoxController controller : this.addedSchedules) {
                        experimentWriter.println("");
                        experimentWriter.println("#Scheduler");
                        controller.writeScheduler(experimentWriter);
                    }
                    boolean bl = true;
                    experimentWriter.close();
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        experimentWriter.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                if (userDriven) {
                    DefaultPopups.showInfoPopup("Can not save experiment file. It might be caused by incorrect values in the form, or by problems with access to computer HDD");
                }
                e.printStackTrace();
            }
        }
        return false;
    }
}

