/*
 * Decompiled with CFR 0.152.
 */
package visualization.gui.components;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import javax.imageio.ImageIO;
import model.experiment.ExperimentSimplePiston;
import model.physics.SimplePhysics;
import multimedia.PDFReport;
import multimedia.SplashScreen;
import multimedia.VTLMovie;
import settings.GlobalSettings;
import settings.Settings;
import settings.VTLLabels;
import visualization.gui.UtilsUI;
import visualization.gui.components.About;
import visualization.gui.components.GlobalSettingsController;
import visualization.gui.components.GraphController;
import visualization.gui.components.SimplePistonSettingsWindowController;
import visualization.gui.components.WaitingWindow;
import visualization.gui.popup.DefaultPopups;
import visualization.main.GlobalClock;
import visualization.snapshots.ExperimentSnapshotCollector;

public class MainStageController {
    public Stage mainStage;
    @FXML
    public MenuItem menuStartExperiment;
    @FXML
    public MenuItem menuStopExperiment;
    @FXML
    public MenuItem menuNewExperiment;
    public MenuItem menuModifyExperiment;
    public MenuItem menuNewGraph;
    public MenuItem menuExportImage;
    public MenuItem menuAbout;
    public MenuItem menuZoomOut;
    public MenuItem menuZoomIn;
    public MenuItem menuSpeedUp;
    public MenuItem menuSlowDown;
    public MenuItem menuReport;
    public Label simulationStatus;
    public MenuItem menuDeleteExperiment;
    public ScrollPane mainCanvasScrollPane;
    public CustomMenuItem menuSpeedLabel;
    @FXML
    private Canvas mainCanvas;
    @FXML
    private Slider animationSlider;
    @FXML
    private VBox experimentStats;
    @FXML
    private ImageView playButton;
    @FXML
    public MenuItem menuExportMovie;
    @FXML
    public Label lCalculatedFrames;
    public Label lNumberOfParticles;
    public Label lFramesPerCPUtime;
    public Label lCPUTime;
    public Label lETA;
    public Label lTime;
    public Label lTemperature;
    public Label lVolume;
    public Label lInternalPressure;
    public Label lExternalPressure;
    public Label lEnergy;
    public Label lWork;
    public Label lWorkChosen;
    public Label lWorkCurrent;
    public Label lHeat;
    public Label lHeatChosen;
    public Label lHeatCurrent;
    public Label lPVNRT;
    public Label lCalculatedFramesMovie;
    private ExperimentSimplePiston experiment = null;
    private ExperimentSnapshotCollector snapshotCollector;
    private SimplePhysics simplePhysics;
    private ScheduledExecutorService engine_executor;
    private ScheduledExecutorService display_executor;
    boolean playAnimation = false;
    private boolean isRunning = false;
    private boolean applicationCrash = false;
    private Runnable updateFrame = () -> Platform.runLater(() -> {
        if (!this.applicationCrash) {
            try {
                if (this.snapshotCollector != null) {
                    double percent = 100.0 * (double)this.snapshotCollector.lenImages() / (double)Settings.numberOfFrames;
                    this.updateSliderGraphics(percent);
                    this.lCalculatedFrames.setText(String.format("Calculated time steps: %7d/%d", (int)GlobalClock.t, Settings.numberOfTimeSteps));
                    this.lCalculatedFramesMovie.setText(String.format("Rendered frames: %7d/%d", this.snapshotCollector.lenImages(), Settings.numberOfFrames));
                    this.lNumberOfParticles.setText(String.format("# particles: %d", this.experiment.numberParticles));
                    if (this.snapshotCollector.lenRecording() > 0) {
                        HashMap<String, Double> state = this.snapshotCollector.getSnapshot(this.snapshotCollector.lenRecording() - 1).getState();
                        this.lCPUTime.setText(String.format("Computation time elapsed [s]: %.0f", state.get("CPU total time [s]")));
                        this.lETA.setText(String.format("ETA [s]: %.0f", (double)(Settings.numberOfTimeSteps - (int)GlobalClock.t) * (state.get("CPU total time [s]") / (double)((int)GlobalClock.t))));
                    }
                    if (this.snapshotCollector.lenImages() == (int)this.animationSlider.getValue() + 1 && !this.playAnimation) {
                        this.updateMovie();
                    }
                    if (this.playAnimation) {
                        if (this.animationSlider.getValue() == (double)(Settings.numberOfFrames - 1)) {
                            this.animationSlider.setValue(0.0);
                        }
                        this.animationSlider.setValue(this.animationSlider.getValue() + 1.0);
                    }
                }
            }
            catch (Exception e) {
                this.applicationCrash = true;
                System.err.println("An error has been thrown while updating the interface:");
                e.printStackTrace();
                this.display_executor.shutdown();
            }
        }
    });

    @FXML
    public void initialize() {
        UtilsUI utils = UtilsUI.getInstance();
        Settings.makeTmpDir();
        Settings.zoom = Math.min(Settings.screenArea.getWidth() / 1920.0, Settings.screenArea.getHeight() / 1080.0);
        Settings.zoom = Math.max(Math.min(Settings.zoom, 1.0), 0.5);
        this.updateZoom();
        this.menuExportMovie.setGraphic((Node)utils.prepareIcon("/visualization/resources/buttons/movie.png"));
        this.menuExportMovie.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.E, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuStartExperiment.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuStopExperiment.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.T, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuNewExperiment.setGraphic((Node)utils.prepareIcon("/visualization/resources/buttons/experiment_setup.png"));
        this.menuNewExperiment.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuModifyExperiment.setGraphic((Node)utils.prepareIcon("/visualization/resources/buttons/experiment_setup.png"));
        this.menuModifyExperiment.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.B, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuNewGraph.setGraphic((Node)utils.prepareIcon("/visualization/resources/buttons/graph.png"));
        this.menuNewGraph.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.G, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuReport.setGraphic((Node)utils.prepareIcon("/visualization/resources/buttons/report.png"));
        this.menuReport.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.H, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuExportImage.setGraphic((Node)utils.prepareIcon("/visualization/resources/buttons/snapshot.png"));
        this.menuExportImage.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuAbout.setGraphic((Node)utils.prepareIcon("/visualization/resources/buttons/info.png"));
        this.menuAbout.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuAbout.setGraphic((Node)utils.prepareIcon("/visualization/resources/buttons/info.png"));
        this.menuZoomIn.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuZoomIn.setGraphic((Node)utils.prepareIcon("/visualization/resources/buttons/zoom_in.png"));
        this.menuZoomOut.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuZoomOut.setGraphic((Node)utils.prepareIcon("/visualization/resources/buttons/zoom_out.png"));
        this.menuSpeedUp.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuSlowDown.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.L, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuSpeedLabel.setContent((Node)new Label("Current FPS: -"));
        this.menuSpeedLabel.setDisable(true);
        new SplashScreen(0).drawOnCanvas(this.mainCanvas);
        this.menuExportImage.setDisable(true);
        this.menuReport.setDisable(true);
        this.menuNewGraph.setDisable(true);
        this.menuStartExperiment.setDisable(true);
        this.menuStopExperiment.setDisable(true);
        this.menuExportMovie.setDisable(true);
        this.menuZoomIn.setDisable(true);
        this.menuZoomOut.setDisable(true);
        this.menuSpeedUp.setDisable(true);
        this.menuSlowDown.setDisable(true);
        this.menuDeleteExperiment.setDisable(true);
        this.experimentStats.setVisible(false);
        try {
            this.playButton.setImage(new Image(this.getClass().getResource("/visualization/resources/buttons/play.png").toURI().toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mainStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                MainStageController.this.deleteExperiment(null);
                System.exit(0);
            }
        });
        this.animationSlider.valueProperty().addListener((observableValue, oldValue, newValue) -> this.updateMovie());
    }

    @FXML
    public void openGlobalSettingsWindow() {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/visualization/gui/components/globalSettings.fxml"));
            fxmlLoader.setController((Object)new GlobalSettingsController());
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.initModality(Modality.WINDOW_MODAL);
            stage.initStyle(StageStyle.DECORATED);
            stage.setTitle("Global Settings");
            stage.setScene(new Scene(root1));
            stage.getIcons().add((Object)UtilsUI.getInstance().prepareIcon("/visualization/resources/buttons/settings.png").getImage());
            stage.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void newExperiment() {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/visualization/gui/components/simplePistonSettingsWindow.fxml"));
            fxmlLoader.setController((Object)new SimplePistonSettingsWindowController(this));
            this.prepareNewExperimentWindow(fxmlLoader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void modifyExperiment() {
        this.newExperiment(Settings.hiddenTemporaryExperimentFile);
    }

    public void newExperiment(File file) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/visualization/gui/components/simplePistonSettingsWindow.fxml"));
            SimplePistonSettingsWindowController controller = new SimplePistonSettingsWindowController(this);
            fxmlLoader.setController((Object)controller);
            this.prepareNewExperimentWindow(fxmlLoader);
            controller.loadData(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareNewExperimentWindow(FXMLLoader fxmlLoader) {
        try {
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.initModality(Modality.WINDOW_MODAL);
            stage.initStyle(StageStyle.DECORATED);
            stage.setTitle("New experiment");
            stage.setScene(new Scene(root1));
            stage.getIcons().add((Object)UtilsUI.getInstance().prepareIcon("/visualization/resources/buttons/experiment_setup.png").getImage());
            double marginW = 0.28 * Settings.screenArea.getWidth();
            double marginH = 0.2 * Settings.screenArea.getHeight();
            stage.setX(Settings.screenArea.getMinX() + marginW);
            stage.setY(Settings.screenArea.getMinY() + marginH);
            stage.setWidth(Settings.screenArea.getWidth() - 2.0 * marginW);
            stage.setHeight(Settings.screenArea.getHeight() - 2.0 * marginH);
            stage.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void graph() {
        if (GlobalClock.t == 0.0) {
            DefaultPopups.showInfoPopup(VTLLabels.GRAPH_EXPERIMENT_NOT_RUNNING);
            return;
        }
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/visualization/gui/components/graph.fxml"));
            fxmlLoader.setController((Object)new GraphController(this.snapshotCollector, this));
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.initModality(Modality.WINDOW_MODAL);
            stage.initStyle(StageStyle.DECORATED);
            stage.setTitle("Graph");
            stage.setScene(new Scene(root1));
            stage.getIcons().add((Object)UtilsUI.getInstance().prepareIcon("/visualization/resources/buttons/graph.png").getImage());
            stage.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void report() {
        if (GlobalClock.t == 0.0) {
            DefaultPopups.showInfoPopup(VTLLabels.REPORT_EXPERIMENT_NOT_RUNNING);
            return;
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Report");
        fileChooser.setInitialDirectory(Settings.getResultsDirectory());
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("PDF files (*.pdf)", new String[]{"*.pdf"});
        fileChooser.getExtensionFilters().add((Object)filter);
        final File file = fileChooser.showSaveDialog(this.mainCanvas.getScene().getWindow());
        if (file == null) {
            return;
        }
        final LinkedHashMap<String, String> toReport = new LinkedHashMap<String, String>();
        toReport.put("Average Temperature Particles [K]", "T (particles) [K]");
        toReport.put("Volume [m^3]", "V [m^3]");
        toReport.put("Internal Pressure (total) [Pa]", "p (internal) [Pa]");
        toReport.put("Internal Energy [J]", "U [J]");
        toReport.put("Heat/Temperature [J/K]", "Q/T [J/K]");
        toReport.put("Total Work by System [J]", "W [J]");
        toReport.put("Total Heat into System [J]", "Q [J]");
        toReport.put("pV/nRT", "pV/nRT");
        toReport.put("CPU total time [s]", "CPU-time [s]");
        Task<Boolean> task = new Task<Boolean>(){

            public Boolean call() {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Platform.runLater(() -> {
                    try {
                        PDFReport pdf = new PDFReport(toReport, MainStageController.this.snapshotCollector);
                        pdf.generateReport(file);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                return true;
            }
        };
        WaitingWindow w = new WaitingWindow(this.mainStage.getScene().getWindow(), "Preparing the report, please wait.");
        task.setOnRunning(e -> w.show());
        task.setOnFailed(e -> w.close());
        task.setOnSucceeded(e -> w.close());
        new Thread((Runnable)task).start();
    }

    @FXML
    public void exit() {
        this.deleteExperiment(null);
        System.exit(0);
    }

    @FXML
    public void exportMovie() {
        if (GlobalClock.t == 0.0) {
            DefaultPopups.showInfoPopup(VTLLabels.SAVEMOVIE_EXPERIMENT_NOT_RUNNING);
        } else {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Save visualisation");
            fileChooser.setInitialDirectory(Settings.getResultsDirectory());
            FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Movie (*.avi)", new String[]{"*.avi"});
            fileChooser.getExtensionFilters().add((Object)filter);
            final File file = fileChooser.showSaveDialog(this.mainCanvas.getScene().getWindow());
            if (file != null) {
                Settings.hiddenCurrentDirectoryResults = file.getParentFile();
                Task<Boolean> task = new Task<Boolean>(){

                    public Boolean call() {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Platform.runLater(() -> {
                            try {
                                new VTLMovie(MainStageController.this.snapshotCollector).renderMovie(file);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                        return true;
                    }
                };
                WaitingWindow w = new WaitingWindow(this.mainStage.getScene().getWindow(), "Preparing the movie, please wait.");
                task.setOnRunning(e -> w.show());
                task.setOnFailed(e -> w.close());
                task.setOnSucceeded(e -> w.close());
                new Thread((Runnable)task).start();
            }
        }
    }

    @FXML
    public void exportImage() {
        if (GlobalClock.t == 0.0) {
            DefaultPopups.showInfoPopup(VTLLabels.SAVEIMAGE_EXPERIMENT_NOT_RUNNING);
        } else {
            WritableImage i = new WritableImage((int)this.mainCanvas.getWidth(), (int)this.mainCanvas.getHeight());
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Save visualisation");
            fileChooser.setInitialDirectory(Settings.getResultsDirectory());
            FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Image (*.jpg)", new String[]{"*.jpg"});
            fileChooser.getExtensionFilters().add((Object)filter);
            File file = fileChooser.showSaveDialog(this.mainCanvas.getScene().getWindow());
            if (file != null) {
                Settings.hiddenCurrentDirectoryResults = file.getParentFile();
                Object path = file.getAbsolutePath();
                if (!((String)path).endsWith(".jpg")) {
                    path = (String)path + ".jpg";
                }
                try {
                    this.mainCanvas.snapshot(null, i);
                    BufferedImage renderedImage = SwingFXUtils.fromFXImage((Image)i, null);
                    ImageIO.write((RenderedImage)renderedImage, "png", file);
                }
                catch (IOException e) {
                    DefaultPopups.showInfoPopup("Can not save image in file:\n" + (String)path);
                    e.printStackTrace();
                }
            }
        }
    }

    public void about(ActionEvent actionEvent) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/visualization/gui/components/about.fxml"));
            About a = new About();
            fxmlLoader.setController((Object)a);
            Parent root1 = (Parent)fxmlLoader.load();
            Stage stage = new Stage();
            stage.initModality(Modality.WINDOW_MODAL);
            stage.initStyle(StageStyle.DECORATED);
            stage.setTitle("About");
            Scene s = new Scene(root1);
            stage.setScene(s);
            stage.getIcons().add((Object)UtilsUI.getInstance().prepareIcon("/visualization/resources/buttons/settings.png").getImage());
            a.setStage(stage);
            stage.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void play(MouseEvent actionEvent) {
        if (GlobalClock.t == 0.0) {
            DefaultPopups.showInfoPopup(VTLLabels.PLAY_EXPERIMENT_NOT_RUNNING);
        } else {
            this.playAnimation = !this.playAnimation;
            try {
                if (this.playAnimation) {
                    this.playButton.setImage(new Image(this.getClass().getResource("/visualization/resources/buttons/stop.png").toURI().toString()));
                } else {
                    this.playButton.setImage(new Image(this.getClass().getResource("/visualization/resources/buttons/play.png").toURI().toString()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateCurrentSpeedLabel() {
        String header = "Current FPS: " + 1000 / GlobalSettings.movieUpdatePeriodValues[GlobalSettings.movieUpdatePeriodIndex] + " (Speed: x" + (double)(1000 / GlobalSettings.movieUpdatePeriodValues[GlobalSettings.movieUpdatePeriodIndex]) / 20.0 + ")";
        ((Label)this.menuSpeedLabel.getContent()).setText(header);
    }

    public ExperimentSimplePiston getExperiment() {
        return this.experiment;
    }

    public void setExperiment(ExperimentSimplePiston exp) {
        this.experiment = exp;
        new SplashScreen(1).drawOnCanvas(this.mainCanvas);
        this.menuStartExperiment.setDisable(false);
        this.menuDeleteExperiment.setDisable(false);
        this.menuNewExperiment.setDisable(true);
        this.menuModifyExperiment.setDisable(true);
    }

    public Canvas getCanvas() {
        return this.mainCanvas;
    }

    public SimplePhysics getPhysics() {
        return this.simplePhysics;
    }

    public int getCurrentTime() {
        return (int)this.animationSlider.getValue();
    }

    public ExperimentSnapshotCollector getSnapshotCollector() {
        return this.snapshotCollector;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void zoomOut(ActionEvent actionEvent) {
        Settings.zoom = Math.max(0.5, Settings.zoom - 0.05);
        this.updateZoom();
    }

    public void zoomIn(ActionEvent actionEvent) {
        Settings.zoom = Math.min(1.25, Settings.zoom + 0.05);
        this.updateZoom();
    }

    public void updateZoom() {
        this.mainCanvas.setWidth((double)Settings.visualizationWidth * Settings.zoom);
        this.mainCanvas.setHeight((double)Settings.visualizationHeight * Settings.zoom);
        this.updateMovie();
    }

    public void speedUp() {
        if (GlobalSettings.movieUpdatePeriodIndex > 0) {
            this.display_executor.shutdown();
            this.display_executor = Executors.newSingleThreadScheduledExecutor();
            this.display_executor.scheduleAtFixedRate(this.updateFrame, 0L, GlobalSettings.movieUpdatePeriodValues[--GlobalSettings.movieUpdatePeriodIndex], TimeUnit.MILLISECONDS);
            this.updateCurrentSpeedLabel();
        }
    }

    public void slowDown() {
        if (GlobalSettings.movieUpdatePeriodIndex < GlobalSettings.movieUpdatePeriodValues.length - 1) {
            this.display_executor.shutdown();
            this.display_executor = Executors.newSingleThreadScheduledExecutor();
            this.display_executor.scheduleAtFixedRate(this.updateFrame, 0L, GlobalSettings.movieUpdatePeriodValues[++GlobalSettings.movieUpdatePeriodIndex], TimeUnit.MILLISECONDS);
            this.updateCurrentSpeedLabel();
        }
    }

    @FXML
    public void deleteExperiment(ActionEvent actionEvent) {
        this.isRunning = false;
        this.animationSlider.setValue(0.0);
        if (this.engine_executor != null) {
            this.display_executor.shutdown();
        }
        if (this.display_executor != null) {
            this.engine_executor.shutdown();
        }
        new SplashScreen(0).drawOnCanvas(this.mainCanvas);
        this.experiment = null;
        this.simplePhysics = null;
        this.snapshotCollector = null;
        GlobalClock.reset();
        this.updateSliderGraphics(0.0);
        this.menuExportImage.setDisable(true);
        this.menuReport.setDisable(true);
        this.menuNewGraph.setDisable(true);
        this.menuStartExperiment.setDisable(true);
        this.menuStopExperiment.setDisable(true);
        this.menuExportMovie.setDisable(true);
        this.menuZoomIn.setDisable(true);
        this.menuZoomOut.setDisable(true);
        this.menuSpeedUp.setDisable(true);
        this.menuSlowDown.setDisable(true);
        this.menuDeleteExperiment.setDisable(true);
        this.menuNewExperiment.setDisable(false);
        this.menuModifyExperiment.setDisable(false);
        this.experimentStats.setVisible(false);
    }

    @FXML
    public void stopExperiment() {
        this.isRunning = false;
        if (this.engine_executor != null) {
            this.engine_executor.shutdownNow();
        }
        this.menuStartExperiment.setDisable(true);
        this.menuStopExperiment.setDisable(true);
    }

    public void initExperiment() {
        if (this.experiment != null) {
            if (this.engine_executor != null) {
                this.engine_executor.shutdownNow();
            }
            if (this.display_executor != null) {
                this.display_executor.shutdownNow();
            }
            this.simplePhysics = new SimplePhysics(this);
            this.snapshotCollector = new ExperimentSnapshotCollector(this.experiment, 1920, 1080, this);
            this.animationSlider.setMax((double)(Settings.numberOfFrames - 1));
            GlobalClock.reset();
            GlobalSettings.reset();
            this.menuExportImage.setDisable(false);
            this.menuReport.setDisable(false);
            this.menuNewGraph.setDisable(false);
            this.menuStartExperiment.setDisable(true);
            this.menuStopExperiment.setDisable(false);
            this.menuExportMovie.setDisable(false);
            this.menuZoomIn.setDisable(false);
            this.menuZoomOut.setDisable(false);
            this.menuSpeedUp.setDisable(false);
            this.menuSlowDown.setDisable(false);
            this.menuDeleteExperiment.setDisable(false);
            this.updateCurrentSpeedLabel();
        }
    }

    @FXML
    public void startExperiment() {
        this.initExperiment();
        new SplashScreen(2).drawOnCanvas(this.mainCanvas);
        this.menuNewExperiment.setDisable(true);
        this.menuModifyExperiment.setDisable(true);
        this.experimentStats.setVisible(true);
        this.isRunning = true;
        this.engine_executor = Executors.newSingleThreadScheduledExecutor();
        this.engine_executor.scheduleAtFixedRate(() -> {
            if (!this.applicationCrash) {
                try {
                    if (GlobalClock.t < (double)Settings.numberOfTimeSteps) {
                        this.simplePhysics.nextStep();
                        this.snapshotCollector.collectSnapshot(this.experiment);
                    } else {
                        this.menuStopExperiment.setDisable(true);
                        this.engine_executor.shutdown();
                    }
                }
                catch (Exception e) {
                    this.applicationCrash = true;
                    System.err.println("An error has been thrown while calculating next simulation step:");
                    e.printStackTrace();
                    this.engine_executor.shutdown();
                }
            }
        }, 0L, 1L, TimeUnit.MICROSECONDS);
        this.display_executor = Executors.newSingleThreadScheduledExecutor();
        this.display_executor.scheduleAtFixedRate(this.updateFrame, 0L, GlobalSettings.movieUpdatePeriodValues[GlobalSettings.movieUpdatePeriodIndex], TimeUnit.MILLISECONDS);
    }

    public void updateSliderGraphics(double percent) {
        String formatString = "-fx-background-color: linear-gradient(to right, #2D819D " + percent + "%, #969696 " + percent + "%);";
        StackPane trackPane = (StackPane)this.animationSlider.lookup(".track");
        trackPane.setStyle(formatString);
    }

    public void updateMovie() {
        if (this.snapshotCollector != null) {
            WritableImage i = this.snapshotCollector.getImage((int)this.animationSlider.getValue());
            this.mainCanvas.getGraphicsContext2D().drawImage((Image)i, 0.0, 0.0, i.getWidth() * Settings.zoom, i.getHeight() * Settings.zoom);
            int displayedFrameID = (int)(this.animationSlider.getValue() / this.animationSlider.getMax() * (double)(Settings.numberOfRecordings - 1));
            if (this.snapshotCollector.lenRecording() > displayedFrameID) {
                HashMap<String, Double> state = this.snapshotCollector.getSnapshot(displayedFrameID).getState();
                this.lTime.setText(String.format("Current Time [s]: %.3f", state.get("Simulation time [s]")));
                this.lTemperature.setText(String.format("Avg Temperature Particles [K]: %.3f", state.get("Average Temperature Particles [K]")));
                this.lVolume.setText(String.format("Volume [m^3]: %.3f", state.get("Volume [m^3]")));
                this.lInternalPressure.setText(String.format("Internal pressure [Pa]: %.3f", state.get("Internal Pressure (total) [Pa]")));
                this.lExternalPressure.setText(String.format("External pressure [Pa]: %.3f", state.get("External Pressure [Pa]")));
                this.lEnergy.setText(String.format("Total Energy [J]: %.3f", state.get("Total Energy [J]")));
                this.lWork.setText(String.format("Total Work (by System) [J]: %.3f", state.get("Total Work by System [J]")));
                this.lWorkChosen.setText(String.format("Total recorded work [J]: %.3f", state.get("Work for Efficiency [J]")));
                this.lWorkCurrent.setText(String.format("Work during current stage [J]: %.3f", state.get("Work during Current Stage [J]")));
                this.lHeat.setText(String.format("Total Heat (into System) [J]: %.3f", state.get("Total Heat into System [J]")));
                this.lHeatChosen.setText(String.format("Total recorded heat [J]: %.3f", state.get("Heat for Efficiency [J]")));
                this.lHeatCurrent.setText(String.format("Heat during current stage [J]: %.3f", state.get("Heat during Current Stage [J]")));
                this.lPVNRT.setText(String.format("pV/nRT: %.3f", state.get("pV/nRT")));
            } else {
                this.lTime.setText("Current Time [s]: -");
                this.lTemperature.setText("Avg Temperature Particles [K]: -");
                this.lVolume.setText("Volume [m^3]: -");
                this.lInternalPressure.setText("Internal pressure [Pa]: -");
                this.lExternalPressure.setText("External pressure [Pa]: -");
                this.lEnergy.setText("Total Energy [J]: -");
                this.lWork.setText("Total Work by System [J]: -");
                this.lWorkChosen.setText("Total recorded work [J]: -");
                this.lWorkCurrent.setText("Work during current stage [J]: -");
                this.lHeat.setText("Total Heat (into System) [J]: -");
                this.lHeatChosen.setText("Total recorded heat [J]: -");
                this.lHeatCurrent.setText("Heat during current stage [J]: -");
                this.lPVNRT.setText("pV/nRT: -");
            }
        }
    }
}

