/*
 * Decompiled with CFR 0.152.
 */
package multimedia;

import java.net.URISyntaxException;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class SplashScreen {
    public static final int SPLASH_SETUP_EXPERIMENT = 0;
    public static final int SPLASH_START_EXPERIMENT = 1;
    public static final int SPLASH_EXPERIMENT_RUNNING = 2;
    private int splashId;

    public SplashScreen(int splashID) {
        this.splashId = splashID;
    }

    public void drawOnCanvas(Canvas canvas) {
        GraphicsContext context = canvas.getGraphicsContext2D();
        context.setFill((Paint)Color.WHITE);
        context.fillRect(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
        try {
            Image splash = null;
            switch (this.splashId) {
                case 0: {
                    splash = new Image(this.getClass().getResource("/src/visualization/resources/splashscreen/splash_setupnewexperiment.png").toURI().toString());
                    break;
                }
                case 1: {
                    splash = new Image(this.getClass().getResource("/src/visualization/resources/splashscreen/splash_experimentreadyforcalculation.png").toURI().toString());
                    break;
                }
                case 2: {
                    splash = new Image(this.getClass().getResource("/src/visualization/resources/splashscreen/splash_experimentisrunning.png").toURI().toString());
                }
            }
            context.drawImage(splash, canvas.getWidth() / 4.0 - 100.0, canvas.getHeight() / 4.0, splash.getWidth(), splash.getHeight());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

