/*
 * Decompiled with CFR 0.152.
 */
package model.physics.core;

import java.util.SplittableRandom;
import model.physics.properties.DynamicObject;

public class UtilsMaths {
    private static final SplittableRandom splittableRandom = new SplittableRandom();
    private static final double PI2 = Math.PI * 2;
    private static double tmpGaussRNV = 1000000.0;

    public static double nextNorm() {
        if (tmpGaussRNV < 1000000.0) {
            double tmp = tmpGaussRNV;
            tmpGaussRNV = 1000000.0;
            return tmp;
        }
        double R = Math.sqrt(-2.0 * Math.log(1.0 - splittableRandom.nextDouble()));
        double theta = Math.PI * 2 * splittableRandom.nextDouble();
        tmpGaussRNV = R * Math.sin(theta);
        return R * Math.cos(theta);
    }

    public static double nextUni() {
        return 1.0 - splittableRandom.nextDouble();
    }

    public static int nextInt(int max) {
        return splittableRandom.nextInt(max);
    }

    public static double[] nextNorm(int size) {
        double[] output = new double[size];
        for (int i = 0; i < size; ++i) {
            output[i] = UtilsMaths.nextNorm();
        }
        return output;
    }

    public static double[] nextUni(int size) {
        double[] output = new double[size];
        for (int i = 0; i < size; ++i) {
            output[i] = UtilsMaths.nextUni();
        }
        return output;
    }

    public static <T extends DynamicObject> double getSpeed(T o) {
        double[] v = o.getV();
        return Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    public static <T extends DynamicObject> double getKineticEnergy(T o) {
        double speed = UtilsMaths.getSpeed(o);
        return 0.5 * o.getM() * speed * speed;
    }

    public static double MaxwellBoltzmannFunction(double T, double v, double m) {
        return Math.pow(m / (8.674874467714E-23 * T), 1.5) * 4.0 * 3.141593 * Math.pow(v, 2.0) * Math.exp(-(m * v * v) / (2.761298E-23 * T));
    }

    public static double squaredNorm(double[] v) {
        double output = 0.0;
        for (int i = 0; i < v.length; ++i) {
            output += v[i] * v[i];
        }
        return output;
    }

    public static double[] productScalarVector(double a, double[] v) {
        double[] output = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            output[i] = a * v[i];
        }
        return output;
    }

    public static double[] crossProduct(double[] A, double[] B) {
        double[] C = new double[]{A[1] * B[2] - A[2] * B[1], A[2] * B[0] - A[0] * B[2], A[0] * B[1] - A[1] * B[0]};
        return C;
    }

    public static double dotProduct(double[] A, double[] B) {
        return A[0] * B[0] + A[1] * B[1] + A[2] * B[2];
    }

    public static double[] differenceVector(double[] A, double[] B) {
        double[] C = new double[]{A[0] - B[0], A[1] - B[1], A[2] - B[2]};
        return C;
    }

    public static double[] sumVector(double[] A, double[] B) {
        double[] C = new double[]{A[0] + B[0], A[1] + B[1], A[2] + B[2]};
        return C;
    }

    public static double[] normalizeVector(double[] A) {
        double ALength = Math.sqrt(A[0] * A[0] + A[1] * A[1] + A[2] * A[2]);
        double[] C = new double[]{A[0] / ALength, A[1] / ALength, A[2] / ALength};
        return C;
    }
}

