/*
 * Decompiled with CFR 0.152.
 */
package model.components.basic;

import java.util.HashMap;
import model.components.core.VTLComponent;
import model.physics.properties.DynamicObject;
import settings.Settings;

public abstract class WallDynamic
extends VTLComponent
implements DynamicObject {
    public double[] pos = new double[6];
    public double[] v = new double[]{0.0, 0.0, 0.0};
    public double m;

    public WallDynamic(double mIn) {
        this.m = mIn;
    }

    @Override
    public void update(double dt) {
        this.pos[0] = this.pos[0] + this.v[0] * dt * Settings.pixelsInAMeter;
        this.pos[3] = this.pos[3] + this.v[0] * dt * Settings.pixelsInAMeter;
        this.pos[1] = this.pos[1] + this.v[1] * dt * Settings.pixelsInAMeter;
        this.pos[4] = this.pos[4] + this.v[1] * dt * Settings.pixelsInAMeter;
        this.pos[2] = this.pos[2] + this.v[2] * dt * Settings.pixelsInAMeter;
        this.pos[5] = this.pos[5] + this.v[2] * dt * Settings.pixelsInAMeter;
    }

    @Override
    public HashMap<String, Double> getState() {
        return null;
    }

    @Override
    public double[] getPosition() {
        return this.pos;
    }

    @Override
    public double[] getV() {
        return this.v;
    }

    @Override
    public double getM() {
        return this.m;
    }

    public abstract int getDirection();

    @Override
    public void setV(double[] v) {
        this.v = v;
    }

    @Override
    public String toXML() {
        return null;
    }

    @Override
    public VTLComponent fromXML(String XMLString) {
        return null;
    }
}

