/*
 * Decompiled with CFR 0.152.
 */
package visualization.gui.components;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import visualization.gui.UtilsUI;

public class WaitingWindow
implements Initializable {
    private Stage stage;
    private String text;
    @FXML
    private Label waitlabel;
    @FXML
    private ImageView imagePlaceholder;

    public WaitingWindow(Window parent, String text) {
        this.text = text;
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/visualization/gui/components/waitingWindow.fxml"));
            fxmlLoader.setController((Object)this);
            Scene s = new Scene((Parent)fxmlLoader.load());
            this.stage = new Stage();
            this.stage.initModality(Modality.NONE);
            this.stage.initStyle(StageStyle.TRANSPARENT);
            this.stage.initOwner(parent);
            this.stage.setScene(s);
            this.stage.getIcons().add((Object)UtilsUI.getInstance().prepareIcon("/visualization/resources/buttons/settings.png").getImage());
            this.stage.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
    }

    public void show() {
        this.waitlabel.setText(this.text);
        this.imagePlaceholder.setImage(new Image(this.getClass().getResourceAsStream("/visualization/resources/splashscreen/waiting.png")));
        this.stage.show();
    }

    @FXML
    public void close() {
        this.stage.close();
    }
}

